/*	This file is part of the software similarity tester SIM.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
	$Header: show_token.c,v 2.1 91/06/18 22:02:13 dick Exp $
*/

#include	"token.h"

show_token(tk)
	TOKEN tk;
{
	/*	prints a token, in two characters:
			normal char		meta (bit 8 set)
			^A	cntl		$A	meta-cntl
			 A	printable	#A	meta
			^?	DEL		$?	meta-DEL
	*/
	register int ch =   TOKEN2int(tk) & 0177;
	register int meta = TOKEN2int(tk) & 0200;
	
	if (' ' <= ch && ch <= '~') {
		printf("%c%c", (meta ? '#' : ' '), ch);
	}
	else {
		printf("%c%c",
			(meta ? '$' : '^'),
			(ch == 0177 ? '?' : ch + '@')
		);
	}
}

