/*	This file is part of the software similarity tester SIM.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
	$Header: pass1.c,v 2.1 91/06/18 22:01:57 dick Exp $
*/

#define		LINT_ARGS
#include	<stdio.h>
#include	"private.h"
#include	"buff.h"
#include	"sim.h"
#include	"stream.h"
#include	"debug.h"

extern char *malloc();

extern char *progname;			/* the program name */

struct text *text;			/* to be filled in by malloc */
int ntexts;				/* number of text records */
int nnewtexts;				/* number of new text records */

PRIVATE print_tokencount();

pass1(argv, argc)
	char *argv[];
{
	register int n;
	
	/* allocate the array of text descriptors */
	ntexts = argc;
	text = (struct text *)
			malloc((unsigned int)(ntexts*sizeof (struct text)));
	if (!text) fatal("out of memory");

	/* assume all texts to be new */
	nnewtexts = ntexts;

	/* read the files */
	for (n = 0; n < ntexts; n++) {
		register char *fname = argv[n];
		register struct text *txt = &text[n];
	
		printf("File %s: ", fname);
	
		txt->tx_fname = fname;
		txt->tx_pos = 0;
		txt->tx_start =
		txt->tx_limit = text_length();
		if (strcmp(fname, "/") == 0) {
			printf("separator\n");
			nnewtexts = n;
		}
		else {
			if (!OpenText(1, txt)) {
				fprintf(stderr, "%s: file %s: cannot open\n",
						progname, txt->tx_fname);
				printf(">>>cannot open<<< ");
			}
			while (NextTextToken(1)) {
				if (!TOKEN_EQ(lex_token, EOL)) {
					store_token();
				}
			}
			CloseText(1, txt);
		
			txt->tx_limit = text_length();
			print_tokencount(txt->tx_limit - txt->tx_start);
#ifdef	DB_TEXT
			db_pr_text(txt);
#endif	/* DB_TEXT */
		}
	}

	printf("Total: ");
	print_tokencount(text_length() - 1);
	printf("\n");
}

PRIVATE
print_tokencount(cnt)
	unsigned int cnt;
{
	/*	prints a grammatically correct string "%u token[s]\n"
	*/
	printf("%u %s\n", cnt, (cnt == 1 ? "token" : "tokens"));
}
