/*	This file is part of the software similarity tester SIM.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
	$Header: option.c,v 2.2 92/06/30 15:23:09 dick Exp $
*/

#define		LINT_ARGS
#include	<stdio.h>
#include	"option.h"

char options[128];

static bad_option();
static int opt_int();

int
do_options(progname, optlist, argc, argv)
	char *progname;
	struct option *optlist;
	int argc;
	char **argv;
{
	int skips = 0;

	while (argc > 0 && argv[0][0] == '-') {
		/* treat argument word */
		char *arg = &argv[0][1];
		int consumed = 0;

		while (*arg) {
			/* treat argument character */
			register char opc = *arg++;
			register struct option *op;

			for (op = optlist; op->op_char; op++) {
				/* for every allowed option */
				if (opc == op->op_char) {
					options[opc]++;
					if (op->op_int) {
						consumed =
							opt_int(progname, opc,
								op->op_int,
								arg, argv);
					}
					break;
				}
			}
			if (!op->op_char) {
				bad_option(progname, optlist,
					"*option -%c unknown", opc);
				/*NOTREACHED*/
			}
			if (consumed) break;
		}
		if (!consumed) {
			consumed = 1;
		}
		argc -= consumed, argv += consumed, skips += consumed;
	}

	return skips;
}

static int
opt_int(progname, opc, ip, arg, argv)
	char *progname;
	int opc;
	int *ip;
	char *arg;
	char **argv;
{
	int skips;

	if (*arg) {
		skips = 1;
	}
	else {
		if (!argv[1]) {
			bad_option(progname, (struct option *)0,
				" option %c requires another argument", opc);
			/*NOTREACHED*/
		}
		arg = argv[1];
		skips = 2;
	}

	if (*arg < '0' || '9' < *arg) {
		bad_option(progname, (struct option *)0,
			" %c is not numeric", *arg);
		/*NOTREACHED*/
	}
	*ip = atoi(arg);
	return skips;
}

static
bad_option(progname, optlist, msg, c)
	char *progname;
	struct option *optlist;
	char *msg;
	int c;
{
	fprintf(stderr, "%s: ", progname);
	fprintf(stderr, &msg[1], c);
	fprintf(stderr, "\n");

	if (msg[0] != ' ') {
		register struct option *op;

		fprintf(stderr, "Possible options  are:\n");
		for (op = optlist; op->op_char; op++) {
			fprintf(stderr, "\t-%c%s\t%s\n",
				op->op_char,
				op->op_int ? " N" : "",
				op->op_text
			);
		}
	}
	exit(1);
}

