/*	This file is part of the software similarity tester SIM.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
	$Header: add_run.c,v 2.2 92/06/30 15:22:38 dick Exp $
*/

#include	"cport.h"
#include	"private.h"
#include	"buff.h"
#include	"sim.h"
#include	"aiso.h"

extern char *malloc();

PRIVATE set_chunk(), set_pos();

add_run(txt0, i0, txt1, i1, size)
	struct text *txt0, *txt1;
	unsigned int i0, i1;
	unsigned int size;
{
	/*	Adds the run of given size to our collection.
	*/
	register struct run *r = (struct run *)malloc(sizeof (struct run));

	if (!r) fatal("out of memory");
	set_chunk(&r->rn_cn0, txt0, i0 - txt0->tx_start, size);
	set_chunk(&r->rn_cn1, txt1, i1 - txt1->tx_start, size);
	r->rn_quality = size;
	
	if (!InsertAiso(r)) fatal("out of memory");
}

PRIVATE
set_chunk(cnk, txt, start, size)
	struct chunk *cnk;
	struct text *txt;
	unsigned int start;
	unsigned int size;
{
	/*	Fill the chunk *cnk with info about the piece of text
		in txt starting at start extending over size tokens.
	*/
	cnk->ch_text = txt;
	set_pos(&cnk->ch_first, 0, txt, start);
	set_pos(&cnk->ch_last, 1, txt, start + size - 1);
}

PRIVATE
set_pos(pos, type, txt, start)
	struct position *pos;
	int type;
	struct text *txt;
	unsigned int start;
{
	/* Fill a single struct position */
	pos->ps_next = txt->tx_pos;
	txt->tx_pos = pos;

	pos->ps_type = type;
	pos->ps_tk_cnt = start;
	pos->ps_fs_pos = 0L;
	pos->ps_nl_cnt = 1;
}
