/*****
 *
 * File: dynamic.c
 *   By: Stephen Pope
 *       June 1989
 *
 * Cellsim, cellular automata simulator
 *
 * Dynamic linking routines
 *
 *****/

/*
 * This dynamic-linking code was supplied by Stephen Pope of
 * the Santa Fe Institute.
 * This code allows a running program to link in an object file and
 * call the first function in the object file.
 */

/*
 *
 * Cellsim copyright 1989, 1990 by Chris Langton and Dave Hiebeler
 * (cgl@lanl.gov, hiebeler@heretic.lanl.gov)
 *
 * This package may be freely distributed, as long as you don't:
 * - remove this notice
 * - try to make money by doing so
 * - prevent others from copying it freely
 * - distribute modified versions without clearly documenting your changes
 *   and notifying us
 *
 * Please contact either of the authors listed above if you have questions
 * or feel an exception to any of the above restrictions is in order.
 *
 * If you make changes to the code, or have suggestions for changes,
 * let us know!  If we use your suggestion, you will receive full credit
 * of course.
 */

/*****
 * Cellsim history:
 *
 * Cellsim was originally written on Apollo workstations by Chris Langton.
 *
 * Sun versions:
 *
 * - version 1.0
 *   by C. Ferenbaugh and C. Langton
 *   released 09/02/88
 *
 * - version 1.5
 *   by Dave Hiebeler and C. Langton  May - June 1989
 *   released 07/03/89
 *
 * - version 2.0
 *   by Dave Hiebeler and C. Langton  July - August 1989
 *   never officially released (unofficially released 09/08/89)
 *
 * - version 2.5
 *   by Dave Hiebeler and C. Langton  September '89 - February 1990
 *   released 02/26/90
 *****/



#include <stdio.h>
#include <a.out.h>
#include <sys/file.h>

extern char* calloc();

char *
dynamic_load(exec_name, toload_name)
char* exec_name;
char* toload_name;
{
    int size;
    int pagsiz;
    int init_fn;
    char command[512];
    int fd;
    char tname[L_tmpnam];
    struct exec header;
    
    if ((fd = open (toload_name, /* 2 */ O_RDONLY, 0)) < 0) {
	fprintf (stderr, "Unable to open file %s\n", toload_name);
	exit (1);
    }
    if (read (fd, (void*) &header, sizeof (header)) <= 0) {
	fprintf (stderr, "Error in reading file %s\n", toload_name);
	exit(1);
    }
    close (fd);

    size = header.a_text + header.a_data;
#ifndef PAGSIZ
    pagsiz = getpagesize();
#else
    pagsiz = PAGSIZ;
#endif

    if (size < (pagsiz))
	size = (pagsiz);

    init_fn = (int) calloc(size, sizeof(short));

    init_fn += pagsiz-1;
    init_fn &= ~(pagsiz-1);

    strcpy (tname, "/tmp/dyld.XXXXXX");
    mktemp (tname);

    sprintf (command, "ld -N -A %s -T %x %s -lc -lparis2 -lm -o %s",
	     exec_name, init_fn, toload_name, tname);

    if (system (command)) {
	fprintf (stderr, "Error in linking file %s\n", toload_name);
	exit (1);
    }

    fd = open (tname, 2, 0);
    if (lseek (fd, sizeof (header), L_SET) < 0) {
	perror ("Error in temp file seek\n");
	exit (1);
    }

    read (fd, (char*) init_fn, size);
    close (fd);
    unlink(tname);

    return (void *)init_fn;
}
