;;;; -*- mode:Lisp; syntax:Common-Lisp; package:user -*- ;;;;
;;;; Copyright 1992 Patrick H. Winston.  All rights reserved.
;;;; Version 1.1.1, copied from master file on 23 Apr 93       
;;;; 
;;;; This software is licensed by Patrick H. Winston (licensor) for
;;;; instructional use with the textbooks ``Artificial Intelligence,'' by
;;;; Patrick H. Winston, and ``Lisp,'' by Patrick H. Winston and Berthold
;;;; K. P. Horn.  Your are free to make copies of this software and
;;;; modify it for such instructional use as long as:
;;;; 1. You keep this notice intact.
;;;; 2. You cause any modified files to carry a prominent notice stating
;;;;    that you modified the files and the date of your modifications.
;;;; This software is licensed ``AS IS'' without warranty and the licensor
;;;; shall have no liability for any alleged defect or damages.

;;;; REMARKS

#|

Trees are encoded as nested lists:  Leaf nodes are represented by
numbers that indicate their static value.  Nonleaf nodes are
represented by lists of their child nodes.

Consider this tree, for example:


              *               <-- Nonleaf nodes

       *             *        <-- Nonleaf nodes

    *     *       *     *     <-- Nonleaf nodes

   2 2   0 4     6 8   4 6    <-- Leaf nodes's static values

Representing this same tree as a nested list produces the
following:

(((2 2) (0 4)) ((6 8) (4 6)))

|#

;;;; DEFINE VARIOUS GAME TREES

(defvar three-ply '(((2 2) (0 4)) ((6 8) (4 6))))

(defvar reverse-three-ply '(((6 4) (8 6)) ((4 0) (2 2))))


(defvar four-ply '((((6 2) (3 3))
		    ((3 9) (4 7)))
		   (((2 2) (0 4))
		    ((6 8) (4 6)))))

(defvar reverse-four-ply '((((6 4) (8 6))
			    ((4 0) (2 2)))
			   (((7 4) (9 3))
			    ((3 3) (2 6)))))
