;************************************************************
;                                                           *
; Copyright (c) 1990, California Institute of Technology.   *
; U.S. Government Sponsorhip under NASA Contract NAS7-918   *
; is acknowledged.                                          *
;                                                           *
;***********************************************************/

; methods.scm
; Brian Beckman                  |    brian@topaz.jpl.nasa.gov
; Pasadena, CA 91109             |    30 June 1989

(define **method-mode** 'normal-method-mode)

(define (set-debug-method-mode)
  (set! **method-mode** 'debug-method-mode))

(define (set-normal-method-mode)
  (set! **method-mode** 'normal-method-mode))

(define (reset-debug-method-mode)  ;;; synonym
  (set! **method-mode** 'normal-method-mode))

(define (test-debug-method-mode)
  (eq? **method-mode** 'debug-method-mode))

(define **method-error-class-name** "No class name.")

(define **method-error-message** 'no-message)

(define (error-method . junk-args)
  (display **method-error-class-name**)
  (display ": uknown message: '")
  (display **method-error-message**)
  (newline)
  ())

(define (make-error-method class-name msg)
  (set! **method-error-class-name** class-name)
  (set! **method-error-message** msg)
  error-method)

(define (search-supertypes supers msg)
  (define method ())
  (if (test-debug-method-mode)
      (begin
       (display "Searching...")
       (newline)))
  (cond
   (  (null? supers)  ()  )
   (  (begin
       (set! method ((car supers) msg))
       (eq? method error-method))
                      (if (test-debug-method-mode)
                          (error-method))
                      (search-supertypes (cdr supers) msg)  )
   (  else  method  )))

(define (for-all-parents supers msg . args)
  (let (  (method-list
           (map (lambda (supertype) (supertype msg)) supers))
          (for-proc
           (lambda (method) (apply method args)))  )
    (for-each for-proc method-list)))

(define (find-all-methods supers msg)
  (cond
   (  (null? supers)  ()  )
   (  else  (cons ((car supers) msg)
                  (find-all-methods (cdr supers) msg))  )))

(define (send object msg . args)
  (apply (object msg) args))


