(define (vrand len max)
  (let ((x (make-vector len)))
    (for (i from 0 to len)
         (vector-set! x i (random max)))
    x))

(define (shelsort vec len bin-op)

  (cond
    ( (<= len 1)  vec )
    ( else

      (do ( (gap (quotient len 2) (quotient gap 2)) )
          ;;; Go down by powers of two.  Gap will always be equal
          ;;; to 1 eventually.  A gap of one is sufficient to guarantee
          ;;; sorting.
          ( (= 0 gap) vec )

          (for (i from gap to len)

              (for (j from (- i gap) down thru 0 by gap)

                  (let ( (x (vector-ref vec j))
                         (y (vector-ref vec (+ j gap))) )
                    (cond
                      ( (bin-op x y)
                        (vector-set! vec j y)
                        (vector-set! vec (+ j gap) x) )))))) )))
                        
(define (binary-search-int vec len elt)
  (let iter ( (min 0)
              (max (- len 1)) )
    (let* ( (mid (quotient (+ min max) 2))
            (test (vector-ref vec mid)) )
      (cond
       ( (= elt test)  (list mid test) )
       ( (>= min max)  '() )
       ( (< elt test)  (iter min (-1+ mid)) )
       ( else          (iter (1+ mid) max)  )))))
