;;; hash tbl.scm -- basic hash table object type
;;; Brian Beckman, 11 Aug 1989

(load "methods.scm")
(load "assocl.scm")

(define (new-hash-tbl size hash-func)
  
  (let* ( (tbl (make-vector size))
          (supers '()) )
    
    (define (install item)
      (let ( (k (hash-func (car item))) )
        (vector-set! tbl k (cons item (vector-ref tbl k)))
        self))

    (define (retrieveq key)
      (assql key (vector-ref tbl (hash-func key))))

    (define (retrievev key)
      (assvl key (vector-ref tbl (hash-func key))))

    (define (retrieve key)
      (assocl key (vector-ref tbl (hash-func key))))

    (define (retrieve-raw key)
      (vector-ref tbl (hash-func key)))

    (define (print)
      (display tbl) (newline) self)

    (define (clear)
      (set! tbl (make-vector size))
      self)
    
    (define (self msg)
      (cond
       ( (eq? msg 'print)         print            )
       ( (eq? msg 'install)       install          )
       ( (eq? msg 'retrieveq)     retrieveq        )
       ( (eq? msg 'retrievev)     retrievev        )
       ( (eq? msg 'retrieve)      retrieve         )
       ( (eq? msg 'retrieve-raw)  retrieve-raw     )
       ( (eq? msg 'clear)         clear            )
       ( (search-supertypes supers msg)            )
       ( else (make-error-method "Hash-tbl" msg) )))
    
    self))

(define h (new-hash-tbl 16 (lambda (n) (remainder n 16))))
(define (test)
  (load "hashtbl.scm")
  (send h 'install '( 1 a))
  (send h 'install '(17 b))
  (send h 'install '( 0 c))
  (send h 'install '( 2 d))
  (send h 'install '( 3 e))
  (send h 'install '(19 f))
  (send h 'install '(35 g))
  (send h 'install '( 2 h))
  (send h 'install '( 1 i))
  (send h 'install '( 1 j))
  (send h 'install '( 2 k))
  (send h 'install '(16 l))
  (send h 'install '(16 m))
  (send h 'install '( 0 n))
  (send h 'install '( 0 o))
  (send h 'install '( 0 p))
  (send h 'print)
  (display (send h 'retrieveq 17)) (newline)
  (display (send h 'retrieveq  1)) (newline)
  (display (send h 'retrieveq  4)) (newline)
  )
