(herald build)

(import t-implementation-env set-logical-name)
(set-logical-name (local-fs) 'back_end "~kranz/risc/comp/back_end")
(set-logical-name (local-fs) 'front_end "~kranz/risc/comp/front_end")
(set-logical-name (local-fs) 't3_primops "~kranz/risc/comp/primops")
(set-logical-name (local-fs) 'link "~kranz/risc/link")
(set-logical-name (local-fs) 'osys "~kranz/risc/sys")
(define (orbit-mips-setup directory)
  (set *object-file-extension* 'mpo)
  (set *information-file-extension* 'mpi)
  (set *noise-file-extension* 'mpn)
  (orbit-setup directory)
  (set (table-entry *modules* 'constants) `(,directory mipsconstants))
  (set (table-entry *modules* 'primops)   `(,directory mipsprimops))
  (set (table-entry *modules* 'arith)     `(,directory mipsarith))
  (set (table-entry *modules* 'low)       `(,directory mipslow))
  (set (table-entry *modules* 'genarith)     `(,directory mipsgenarith))
  nil)

(define (orbit-mips-init . directory)
  (orbit-mips-setup (if directory (car directory) '#f))
  (orbit-init 'base
              'constants
              'primops
	      'arith
              'locations
              'low
	      'predicates
              'open
              'aliases
              'carcdr
              'genarith))

(orbit-mips-setup 't3_Primops)
(create-support '(t3_Primops mipsconstants) '(t3_Primops mipsconstants))
(load '(t3_Primops mipsconstants t) orbit-env)
(orbit-init 'base)
(set (orbit-syntax-table) primop-syntax-table)
(set *compile-primops?* nil)
(create-support '(t3_Primops mipsprimops)   '(t3_Primops mipsprimops))
(create-support '(t3_Primops mipsarith)     '(t3_Primops mipsarith))
(create-support '(t3_Primops locations)    '(t3_Primops locations))
(create-support '(t3_Primops mipslow)       '(t3_Primops mipslow))
(create-support '(t3_Primops predicates)       '(t3_Primops predicates))
(orbit-init 'base  
            'constants 'primops 'arith 'locations 'low 'predicates)
(create-support '(t3_Primops open)    '(t3_Primops open))
(create-support '(t3_Primops aliases) '(t3_Primops aliases))
(create-support '(t3_Primops carcdr)  '(t3_Primops carcdr))
(create-support '(t3_Primops mipsgenarith)  '(t3_Primops mipsgenarith))
