(herald fix)

(define (orbit-mips-setup directory)
  (set *object-file-extension* 'mlo)
  (set *information-file-extension* 'mli)
  (set *noise-file-extension* 'mln)
  (set *debug-file-extension* 'mld)
  (orbit-setup directory)
  (set (table-entry *modules* 'constants) `(,directory mipsconstants))
  (set (table-entry *modules* 'primops)   `(,directory mipsprimops))
  (set (table-entry *modules* 'arith)     `(,directory mipsarith))
  (set (table-entry *modules* 'low)       `(,directory mipslow))
  (set (table-entry *modules* 'genarith)     `(,directory mipsgenarith))
  nil)

(define (orbit-mips-init . directory)
  (orbit-mips-setup (if directory (car directory) '#f))
  (orbit-init 'base
              'constants
              'primops
	      'arith
              'locations
              'low
	      'predicates
              'open
              'aliases
              'carcdr
              'genarith))

(define (add-label-assigner var thunk parent)
  (cond ((thunk-value thunk)
         => (lambda (value)
              (add-simple-label-assigner var (detach value) parent)
              (splice-thunk thunk parent)))
        (else
         (let* ((c-var (create-variable 'k))
                (value (create-reference-node c-var)))
           (add-simple-label-assigner var value parent)
           (var-gets-thunk-value c-var thunk parent)
	   (let ((node (node-parent thunk)))
	     (walk (lambda (var val)
		     (if (lambda-node? val)
			 (check-continuation-var var val)))
		   (lambda-variables (call-proc node))
		   (call-args node)))))))


(define (check-continuation-var var val)
  (walk-refs-safely (lambda (ref)
		      (if (call-exit? ref)
			  (fix-exit-reference var ref val)))
		    var))

(define (introduce-exit-lambda var node value args?)
  (let* ((new-vars (free-map (lambda (var)
                               (if var
                                   (create-variable (variable-name var))
                                   nil))
                             (lambda-rest+variables value)))
         (cont (create-lambda-node 'c new-vars))
         (args (if (not args?)
                   '()
                   (map (lambda (v) (if v
                                        (create-reference-node v)
                                        (create-literal-node '#f)))
                        (cdr new-vars))))
         (call (create-call-node (fx+ '1 (length args)) '0)))
    (relate call-proc call (create-reference-node var))
    (relate-call-args call args)
    (relate lambda-body cont call)
    (replace node cont)))

(define (complexity-analyze node)
  (cond ((empty? node)
         '0)
        ((reference-node? node)
         (cond ((get-variable-definition (reference-variable node)) 0)
               ((call-arg-mismatches? node) 1)
               (else 2)))
        ((leaf-node? node) '0)
        ((lambda-node? node)
         (complexity-analyze (lambda-body node)))
        ((call-node? node)
         (let ((q (complexity-analyze-list (call-proc+args node))))
           (set (call-complexity node) q)
           q))
        ((object-node? node)
         (let ((q1 (complexity-analyze (object-proc node)))
               (q2 (complexity-analyze-list (object-operations node)))
               (q3 (complexity-analyze-list (object-methods node))))
           (fx+ q1 (fx+ q2 q3))))
        (else
         (bug '"funny node ~S" node))))
                    
(define (call-arg-mismatches? node)
  (let ((var (reference-variable node)))
    (and (variable-binder var)
         (fxn= (call-arg-number (node-role node))
               (fx- (variable-number var) 1)))))

