(herald fix)

(define (add-jump next i is cc)
  (let ((insts (ib-instructions next)))
    (cond ((or (null? insts)
	       (fxn= (car cc) jump-op/jabs)
	       (branch-instruction? (car insts)))
	   (return (fx+ i (fx* CELL 2))
		   (cons noop-inst 
			 (cons (list jbr-inst nil cc (cons 'label next))
			       is))))
	  (else
	   (return (fx+ i (fx* CELL 2))
		   (cons (car insts) 
			 (cons (list jbr-inst nil cc (cons 'label+1 next))
			       is)))))))

(define (branch-instruction? x)
  (or (eq? (car x) mips/jalr)
      (eq? (car x) mips/jr)
      (eq? (car x) jbr-inst)
      (eq? (car x) maybe-popfr)
      (eq? (car x) maybe-pushfr)))

(define (need-to-delay? load rest)
  (if (null? rest)
      '#t
      (let ((write (apply write-register mips/load (cddr load))));flush comment
	(destructure (((op #f . args) (car rest)))
	  (select  op
	    ((maybe-pushfr maybe-popfr)
	     (fx= (lambda-max-temps (car args)) 0))
	    (else
	     (receive (r1 r2) (apply read-registers op args)
	       (or (fx= write r1) (fx= write r2)))))))))
	
