(herald unix_umax (env tsys))

(define file-mode/in     #o0)
(define file-mode/out    #o3001)
(define file-mode/append #o1011)

(define-constant number-of-signals 27)   ;4.2


;;; handler-types (Htype): A = asynchronous, E = exception, D = default,
;;; I = ignore
;;; (sig# handler-type handler description)

(define *signals*
  '(( 1   E    non-continuable  "hangup")
 ;   ( 2   A    sigint-handler    "interrupt")
 ;   ( 3   A    siquit-handler    "quit")
    ( 4   E    non-continuable  "illegal instruction")
    ( 5   E    non-continuable  "trace/BPT trap")
    ( 6   E    non-continuable  "IOT instruction")
    ( 7   E    non-continuable  "EMT instruction")
    ( 8   E    non-continuable  "floating point exception")
 ;   ( 9   D    default          "kill")
    (10   E    non-continuable  "memory protection violation")
    (11   E    non-continuable  "reference to non-existent memory")
    (12   E    non-continuable  "bad argument to a system call")
    (13   E    non-continuable  "broken pipe")
 ;   (14   D    default          "alarm clock")
 ;   (15   A    sigterm-handler   "software termination signal")
 ;   (16   D    default          "urgent condition on socket")
 ;   (17   D    default          "stop")
 ;   (18   D    default          "stop signal generated from keyboard")
 ;   (19   D    default          "continue after stop")
 ;   (20   D    default          "child status has changed")
 ;   (21   D    default          "background read attempted")
 ;   (22   D    default          "background write attempted")
 ;   (23   D    default          "i/o is possible")
    (24   E    non-continuable  "cpu time limit exceeded")
    (25   E    non-continuable  "file size limit exceeded")
  ;  (26   D    default          "virtual time alarm")
  ;  (27   D    default          "profiling timer alarm")
  ))

(define-constant %%SIGINT     2)
(define-constant %%SIGQUIT    3)
(define-constant %%SIGTERM    15)
(define-constant %%SIGSTOP    17)

(define-unimplemented (make-foreign-procedure sym))
(define-unimplemented (load-foreign file))

(define (initialize-local-system) nil)
