(herald maxkernel
  (env tsys))

;;; Copyright (c) 1985 Yale University
;;;     Authors: N Adams, R Kelsey, D Kranz, J Philbin, J Rees.
;;; This material was developed by the T Project at the Yale University Computer 
;;; Science Department.  Permission to copy this software, to redistribute it, 
;;; and to use it for any purpose is granted, subject to the following restric-
;;; tions and understandings.
;;; 1. Any copy made of this software must include this copyright notice in full.
;;; 2. Users of this software agree to make their best efforts (a) to return
;;;    to the T Project at Yale any improvements or extensions that they make,
;;;    so that these may be included in future readdrses; and (b) to inform
;;;    the T Project of noteworthy uses of this software.
;;; 3. All materials developed as a consequence of the use of this software
;;;    shall duly acknowledge such use, in accordance with the usual standards
;;;    of acknowledging credit in academic research.
;;; 4. Yale has made no warrantee or representation that the operation of
;;;    this software will be error-free, and Yale is under no obligation to
;;;    provide any services, by way of maintenance, update, or otherwise.
;;; 5. In conjunction with products arising from the use of this material,
;;;    there shall be no use of the name of the Yale University nor of any
;;;    adaptation thereof in any advertising, promotional, or sales literature
;;;    without prior written consent from Yale in each case.
;;;

;;; The procedure big_bang MUST come first in this file.     boot-arg-offset
;;;  When we enter Big_bang the stack looks as follows:
;;;              ________________
;;;              |   debug?      |   not a boot arg
;;;              |_______________|
;;;              |      argv     |    Command line argv
;;;              |_______________|
;;;              |      argc     |    Command line argc
;;;              |_______________|
;;;              |  heap-size    |    Size of the static storage area
;;;              |_______________|
;;;              |     heap2     | Base addresss of static
;;;              |_______________|        storage area
;;;              |     heap1     |
;;;              |_______________|
;;;       SP =>  |  return addr  |
;;;              |_______________|
;;;
;;; The address of interrupt_xenoid (see $BUILD/max_start_t.s) is in S0.

;++ replace the numbers 1 and 3 below with boot/heap1 and boot/heap-size

(define (big_bang) 
  (lap (n32-big-bang *boot*)

    ;; set up global-constants
    (ashi d ($ 2) S0)   
    (movi d S0 (d@r nil-reg slink/interrupt-handler))
    (spri d SP A1)                                            ; save ptr to args
    (movi d ($ (fx+ (fixnum-ashl 6 8) header/general-vector)) ; 6 boot-args
          (tos))
    (addr (d@r SP 2) A2)                                    ; second arg to boot
    (movi d A2 (d@r nil-reg slink/boot-args))                 ; set up boot-args

    (movi d (d@r P (static 'n32-big-bang)) P)
    (movi d (d@r p 2) p)
    (movi d (d@r P -2) A2)
    (addr (label big-bang-return) AN)          ; temp because TP is special
    (movi d AN TP)
;;; note that pointer to boot args is in A1
    (jump (@r A2))                  
big-bang-return
    ;; initialize area,area-frontier and area-limit
    (movi d (d@r A1 4) S0)         ; get address of heap
    (movi d S0 (d@r TASK task/area-begin))          
    (movi d S0 (d@r TASK task/area-frontier))       
    (addi d (d@r A1 12) S0)         ; add size to base
    (movi d S0 (d@r TASK task/area-limit))          

    ;; Set up the procedure register P and call boot,
    ;; never to return. (note: arg 2 (*boot-args*) setup above)
    (spri d nil-reg A3)
    (cmpi b ($ 0) (d@r A1 24))
    (j= %debug)
    (movi d ($ header/true) A3)
%debug
    (addr (d@r TASK %%task-header-offset) A1)       ; root-process
    (movi d ($ 4) NARGS)                              ; 3 args
    (movi d (d@r P (static '*boot*)) P)
    (movi d (d@r p 2) p)
    (movi d (d@r P -2) TP)
    (jump  (@r TP))))

(define (call-fault-handler)
  (lap (signal-handler)

    (equate t-interrupt      (fixnum-ashl  2 2))   ; UNIX signal codes
    (equate t-virtual-timer  (fixnum-ashl 26 2))

    (movi d ($ t-interrupt) A1)                      ; signal code is arg 1
    (tbiti b ($ 1) (d@r TASK (fx+ task/critical-count 3)))  ; t-interrupt?
    (jfs %call-fault)                               ; test F flag
    (movi d ($ t-virtual-timer) A1)
%call-fault                                
    (addr (d@r SP (fx+ 4 tag/extend)) A2)          ; fault frame is arg 2
    (movi d (d@r P (static 'signal-handler)) P)
    (movi d (d@r p 2) p)
    (movi d (d@r P -2) TP)
    (movi b ($ 0) (d@r TASK (fx+ task/critical-count 3)))
    (jump (@r TP))))                                


;;;; Various return points pushed as continuations by INTERRUPT_DISPATCHER

;;; Return from fault handler when originally interrupted in T code
(lap-template (0 0 -1 t stack %fault-frame-handler)
%fault-frame-template
    (equate %%fault-sp-offset 20)               
    (equate %%df_r2 16)
    (equate %%df_r3 -44)
    (equate %%df_r4 -40)
    (equate %%df_r5 -36)
    (equate %%df_r6 -32)
    (equate %%df_fp -28)
    (equate %%df_pc       24)

    (ori b ($ #b01000000) (d@r TASK (fx+ task/critical-count 3)))  ; ignore int's
    (movi d (d@r SP 4) S0)                    ; fault header
    (ashi d ($ -8) S0)
    (addi d ($ 2) S0)                         ; 2 for header and template
    (cmpi d ($ 0) (d@r SP 12))
    (j= foobar)
    (movi d (d@r SP 12) (index-d (@r SP) S0)) ; restore hacked top of stack
foobar
    (adjspi b ($ -16))         ; pop template, header, pointers on stack, hack top
        ;; 10 = 3 (extra p & s & task/scratch) + 6 (pointer regs) + 1 (pc)
    (movi d (d@r SP (* (+ *pointer-temps* *scratch-temps* 10) 4))
          A1)                      ; context.  pushed in %fault-save-loop above
    (movi d (tos) (d@r A1 %%df_pc))
    (movi d (tos) (d@r A1 %%df_r2))    ; P
    (movi d (tos) (d@r A1 %%df_r3))    ; A1
    (movi d (tos) (d@r A1 %%df_r4))    ; A2
    (movi d (tos) (d@r A1 %%df_r5))    ; A3
    (movi d (tos) (d@r A1 %%df_r6))    ; AN
    (movi d (tos) (d@r A1 %%df_fp))    ; TP

    (movi d ($ -3) S0)                              ; extra p & s & task/scratch
%fault-restore-loop                                 ; restore temps
    (movi d (tos) (index-d (@r TASK) S0))
    (addi d ($ 1) S0)
    (cmpi d ($ (fx/ temp-block-size 4)) S0)
    (j> %fault-restore-loop)
    (adjspi b ($ -4))                                  ; pop context
    (bici b ($ #b01000000) (d@r TASK (fx+ task/critical-count 3)))
    (ret ($ 0))
%fault-frame-handler
    (spri d nil-reg AN)
    (ret ($ 0)))

;;; Return from fault handler when originally interrupted in foreign code
(lap-template (0 0 -1 nil stack handle-foreign-return)
%foreign-return
    (ori b ($ #b01000000) (d@r TASK (fx+ task/critical-count 3)))  ; ignore int's
    (adjspi b ($ -8))                         ; pop template,header
    (movi d (tos) (d@r TASK task/foreign-call-cont))
    (bici b ($ #b01000000) (d@r TASK (fx+ task/critical-count 3)))
    (ret ($ 0))
handle-foreign-return
    (spri d nil-reg AN)
    (ret ($ 0)))

(lap-template (0 0 -1 nil stack handle-enable-return)
%re-enabled
    (adjspi b ($ -4))                         ; pop return address
    (ret ($ 0))
handle-enable-return
    (spri d nil-reg AN)
    (ret ($ 0)))

(lap-template (0 0 -1 nil stack handle-doing-gc-return)
%doing-gc-return
    (adjspi b ($ -4))                         ; pop return address
    (ret ($ 0))
handle-doing-gc-return
    (spri d nil-reg AN)
    (ret ($ 0)))



;;; This is T's fault handler, called by UNIX fault handler via 
;;; assembly routine INTERRUPT_XENOID.
;;;     S0 contains UNIX signal code 
;;;     A1 contains context

;;; Interrupts can be deferred.   
;;; the task/critical count byte has
;;; bit 7 -- interrupts deferred
;;; bit 6 -- interrupts ignored
;;; bit 1 -- quit pending
;;; bit 0 -- timer interrupt pending

(define (interrupt_dispatcher)
  (lap (signal-handler enable-signals gc_interrupt)

    (equate %%fault-sp-offset 20)               
    (equate %%df_r2 16)
    (equate %%df_r3 -44)
    (equate %%df_r4 -40)
    (equate %%df_r5 -36)
    (equate %%df_r6 -32)
    (equate %%df_fp -28)
    (equate %%df_pc       24)
    (equate fault-interrupt      2)                       ; UNIX signal codes
    (equate fault-quit           3)
    (equate fault-virtual-timer 26)
                                             
    (movi d S0 A2)               ; save signal code
;    (movi d (d@r P (static '*the-slink*)) nil-reg)
    (lpri d TASK (d@r nil-reg slink/current-task))          ; restore task
    (tbiti b ($ 6) (d@r TASK (fx+ task/critical-count 3)))  ; ignoring int's? 
    (jfs %ignore-interrupt)                                 ; test F flag
    (cmpi d ($ fault-virtual-timer) S0)                     ; timer interrupt?
    (j= %timer)                                   
    (cmpi d ($ fault-interrupt) S0)                         ; is this a ^q?
    (jn= %fault)                                            ; if so ...
    (cmpi d (d@r TASK task/doing-gc?) (d@r nil-reg slink/nil-car)) ; are we doing gc?
    (jn= %doing-gc)                                         ; if not ...
    (cmpi b ($ 0) (d@r TASK task/foreign-call-cont))
    (jn= %fault)                                             ; if so ...
    (tbiti b ($ 1) (d@r TASK (fx+ task/critical-count 3)))
    (jfc %set-interrupt-flag)
    (andi b ($ #b11111101) (d@r TASK (fx+ task/critical-count 3)))
    (cmpi b ($ 0) (d@r TASK (fx+ task/critical-count 3)))
    (j= %fault)
%set-interrupt-flag
    (ori b ($ #b10) (d@r TASK (fx+ task/critical-count 3))) ; set "quit pending"
    (jbr %ignore-interrupt)
%timer
    (cmpi d (d@r TASK task/doing-gc?) (d@r nil-reg slink/nil-car)) ; are we doing gc?
    (jn= %ignore-interrupt)                                 ; if so, ignore int
    (cmpi b ($ 0) (d@r TASK (fx+ task/critical-count 3)))   ; are int's deferred?
    (j= %fault)                                             ; if so ...
    (ori b ($ 1) (d@r TASK (fx+ task/critical-count 3)))    ; set timer bit 
%ignore-interrupt
    (addr (label %re-enabled) (tos))                        ; re-enable interrupts
    (movi d (d@r P (static 'enable-signals)) P)             ; DON'T CONS!!!
    (movi d (d@r p 2) p)
    (movi d (d@r P -2) TP)
    (jump (@r TP))

%doing-gc
    (addr (label %doing-gc-return) (tos))
    (movi d (d@r P (static 'gc_interrupt)) P)
    (movi d (d@r p 2) p)
    (movi d (d@r P -2) TP)
    (jump (@r TP))


;;; Interrupts are disabled here.  (i.e. Signals are disabled at OS level)
%fault
    (movi d (d@r TASK task/foreign-call-cont) S0)
    (cmpi d ($ 0) S0)
    (j=  %t-code-interrupt)

    ;; Interrupted out of foreign code.
    (movi d ($ 0) (d@r TASK task/foreign-call-cont))     
    (movi d S0 (tos))                              ; push foreign continuation
    (spri d SP AN)                                 ; can't subtract directly...
    (subi d AN S0)                                 ; compute frame size
    (ashi d ($ 6) S0)                              ; shift to byte 2
    (movi b ($ (fx+ header/fault-frame 128)) S0)   ; add header, foreign bit
    (movi d S0 (tos))                              ; push fault frame header
    (addr (label %foreign-return) (tos))           ; push continuation
    (jbr %fault-done)
                                 
;;; registers:  use AN for fault-sp.  Still have A1 = context
%t-code-interrupt                    
    (movi d A1 (tos))                                   ; save context
    (movi d (d@r A1 %%fault-sp-offset) AN)            ; get fault SP in AN

    (movi d ($ (fx/ (fx+ temp-block-size 8) 4)) S0)
%fault-save-loop                                    ; save temps and extra p & s
    (movi d (index-d (d@r TASK -12) S0) (tos))      ; and task/scratch
    (subi d ($ 1) S0)
    (cmpi d S0 ($ 0))
    (j>= %fault-save-loop)

    (movi d (d@r A1 %%df_fp) (tos))         ; TP (FP)
    (movi d (d@r A1 %%df_r6) (tos))         ; AN (R6)
    (movi d (d@r A1 %%df_r5) (tos))         ; A3 (R5)
    (movi d (d@r A1 %%df_r4) (tos))         ; A2 (R4)
    (movi d (d@r A1 %%df_r3) (tos))         ; A1 (R3)
    (movi d (d@r A1 %%df_r2) (tos))         ; P  (R2)
    (movi d (d@r A1 %%df_pc) S0)
    (movi d S0 (tos))
    (cmpi d (d@r nil-reg slink/kernel-begin) S0)
    (j> %not-in-kernel)
    (cmpi d (d@r nil-reg slink/kernel-end) S0)
    (j< %not-in-kernel)
    (movi d (@r AN) (tos))                  ; save hack top of stack
    (movi d ($ 0) (tos))                    ; # of pointers on stack was 0
    (jbr %t-code-done)

%not-in-kernel
    (movi d ($ 0) (tos))                    ; no hacked stack top

;;; find how many pointers were top of stack at time of fault
;;; AN - sp at fault time
;;; S0 -  search pointer
;;; A3 - next pointer slot from stack
;;; NARGS - temp

    (movi d AN S0)                             ; start search at fault sp
%find-last-template-loop
    (movi d (@r S0) A3)                        ; load next word
    (addi d ($ 4) S0)
    (cmpi b ($ header/vframe) A3)              ; vframe?
    (j= %found-frame)                        ; .. if so, done looking

    (movi d A3 NARGS)                          ; copy for extend test
    (andi b ($ #b11) NARGS)
    (cmpi b ($ tag/extend) NARGS)              ; extend?
    (jn= %find-last-template-loop)           ; .. if not, keep looking
    (movi d (d@r A3 -2) nargs)
    (andi b ($ #x7f) nargs)
    (cmpi b ($ header/template) nargs)   ; template?
    (jn= %find-last-template-loop)           ; .. if not, keep looking

%found-frame
    (subi d AN S0)                             ; compute # of pointers (fixnum)
    (subi d ($ 4) S0)                          ; (it was one too high)
    (movi d S0 (tos))                            ; and push on stack
%t-code-done
    (spri d SP S0)
    (subi d S0 AN)                             ; compute total size of frame (-)
    (ashi d ($ 6) S0)                          ; move to byte 2
    (movi b ($ header/fault-frame) S0)         ; add header
    (movi d S0 (tos))                            ; push fault header
    (addr (label %fault-frame-template) (tos)) ; continuation 

%fault-done                                            
    (movi d A2 S0)  ; restore UNIX signal code
    (ashi d ($ 2) S0)                          ; fixnumize
    (movi d S0 A1)                             ; 1st argument is signal code
    (addr (d@r SP 6) A2)                     ; 2nd argument is frame
    (movi d (d@r P (static 'signal-handler)) p)
    (movi d (d@r p 2) p)
    (movi d (d@r P -2) TP)
    (jump (@r TP))

    ))             
                    

(define (local-machine)
  (object nil                               
      ((machine-type self)          'max)
      ((machine-suspend-file self)  '(link maxsuspend))
      ((page-size self)             2048)         ;?????
      ((object-file-type self)      'no)
      ((information-file-type self) 'ni)
      ((noise-file-type self)       'nn)
      ((print-type-string self)     "Machine")))

(define (nan? x) (ignore x) '#f)

(define (st_mtime stat-block)
  (+ (ash (mref-16-u stat-block 34) 16) 
     (mref-16-u stat-block 32)))

(define-integrable (st_size stat-block)
  (mref-integer stat-block 20))


(define-integrable (st_mode stat-block)
  (mref-16-u stat-block 8))
