(herald reducer (env t))

(define-constant I 0)			; fixnums.
(define-constant J 1)
(define-constant Y 2)
(define-constant K 3)
(define-constant T 4)			; Yeah!  T doesn't steal
(define-constant CP 5)			; the symbol T.
(define-constant SP 6)
(define-constant W 7)
(define-constant BP 8)
(define-constant B 9)
(define-constant C 10)
(define-constant P 11)
(define-constant S 12)
(define-constant biggest-basis S)
(define-constant smallest-basis I)
(define-constant empty-stack '())
(define-integrable curry-apply cons)
(define-integrable head car)
(define-integrable tail cdr)
(define-integrable is-top? null?)	; is-top-of-stack?
(define-integrable is-pointer? pair?)
(define (pointer-reversal-reduce fun)
  (labels
      (((start-reduction)		; Start a reduction.
	(reduce fun empty-stack))
       ((reduce fun stack)		; The major reduce loop
	(cond ((is-pointer? fun)	; starts here.
	       (let ((temp (head fun)))
		 (set (head fun) stack)	; Reverse pointers.
		 (reduce temp fun)))
	      ((is-top? stack)		; Reduction done,
	       (print-fun fun))		; print result.
	      (else
	       (select fun		; Hope the compiler
		       ((I) (I-reduce stack)) ; does wonderful things
		       ((J) (J-reduce stack)) ; with this dispatch.
		       ((Y) (Y-reduce stack))
		       ((K) (two-arg-reduce fun stack))
		       ((T) (two-arg-reduce fun stack))
		       ((CP) (two-arg-reduce fun stack))
		       ((SP) (two-arg-reduce fun stack))
		       ((W) (two-arg-reduce fun stack))
		       ((BP) (two-arg-reduce fun stack))
		       ((B) (three-arg-reduce fun stack))
		       ((C) (three-arg-reduce fun stack))
		       ((P) (three-arg-reduce fun stack))
		       ((S) (three-arg-reduce fun stack))
		       (else
			(error "Odd function ~a" fun))))))
       ((I-reduce stack)		; (I x) => x.
	(cond ((is-top? stack)
	       (print-fun I))
	      (else
	       (let ((rest (head stack)))
		 (set (head stack) I)
		 (reduce (tail stack) rest)))))
       ((J-reduce stack)		; (J x) => I.
	(cond ((is-top? stack)
	       (print-fun J))
	      (else
	       (let ((rest (head stack)))
		 (set (head stack) I)
		 (set (tail stack) I)
		 (I-reduce rest)))))
       ((Y-reduce stack)		; (Y f) => fix f.
	(cond ((is-top? stack)
	       (print-fun Y))
	      (else
	       (let ((fun (tail stack)))
		 (set (tail stack) stack)
		 (reduce fun stack)))))
       ((two-arg-reduce fun stack)	; Pop one argument and
	(if (is-top? stack)		; dispatch on fun.
	    (print-fun fun)
	    (let ((arg (tail stack))
		  (rest (head stack)))
	      (set (head stack) fun)
	      (if (not (is-pointer? rest))
		  (unreduce stack rest)
		  (select fun
			  ((K) (K-reduce arg rest))
			  ((T) (T-reduce arg rest))
			  ((CP) (fP-reduce C arg rest))
			  ((SP) (fP-reduce S arg rest))
			  ((W) (W-reduce arg rest))
			  ((BP) (fP-reduce B arg rest))
			  (else
			   (error
			    "Unknown function ~a in two-arg-reduce"
			    fun)))))))
       ((K-reduce arg stack)		; (K x y) => x.
	(set (tail stack) arg)
	(I-reduce stack))
       ((T-reduce arg stack)		; (T x y) => (y x).
	(let ((fun (tail stack)))
	  (set (tail stack) arg)
	  (reduce fun stack)))
       ((W-reduce arg stack)		; (W x y) => (x y y).
	(reduce (curry-apply arg (tail stack)) stack))
       ((fP-reduce fun arg stack)	; (fP x y) => (f (B x y))
	(set (tail stack)		; where f = C, S or B.
	     (curry-apply (curry-apply B arg)
			  (tail stack)))
	(reduce fun stack))
       ((three-arg-reduce fun stack)	; Pop two args and
	(if (is-top? stack)		; dispatch on fun.
	    (print-fun fun)
	    (let ((arg (tail stack))
		  (temp (head stack)))
	      (set (head stack) fun)
	      (if (is-top? temp)
		  (unreduce stack temp)
		  (let ((arg1 (tail temp))
			(rest (head temp)))
		    (set (head temp) stack)
		    (if (not (is-pointer? rest))
			(unreduce temp rest)
			(select fun
				((B) (B-reduce arg arg1 rest))
				((C) (C-reduce arg arg1 rest))
				((P) (P-reduce arg arg1 rest))
				((S) (S-reduce arg arg1 rest))
				(else
				 (error
				  "Unknown function ~a in three-arg-reduce"
				  fun)))))))))
       ((B-reduce arg arg1 stack)	; (B x y z) => (x (y z)).
	(set (tail stack)
	     (curry-apply arg1 (tail stack)))
	(reduce arg stack))
       ((C-reduce arg arg1 stack)	; (C x y z) => (x z y).
	(let ((fun (curry-apply arg (tail stack))))
	  (set (tail stack) arg1)
	  (reduce fun stack)))
       ((P-reduce arg arg1 stack)	; (P x y z) => (z x y).
	(let ((fun (curry-apply (tail stack) arg)))
	  (set (tail stack) arg1)
	  (reduce fun stack)))
       ((S-reduce arg arg1 stack)	; (S x y z) => (x z (y z)).
	(let ((arg2 (tail stack)))
	  (set (tail stack)
	       (curry-apply arg1 arg2))
	  (reduce (curry-apply arg arg2) stack)))
       ((unreduce fun stack)		; Pop stack.
	(if (is-top? stack)
	    (print-fun fun)
	    (let ((rest (head stack)))
	      (set (head stack) fun)
	      (unreduce stack rest))))
       ((print-fun fun) fun))		; Print result of reduction.
    (start-reduction)))


