(herald (back_end n32rep)                                              ;87/02/09
  (env t (orbit_top defs)))

;;; Copyright (c) 1985 Yale University
;;;     Authors: N Adams, R Kelsey, D Kranz, J Philbin, J Rees.
;;; This material was developed by the T Project at the Yale University Computer 
;;; Science Department.  Permission to copy this software, to redistribute it, 
;;; and to use it for any purpose is granted, subject to the following restric-
;;; tions and understandings.
;;; 1. Any copy made of this software must include this copyright notice in full.
;;; 2. Users of this software agree to make their best efforts (a) to return
;;;    to the T Project at Yale any improvements or extensions that they make,
;;;    so that these may be included in future releases; and (b) to inform
;;;    the T Project of noteworthy uses of this software.
;;; 3. All materials developed as a consequence of the use of this software
;;;    shall duly acknowledge such use, in accordance with the usual standards
;;;    of acknowledging credit in academic research.
;;; 4. Yale has made no warrantee or representation that the operation of
;;;    this software will be error-free, and Yale is under no obligation to
;;;    provide any services, by way of maintenance, update, or otherwise.
;;; 5. In conjunction with products arising from the use of this material,
;;;    there shall be no use of the name of the Yale University nor of any
;;;    adaptation thereof in any advertising, promotional, or sales literature
;;;    without prior written consent from Yale in each case.
;;;

(define (rep-analyze-top node)
  (rep-analyze ((call-arg 1) (lambda-body node)))
  (rep-analyze ((call-arg 1) (lambda-body node))))

(define (rep-analyze node)
  (cond ((lambda-node? node)
         (rep-analyze-call (lambda-body node))
         (select (lambda-strategy node)
           ((strategy/label strategy/open) 
            (walk (lambda (var)
                    (or (eq? (variable-type var) type/top)
                        (neq? (variable-rep var) 'rep/pointer)
                        (set (variable-rep var) (most-important-rep var))))
                  (if (continuation? node)
                      (lambda-variables node)
                      (cdr (lambda-variables node)))))))))


(define (rep-analyze-call node)
  (let ((proc (call-proc node)))
    (cond ((lambda-node? proc)
           (walk rep-analyze (call-args node))
           (rep-analyze-call (lambda-body proc)))
	  ((not (primop-node? proc))
           (walk rep-analyze (call-args node)))
          ((eq? (primop-value proc) primop/Y)
           (rep-analyze ((call-arg 1) node))
           (destructure (((body . procs) 
                          (call-args (lambda-body ((call-arg 2) node)))))
             (walk rep-analyze procs)
             (rep-analyze body)))
          (else
	   (walk rep-analyze (call-args node))
	   (cond ((and (eq? (primop-value proc) primop/contents-location)
		       (lambda-node? ((call-arg 1) node))
		       (eq? (variable-rep (lambda-cont-var ((call-arg 1) node)))
			    'rep/pointer))
		  (set (variable-rep (lambda-cont-var ((call-arg 1) node)))
		       (primop.rep-wants (leaf-value ((call-arg 2) node))))))))))


(define (most-important-rep var)
  (iterate loop ((refs (variable-refs var)) (reps '()))
    (cond ((null? refs) 
           (select-rep (reverse! reps) (variable-type var)))
          (else
           (let* ((parent (node-parent (car refs)))
                  (proc (call-proc parent))
                  (number (call-arg-number (node-role (car refs)))))
             (cond ((primop-node? proc)
                    (cond ((primop.rep-wants (primop-value proc))
                           => (lambda (creps)
				(let ((rep 
				       (nth creps (fx- (fx- number
                                                    (call-exits parent))
							     1))))
				  (if (neq? rep '*)
				      (loop (cdr refs) (cons rep reps))
				      (let ((cont ((call-arg 1) parent)))
					(loop (cdr refs)
					      (if (leaf-node? cont)
						  (cons 'rep/pointer reps)
						  (let ((rep (variable-rep
							 (lambda-cont-var cont))))
					    (cons (if (eq? (rep-size rep) 4)
						      rep
						      'rep/integer)
						  reps)))))))))
                          ((eq? (primop-value proc) primop/contents-location)
			   (loop (cdr refs)
				 (cons
                           (if (and (fx= number 4) 
                                    (fx< (rep-size (primop.rep-wants
                                             (leaf-value ((call-arg 2) parent))))
                                          size/long))
                               'rep/integer 'rep/pointer)
			   reps)))
                          ((eq? (primop-value proc) primop/set-location)
			   (loop (cdr refs)
				 (cons 
                           (cond ((and (fx= number 5)
                                       (fx< (rep-size (primop.rep-wants
                                               (leaf-value ((call-arg 2) parent))))
                                            size/long))
                                  'rep/integer)
                                 ((fx= number 3)
                                  (primop.rep-wants 
                                      (leaf-value ((call-arg 2) parent))))
                                 (else 'rep/pointer))
			   reps)))
                          (else 
                           (loop (cdr refs) reps))))
                   ((variable-known (leaf-value proc)) 
                    => (lambda (label)
                         (cond ((lambda-rest-var label) 
                                (loop (cdr refs) reps))
                               (else
				(loop (cdr refs)
				      (cons (variable-rep (nth (lambda-variables label)
							       (fx- number 1)))
					    reps))))))
                   (else
                    (loop (cdr refs) (cons 'rep/pointer reps)))))))))

(define (select-rep reps type)
  (cond ((null? reps)
	 'rep/pointer)
	((eq? type type/char)
	 (car reps))
	(else
	 (let ((size (rep-size (car reps))))
	   (iterate loop ((r (cdr reps)))
	     (cond ((null? r) (car reps))
		   ((fx= (rep-size (car r)) size)
		    (loop (cdr r)))
		   (else
		    (car (sort-list! reps (lambda (x y)
					    (fx> (rep-size x) (rep-size y))))))))))))



(define (access-with-rep node value rep)                               ;87/02/09
  (access-with-rep-reg node value rep nil))

(define (access-with-rep-reg node value rep reg)                       ;87/02/09
  (cond ((variable? value)
         (let ((acc (access-value node value)))
           (cond ((rep-converter (variable-rep value) rep)
                  => (lambda (converter)
                       (let* ((rep-type (if (eq? rep 'rep/pointer) 'pointer 'scratch))
                              (reg (cond ((and (register? acc) 
                                               (eq? (reg-type acc) rep-type)
                                               (dying? value node))
                                            acc)
                                         ((and (register? reg) 
                                               (not (reg-node reg))
                                               (eq? (reg-type reg) rep-type))
                                          reg)
                                         (else 
                                          (get-register rep-type node '*)))))
                         (converter node acc reg)
                         reg)))
                 (else acc))))
        ((eq? rep 'rep/pointer)
         (access-value node value))
        (else
         (value-with-rep value rep))))


(lset *reps* '(rep/char                                                ;87/02/09
               rep/extend
               rep/double
               rep/integer
               rep/integer-8-s
               rep/integer-8-u
               rep/integer-16-s
               rep/integer-16-u
               rep/string
               rep/pointer))

(define-constant size/byte 1)                                          ;87/02/09
(define-constant size/word 2)
(define-constant size/long 4)
(define-constant size/double 8)


(lset *rep-converter-table* (make-table 'reps))                        ;87/02/09

(walk (lambda (rep)                                                    ;87/02/09
        (set (table-entry *rep-converter-table* rep) 
             (make-table rep)))
      *reps*)

(define (rep-size rep)                                                 ;87/02/09
  (xcase rep
    ((rep/char rep/integer-8-u rep/integer-8-s) size/byte)
    ((rep/integer-16-u rep/integer-16-s) size/word)
    ((rep/pointer rep/integer rep/extend rep/string) size/long)
    ((rep/double) size/double)))

(define-local-syntax (define-rep-converter from to proc)               ;87/02/09
  `(set (table-entry (table-entry *rep-converter-table* ',to) ',from)
        ,proc))

;;; rep/extend is for, e.g. a pascal array.  Point to first descriptor in 
;;; stored object.

(define-rep-converter rep/pointer rep/extend                           ;87/02/09
  (lambda (node from to)
    (generate-move from to)
    (emit n32/addi d (machine-num (fx- 4 tag/extend)) to)))

;;; only used in foreign calls; we know registers have been saved

(define-rep-converter rep/pointer rep/string                           ;87/02/09
  (lambda (node from to)             
    (let ((reg (cond ((register? from) from)
                     (else
                      (generate-move from AN)
                      AN)))) 
      (emit n32/movi d (reg-offset reg offset/string-text) S0)
      (emit n32/addi d (reg-offset reg offset/string-base) S0)
      (emit n32/addi d (machine-num (fx- 4 tag/extend)) S0)
      (emit n32/movi d S0 to))))

(define-rep-converter rep/pointer rep/char                             ;87/02/09
  (lambda (node from to)
    (cond ((register? to)
           (generate-move from to)
           (emit n32/ashi d (machine-num -8) to))
          (else
           (let ((reg (get-free-scratch-register)))
             (emit n32/movi d from reg)
             (emit n32/ashi d (machine-num -8) reg)
             (emit n32/movi b reg to))))))

(define-rep-converter rep/pointer rep/integer                          ;87/02/09
  (lambda (node from to)                    
    (cond ((register? to)
           (generate-move from to)
           (emit n32/ashi d (machine-num -2) to))
          (else
           (let ((reg (get-free-scratch-register)))
             (emit n32/movi d from reg)
             (emit n32/ashi d (machine-num -2) reg)
             (emit n32/movi d reg to))))))

(define (pointer->integer-16 node from to)                             ;87/02/09
    (cond ((register? to)
           (generate-move from to)
           (emit n32/ashi d (machine-num -2) to))
          (else
           (let ((reg (get-free-scratch-register)))
             (emit n32/movi d from reg)
             (emit n32/ashi d (machine-num -2) reg)
             (emit n32/movi w reg to)))))

(define-rep-converter rep/pointer rep/integer-16-u                     ;87/02/09
  pointer->integer-16)

(define-rep-converter rep/pointer rep/integer-16-s                     ;87/02/09
  pointer->integer-16)

(define (pointer->integer-8 node from to)                              ;87/02/09
    (cond ((register? to)
           (generate-move from to)
           (emit n32/ashi d (machine-num -2) to))
          (else
           (let ((reg (get-free-scratch-register)))
             (emit n32/movi d from reg)
             (emit n32/ashi d (machine-num -2) reg)
             (emit n32/movi b reg to)))))

(define-rep-converter rep/pointer rep/integer-8-u                      ;87/02/09
  pointer->integer-8)

(define-rep-converter rep/pointer rep/integer-8-s                      ;87/02/09
  pointer->integer-8)
                 
;----------------------------

(define-rep-converter rep/char rep/pointer                             ;87/02/09
  (lambda (node from to)
    (let ((temp (if (and (register? to) (eq? (reg-type to) 'scratch))
                    to
                    (get-free-scratch-register))))
      (emit n32/movzid b from temp)
      (emit n32/ashi d (machine-num 8) temp)
      (emit n32/movi b (machine-num header/char) temp)
      (generate-move temp to))))                              

;-----------------------------

(define-rep-converter rep/integer rep/pointer                          ;87/02/09
  (lambda (node from to)
    (let ((reg (if (and (register? to) (eq? (reg-type to) 'scratch))
                   to
                   (get-free-scratch-register))))
      (generate-move from reg)
      (emit n32/ashi d (machine-num 2) reg)
      (generate-move reg to))))

;--------------------------------

(define-rep-converter rep/integer-16-s rep/pointer                     ;87/02/09
  (lambda (node from to)
    (rep-convert-safely node from to n32/movxid w)))

(define-rep-converter rep/integer-16-s rep/integer                     ;87/02/09
  (lambda (node from to)
    (emit n32/movxid w from to)))

;----------------------------------

(define-rep-converter rep/integer-16-u rep/pointer                     ;87/02/09
  (lambda (node from to)
    (rep-convert-safely node from to n32/movzid w)))

(define-rep-converter rep/integer-16-u rep/integer                     ;87/02/09
  (lambda (node from to)
    (emit n32/movzid w from to)))

;------------------------------------

(define-rep-converter rep/integer-8-s rep/pointer                      ;87/02/09
  (lambda (node from to)
    (rep-convert-safely node from to n32/movxid b)))

(define-rep-converter rep/integer-8-s rep/integer                      ;87/02/09
  (lambda (node from to)
    (emit n32/movxid b from to)))

(define-rep-converter rep/integer-8-s rep/integer-16-s                 ;87/02/09
  (lambda (node from to)
    (emit n32/movxiw b from to)))

(define-rep-converter rep/integer-8-s rep/integer-16-u                 ;87/02/09
  (lambda (node from to)
    (emit n32/movxiw b from to)))
                                     
;---------------------------------------

(define-rep-converter rep/integer-8-u rep/pointer                      ;87/02/09
  (lambda (node from to)
    (rep-convert-safely node from to n32/movzid b)))

(define-rep-converter rep/integer-8-u rep/integer                      ;87/02/09
  (lambda (node from to)
    (emit n32/movzid b from to)))

(define-rep-converter rep/integer-8-u rep/integer-16-s                 ;87/02/09
  (lambda (node from to)
    (emit n32/movziw b from to)))

(define-rep-converter rep/integer-8-u rep/integer-16-u                 ;87/02/09
  (lambda (node from to)
    (emit n32/movziw b from to)))
                  
(define-rep-converter rep/double rep/pointer
  (lambda (node from to)
    (free-register node AN)
    (generate-slink-jump slink/make-double-float)
    (emit n32/movi d from (d@r AN 2))
    (generate-move AN to)))

(define-rep-converter rep/pointer rep/double
  (lambda (node from to)
    (cond ((register? from)
           (emit n32/movi d (d@r from 2) to))
          (else
           (let ((reg (get-register 'pointer node '*)))
             (emit n32/movi d from reg)
             (emit n32/movi d (d@r reg 2) to))))))

;------------------------------------------

(define (rep-converter from-rep to-rep)                                ;87/02/09
  (table-entry (table-entry *rep-converter-table* to-rep) from-rep))

(define (rep-convert-safely node from to inst size)                    ;87/05/26
  (let ((temp (if (eq? (reg-type to) 'scratch)
                  to
                  (get-free-scratch-register))))
    (emit inst size from temp)
    (emit n32/ashi d (machine-num 2) temp)
    (generate-move temp to)))

(define (really-rep-convert node from from-rep to to-rep)              ;87/02/09
  (cond ((rep-converter from-rep to-rep)
         => (lambda (converter) (converter node from to)))
        ((eq? to-rep 'rep/pointer)
         (generate-move from to))
        ((neq? from to)
         (emit n32/movi (n32-size to-rep) from to))))

(define (value-with-rep value rep)                                     ;87/02/09
  (xcond ((char? value)
          (xcond ((eq? rep 'rep/char)
                  (machine-num (char->ascii value)))
                 ((eq? rep 'rep/pointer)
                  (machine-num (fixnum-logior (fixnum-ashl (char->ascii value) 8)
                                              header/char)))))
         ((fixnum? value)
          (cond ((eq? rep 'rep/pointer)
                 (lit value))
                (else
                 (machine-num value))))
         ((eq? value '#T)
          (machine-num header/true))
         ((or (eq? value '#F) (eq? value '()))
          (access-nil))))
                                                                    
;; can't return nil-reg; it's a special register

(define-constant (access-nil)
  (reg-offset nil-reg slink/nil-car))

;;; need this because of PARASSIGN:  say we're doing a PARASSIGN involving all
;;; the scratch registers, and we need to use a scratch register for a rep
;;; conversion.  If we free up a scratch register, PARASSIGN will not know
;;; because it is written in terms of registers, not values.  So we introduce
;;; task/scratch (analogue of SCRATCH on the 68000) and use it when no
;;; scratch registers are available.

(define (get-free-scratch-register)
  (iterate loop ((i 0))
    (cond ((fx= i *scratch-registers*)
           (reg-offset TASK task/scratch))
          ((not (reg-node i))
           i)
          (else
           (loop (fx+ i 1))))))

