(herald fix)

(lset primop/lap nil)
(lset primop/lap-template nil)

(set known-primops `((lap #f) (lap-template #f) ,@known-primops))

(define (analyze top-node)
  (analyze-top top-node)
  (live-analyze-top top-node)
  (collect-top top-node)
  (bind ((*noise-flag* t))
    (print-variable-info *unit-variables*))
  (type-analyze-top top-node)
  (rep-analyze-top top-node)
  (close-analyze-top top-node nil))

(define (make-method state vars body)
  (cond ((atom? state)        ; old form
         `(,syntax/lambda (,state . ,vars)   
               (,syntax/declare ignorable ,state)
	       (,primop/remove-state-object)
               . ,body))
        ((fxn= 2 (length state))
         (error "bad syntax in state section of method clause ~S" state))
        (else
         (destructure (((self obj) state))
          `(,syntax/lambda (,self . ,vars)  
             ((,syntax/lambda (,obj)  . ,body)
	      (,primop/remove-state-object)))))))

(define (allocate-general-call node)
  (let ((cont ((call-arg 1) node)))
    (cond ((lambda-node? cont)     
           (parallel-assign-general node))
          (else                          
           (parallel-assign-general node)          
           (restore-continuation node cont))))
  (clear-slots)
  (generate-general-call (reference-variable (call-proc node))
			 (fx- (length (call-args node)) 1)))

(define (do-unit-variables thing)
  (iterate loop ((a-list `((,*the-environment* . 12) (,thing . 16)))
                 (vars (delq! *the-environment* *unit-variables*)); header 0
                 (count 20))                                      ; id 4
    (cond ((null? vars) (return a-list count))                    ; filename 8
          (else                                                   ; env 12
           (let ((var (car vars)))                                ; thing 16
	     (receive (value? vcell?)
		      (cond ((defined-variable? var)
			     (if (null? (cdr (variable-refs var)))
				 (return nil t)
				 (return (all-important-refs-are-calls? var) t)))
			    ((all-important-refs-are-calls? var)
			     (return t nil))
			    (else
			     (return nil t)))
	       (if (and value? vcell?)
		   (loop `(,(cons var (fx+ count cell)) 
			   ,(cons (create-loc-list var) count)
			   ,@a-list)
			 (cdr vars)
			 (fx+ count (fx* CELL 2)))
		   (if value? 
		       (loop `(,(cons var count) ,@a-list)
			     (cdr vars)
			     (fx+ count CELL))
		       (loop `(,(cons (create-loc-list var) count) ,@a-list)
			     (cdr vars)
			     (fx+ count CELL))))))))))

(define (create-comex filename h unit templates thing code)
  (let ((size (fx+ (fx+ (length unit) 4) (fx* (length templates) 2))) ; hack,
        (comex (make-comex)))                                         ; template
    (receive (objects opcodes)                                        ; in both
             (create-obj-op-vectors thing unit size filename h)
      (set (comex-module-name comex) version-number)
      (set (comex-code comex) code)
      (set (comex-objects comex) objects)
      (set (comex-opcodes comex) opcodes)           
      (set (comex-annotation comex) nil)
      comex)))

(define (comex-decipher obj)
  (cond ((foreign-name obj)
         => (lambda (name) (return op/foreign name)))
        ((and (node? obj) (lambda-node? obj))
         (return op/closure (code-vector-offset obj)))
        ((loc-list? obj)
         (vcell-status (loc-list-var obj)))
        ((not (variable? obj))
         (return op/literal obj))
        (else
         (return op/variable-value (variable-name obj)))))



(define (vcell-status var)
  (let ((name (variable-name var)))
    (cond ((not (defined-variable? var))
	   (return op/vcell name))
	  (else
	   (case (defined-variable-variant var)
	     ((set) (return op/vcell name))
	     ((lset) (return op/vcell-lset name))
	     (else
	      (let ((l (defined-variable-value var)))
		(cond ((and l
			    (let ((node ((call-arg 3) (node-parent l))))
			      (and (lambda-node? node)
				   (assq node (closure-env *unit*)))))
		       => (lambda (pair)
			    (return op/vcell-stored-definition
				    (cons name (cdr pair)))))
		      (else
		       (return op/vcell-defined name))))))))))



(define (all-important-refs-are-calls? var)
  (every? (lambda (ref)
	    (or (eq? (node-role ref) call-proc)
		(and (eq? (node-role ref) (call-arg 2))
		     (let ((call (node-parent ref)))
		       (primop-ref? (call-proc call) primop/*define)))))
	  (variable-refs var)))

(define (var-is-vcell? var)
  (and (not (all-important-refs-are-calls? var))
       (neq? var *the-environment*)))


(define (access-value node value)
  (cond ((and (variable? value)
	      (not (variable-binder value))
	      (var-is-vcell? value))
	 (let ((acc (lookup node (get-lvalue value) nil)))
	   (let ((reg (get-register 'pointer node '*)))
	     (generate-move acc reg)
	     (reg-offset reg 2))))
	(else
	 (really-access-value node value))))

(define (really-access-value node value)               
 (let ((value (cond ((and (variable? value) (variable-known value))
                     => lambda-self-var)
                    (else value))))
  (cond ((register-loc value)
         => (lambda (spec)
              (cond ((fixnum? spec))
                    (else
                     (cond ((pair? (car spec))
                            (unlock (caar spec))
                            (cond ((reg-node (caar spec))
                                   => (lambda (var) (kill-if-dying var node))))
                            (unlock (cdar spec)))
                           (else
                            (unlock (car spec))
                            (cond ((reg-node (car spec))
                                   => (lambda (var) (kill-if-dying var node))))))
                     (set (register-loc value) nil)))
              spec))
        ((temp-loc value))
        ((variable? value)
         (let ((binder (variable-binder value)))
           (cond ((not binder)
                  (lookup node value nil))
                 ((and (fx= (variable-number value) 0) 
                       (assq binder (closure-env *unit*)))
                  (lookup node binder nil))
                 (else
                  (lookup node value binder)))))
        ((primop? value)
         (if (eq? value primop/undefined)
             (machine-num 0)
             (lookup node value nil)))
        ((eq? value '#T)
         (machine-num header/true))
        ((or (eq? value '#F) (eq? value '()))
          nil-reg)
        ((addressable? value)
         (lit value))
        (else
         (lookup node value nil)))))



	   

(define (hoist-continuation cont)
  (let* ((call (node-parent cont))
         (live (hack-live (lambda-live cont) call)))
  (iterate loop ((call call))
    (let ((l (node-parent call)))       
      (cond ((or (primop-ref? (call-proc (node-parent l))
			      primop/remove-state-object)
	         (neq? (lambda-strategy l) strategy/open)
                 (intersection? (lambda-variables l) live)
                 (eq? (node-role l) call-proc)
                 (fxn= (call-exits (node-parent l)) 1))
             (set (call-hoisted-cont call) cont))
            (else
             (loop (node-parent l))))))))


(comment
(define-local-syntax (ass-comment string . rest)
  `(if *assembly-comments?*
       (emit-comment (format nil ,string ,@rest))))
   
(define (initialize-registers node)
  (xselect (lambda-strategy node)
    ((strategy/heap strategy/hack)                                       
     (ass-comment "Procedure ~s (lambda ~s ...)" 
             (lambda-name node)
             (append! (map variable-unique-name (lambda-variables node))
                      (cond ((lambda-rest-var node) => variable-unique-name)
                            (else '()))))
     (cond ((method-lambda node)
            => (lambda (obj)
                 (mark (lambda-self-var obj) P)
                 (set *lambda* obj)))
           (else
            (mark (lambda-self-var node) P)))
     (mark-vars-in-regs (cdr (lambda-variables node))))
    ((strategy/stack)
     (ass-comment "Continuation ~s (lambda ~s ...)"
             (lambda-name node)
             (append! (map variable-unique-name (lambda-variables node))
                      (cond ((lambda-rest-var node) => variable-unique-name)
                            (else '()))))
     (continuation-nargs-check node)
     (mark-vars-in-regs (lambda-variables node)))
    ((strategy/vframe)
     (ass-comment "Procedure ~s (lambda ~s ...)" 
             (lambda-name node)
             (map variable-unique-name (lambda-variables node)))
     (mark (lambda-self-var *lambda*) P)
     (mark-vars-in-regs (cdr (lambda-variables node))))
    ((strategy/ezclose)
     (ass-comment "Procedure ~s (lambda ~s ...)" 
             (lambda-name node)
             (map variable-unique-name (lambda-variables node)))
     (mark-vars-in-regs (cdr (lambda-variables node))))
    ((strategy/label)
     (ass-comment "Label procedure ~s (lambda ~s ...)" 
             (lambda-name node)
             (map variable-unique-name (lambda-variables node)))
     (cond ((join-point-contour-needed? (lambda-env node))
            (let ((contour (join-point-contour (lambda-env node))))
              (mark contour P)
              (if (closure-cit-offset (environment-closure 
                        (lambda-env (variable-binder contour))))
                  (generate-move (reg-offset P -2) TP)))))
     (walk (lambda (var arg-spec)
             (mark var (car arg-spec)))
          (if (continuation? node)
              (lambda-variables node)
              (cdr (lambda-variables node)))
          (join-point-arg-specs (lambda-env node)))
     (walk (lambda (pair)
             (mark (cdr pair) (car pair)))
           (join-point-global-registers (lambda-env node))))))


(define (continuation-nargs-check node)
  (let ((no-args (length (lambda-variables node))))
    (cond ((n-ary? node)
	   (cond ((or (fx> no-args 0) (used? (lambda-rest-var node)))
		  (emit m68/cmp .b ($ (fx- -1 no-args)) nargs)
		  (emit-hacked-branch jump-op/j<= 6)
		  (generate-jump-absolute (*d@nil slink/cont-wrong-nargs)))))
	  (else
	   (emit m68/cmp .b ($ (fx- -1 no-args)) nargs)
	   (emit-hacked-branch jump-op/j= 6)
	   (generate-jump-absolute (*d@nil slink/cont-wrong-nargs))))))
)	       


(define (static var-name)
  (let* ((a-list (closure-env *unit*))
         (val (ass (lambda (name var)
                     (and (loc-list? var)
			  (eq? (variable-name (loc-list-var var)) name)))
                   var-name
                   a-list)))
    (cond (val
           (fx- (cdr val)
                (fx+ (cond ((assq *lambda* (cddr a-list))
                            => cdr)
                           (else
                            (cdr (last a-list))))
                      tag/extend)))
          (else
           (error "static value not mentioned ~s" var-name)))))

(define (generate-set-vector-elt node)
  (destructure (((#f type value loc idex) (call-args node)))
    (let ((idex (leaf-value idex))
          (rep (primop.rep-wants (leaf-value type)))
	  (reg (->register 'pointer node (leaf-value loc) '*)))
      (lock reg)
      (cond ((eq? rep 'rep/pointer)
             (let* ((access (if (lambda-node? value)
                                (access/make-closure node value)
                                (access-value node (leaf-value value))))
                    (value-acc (if access access AN)))
               (if access (protect-access access) (lock AN))
               (let* ((i-acc (access-with-rep node idex 'rep/pointer))
                      (i-reg (cond ((register? i-acc) i-acc)
                                   (else
                                    (emit m68/move .l i-acc SCRATCH)
                                    SCRATCH))))
                 (generate-move value-acc (indexer reg tag/extend i-reg))
		 (unlock reg)
                 (if access (release-access access) (unlock AN)))))
            (else                                                               
             (let* ((i-acc (access-with-rep node idex 'rep/integer))
                    (i-reg (cond ((register? i-acc) i-acc)
                                 (else
                                  (let ((i (get-register 'scratch node '*)))
                                    (emit m68/move .l i-acc i)
                                    i))))
                    (value (leaf-value value)))
                 (lock i-reg)
                 (cond ((variable? value)                       
                        (let ((acc (access-value node value)))
                          (protect-access acc)
                          (really-rep-convert node acc (variable-rep value)
                                   (indexer reg tag/extend i-reg)
                                   rep)
                          (release-access acc)))
                       (else
                        (really-rep-convert node (value-with-rep value rep)
                                            rep
                                            (indexer reg tag/extend i-reg)
                                            rep)))
                 (unlock i-reg)
                 (unlock reg)))))))