(herald fix)

;;; Interpret this to protect against looping gc (no changes to proc)
#|
(define (initialize-span sdfs index sdf)
  (let ((span (fx- (ib-address (sdf-label sdf)) 
                   (mark-address (sdf-mark sdf))))
        (label-sdf# (ib-sdf-number (sdf-label sdf)))
        (mark-sdf# (mark-sdf-position (sdf-mark sdf))))
    
    (set (sdf-backwards? sdf) (fx>= mark-sdf# label-sdf#))
    (set (sdf-span sdf) span)
    
    ;; consistency check
    (cond ((or (and (fx> (sdf-span sdf) 0) (sdf-backwards? sdf))
               (and (fx< (sdf-span sdf) 0) (not (sdf-backwards? sdf))))
           (bug "inconsistent sdf ~s ~%" sdf)))
    
    (let ((dest (ib-sdf-number (sdf-label sdf))))
      (receive (start end) 
               (cond ((fx> dest index) (return (fx+ index 1) dest)) ;forward
                     (else (return dest index)))
        (do ((i start (fx+ i 1)))
            ((fx>= i end) sdf)
          (push (sdf-crossers (vref sdfs i)) sdf))))
    (set (sdf-width sdf) (sdf-static-first-width (sdf-static sdf)))))
|#
;;; For MOVf.  This is temporary, for one instruction in one place.  Really we
;;; need representations for floating point registers.  For now, using the "R"
;;; registers result in the right bits but the wrong mnemonics.

(define (n32-mnem port mnem size)
  (let ((len (string-length mnem)))
    (iterate loop ((i 0))
      (cond ((fx= i len) 'done)
            (else
             (let ((c (string-elt mnem i)))
               (cond ((char= c #\i)
                      (write-char port (n32-format-i size)))
                     ((char= c #\f)
                      (write-char port (n32-format-f size)))
                     (else
                      (write-char port c)))
               (loop (fx+ i 1))))))))

(define make-n32-format-11
  (let ((f11-fg
         (fg-template (n32-format-11 mnem size opc src dst)
           (print (p) (n32-mnem p mnem size) (format p "~g,~g" src dst))
           (local start s-ext d-ext)
           (set-context-item s-ext (general (size size) (start start)
                                            (type 'float)))
           (set-context-item d-ext (general (size size) (start start)
                                            (type 'float)))
           (fields
            (mark start)
            (group
             (subfield (n32-operand-mode src)) 
             (subfield (n32-operand-mode dst)) 
             (fixed 4 opc) (0) (fixed 1 size) (1 0 1 1  1 1 1 0))
            (subfield (n32-index-bytes src dst))
            (subfield s-ext (n32-operand-extension src)) 
            (subfield d-ext (n32-operand-extension dst)) 
            ))))
    (lambda (mnem opc)
      (lambda (size src dst)
        (f11-fg mnem size opc src dst)))))

(define-op n32 MOVf     113 (make-n32-format-11   "MOVf    " #x1))
(define n32/movf (table-entry (machine-ops-table n32) 'movf))
#|
(define bignum-bit-field 
  (eval '(lambda (a b c)
	   (cond ((negative? a)
		  (let ((new (bignum-negate a)))
		    (do ((i (fx- (bignum-length new) 1) (fx- i 1)))
			((fx< i 0)
			 (bignum-bit-field (+ new 1) b c))
		      (modify (bignum-digit new i) fixnum-lognot))))
		 (else
		  (bignum-bit-field a b c))))
	t-implementation-env))
|#


(define-fg (n32-hack-branch jop disp)
  (printer "B~a     *+6"  (n32-jump-op-name jop))
  (fields
   (fixed 4 jop) (1 0 1 0) (fixed 8 disp)))

(define listing quicklist)