(herald (assembler n32ops t 56)
        (env tsys (assembler as_open))
        )

;;; It would be OK to remove all "i" and "f" size markers
;;; from instruction names except in the floating point names
;;; (though ROUND TRUNC and FLOOR would be OK if trimmed)
;;; The "i"'s and "f"'s should NOT be removed from the mnemonics
;;; (the strings) - they are used for formatting the output

(define-op n32 Bcc      15 (lambda (cc tag) (n32-format-0 "B" cc tag)))
(define-op n32 BSR      16 (make-n32-format-1d   "BSR     " #x02))
(define-op n32 RET      17 (make-n32-format-1d   "RET     " #x12)) ;takes fixnum
(define-op n32 CXP      18 (make-n32-format-1d   "CXP     " #x22))
(define-op n32 RXP      19 (make-n32-format-1d   "RXP     " #x32))
(define-op n32 RETT     20 (make-n32-format-1d   "RETT    " #x42))
(define-op n32 RETI     21 (make-n32-format-1    "RETI    " #x52))
(define-op n32 SAVE     22 (make-n32-format-1rl  "SAVE    " #x62 '#f))
(define-op n32 RESTORE  23 (make-n32-format-1rl  "RESTORE " #x72 '#t))
(define-op n32 ENTER    24 (make-n32-format-1rld "ENTER   " #x82 '#f))
(define-op n32 EXIT     25 (make-n32-format-1rl  "EXIT    " #x92 '#t))
(define-op n32 NOP      26 (make-n32-format-1    "NOP     " #xA2))
(define-op n32 WAIT     27 (make-n32-format-1    "WAIT    " #xB2))
(define-op n32 DIA      28 (make-n32-format-1    "DIA     " #xC2))
(define-op n32 FLAG     29 (make-n32-format-1    "FLAG    " #xD2))
(define-op n32 SVC      30 (make-n32-format-1    "SVC     " #xE2))
(define-op n32 BPT      31 (make-n32-format-1    "BPT     " #xF2))
(define-op n32 ADDQi    32 (make-n32-format-2    "ADDQi   " 0))
(define-op n32 CMPQi    33 (make-n32-format-2    "CMPQi   " 1))
(define-op n32 SPRi     34 (make-n32-format-2    "SPRi    " 2))
(define-op n32 Scondi   35 (make-n32-format-2    "Scondi  " 3))
(define-op n32 ACBi     36 (make-n32-format-2d   "ACBi    " 4))
(define-op n32 MOVQi    37 (make-n32-format-2    "MOVQi   " 5))
(define-op n32 LPRi     38 (make-n32-format-2    "LPRi    " 6))
(define-op n32 CXPD     39 (make-n32-format-3'   "CXPD    " 0))
(define-op n32 BICPSRi  40 (make-n32-format-3    "BICPSRi " 1))
(define-op n32 JUMP     41 (make-n32-format-3'   "JUMP    " 2))
(define-op n32 BISPSRi  42 (make-n32-format-3    "BISPSRi " 3))
(define-op n32 ADJSPi   43 (make-n32-format-3    "ADJSPi  " 5))
(define-op n32 JSR      44 (make-n32-format-3'   "JSR     " 6))
(define-op n32 CASEi    45 (make-n32-format-3    "CASEi   " 7))
(define-op n32 %ADDi     46 (make-n32-format-4    "ADDi    " #x0))
(define-op n32 %CMPi     47 (make-n32-format-4    "CMPi    " #x1))
(define-op n32 BICi     48 (make-n32-format-4    "BICi    " #x2))
(define-op n32 ADDCi    49 (make-n32-format-4    "ADDCi   " #x4))
(define-op n32 %MOVi     50 (make-n32-format-4    "MOVi    " #x5))
(define-op n32 ORi      51 (make-n32-format-4    "ORi     " #x6))
(define-op n32 %SUBi     52 (make-n32-format-4    "SUBi    " #x8))
(define-op n32 ADDR     53 (make-n32-format-4'   "ADDR    " #x9))
(define-op n32 ANDi     54 (make-n32-format-4    "ANDi    " #xA))
(define-op n32 TBITi    55 (make-n32-format-4    "TBITi   " #xD))
(define-op n32 XORi     56 (make-n32-format-4    "XORi    " #xE))
(define-op n32 MOVSi    57 (make-n32-format-5    "MOVSi   " #b000000))
(define-op n32 MOVST    58 (make-n32-format-5t   "MOVST   " #b100000))
(define-op n32 CMPSi    59 (make-n32-format-5    "CMPSi   " #b000001))
(define-op n32 CMPST    60 (make-n32-format-5t   "CMPST   " #b100001))
(define-op n32 SKPSi    61 (make-n32-format-5    "SKPSi   " #b000011))
(define-op n32 SKPST    62 (make-n32-format-5t   "SKPST   " #b100011))
(define-op n32 ROTi     63 (make-n32-format-6'   "ROTi    " #x0 #x4E))
(define-op n32 ASHi     64 (make-n32-format-6'   "ASHi    " #x1 #x4E))
(define-op n32 CBITi    65 (make-n32-format-6/7  "CBITi   " #x2 #x4E))
(define-op n32 CBITIi   66 (make-n32-format-6/7  "CBITIi  " #x3 #x4E))
(define-op n32 LSHi     67 (make-n32-format-6'   "LSHi    " #x5 #x4E))
(define-op n32 SBITi    68 (make-n32-format-6/7  "SBITi   " #x6 #x4E))
(define-op n32 SBITIi   69 (make-n32-format-6/7  "SBITIi  " #x7 #x4E))
(define-op n32 NEGi     70 (make-n32-format-6/7  "NEGi    " #x8 #x4E))
(define-op n32 NOTi     71 (make-n32-format-6/7  "NOTi    " #x9 #x4E))
(define-op n32 SUBPi    72 (make-n32-format-6/7  "SUBPi   " #xB #x4E))
(define-op n32 ABSi     73 (make-n32-format-6/7  "ABSi    " #xC #x4E))
(define-op n32 COMi     74 (make-n32-format-6/7  "COMi    " #xD #x4E))
(define-op n32 IBITi    75 (make-n32-format-6/7  "IBITi   " #xE #x4E))
(define-op n32 ADDPi    76 (make-n32-format-6/7  "ADDPi   " #xF #x4E))
(define-op n32 MOVMi    77 (make-n32-format-7d   "MOVMi   " #x0))
(define-op n32 CMPMi    78 (make-n32-format-7d   "CMPMi   " #x1))
(define-op n32 INSSi    79 (make-n32-format-7'   "INSSi   " #x2))
(define-op n32 EXTSi    80 (make-n32-format-7'   "EXTSi   " #x3))
(define-op n32 MOVXiW   81 (make-n32-format-6/7  "MOVXiW  " #x4 #xCE))
(define-op n32 MOVZiW   82 (make-n32-format-6/7  "MOVZiW  " #x5 #xCE))
(define-op n32 MOVZiD   83 (make-n32-format-6/7  "MOVZiD  " #x6 #xCE))
(define-op n32 MOVXiD   84 (make-n32-format-6/7  "MOVXiD  " #x7 #xCE))
(define-op n32 MULi     85 (make-n32-format-6/7  "MULi    " #x8 #xCE))
(define-op n32 MEIi     86 (make-n32-format-6/7  "MEIi    " #x9 #xCE))
(define-op n32 DEIi     87 (make-n32-format-6/7  "DEIi    " #xB #xCE))
(define-op n32 QUOi     88 (make-n32-format-6/7  "QUOi    " #xC #xCE))
(define-op n32 REMi     89 (make-n32-format-6/7  "REMi    " #xD #xCE))
(define-op n32 MODi     90 (make-n32-format-6/7  "MODi    " #xE #xCE))
(define-op n32 DIVi     91 (make-n32-format-6/7  "DIVi    " #xF #xCE))
(define-op n32 EXTi     92 (make-n32-format-8d   "EXTi    " 0 0))
(define-op n32 CVTP     93 (make-n32-format-8b   "CVTP    " 0 1))
(define-op n32 INSi     94 (make-n32-format-8d   "INSi    " 0 2))
(define-op n32 CHECKi   95 (make-n32-format-8    "CHECKi  " 0 3 ))
(define-op n32 INDEXi   96 (make-n32-format-8    "INDEXi  " 1 0))
(define-op n32 FFSi     97 (make-n32-format-8a   "FFSi    " 1 1 0))
(define-op n32 MOVSUi   98 (make-n32-format-8a   "MOVSUi  " 1 2 1))
(define-op n32 MOVUSi   99 (make-n32-format-8a   "MOVUSi  " 1 2 3))
;(define-op n32 SETCFG   100 (make... ))
;(define-op n32 LMR      101 (make-n32-format-14   "LMR     " 0))
;(define-op n32 SMR      102 (make-n32-format-14   "SMR     " 0))
;(define-op n32 RDVAL    103 (make-n32-format-14   "RDVAL   " 0))
;(define-op n32 WRVAL    104 (make-n32-format-14   "WRVAL   " 0))

;(define-op n32 MOVf     113 (make-n32-format-11   "MOVf    " #x1))

#|

(define-op n32 MOVif    105 (make-n32-format-9if  "MOVif   " #b000))
(define-op n32 ROUNDfi  106 (make-n32-format-9fi  "ROUNDfi " #b100))
(define-op n32 TRUNCfi  107 (make-n32-format-9fi  "TRUNCfi " #b101))
(define-op n32 FLOORfi  108 (make-n32-format-9fi  "FLOORfi " #b111))

;;; ((src) (dst) (0 1) (f 1 src-sz) (f 1 dst-sz) (1) (f 1 src-sz)) (0011110))
(define-op n32 MOVff    109 (make-n32-format-9ff  "MOVff   "))

;(define-op n32 LFSR     110 (make-n32-format-9x   "LFSR    " #b001))
;(define-op n32 SFSR     111 (make-n32-format-9x   "SFSR    " #b110))

(define-op n32 ADDf     112 (make-n32-format-11   "ADDf    " #x0))
(define-op n32 MOVf     113 (make-n32-format-11   "MOVf    " #x1))
(define-op n32 CMPf     114 (make-n32-format-11   "CMPf    " #x2))
(define-op n32 SUBf     115 (make-n32-format-11   "SUBf    " #x4))
(define-op n32 NEGf     116 (make-n32-format-11   "NEGf    " #x5))
(define-op n32 DIVf     117 (make-n32-format-11   "DIVf    " #x8))
(define-op n32 ABSf     118 (make-n32-format-11   "ABSf    " #xB))
(define-op n32 MULf     119 (make-n32-format-11   "MULf    " #xC))

|#

;;; SPACE BYTE WORD LONG
