(herald (assembler n32lapenv t 11)
        (env tsys (assembler as))
        )

;;; ---------------- Pseudo ops and operands.

(include-vanilla-pseudo-ops n32)

(walk (lambda (i)
        (set (table-entry (machine-pseudo-ops n32) (car i)) (cdr i)))
      `(
        (jbr  . ,(jabs-emitter jump-op/jabs))

        (j=   . ,(jump-op-emitter jump-op/j=))
        (jn=  . ,(jump-op-emitter jump-op/jn=))
        (j>   . ,(jump-op-emitter jump-op/j>))
        (j>=  . ,(jump-op-emitter jump-op/j>=))
        (j<   . ,(jump-op-emitter jump-op/j<))
        (j<=  . ,(jump-op-emitter jump-op/j<=))
        (uj>  . ,(jump-op-emitter jump-op/uj>))
        (uj>= . ,(jump-op-emitter jump-op/uj>=))
        (uj<  . ,(jump-op-emitter jump-op/uj<))
        (uj<= . ,(jump-op-emitter jump-op/uj<=))
;        (jmi  . ,(jump-op-emitter jump-op/minus))
;        (jpl  . ,(jump-op-emitter jump-op/plus))
;        (jvs  . ,(jump-op-emitter jump-op/overflow))
;        (jvc  . ,(jump-op-emitter jump-op/no_overflow))

        (jcs  . ,(jump-op-emitter jump-op/carry_set))
        (jcc  . ,(jump-op-emitter jump-op/carry_cleared))
        (jfs  . ,(jump-op-emitter jump-op/flag_set))
        (jfc  . ,(jump-op-emitter jump-op/flag_cleared))
        ))
                                                                   
(walk (lambda (i)
        (set (table-entry (machine-pseudo-operands n32) (car i)) (cdr i)))
      `(
        (label . ,(lambda (form section)
                    (destructure (((label lab) form))
                      (n32/label section lab))))
        
        (to    . ,(lambda (form section)
                    (destructure (((to lab) form))
                      (as-data-tag section lab))))
        ))

;;; ---------------- Lap environment

(walk (lambda (regname index)
        (*define-lap-register n32 regname index))
      '(r0 r1 r2 r3 r4 r5 r6 r7 fp sp sb pc)
      '(0   1  2  3  4  5  6  7  8  9 10 11))

(let ((def-n32-lap (lambda (sym val)
                     (*define-lap-global n32 sym val))))

  (walk def-n32-lap
      '(b w d f l)       ; operation sizes (8 16 32 32 64)
      '(0 1 3 1 0))

  (walk def-n32-lap
        '(:b :w :d :q)
        '(:b :w :d :q))

  (walk def-n32-lap
        '( + - * / << >>)
        (list add subtract multiply quotient fixnum-ashl fixnum-ashr ))
  )

;;; ---------------- Utility

(define-syntax (n32lap . items) ;;;  For testing lap
  `(test-lap ',items n32))

