_Chapter(User interface)
_label(chapter:user)

This chapter describes the user interface to the _T system, which
is the current implementation of the _T language.  Also part of
the user interface are the various debugging facilities, which are
described in chapter _Ref(chapter:debug).

The features described in this chapter are highly volatile and
implementation-dependent.

_Section(Invoking _T)

To invoke a _T system, one typically gives a command to the system
command processor, as appropriate to the operating system and installation.
For example, under Aegis, the following interaction might take place:
_begin_Example
_cDL() t _LNL
524280 bytes per heap, 131071 bytes reserved _LNL
T 3.1 (5) MC68000/UNIX  Copyright (C) 1988 Yale University _LNL
;Loading  /usr/local/lib/t/tfix5.t into T-IMPLEMENTATION-ENV _LNL
T Top level _LNL
_Ftt(_cGT) (list 'planner 'conniver) _LNL
(PLANNER CONNIVER) _LNL
_Ftt(_cGT) _LNL
_end_Example
The interaction may look slightly different in the other implementations.
The above illustrates the startup sequence, which proceeds as follows:
_begin_Itemize
_Item()The user invokes _T with an appropriate command.

_Item()The _T system identifies itself by giving the processor and
operating system under which it believes itself to be running, the
major and minor system _ix(version numbers), and the system
edit number.  The version numbers identify which release of
_T is running.  The edit number is
useful to the system implementors and
should be provided in any bug reports sent to them.

_Item()_T loads a _iix(patch file), if one exists.  The patch file
consists of forms which fix bugs in the current release of the system.

_Item()_T loads a user _ix(initialization file), if one exists.  The user
_ix(initialization file) consists of any forms which the users wants to
have evaluated when _T starts up.  The location in the file system
where the initialization file is found is system-dependent, but is usually
the file _tc(init.t) in the user's home directory.

_Item()_T enters a _iix(read-eval-print loop).  Read-eval-print loops
are described in section _Ref(section:repl).
_end_Itemize

_Comdef(`STOP',` ',
`(STOP) _yl() _Fit(undefined)')
_begin_Desc
Exits _T in such a way that it may be resumed later.
Control returns to the context from which _T
was invoked.  Under Unix, this usually means the
shell.  Under VMS, this means the command interpreter (DCL).
_tc(STOP) is not defined in Aegis _T because
the Aegis environment makes it unnecessary.
_end_Desc 

_Comdef(`EXIT',` ',
`(EXIT)')
_begin_Desc
Exits _T, returning control to the context in which _T
was invoked in the first place (usually a shell or other command processor).
Any resources associated with the _T process will be freed;
_tc(EXIT) is not reversible.
A call to _tc(EXIT) cannot return.
_end_Desc 

_Comdef(`COMMAND-LINE',` ',
`(COMMAND-LINE) _yl() _Fit(list)')
_begin_Desc
In _Tv(2) called _tix(*COMMAND-LINE*).
This variable has as its value the command line which
was used to invoke _T, represented as a list of strings.
_end_Desc

_Section(Suspending _T)

_DComment(dorab: how to handle this more generically)
_begin_Inset(Caution:)
The following is somewhat Sun specific.
_end_Inset

A system is suspended as follows:

_begin_Example
_cP t -h 8000000 _cH as big as possible _LNL

_cGT ;; load stuff _LNL
_cGT (gc) _LNL
_cGT ((*value t-implementation-env 'system-suspend) filespec nil) _LNL
_cGT (exit)
_end_Example

If a GC occurs during the suspend it will hang.  This means that the heap
was not big enough.

The binary distributions are a directory called _qu(tsystem).
In that directory
are a bunch of files including a script called _qu(linkt) which takes
a _Ftt(.o) file produced by suspend and creates an executable.

_begin_Example
_cP cd tsystem _LNL
_cP linkt filespec.o newimage
_end_Example

If the code to be loaded before suspending a system contains
_wt(DEFINE-FOREIGN)
forms, files containing these forms should be loaded inside of:

_begin_ExampleTabbing
(bind _settab()((_settab()(*value t-implementation-env 'make-foreign-procedure)_incrtab()_incrtab()_LNL
        (*value t-implementation-env 'make-foreign))) _decrtab()_LNL
  (load file1) _LNL
  _dots)
_end_ExampleTabbing

In this case, the _Ftt(linkt) script must be modified to include
_Ftt(.o) files that are referenced by the _wt(DEFINE-FOREIGN) expressions.

_Fbf(System building:)

It is possible to build a system from the sources.  The tsystem directory
contains a file, i.e. _qu(sunbuild.t) which explains how.

_Section(Read-eval-print loops)
_label(section:repl)

The user usually interacts with the _T system
via a _ix(read-eval-print loop).
As illustrated above, this is a command loop which repeatedly reads an
expression, evaluates it, and prints the value.

The read-eval-print loop is a simple command processor;
it prints a prompt, reads a command from the terminal,
executes the command, then prints another prompt, ad infinitum.
A _iix(command) is any executable _T form, and executing
the command consists of evaluating the form and printing the result.

_DComment(There really ought to be a more complete history mechanism;
this will probably be done at some point.)

_Comdef2(`sharp-sharp',`_cH()_cH()',` ',
`_cH()_cH() _yl() _Fit(object)')
_begin_Desc
In _Tv(2) called _tix(**).
The variable _tc(_cH()_cH()) always has as its value the last object
which was _Fit(printed) by the read-eval-print loop, that is, the value
of the last expression typed by the user.
_end_Desc

_Comdef(`++',` ',
`++ _yl() _Fit(object)')
_begin_Desc
_Fbf(Removed in _Tv(3).)
The variable _tc(++) always has as its value the last expression
_Fit(read) by the read-eval-print loop.
It is not assigned this value, however, until _Fit(after) the expression
has been evaluated, so that a new expression may refer to
the previous one.
_end_Desc 

Expressions are read from the terminal by applying the _tc(READ)
operation (actually, the value of _tc((REPL-READ)); see page
_Pageref(REPL-READ)) to the terminal input port.  Initially, that
port's read table is the standard read table, but this may be changed
using _tc(SET), for example:
_begin_Example
(SET (PORT-READ-TABLE (TERMINAL-INPUT)) *MY-READ-TABLE*)
_end_Example

Evaluation is performed with respect to a particular variable
environment and its syntax table.  The read-eval-print loop may move
from place to place within the environment hierarchy; one may control
the evaluation environment and syntax table by setting _tc((REPL-ENV)).

_Comdef(`REPL-ENV',`Settable',
`(REPL-ENV) _yl() _Fit(environment)')
_begin_Desc
Accesses the environment passed to _tc((REPL-EVAL)) by the
read-eval-print loop.  Initially, this is the scratch environment
(see page _Pageref(USER-ENV)).
_end_Desc 

_Section(Command levels)

Read-eval-print loops may be invoked recursively.  Each currently running
read-eval-print loop is said to be at a different _iix(command level).
The initial read-eval-print loop is at _Fit(top level), and recursive
read-eval-print loops are at successively deeper levels.

The level of the current command loop is reflected in the way the
loop prompts for input.  At top level, the prompt is a single
greater-than sign (_tc(>)).  At deeper command levels, the prompt
contains as many greater-than signs as there are active read-eval-print
loops; for example, _tc(>>>) if there are two recursive read-eval-print
loops beneath the top level one.

Deeper command levels are usually entered as the result of program
execution errors, but may also be entered because of a keyboard
interrupt or an explicit call to _tc(BREAKPOINT).

_Fit(Interrupts:) _index(interrupts)
Issuing a keyboard interrupt will asynchronously enter a read-eval-print
loop.  One may proceed from this breakpoint, at the point where
computation was interrupted, by doing _tc((RET)).  Keyboard interrupts
are normally issued under Aegis by giving a Display Manager _tc(DQ)
command (normally assigned to control-Q), under VMS by typing control-C,
or under Unix by typing the interrupt character (normally control-C
or DEL).

_Fit(End-of-file:) _index(end-of-file) _label(end-of-file)
An end-of-file condition on the terminal input port (see page
_Pageref(TERMINAL-INPUT)) which occurs at a read-eval-print loop
will cause control to transfer up one command level to the next
read-eval-print loop.  End-of-file can usually be generated under
Aegis with the display manager _tc(EEF) command (normally assigned
to control-Z), under VMS by typing control-Z, or under Unix by typing
the end of file character (normally control-D).
  
_Comdef(`RESET',` ',
`(RESET)')
_label(RESET)
_begin_Desc
Transfers control directly to the top-level read-eval-print loop
by performing a throw (see page _Pageref(CATCH)).
_end_Desc 

_Comdef(`BREAKPOINT',` ',
`(BREAKPOINT . _Fit(message)) _yl() _Fit(object) _rm(or) _Fit(undefined)')
_begin_Desc
Enters a read-eval-print loop.  If _Fit(message) is non-null, then it
is printed on _tc((ERROR-OUTPUT)) using _tc(DISPLAY).
If _wt((RET _Fit(object))) is called, then the loop terminates and
_Fit(object) is returned as the value of the call to
_tc(BREAKPOINT).  If an end-of-file condition occurs, then
control is thrown to the read-eval-print loop at the next higher level,
which continues.
_end_Desc 

_Section(Transcripts)

A _iix(transcript) is a record of the user's interaction with the
_T system.  Transcripts are necessary in _T implementations
under operating systems which do not natively provide transcript
facilities.  Transcripts are not necessary, for example, when running
under the Aegis Display Manager.

_Comdef(`TRANSCRIPT-ON',` ',
`(TRANSCRIPT-ON _Fit(filename)) _yl() _Fit(undefined)')
_begin_Desc
Starts writing a transcript to the specified file.  All output to
_tc((TERMINAL-OUTPUT)) and input from _tc((TERMINAL-INPUT)) between
calls to _tc(TRANSCRIPT-ON) and _tc(TRANSCRIPT-OFF) is written to
the file.  A subsequent call to _tc(TRANSCRIPT-OFF) will terminate
the transcript, closing the file.
_end_Desc 

_Comdef(`TRANSCRIPT-OFF',` ',
`(TRANSCRIPT-OFF) _yl() _Fit(undefined)')
_begin_Desc
Closes the active transcript file.
_end_Desc 

_Section(Customization)

The various phases of the read-eval-print loop may be customized by
assigning values to switches.

_Comdef(`REPL-READ',`Settable',
`(REPL-READ) _yl() _Fit(procedure)')
_label(REPL-READ)
_begin_Desc
Accesses the _tc(READ) part of the read-eval-print loop.  Initially, this is
_tc(READ).
_end_Desc 

_Comdef(`REPL-EVAL',`Settable',
`(REPL-EVAL) _yl() _Fit(procedure)')
_begin_Desc
Accesses the _tc(EVAL) part of the read-eval-print loop.  Initially, this is
_tc(EVAL).
_end_Desc 

_Comdef(`REPL-PRINT',`Settable',
`(REPL-PRINT) _yl() _Fit(procedure)')
_begin_Desc
Accesses the _tc(PRINT) part of the read-eval-print loop.  Initially, this
is _tc(PRINT).
_end_Desc 

_Comdef(`REPL-PROMPT',`Settable',
`(REPL-PROMPT) _yl() _Fit(procedure)')
_begin_Desc
Accesses the prompting routine used in the read-eval-print loop.  This
should be a procedure of one argument, which is a nonnegative integer
giving the command level (zero at top level, one at the next deeper
level, and so on).  The procedure should return a string.  Initially,
_tc((REPL-PROMPT)) is a procedure that returns _tc(`> ') at the top
level, _tc(`>> ') at the level below that, etc.
_end_Desc 

_Comdef(`LOAD-NOISILY?',`Settable',
`(LOAD-NOISILY?) _yl() _Fit(boolean)')
_begin_Desc
If _tc((LOAD-NOISILY?)) is true (which it is initially), then _tc(LOAD)
and _tc(REQUIRE) will print the value of each top-level expression
in the file (standard compiler only).  The output goes to the terminal
output port.
_end_Desc 

_Comdef(`REPL-WONT-PRINT?',`Operation',
`(REPL-WONT-PRINT? _Fit(object)) _yl() _Fit(boolean)')
_begin_Desc
Read-eval-print loops will not print any object which answers true to
this operation.
Note that this is unrelated to the functioning of _tc(PRINT) itself.
_end_Desc 

_Comdef(`REPL-WONT-PRINT',` ',
`REPL-WONT-PRINT _yl() _Fit(object)')
_begin_Desc
In _Tv(2) called _tix(*REPL-WONT-PRINT*).
Its value is an object which answers true to the _tc(REPL-WONT-PRINT?)
predicate.
_begin_Example
REPL-WONT-PRINT  _equiv()  (OBJECT NIL ((REPL-WONT-PRINT? SELF) T))
_end_Example
_end_Desc
