_Chapter(Syntax)
_label(chapter:syntax)   
The _T standard environment includes routines which perform
syntactic and semantic analysis of _T programs.
There are two such subsystems within _T, corresponding to the
language's two syntactic levels (see chapter _Ref(chapter:semantics)).
These are the _Fit(reader) and the _Fit(compiler).

In an attempt to make each of these subsystems as generally useful and
flexible as possible, they are not restricted to processing the language
as described in this manual.  Instead, they each operate with respect to
parameter clusters known as _iix(read tables), in the case of the
reader, or _iix(syntax tables), in the case of the compiler.

_Section(The reader)
_label(section:reader)
The _iix(reader) is a procedure available in the standard environment as
the value of the variable _tc(READ-OBJECT).  Conceptually, the reader
coerces a stream of characters (_ix(external representation)) to a stream of
objects (internal representations) via a mechanism
known as _Fit(parsing).

_Comdef(`READ-OBJECT',` ',
`(READ-OBJECT _Fit(port) _Fit(read-table)) _yl() _Fit(object) _rm(or) _Fit(end-of-file)')
_label(READ-OBJECT)
_begin_Desc
_tc(READ-OBJECT) employs the _tc(READ-CHAR) (page _Pageref(READ-CHAR))
and _tc(UNREAD-CHAR) (page _Pageref(UNREAD-CHAR)) operations in
order to parse an object according to the port's read table.

If the port is empty, the end-of-file token is returned.

_tc(READ-OBJECT) is called by the default method for the _tc(READ)
operation (page _Pageref(READ)), so the reader is usually invoked
indirectly by calling
_tc(READ), not by calling _tc(READ-OBJECT) directly.  When invoked
from _tc(READ), the second argument to _tc(READ-OBJECT) is obtained
by calling the _tc(PORT-READ-TABLE) operation on the port.
_end_Desc 

The reader works as follows:

Any whitespace characters (space, tab, newline, carriage return, line
feed, or form feed) are read and ignored.  A non-whitespace character is
obtained; call it _Fit(c).
_index(whitespace)

If _Fit(c) is a read-macro character, the reader invokes a specialist routine
to handle a syntactic construct introduced by the read-macro character.

If _Fit(c) is not a read-macro character, then characters are read and
saved until a _Fit(delimiter) character is read.  A delimiter character is
either a whitespace character, or one of the following: _tc(_cPo()) (left
parenthesis), _tc(_cPc()) (right parenthesis), _tc([), _tc(]), _tc(_cBo()),
_tc(_cBc()), or _tc(;) (semicolon).  If the sequence of characters beginning
with _Fit(c) and going up to but not including the delimiter is parsable
as a number, then the sequence is converted to a number, which is
returned.
Otherwise the sequence is converted to a symbol.
_index(numbers)
_index(symbols)
_index(delimiter characters)
_index(constituent characters)

The _Fit(escape character), backslash (_cSL), may be used within a
run of constituent characters to include unusual characters in a
symbol's print name.  In this case, the escaped character (i.e. the character
following the escape character) is treated as if it were a constituent
character, and is not converted to upper case if it is a lower case
letter.  For example:
_begin_Example
_a(abc,_cSL,;def)  _rm(reads the same as)  _cH()[Symbol _exqu(ABC;DEF)] _LNL
_a(_cSL,a,_cSL,bcdef)  _rm(reads the same as)  _cH()[Symbol _exqu(abCDEF)] _LNL
_a(_cSL,12345)    _rm(reads the same as)  _cH()[Symbol _exqu(12345)] _LNL
_a(_cSL,'12345)   _rm(reads the same as)  _cH()[Symbol _exqu('12345)] 
_end_Example

_DComment( talk about dot? )

The following are standard read-macro characters:

_begin_Table
_Item(_tc(_cQ))	Doublequote: introduces a string.  Characters are read until another doublequote
character is found which does not immediately follow a backslash (_cSL)
and a string is returned.  Within a string, backslash acts as an escape
character, so that doublequotes and backslashes may appear in strings.
_index(strings)

_Item(`_cQc')	Quote: _cQc()_Fit(object) reads the same as _tc((QUOTE _Fit(object))).
_tindex(QUOTE)

_Item(`(')	Left parenthesis: begins a list. _index(parentheses)

_Item(`)')	Right parenthesis: ends a list or vector, and is illegal in other
contexts.

_Item(`_cQo')	Quasiquote: see section _Ref(section:quasiquote).
	In _Tv(2), was called ``Backquote''.
	_tindex(quasiquote)
	_tindex(backquote)

_Item(_tc(`,'))	Comma: this is part of the backquote syntax.

_Item(_tc(_cAT))	At sign: this is part of the backquote syntax.

_Item(_tc(;))	Semicolon: introduces a comment.  Characters are read and discarded
until a newline is encountered, at which point the parsing process starts over.
_label(SEMICOLON)
_index(comments)

_Item(_tc(_cH()))	Sharp-sign: another dispatch to a specialist routine is
performed according to the character following the _tc(_cH()).
_end_Table

Standard sharp-sign forms:

_begin_Table
_Item(_char())
	Character syntax.  See section _Ref(character syntax).

_Item(_tc(_cH()x))
	_ix(Hexadecimal) input.  An integer following the _tc(_cH()x)
is read in base 16.

_Item(_tc(_cH()o))
	Octal _index(octal) input.  An integer following the _tc(_cH()o) is read in base 8.

_Item(_tc(_cH()b))
	Binary input.  An integer following the _tc(_cH()b) is read in base 2.

_Item(_tc(_cH()(_dots())))
	Vector.  The elements of a vector are read between the parentheses,
and the vector is returned.
_index(vectors)

_Item(_tc(_cH()[_dots()]))
	This syntax is used for certain kinds of re-readable objects.
It also provides an alternate syntax for characters and symbols.
The brackets enclose a sequence of objects; the first should be a symbol
which keys the type of the resulting object, e.g. _tc(CHAR) or _tc(SYMBOL).
_index(characters)_index(symbols)
For example,
_begin_Example
_cH()[Ascii 65]       _rm(represents the same object as)  _char(A) _LNL
_cH()[Symbol `FOO']  _rm(represents the same object as)  FOO
_end_Example
_Tv(2) used _Ftt(_cH()[Ascii _dots]) rather than _Ftt(_cH()[Ascii _dots]).
This syntax is used by the printer when necessary, for example:
_begin_Example
(_a(STRING-,_cGT,SYMBOL) `')  _evalto()  _cH()[Symbol `'] _LNL
(_a(ASCII-,_cGT,CHAR 128))    _evalto()  _cH()[Ascii 128]
_end_Example

_Item(_tc(_cH()_cBo()_dots()_cBc()))
This is the syntax used by the printer for objects which
have no reader syntax.  When the reader encounters the sequence _tc(_cH()_cBo())
it signals an error.
_end_Table

_Section(Read tables and read macros)
_label(READTABLES)
Read tables _index(read tables) package a number of parameters for use by programs which
parse, generate, or otherwise manipulate external syntax of programs and
objects.  In particular, every read table contains a table which
maps characters to objects which describe their lexical
properties.

There is a standard read table which contains the standard read syntax
for all characters.  In order to define nonstandard read syntax, one
must create a new read table using _tc(MAKE-READ-TABLE), and arrange
for _tc(READ-OBJECT) to use the new read table instead of the standard
read table, e.g. by doing _wt((SET (PORT-READ-TABLE _dots()) _dots())).

_Comdef(`MAKE-READ-TABLE',` ',
`(MAKE-READ-TABLE _Fit(read-table identification)) _yl() _Fit(new-read-table)')
_begin_Desc
Creates a new read table which is a copy of _Fit(read-table).
_Fit(Identification) serves for debugging purposes only.
_begin_ExampleTabbing
(DEFINE _settab()*MY-READ-TABLE* _incrtab()_LNL
  (MAKE-READ-TABLE STANDARD-READ-TABLE '*MY-READ-TABLE*))
_end_ExampleTabbing
_end_Desc 

_Comdef(`STANDARD-READ-TABLE',` ',
`STANDARD-READ-TABLE _yl() _Fit(read-table)')
_begin_Desc
In _Tv(2), called _tix(*STANDARD-READ-TABLE*).
The standard _T read table.
_end_Desc

_Comdef(`VANILLA-READ-TABLE',` ',
`VANILLA-READ-TABLE _yl() _Fit(read-table)')
_begin_Desc
In _Tv(2), called _tix(*VANILLA-READ-TABLE*).
The value of _tc(VANILLA-READ-TABLE) is a read table in which all
all graphic characters have ordinary non-read-macro constituent
syntax, whitespace characters have whitespace syntax, and
other characters (e.g. control characters) are illegal.
_begin_ExampleTabbing
(WITH-INPUT-FROM-STRING _settab()(PORT _cQ() FOO () _cQ()) _incrtab()_LNL
  (SET (PORT-READ-TABLE PORT) VANILLA-READ-TABLE) _LNL
  (LIST (READ PORT) (READ PORT))) _decrtab()_LNL
_evalto()  (FOO _cH()[Symbol `()'])
_end_ExampleTabbing
_end_Desc

_Comdef(`READ-TABLE-ENTRY',`Settable',
`(READ-TABLE-ENTRY _Fit(table character)) _yl() _Fit(syntax)')
_begin_Desc
Access _Fit(character)'s read syntax in _Fit(table).
The entry for a given character is some object which represents the
character's lexical properties, for example, whether it is
a constituent, whitespace, or read-macro character.
For read-macro characters, the entry is a procedure
for parsing the read-macro construct.
_index(read macros)

Values suitable to be stored in read tables may be obtained
by accessing existing entries in the standard read table.  For example:
_begin_ExampleTabbing
(SET _settab()(READ-TABLE-ENTRY *MY-READ-TABLE* _char(;)) _LNL
     _gotab()(READ-TABLE-ENTRY STANDARD-READ-TABLE _char(:)))
_end_ExampleTabbing
makes the read syntax of semicolon in _tc(*MY-READ-TABLE*) be the
same as the standard read syntax of colon (which is a
contituent character).

To define a read macro, do
_begin_Example
(SET (READ-TABLE-ENTRY _Fit(read-table) _Fit(character)) _Fit(procedure))
_end_Example
where _Fit(procedure) is a procedure taking three arguments: a port,
a character, and a read-table.  The port is the port which is currently being
parsed by _tc(READ-OBJECT).  It may be passed as the port argument
to input routines like _tc(READC) and _tc(READ-REFUSING-EOF) if the
read-macro needs to parse further characters from the input port.
The character is the character which caused the read macro to be
invoked; that is, it is the character under which the procedure is
stored in the read table. The read-table is the read table from
which the procedure was fetched (i.e. the one that was originally
passed to _tc(READ-OBJECT). Read macros which recursively invoke the
reader will want to pass that read table as the second argument to
_tc(READ-OBJECT).

Example:
_begin_ExampleTabbing
(SET _settab()(READ-TABLE-ENTRY *MY-READ-TABLE* _char()') _incrtab()_LNL
     (LAMBDA _settab()(PORT CH RTABLE) _incrtab()_LNL
       (IGNORE CH) (IGNORE RTABLE)_LNL
       (LIST 'QUOTE (READ-REFUSING-EOF PORT))))
_end_ExampleTabbing
Note that the standard read table and the vanilla read table
are immutable, and so their entries may not be changed.
_end_Desc 

_Comdef(`NOTHING-READ',` ',
`NOTHING-READ _yl() _Fit(object)')
_begin_Desc
In _Tv(2), called _tix(*NOTHING-READ*).
Read macros should return this object, which is treated specially
by the reader, if they want to return no object.
For example, the semi-colon (comment) read-macro might be defined as follows:
_begin_ExampleTabbing
(SET _settab()(READ-TABLE-ENTRY *MY-READ-TABLE* _char(;)) _incrtab()_LNL
     (LAMBDA _settab()(PORT CH RTABLE) _incrtab()_LNL
	(IGNORE RTABLE) _LNL
        (ITERATE _settab()LOOP () _incrtab()_LNL
          (LET _settab()((C (READC PORT))) _incrtab()_LNL
            (COND _settab()((EOF? C) C) _incrtab()_LNL
                  ((CHAR= C _char(NEWLINE)) NOTHING-READ) _LNL
                  (ELSE (LOOP)))))))
_end_ExampleTabbing
_end_Desc

_Comdef(`DELIMITING-READ-MACRO?',`Operation',
`(DELIMITING-READ-MACRO? _Fit(procedure)) _yl() _Fit(boolean)')
_begin_Desc
If an object which returns true to the _tc(DELIMITING-READ-MACRO?) operation is
stored in a read table under a given character, then the reader will
treat the character as a delimiter (non-constituent) character.
By default, read-macro procedures return false to this predicate.  Thus
to make a read-macro character be a delimiting character also (as
are parentheses and semicolon in the standard read table), its
read table entry should handle this operation by returning true.
_begin_ExampleTabbing
(SET _settab()(READ-TABLE-ENTRY *MY-READ-TABLE* _char(_cTL)) _incrtab()_LNL
     (OBJECT _settab()(LAMBDA (PORT CH RTABLE) _incrtab()_LNL
               _dots()) _LNL
             ((DELIMITING-READ-MACRO? SELF) T)))
_end_ExampleTabbing
_end_Desc 

_Comdef(`MAKE-LIST-READER)',` ',
`(MAKE-LIST-READER) _yl() _Fit(list-reader)')
_begin_Desc
The two procedures _tc(MAKE-LIST-READER) and _tc(LIST-TERMINATOR)
can be used together to define read macros which behave syntactically
like parentheses.

Each call to _tc(MAKE-LIST-READER) returns an object which is a
procedure of two arguments called a _Fit(list reader.)  Calling
_tc(LIST-TERMINATOR) on a list reader will return another object called
its _Fit(list terminator.)

List readers and terminators are suitable for entry in read tables.
A list reader acts as a read macro which reads a sequence of objects,
terminated by a character whose read syntax is the corresponding list
terminator.  For example, the standard syntax for left and right
parentheses might be defined as follows:

_begin_ExampleTabbing
(LET _settab()((LIST-READER (MAKE-LIST-READER))) _incrtab()_LNL
  (SET _settab()(READ-TABLE-ENTRY STANDARD-READ-TABLE _char(LEFT-PAREN)) _incrtab()_LNL
       LIST-READER) _decrtab()_LNL
  (SET (READ-TABLE-ENTRY STANDARD-READ-TABLE _char(RIGHT-PAREN)) _incrtab()_LNL
       (LIST-TERMINATOR LIST-READER)))
_end_ExampleTabbing

Like any read-macro procedure, a list reader is a procedure of two
arguments.  The first argument must be a port, and the second is
ignored.  Thus instead of being stored in a read table, it may be
called from another read-macro procedure.  For example, the following
makes _tc([_dots()]) an alternative read syntax for vectors:
_begin_ExampleTabbing
(LET _settab()((LIST-READER (MAKE-LIST-READER))) _incrtab()_LNL
  (SET _settab()(READ-TABLE-ENTRY *MY-READ-TABLE* _char(LEFT-BRACKET)) _incrtab()_LNL
       (OBJECT _settab()(LAMBDA _settab()(PORT CH RTABLE) _incrtab()_incrtab()_LNL
		 (IGNORE RTABLE) _LNL
                 (_a(LIST-,_cGT,VECTOR) (LIST-READER PORT CH))) _decrtab()_LNL
               ((DELIMITING-READ-MACRO? SELF) T))) _decrtab()_decrtab()_LNL
  (SET (READ-TABLE-ENTRY *MY-READ-TABLE* _char(RIGHT-BRACKET)) _incrtab()_LNL
       (LIST-TERMINATOR LIST-READER)))
_end_ExampleTabbing

List readers and terminators handle the _tc(DELIMITING-READ-MACRO?)
operation by returning true.
_end_Desc 

_Comdef(`LIST-TERMINATOR',` ',
`(LIST-TERMINATOR _Fit(list-reader)) _yl() _Fit(list-terminator)')
_begin_Desc
Given a list reader, returns its list terminator.  See _tc(LIST-READER),
above.
_end_Desc 

_Section(Standard compiler)

A _iix(compiler) is a procedure which accepts an expression and a
syntax table, and returns a _Fit(compiled code) object.  A compiled
code object may be executed in a given environment.  Note that
the term _qu(compiler) is used in a technical sense
and encompasses not only compilers such as _orbit()
(section _Ref(COMPILE-FILE)) which
produce machine instructions, but also programs such as the standard
compiler (which is called by _tc(EVAL)) which operate internally by
producing intermediate code or by interpreting source code directly.
Often programs like these are called _Fit(interpreters) instead of
_Fit(compilers.)

A given _T implementation may have several compilers.
_tc(STANDARD-COMPILER) should be one of these compilers.
_T 3.1 also provides a compiler called _orbit(), which is
described in section _Ref(COMPILE-FILE).

_Comdef(`EVAL',` ',
`(EVAL _Fit(expression) _Fit(environment)) _yl() _Fit(object)')
_begin_Desc
Evaluates _Fit(expression) in _Fit(environment).  Evaluation is performed as
a two-stage process: first, the standard compiler compiles the
expression, producing a compiled code object; then the compiled code
object is invoked in the given environment.
_begin_ExampleTabbing
(EVAL _settab()_Fit(expression) _Fit(environment)) _LNL
  _gotab()_equiv() _LNL
(RUN-COMPILED-CODE _settab()(STANDARD-COMPILER _settab()_Fit(expression) _LNL
                                      _gotab()_gotab()(ENV-SYNTAX-TABLE _Fit(environment))) _LNL
                   _gotab()_Fit(environment))
_end_ExampleTabbing

The evaluation semantics have been extended to allow the
valuation of forms whose _wt(car)'s are syntax descriptors.
such a form is interpreted just as if it were a form whose _wt(car)
was a symbol whose syntax table entry was the syntax descriptor.
For example,

_begin_ExampleTabbing
(DEFINE-LOCAL-SYNTAX _settab()(FOO X) _LNL
 _gotab()_cQo()(,(SYNTAX-TABLE-ENTRY STANDARD-SYNTAX-TABLE 'LAMBDA) () ,X)) _LNL

((FOO 5)) _evalto 5
_end_ExampleTabbing

_index(expression syntax)

This feature allows control over binding time for reserved words.
For example, a syntax descriptor such as _Ftt(FOO), above, can
be sure that its expansion will be treated as an expression
that evaluates to a closure, regardless of what the syntax table
entry for the symbol _wt(lambda) is when the expansion
is evaluated or otherwise analyzed.
_end_Desc 

_Comdef(`STANDARD-COMPILER',` ',
`(STANDARD-COMPILER _Fit(expression) _Fit(syntax-table)) _yl() _Fit(compiled-code)')
_label(STANDARD-COMPILER)
_begin_Desc
Compiles _Fit(expression). _T may provide several
compilers, of which _tc(STANDARD-COMPILER) will be the one which is
invoked by _tc(EVAL).
_end_Desc 

_Comdef(`RUN-COMPILED-CODE',` ',
`(RUN-COMPILED-CODE _Fit(compiled-code) _Fit(environment)) _yl() _Fit(object)')
_begin_Desc
Invokes a compiled code object.
    _begin_Inset(Bug:)
    In _T 2.7, the environment passed to _tc(RUN-COMPILED-CODE)
    must be the same as the one whose syntax table was passed
    to _tc(STANDARD-COMPILER).
    _end_Inset
_end_Desc 

_Section(Syntax Tables)

_label(section:syntaxTables)   
_index(syntax tables)
_index(reserved words)
_index(special forms)
A syntax table maps symbols to _iix(syntax descriptors).  Every syntax
descriptor is itself either a macro expander, or a unique token
identifying a primitive special form type.

Every locale has an associated syntax table.  A locale's syntax table
contains definitions of special forms which are local to the locale.  Each
such syntax table inherits entries lexically from the syntax tables
of enclosing locales.

_Fit(Macros)_index(macros) provide a mechanism for extending the syntax of _T
by means of source-to-source transformations.
As in many Lisp dialects, the macro facility in _T provides a powerful
tool for amplifying the expressiveness of the language.  But like any
powerful tool, macros may be abused.  They may easily lead to programs
that are very hard to understand.

Macros are defined by entering syntax descriptor objects known as
_iix(macro expanders) into syntax tables; see
_tc(SYNTAX-TABLE-ENTRY) and _tc(DEFINE-SYNTAX), below.
Macros may also be defined locally to a file or expression using
_tc(DEFINE-LOCAL-SYNTAX) or _tc(LET-SYNTAX).

Procedure integration is preferable to the use of macros in situations
where either would be applicable.  See _tc(DEFINE-INTEGRABLE), page
_Pageref(section:defineIntegrable).

_Comdef(`ENV-SYNTAX-TABLE',` ',
`(ENV-SYNTAX-TABLE _Fit(environment)) _yl() _Fit(syntax-table)')
_begin_Desc
Returns the syntax table associated with _Fit(environment).
_end_Desc 

_Comdef(`MAKE-SYNTAX-TABLE',` ',
`(MAKE-SYNTAX-TABLE _Fit(syntax-table) _Fit(identification)) _yl() _Fit(syntax-table)')
_begin_Desc
Creates a new syntax table inferior to the given syntax table.
Note that syntax tables are created implicitly by _tc(MAKE-LOCALE)
(page _Pageref(MAKE-LOCALE)).
_end_Desc 

_Comdef(`STANDARD-SYNTAX-TABLE',` ',
`STANDARD-SYNTAX-TABLE _yl() _Fit(syntax-table)')
_begin_Desc
In _Tv(2), called _tix(*STANDARD-SYNTAX-TABLE*).
A syntax table with entries for all standard _T reserved words.
_begin_Example
STANDARD-SYNTAX-TABLE  _equiv()  (ENV-SYNTAX-TABLE-ENTRY STANDARD-ENV)
_end_Example
_end_Desc 


_Comdef(`SYNTAX-TABLE-ENTRY',`Settable',
`(SYNTAX-TABLE-ENTRY _Fit(syntax-table) _Fit(symbol)) _yl() _Fit(descriptor) _rm(or) _Fit(false)')
_label(SYNTAX-TABLE)
_begin_Desc
Accesses the syntax descriptor associated with _Fit(symbol) in
_Fit(syntax-table).  Returns false if there is no such entry.
_begin_ExampleTabbing
(SYNTAX-TABLE-ENTRY STANDARD-SYNTAX-TABLE _cQc()QUOTE)  _evalto()  _a(_cH,_cBo,Syntax,` ',QUOTE,_cBc)
_LNL
(SYNTAX-TABLE-ENTRY STANDARD-SYNTAX-TABLE 'CAR)    _evalto()  _Fsem(false)
_end_ExampleTabbing
Syntax table entries may be created or altered using
_wt((SET (SYNTAX-TABLE-ENTRY _dots()) _dots()))
or by using _tc(DEFINE-SYNTAX).  On assignment, _Fit(descriptor) may
be false, in which case _Fit(symbol) loses any syntax table entry it
may have had.  This allows it to be bound as a variable using
_tc(DEFINE) or _tc(LET), for example.
_end_Desc 

_Section(Defining syntax)

_Comdefb(`DEFINE-SYNTAX',` ',
`(DEFINE-SYNTAX _Fit(symbol) _Fit(descriptor)) _yl() _Fit(undefined)',
`(DEFINE-SYNTAX (_Fit(symbol) . _Fit(vars)) . _Fit(body)) _yl() _Fit(undefined)')
_begin_Desc 
Sets _Fit(symbol)'s syntax table entry in the syntax table of the
environment in which the _tc(DEFINE-SYNTAX) form is being evaluated.
The second form is an abbreviation for an equivalent expression
of the first form involving _tc(MACRO-EXPANDER):
_begin_ExampleTabbing
(DEFINE-SYNTAX _settab()(_Fit(symbol) . _Fit(variables)) . _Fit(body)) _LNL
  _gotab()_equiv() _LNL
(DEFINE-SYNTAX _Fit(symbol) _LNL
  _gotab()(MACRO-EXPANDER (_Fit(symbol) . _Fit(variables)) . _Fit(body)))
_end_ExampleTabbing
Macros and _tc(MACRO-EXPANDER) are explained below.

As with _tc((SET (SYNTAX-TABLE-ENTRY _dots()) _dots())), _Fit(descriptor) may
be false, in which case _Fit(symbol) loses any syntax table entry it
may have had.  This allows it to be bound as a variable using
_tc(DEFINE) or _tc(LET), for example.

Note that _tc(DEFINE-SYNTAX) forms have no effect
at compile time.  Using them indiscriminately may lead to code
which behaves differently depending on what compiler is being used.
For example, a use of the special form defined by a _tc(DEFINE-SYNTAX)
form later on in the same file in which the _tc(DEFINE-SYNTAX) form
occurs may be seen as a valid special form reference by the standard
compiler, but may be treated as a call by _orbit().

_begin_ExampleTabbing
(DEFINE-SYNTAX _settab()(REPEAT N . CODE) _incrtab()_LNL
  _cQo()(LET _settab()((COUNT ,N) _incrtab()_LNL
         (THUNK (LAMBDA () ,@CODE))) _LNL
     (DO _settab()((COUNT COUNT (- COUNT 1))) _incrtab()_LNL
         ((_a(_cLT,=) COUNT 0) NIL) _LNL
       (THUNK))))
_end_ExampleTabbing
_end_Desc

_Section(Local syntax)

Reserved words may be defined at compile time using _tc(LET-SYNTAX)
and _tc(DEFINE-LOCAL-SYNTAX).  Syntax defined this way is called
_iix(local syntax) and is in effect only at compile time, not at run
time.

Local syntax is block structured, much as variables are.  The outermost
local syntax contour is the point at which a compiler is invoked,
which usually means a file boundary.  Inner contours are introduced
by _tc(LET-SYNTAX) forms.

Put another way, a local syntax table is created whenever a compiler
is invoked (_tc(LOAD), _tc(COMPILE-FILE), _tc(EVAL)) and whenever a
_tc(LET-SYNTAX) form is compiled.  Entries are created in a local
syntax table at compile time for syntax defined initially by the
_tc(LET-SYNTAX) form and later when the compiler encounters
_tc(DEFINE-LOCAL-SYNTAX) forms.  The syntax table is used at compile
time and is otherwise unavailable.

_Comdef(`LET-SYNTAX',` ',
`(LET-SYNTAX _Fit(specs) . _Fit(body)) _yl() _Fit(value-of-body)')
_begin_Desc
Defines macros locally to _Fit(body).  Yields the value of _Fit(body),
an implicit block.  Each _Fit(spec) should be either
_begin_Example
(_Fit(symbol) _Fit(descriptor))
_end_Example
or
_begin_Example
((_Fit(symbol) . _Fit(vars)) . _Fit(body))
_end_Example
in analogy to _tc(DEFINE-SYNTAX).

The _Fit(descriptor) and _Fit(body) forms in _Fit(specs) will not necessarily
run in an environment which is at all related to the environment in
which the program in which the _tc(LET-SYNTAX) form occurred will
be run, because compilation may occur independently of execution.
_orbit evaluates syntax-descriptors in the
_wt(env-for-syntax-definition) associated with the syntax
table from which the descriptor was obtained, e.g. _wt((tc-syntax-table)).
The standard compiler uses the
locale with which the syntax table passed to it is associated.
This is implementation-dependent, and subject to change.  For this reason,
it is best to write local macros in such a way that no free variables
or special forms are used, other than those in the standard system
environment, that is, those defined to be part of the _T language.

This disclaimer does not apply to the _Fit(body) of the _tc(LET-SYNTAX) form,
which is evaluated (except for syntax) exactly as if the _tc(LET-SYNTAX)
expression were a _tc(BLOCK) expression.
_begin_ExampleTabbing
(LET-SYNTAX _settab()((KWOTE (SYNTAX-TABLE-ENTRY _settab()STANDARD-SYNTAX-TABLE _LNL
                                        _gotab()_gotab()'QUOTE))) _LNL
  _gotab()(KWOTE (A B C)))_tindex(KWOTE) _LNL
_gotab()_evalto()  (A B C)
_end_ExampleTabbing

_begin_ExampleTabbing
(LET-SYNTAX ((SET NIL)) (LET ((SET LIST) (X 5)) (SET X 8)))  _evalto()  (5 8) _LNL

(LET-SYNTAX (((MAC X) _cQo()'(X = ,X))) (MAC Y))  _evalto()  (X = Y)
_end_ExampleTabbing
_end_Desc 


_Comdefb(`DEFINE-LOCAL-SYNTAX',`Special form',
`(DEFINE-LOCAL-SYNTAX _Fit(symbol) _Fit(descriptor)) _yl() _Fit(undefined)',
`(DEFINE-LOCAL-SYNTAX (_Fit(symbol) . _Fit(vars)) . _Fit(body)) _yl() _Fit(undefined)')
_begin_Desc 
_tc(DEFINE-LOCAL-SYNTAX) defines syntax locally to the body of the
nearest enclosing _tc(LET-SYNTAX) form, or, if the
_tc(DEFINE-LOCAL-SYNTAX) does not
appear inside a _tc(LET-SYNTAX) form, then to the file or outermost
expression in which it occurs.  Forward references are not defined
to work; the _tc(DEFINE-LOCAL-SYNTAX) form should appear prior to any use of
_Fit(symbol) as a reserved word.

The syntax of _tc(DEFINE-LOCAL-SYNTAX) is analogous to that of
_tc(DEFINE-SYNTAX).

In general, _tc(DEFINE-LOCAL-SYNTAX) should be used for syntax which is
to be available only within the file in which it occurs.  If
a syntax definition is needed for several files, then they
should be made available in some locale's syntax table by evaluating
_tc(DEFINE-SYNTAX) forms in that locale, and then that locale's syntax table
should be used when compiling or loading the file (see the _tc(SYNTAX-TABLE)
file header clause, page _Pageref(SYNTAX-TABLE)).

    _begin_Inset(Note:)
    To ease incremental debugging, the standard compiler in _T
    2.7 causes syntax defined with _tc(DEFINE-LOCAL-SYNTAX) to be
    retained indefinitely; that is, they are entered into the syntax
    table of the locale which was passed to _tc(LOAD).  Programs should
    not rely on this feature,
    however, or code may behave differently when compiled using TC.
    _end_Inset
_end_Desc

_Section(Macro expanders)

_Comdef(`MACRO-EXPANDER',`Special form',
`(MACRO-EXPANDER (_Fit(identification) . _Fit(variables)) . _Fit(body)) _yl() _Fit(macro-expander)')
_begin_Desc
Yields a macro expander.  A macro expander is a kind of syntax
descriptor, and may therefore be stored in a syntax table.  When a
compiler using a symbol table _Fit(S) encounters a form whose car is
a symbol, and the entry in _Fit(S) for that symbol is the object yielded
by a _tc(MACRO-EXPANDER)-expression, then the macro expander
is invoked; that is, its
_Fit(variables) are bound to the rest of form (as with one level of
_tc(DESTRUCTURE) binding), the _Fit(body) (an implicit block) is evaluated,
and the value is returned to the compiler.  The compiler then compiles that
form in place of the original one.

The lexical context of _Fit(body) is that of the _tc(MACRO-EXPANDER) form
(augmented by the bindings of _Fit(variables), of course), as with
_tc(LAMBDA).
_begin_ExampleTabbing
(DEFINE M (MACRO-EXPANDER (FOO X Y Z) _cQo()(LIST 'FIRST ',X ,Y ,Z))) _LNL
(INVOKE-MACRO-EXPANDER _settab()M '(BAR QUOTED (+ 1 2) (* 3 4))) _LNL
  _gotab()_evalto()  (LIST 'FIRST 'QUOTED  (+ 1 2) (* 3 4)) _LNL

(DEFINE L (MAKE-LOCALE STANDARD-ENV NIL)) _LNL
(SET (SYNTAX-TABLE-ENTRY (ENV-SYNTAX-TABLE L) 'BAR) M) _LNL

(EVAL '(BAR QUOTED (+ 1 2) (* 3 4)) L)  _evalto()  (FIRST QUOTED 3 12) _LNL

(DEFINE-SYNTAX _settab()FOO _incrtab()_LNL
  (MACRO-EXPANDER _settab()(FOO THING FORM) _incrtab()_LNL
    _cQo()(LIST ,FORM ',THING))) _decrtab()_decrtab()_LNL

(FOO (CONS 1 2) (CONS 3 5))  _evalto()  ((3 . 5) (CONS 1 2))
_end_ExampleTabbing

_tc(DESTRUCTURE) (page _Pageref(DESTRUCTURE)) and
quasiquote (page _Pageref(section:quasiquote)) are useful in writing
macro expansion procedures, the first for taking apart the
form which is to be expanded, the second for constructing the resultant code
from templates.

Note that for a macro definition to take effect at compile time, it
must either be present in the syntax table being used by the
compiler (see page _Pageref(SYNTAX-TABLE)), or defined locally
using _tc(LET-SYNTAX) or _tc(DEFINE-LOCAL-SYNTAX).
_end_Desc 

_Comdef(`MACRO-EXPANDER?',` ',
`(MACRO-EXPANDER? _Fit(descriptor)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(descriptor), which must be a syntax descriptor,
is a macro expander.
_begin_Example
(MACRO-EXPANDER? (MACRO-EXPANDER (FOO X) X))  _evalto()  _Fsem(true)
_end_Example
_end_Desc 

_Comdef(`INVOKE-MACRO-EXPANDER',` ',
`(INVOKE-MACRO-EXPANDER _Fit(descriptor) _Fit(form)) _yl() _Fit(new-form)')
_begin_Desc
Invokes the macro expansion procedure for _Fit(descriptor), which must
be a macro expander.  (See _tc(MACRO-EXPANDER), above.)
_begin_ExampleTabbing
(INVOKE-MACRO-EXPANDER _settab()(MACRO-EXPANDER (FOO X) _cQo()(LAMBDA () ,X)) _LNL
                       _gotab()_cQo()(BAZ (+ 1 2))) _LNL
  _gotab()_evalto() _LNL
(LAMBDA () (+ 1 2))
_end_ExampleTabbing
_end_Desc 

_Comdef(`MACRO-EXPAND',` ',
`(MACRO-EXPAND _Fit(form syntax-table)) _yl() _Fit(new-form)')
_begin_Desc
Performs one macro expansion on the _Fit(form), if it is a list whose
car is a symbol, there is an entry in the given _Fit(syntax-table) for
that symbol, and that entry is a macro expander.
_end_Desc 
