_Chapter(Structures)

A structure corresponds to what is called a record in some other
languages: a data structure with a fixed set of named fields or slots,
known in _T as _Fit(components).  For example, one might want an
_qu(employee) structure, with slots for the employee's name, age, and
salary.  A structure, then, is an organized set of _Fit(locations), places
to store things.
_index(structures)

_DComment( Compare with use of _tc(LAMBDA) and _tc(OBJECT). )

_Section(Terminology)

Every structure has an associated an object called a _iix(structure
type) (sometimes abbreviated _iix(stype), pronounced _qu(ess type)).
Structure types are created by the procedure _tc(MAKE-STYPE) (see below)
and by the special form _tc(DEFINE-STRUCTURE-TYPE)

Given a structure type _Fit(S), one can access several things of interest:
_begin_Table
_Item(Constructor)
a procedure that will create uninitialized structures of
type _Fit(S) (e.g., the structure for a particular employee).

_Item(Predicator)
a procedure (a type predicate) that returns true if its
  argument is a structure of type _Fit(S).

_Item(Component selectors)
procedures that access the various components of
  structures of type _Fit(S) (one selector per component).

_Item(Handler)
the mechanism for specifying how a set of generic operations
will behave when applied to structures of type _Fit(S).
_end_Table

_DComment( mention the master copy also. )

_Section(Defining structure types)

The _tc(DEFINE-STRUCTURE-TYPE) macro _DComment(?)
is a convenient way to define a new structure type and its
associated constructor, predicator, and component selectors.
_tc(DEFINE-STRUCTURE-TYPE) is a macro defined in terms of _tc(MAKE-STYPE) and
the other low-level routines described in the next section.  One may
want to define one's own interface to these routines, one that
initializes the components when a new instance is constructed, for
example.

_Comdef(`DEFINE-STRUCTURE-TYPE',`Special form',
`(DEFINE-STRUCTURE-TYPE _Fit(typename _a(_cBo,components,_cBc,_plus) _a(_cBo,methods,_cBc,_star))) _yl() _Fit(stype)')
_begin_Desc
Creates a structure type (using _tc(MAKE-STYPE)),
and defines a number of variables:
_begin_Itemize
_Item()_Fit(typename)_tc(-STYPE) is defined to be the structure type.

_Item()_tc(MAKE-)_Fit(typename) is defined to be the constructor.

_Item()_Fit(typename)_tc(?) is defined to be the predicator.

_Item()_Fit(typename)_tc(-)_Fit(componentname) is defined to be a component selector, for
each of the _Fit(componentnames).
_end_Itemize
For example,
_begin_Example
(DEFINE-STRUCTURE-TYPE EMPLOYEE NAME AGE SALARY)
_end_Example
defines
_begin_Itemize
_Item()_tc(EMPLOYEE-STYPE), a variable whose value is
the structure type whose name is _tc(EMPLOYEE).

_Item()_tc((MAKE-EMPLOYEE)), a procedure that creates uninitialized
_tc(EMPLOYEE)-structures.

_Item()_tc((EMPLOYEE? _Fit(object))), a type predicate.

_Item()
_begin_Example
_tc((EMPLOYEE-NAME _Fit(employee)) _LNL
(EMPLOYEE-AGE _Fit(employee)) _LNL
(EMPLOYEE-SALARY _Fit(employee)))
_end_Example
selectors that access the components of _tc(EMPLOYEE)-structures.
_DComment(dorab: fix for info. ideal use of Itemx ?)

_end_Itemize

_Fsem(methods) is an optional list of method clauses.  For example,

_begin_ExampleTabbing
(DEFINE-STRUCTURE-TYPE _settab()EMPLOYEE _incrtab() _LNL
	NAME _LNL
	AGE _LNL
	SALARY _LNL
	(((HUMAN? SELF) '_true) _LNL
	(_settab()PRINT SELF PORT) _incrtab()_LNL
	 (FORMAT _settab()PORT _cQ()_cH()_cBo()Employee (_cTL()A) _cTL()A _cBc()_cQ() _incrtab()_LNL
		 (OBJECT-HASH SELF) _LNL
		 (EMPLOYEE-NAME SELF)))))
_end_ExampleTabbing

The methods in the methods clauses cannot reference the components
directly.  They must use the standard structure accessors.  For
example, in the print method above the _Fsem(name) component of the 
_Fsem(employee) structure must be
accessed as _Ftt((EMPLOYEE-NAME SELF)) _em(not) as _Ftt(NAME).

_begin_Inset(Bug:)
Structures cannot yet be joined to other objects.
_end_Inset

_end_Desc 

_Section(Manipulating structure types)

_begin_Inset(Caution:)
      The unreleased feature of _Tv(2) that allowed handlers
      for structures to be
      mutated no longer exists.  Any code using
      _wt(handle-stype), _wt(get-method),
      _wt(set-method), etc.  will no longer work, but
      _wt(join) now works efficiently.
_end_Inset

_Comdef(`MAKE-STYPE',` ',
`(MAKE-STYPE _Fit(typename componentnames method-handler)) _yl() _Fit(stype)')
_begin_Desc
Returns a new structure type.  The _Fit(typename), which should be a
symbol, is used for printing and identification purposes only.
_Fit(Componentnames) should be a list of symbols.  The _Fit(componentnames)
correspond to the components that instances of the structure will have.
The _Fit(method-handler) should be an object that handles whatever
operations are required, or '_false(), if a handler is not required.

For example:
_begin_Example
(MAKE-STYPE 'EMPLOYEE '(NAME AGE SALARY) '_false)  _evalto()  _a(_cH,_cBo,Stype,` ',EMPLOYEE,_cBc)
_end_Example
This creates a structure type, identified as _tc(EMPLOYEE),
whose instances have components _tc(NAME), _tc(AGE), and _tc(SALARY).
The object returned, a structure type, is appropriate as an argument to other
routines described in this section. However,
_begin_ExampleTabbing
(MAKE-STYPE _settab()'EMPLOYEE _incrtab() _LNL
	    '(NAME AGE SALARY) _LNL
	    (OBJECT _settab()NIL _incrtab() _LNL
		    ((EMP? SELF) '_true))) _decrtab() _LNL
    _evalto() _a(_cH,_cBo,Stype,` ',EMPLOYEE,_cBc)
_end_ExampleTabbing
defines an _Fit(stype) that handles the predicate _wt(EMP?).
_end_Desc

_Comdef(`STYPE-ID',` ',
`(STYPE-ID _Fit(stype)) _yl() _Fit(typename)')
_begin_Desc
Returns the type identifier for _Fit(stype).
_end_Desc 

_Comdef(`STYPE-CONSTRUCTOR',` ',
`(STYPE-CONSTRUCTOR _Fit(stype)) _yl() _Fit(procedure)')
_begin_Desc
Given a structure type _Fit(stype), returns the procedure which will
instantiate (i.e., create instances of) the structure type.  The
constructor procedure takes no arguments and creates a structure with
uninitialized components.

Note that the constructor procedure is created at the time the structure type
is created, not at the time that _tc(STYPE-CONSTRUCTOR) is called.
_begin_Example
((STYPE-CONSTRUCTOR _Fit(stype)))  _equiv()  (COPY-STRUCTURE (STYPE-MASTER _Fit(stype)))
_end_Example
_end_Desc 

_Comdef(`STYPE-MASTER',` ',
`(STYPE-MASTER _Fit(stype)) _yl() _Fit(structure)')
_begin_Desc
Returns the _qu(master copy) from which all structures created by the
structure type's constructor-procedure are made.
This can be convenient for establishing default values for components in
newly created structures.  The way to do this is by storing into the
master copy the desired default values; these values will be copied
into all new instances of the structure type.  For example,
_begin_Example
(SET (EMPLOYEE-SALARY (STYPE-MASTER EMPLOYEE-STYPE)) 12000) _LNL
(EMPLOYEE-SALARY (MAKE-EMPLOYEE))  _evalto()  12000
_end_Example
_end_Desc 

_Comdef(`STYPE-PREDICATOR',` ',
`(STYPE-PREDICATOR _Fit(stype)) _yl() _Fit(procedure)')
_begin_Desc
Given a structure type _Fit(stype), returns the procedure (a type predicate)
which will predicate
membership in the structure type.  This procedure takes one
argument and returns true if that argument is an instance of the structure type.
_DComment((i.e., was created using the structure type's _tc(STYPE-CONSTRUCTOR)).)

Note that the predicator procedure is created at the time the structure type
is created, not at the time that _tc(STYPE-PREDICATOR) is called.
_end_Desc 

_Comdef(`STYPE-SELECTOR',` ',
`(STYPE-SELECTOR _Fit(stype componentname)) _yl() _Fit(procedure)')
_begin_Desc
Given a structure type _Fit(stype), returns the procedure which will
select the component of the structure type's instances identified by
_Fit(componentname).  The selector procedure takes one argument, which
must be a structure whose structure type is _Fit(stype), and returns the
appropriate component of the instance.

Such selector procedures support _tc(SETTER) operations, which is to say
that one may alter components of structures by using _tc(SET) or related
special forms.

The effect of selecting a structure component that has not been
previously set, or initialized from the master structure
(see _tc(STYPE-MASTER), above), is undefined.

Note that the selector procedures are created at the time the structure type
is created, not at the time that _tc(STYPE-SELECTOR) is invoked.
_end_Desc 

_Comdef(`STYPE-SELECTORS',` ',
`(STYPE-SELECTORS _Fit(stype)) _yl() _Fit(list of procedures)')
_begin_Desc
Given a structure type _Fit(stype), returns a list of its selector procedures.
_end_Desc 

_Comdef(`SELECTOR-ID',` ',
`(SELECTOR-ID _Fit(selector)) _yl() _Fit(identifier)')
_begin_Desc
Given a selector procedure, e.g., as returned by _tc(STYPE-SELECTOR),
returns its corresponding componentname.
_end_Desc 

_Comdef(`STYPE-HANDLER',`Settable',
`(STYPE-HANDLER _Fit(stype)) _yl() _Fit(handler)')
_begin_Desc
Given a structure type _Fit(stype), accesses the handler to be used
for generic operations applied to instances of the structure type.
For a newly created structure type, this handler handles
no operations, but one may set the handler to be any handler at all.
_DComment( Give example. )
_end_Desc 

_Section(Manipulating structures)

The primary means for manipulating structures is to call
their selector procedures and their setters.  For example, in the context
of the examples above, if _tc(EMPLOYEE-23) is an _tc(EMPLOYEE)-structure,
then _tc(EMPLOYEE-23)'s _tc(NAME) component may be retrieved
by evaluating
_begin_Example
(EMPLOYEE-NAME EMPLOYEE-23)
_end_Example
and this value may be set by evaluating
_begin_Example
(SET (EMPLOYEE-NAME EMPLOYEE-23) 'FRED)
_end_Example

This works because the selector procedures for _tc(EMPLOYEE-STYPE)
handle the generic operation called _tc(SETTER).
Structures may also be manipulated using other generic operations.
_DComment( as explained in the next section?? )

_Comdef(`STRUCTURE?',`Type predicate',
`(STRUCTURE? _Fit(object)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(object) is a structure.
_end_Desc 

_Comdef(`COPY-STRUCTURE',` ',
`(COPY-STRUCTURE _Fit(structure)) _yl() _Fit(structure)')
_begin_Desc
Makes a copy of _Fit(structure).  The value returned is a new object
of the same structure type as _Fit(structure) whose components
are the same (in the _tc(EQ?) sense) as _Fit(structure)'s.
_end_Desc 

_Comdef(`COPY-STRUCTURE!',` ',
`(COPY-STRUCTURE! _Fit(destination source)) _yl() _Fit(structure)')
_begin_Desc
Copies the components of _Fit(source) into _Fit(destination), which
is returned.
_Fit(Source) and _Fit(destination) must be structures of the same type.
_end_Desc 
