_Chapter(Side effects)

A _iix(side-effect) is a change in the _ix(state) of a running _T
system, such as a change in the value stored in some location, or an
effect on the outside world.
_index(locations)

Many useful programs can be written which make no use of side-effects.
In principle, side-effects other than those controlling the outside world are
unnecessary.  However, side effects, when used carefully, can be used to
promote program modularity and readability.  In addition, they may be
necessary in a _T implementation to obtain efficient program
execution.

_Section(Assignment)
_label(section:assignment)

_T provides several special forms which perform assignment to
_Fit(locations).  A location is a place in which a value may be stored,
for example, a variable, or the car of a list, or a component of a
structure.  Locations are not objects _Fit(per se), although
references to them may be obtained through the use of _iix(locatives).

_DComment( Talk about the syntax of _Fit(location) in the following. )

_Comdef(`SET',`Special form',
`(SET _Fit(location new-value)) _yl() _Fit(undefined)')
_label(SET)
_begin_Desc

_tc(SET) is a generalized assignment operator.
It alters the location specified by _Fit(location) to hold _Fit(new-value).
The value of any _tc(SET)-expression is the _Fit(new-value) thus stored.

If _Fit(location) is a symbol, then it names a variable which has been
previously bound by a _tc(LAMBDA) or an _tc(LSET) (or indirectly by
any form which does _tc(LAMBDA)-binding, such as _tc(LET)),
whose value is to be altered.
_begin_ExampleTabular
(SET X (LIST 1 2 3))  _colsep()_evalto()_colsep  (1 2 3) _LNL
X                     _colsep()_evalto()_colsep  (1 2 3)
_end_ExampleTabular
_Fit(Location) may also have the syntax of a call to an _Fit(access-type)
procedure or operation such as _tc(CAR).  (In this manual, these are
marked as _Fit(Settable).)
_label(Settable)
_begin_ExampleTabular
(SET (CAR X) 'A)  _colsep()_evalto()_colsep  A _LNL
X                 _colsep()_evalto()_colsep  (A 2 3)
_end_ExampleTabular

_begin_Example
(SET (_Fit(proc _sub(arg,1)) _dots _Fit(_sub(arg,n))) _Fit(value)) _LNL
  _equiv()  ((SETTER _Fit(proc)) _Fit(_sub(arg,1)) _dots _Fit(_sub(arg,n)) value)
_end_Example

It is an error to use a _wt(SET) form in a value requiring
position.  For example,

_example((SET (p x y _dots) val))

is conceptually equivalent

_begin_ExampleTabbing
(LAMBDA _settab()() _incrtab()_LNL
  ((SETTER p) x y _dots val) _LNL
  (RETURN))
_end_ExampleTabbing

where _Fcode((RETURN)) invokes the calling continuation with
no arguments. For more information on _wt(RETURN) see section
_Ref(RETURN).

In _Tv(3.1) _wt(SET) will continue
to return the value being assigned to the location, but an
error will be signalled in the future.
_end_Desc

_Comdef(`SETTER',`Operation',
`(SETTER _Fit(procedure)) _yl() _Fit(procedure)')
_begin_Desc

Given an access routine, _tc(SETTER) returns a corresponding alteration
routine.  _wt((SETTER CAR)), for example, evaluates to a primitive
procedure that takes two arguments, a list whose car is to be changed,
and a value to store in the car of the list.

See also _tc(DEFINE-SETTABLE-OPERATION), page
_Pageref(DEFINE-SETTABLE-OPERATION).  _DComment( ? )
_end_Desc

_Comdef(`SWAP',`Special form',
`(SWAP _Fit(location new-value)) _yl() _Fit(object)')
_begin_Desc

This behaves the same as _tc(SET), except that the value
returned is the old value found in _Fit(location),
rather than the _Fit(new-value).  For example,
the following expression exchanges the values of the variables _tc(X) and
_tc(Y):
_begin_Example
(SET X (SWAP Y X))
_end_Example
_end_Desc

_Comdef(`EXCHANGE',`Special form',
`(EXCHANGE _Fit(location1 location2)) _yl() _Fit(undefined)')
_begin_Desc

Exchanges the values in the two locations.
_DComment(Explain more fully.)
_end_Desc

_Comdef(`MODIFY',`Special form',
`(MODIFY _Fit(location procedure)) _yl() _Fit(undefined)')
_begin_Desc

Stores a value in the _Fit(location) which is obtained by applying _Fit(procedure)
to the old value in _Fit(location).
_begin_Example
(MODIFY _Fit(location) 1+)  _equiv()  (INCREMENT _Fit(location))
_end_Example

The value of the _wt(MODIFY) special form is undefined, and
it is an error to use a _wt(MODIFY) form in a value requiring
position.  In _Tv(3.1) _wt(MODIFY) will continue to return
a value.
_end_Desc

_Comdef(`MODIFY-LOCATION',`Special form',
`(MODIFY-LOCATION _Fit(location continuation)) _yl() _Fit(object)')
_begin_Desc

Calls _Fit(continuation), which should be a procedure of two arguments,
passing it an access procedure
of no arguments, which fetches the value in _Fit(location);
and an update procedure of one argument, which will store a
new value in _Fit(location).
_DComment(bletch)

_tc(MODIFY-LOCATION)'s purpose is to ensure that any subforms
of the form for _Fit(location) are evaluated only once.  For example,
_begin_ExampleTabbing
(INCREMENT _settab()(CAR (HACK)) _LNL
  _gotab()_equiv() _LNL
(MODIFY-LOCATION _settab()(CAR (HACK)) _LNL
                 _gotab()(LAMBDA (FETCH STORE) (STORE (+ (FETCH) 1))))
_end_ExampleTabbing
In this expression, _tc((HACK)) will be evaluated only once, whereas in the following
naive expansion
_begin_Example
(SET (CAR (HACK)) (+ (CAR (HACK)) 1))
_end_Example
it is evaluated twice, which is presumably neither necessary nor desirable.
During the expansion of _tc(MODIFY-LOCATION) forms extra temporary
variables are introduced, as needed, to account for this.

_tc(MODIFY-LOCATION) is useful in macro expansions,
although awkward when written directly.
Other _qu(modification) forms such as _tc(PUSH), _tc(MODIFY), and _tc(SWAP)
are implementeded as macros in terms of the
_tc(MODIFY-LOCATION) special form.

For example, one might define a _tc(DOUBLE) macro, which multiplies by two the
value in a location, as follows:
_begin_ExampleTabbing
(DEFINE-SYNTAX _settab()(DOUBLE FORM) _incrtab()_LNL
  _cQo()(MODIFY-LOCATION _LNL
     ,FORM _LNL
     (LAMBDA (FETCH STORE) (STORE (* (FETCH) 2))))) _decrtab()_LNL

(DOUBLE (CAR (HACK)))
_end_ExampleTabbing
_end_Desc

_Section(Locatives)
_label(section:locatives)

_Fit(Locatives) in _T are similar to the _Fit(pointers) or
_Fit(references) of languages like C or Algol 68.

Locatives are obtained by evaluating _tc(LOCATIVE)-expressions.  The
value in the location they refer to may be fetched using the
_tc(CONTENTS) operation, and stored using _tc(SET).

Objects which act as locatives may be created using _tc(OBJECT), as long
as they handle the _tc(CONTENTS) and _tc((SETTER CONTENTS)) operations
appropriately, and handle _tc(LOCATIVE?) by returning true.

_Comdef(`LOCATIVE',`Special form',
`(LOCATIVE _Fit(location)) _yl() _Fit(locative)')
_begin_Desc

Returns a locative which accesses the location specified by _Fit(location).
_Fit(Location) receives similar treatment to the _Fit(location) position
in the _tc(SET) special form; it may refer to a variable, or to a
_qu(field) within some mutable structure, for example the car of a pair.

The following equivalence approximates the behavior of _tc(LOCATIVE):
_begin_ExampleTabbing
(LOCATIVE _settab()_Fit(location)) _LNL
  _gotab()_equiv() _LNL
(OBJECT _settab()NIL _incrtab()_LNL
        ((CONTENTS SELF) _Fit(location)) _LNL
        (((SETTER CONTENTS) SELF VALUE) (SET _Fit(location) VALUE)) _LNL
        ((LOCATIVE? SELF) T))
_end_ExampleTabbing
This is accurate if _Fit(location) is a variable, but if it is a call,
the subforms of the call are evaluated when the _tc(LOCATIVE)-expression
is evaluated, not when the contents of the locative are required.
For example,
_begin_ExampleTabbing
(LOCATIVE _settab()(FOO (BAR BAZ))) _LNL
  _gotab()_equiv() _LNL
(LET _settab()(_settab()(TEMP1 FOO) _incrtab()_incrtab()_LNL
      (TEMP2 (BAR BAZ))) _decrtab()_LNL
  (OBJECT _settab()NIL _incrtab()_LNL
          ((CONTENTS SELF) (TEMP1 TEMP2)) _LNL
          (((SETTER CONTENTS) SELF VALUE) (SET (TEMP1 TEMP2) VALUE)) _LNL
          ((LOCATIVE? SELF) T)))
_end_ExampleTabbing
_end_Desc

_Comdef(`CONTENTS',`Settable operation',
`(CONTENTS _Fit(locative)) _yl() _Fit(object)')
_begin_Desc

Dereferences (indirects through) the _Fit(locative).
_begin_ExampleTabular
(LSET Z (LIST 'A 'B))                   _colsep()_evalto()_colsep  (A B) _LNL
(CONTENTS (LOCATIVE (CAR Z)))           _colsep()_evalto()_colsep  A _LNL
(SET (CONTENTS (LOCATIVE (CAR Z))) 'C)  _colsep()_evalto()_colsep  C _LNL
Z                                       _colsep()_evalto()_colsep  (C B) _LNL

(CONTENTS (LOCATIVE _Fit(location)))  _colsep()_equiv()_colsep  _Fit(location) _LNL
(SET (CONTENTS (LOCATIVE _Fit(location))) _Fit(value)  _colsep()_equiv()_colsep  (SET _Fit(location) _Fit(value))
_end_ExampleTabular
_end_Desc

_Comdef(`LOCATIVE?',`Type predicate operation',
`(LOCATIVE? _Fit(object)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(object) is a locative.
_end_Desc

_Section(Dynamic state)
_label(section:dynamicState)
_index(dynamic state)

_Comdef(`BIND',`Special form',
`(BIND _Fit(specs) . _Fit(body)) _yl() _Fit(value-of-body)')
_begin_Desc

_tc(BIND) implements _ix(dynamic binding).  Syntactically, it is similar
to _tc(LET), but semantically it is completely different.  _tc(BIND)
operates by doing temporary assignments to locations, for example, to
bound variables.  Unlike _tc(LET), it does not introduce a new lexical
binding contour.

Note that the use of the term _Fit(bind) in this context is
unrelated to its use elsewhere (for example, at the beginning of chapter
_Ref(environments)).

Each _Fit(spec) should have the syntax
_begin_Example
(_Fit(location) _Fit(value))
_end_Example
The value in each _Fit(location) is obtained and saved.
Each _Fit(location) is assigned the _Fit(value), as with _tc(SET).
The _Fit(body) expressions are evaluated and the value of the last
is saved.  The _Fit(locations) are then restored to their original
saved values.  The _tc(BIND)-expression finally yields the saved value
of the _Fit(body).
_begin_Example
(BIND ((_Fit(location) _Fit(value))) . _Fit(body))
_end_Example
is therefore similar to
_begin_ExampleTabbing
(LET _settab()((SAVED-VALUE _Fit(location))) _incrtab()_LNL
  (SET _Fit(location) _Fit(value)) _LNL
  (BLOCK0 _settab()(BLOCK . _Fit(body)) _incrtab()_LNL
          (SET _Fit(location) SAVED-VALUE)))
_end_ExampleTabbing
or
_begin_ExampleTabbing
(LET _settab()((SAVED-VALUE _Fit(location))) _incrtab()_LNL
  (SET _Fit(location) _Fit(value)) _LNL
  (UNWIND-PROTECT _settab()(BLOCK . _Fit(body)) _incrtab()_LNL
                  (SET _Fit(location) SAVED-VALUE)))
_end_ExampleTabbing
Examples:
_begin_Example
(LSET A 1) _LNL
(DEFINE (F) (+ A 1)) _LNL
(F)                   _evalto()  2 _LNL
(LET  ((A 10)) (F))   _evalto()  2 _LNL
(BIND ((A 10)) (F))   _evalto()  11 _LNL

(LSET X (LIST 1 2 3)) _LNL
(BIND (((CAR X) 10)) _LNL
  (LSET Y (COPY-LIST X))) _LNL
X  _evalto()  (1 2 3) _LNL
Y  _evalto()  (10 2 3)
_end_Example
The values in the _Fit(locations) are restored, even
if a throw out of _Fit(body) occurs (see _tc(CATCH), page _Pageref(CATCH)).
For example:
_begin_ExampleTabbing
(LET _settab()((A 10)) _incrtab()_LNL
  (CATCH EP (BIND ((A 20)) (EP NIL))) _LNL
  A) _LNL
  _evalto()  10
_end_ExampleTabbing
Any _Fit(location) in a _tc(BIND)-form which is a variable name
should name a variable which has been previously bound
using, for example, _tc(LSET) or _tc(LET).
_end_Desc

_Comdef(`UNWIND-PROTECT',`Special form',
`(UNWIND-PROTECT _Fit(form . unwind-forms)) _yl() _Fit(value-of-form)')
_label(UNWIND-PROTECT)
_begin_Desc

_tc(UNWIND-PROTECT) behaves nearly the same as _tc(BLOCK0):
the _Fit(form) is evaluated, and the value is saved; the _Fit(unwind-forms)
are evaluated; and the _tc(UNWIND-PROTECT)-expression yields the (saved)
value of _Fit(form).  However, unlike _tc(BLOCK0),
_tc(UNWIND-PROTECT) guarantees that
the _Fit(unwind-forms) will be evaluated,
even if a throw occurs
during the evaluation of _Fit(form).

In the following example, the motor will be stopped even if _tc(DRILL-HOLE)
attempts to throw out of the _tc(UNWIND-PROTECT).
_begin_ExampleTabbing
(UNWIND-PROTECT _settab()(BLOCK _settab()(START-MOTOR) _incrtab()_incrtab()_LNL
                       (DRILL-HOLE)) _decrtab()_LNL
                (STOP-MOTOR)) _LNL
_end_ExampleTabbing

A throw (see page _Pageref(CATCH)) out of the _tc(BLOCK) - for example,
as a result of calling _tc(DRILL-HOLE), will evaluate the exit form
_wt((STOP-MOTOR)) before control finally returns to its corresponding
_tc(CATCH).

It is an error to throw out of the unwind forms of an _tc(UNWIND-PROTECT).
_end_Desc

_DComment( Talk about dynamic state; _qu(soft) and _qu(hard) throws;
the difference between _tc(BIND) and _tc(UNWIND-PROTECT); etc. )
