_Chapter(Ports)

_DComment( Some general comments are in order: )

A _Fit(port) is any object which handles port operations.  In general,
ports are objects which contain pointers into sequences of objects.
The port operations provide for obtaining objects from such a
sequence, advancing a port's pointer, performing side effects
on the sequence itself, and so forth.

_DComment( Opening and closing ports. )

_DComment( Input and output ports. )

_DComment( Comparison with streams in the AI sense - those don't have state; they
are instead like infinite (lazy) lists. )

_T programs communicate with the external world via _ix(ports).
Ports may access file systems or terminals.  They may also be used
to implement filters and buffers of various sorts.

Ports are manipulated using generic operations.  Most of the
procedures described below are generic operations, and their
descriptions either specify the behavior of their default methods
or of the methods for system-supplied ports.  Users may create
ports to their own specifications using _tc(OBJECT)-expressions.
As long as a user port supports
_tc(READ-CHAR) and _tc(UNREAD-CHAR) (for input ports) or
_tc(WRITE-CHAR) (for output ports), most of the other I/O operations
will work with them.

_Section(General)

_Comdef(`PORT?',`Type predicate operation',
`(PORT? _Fit(object)) _yl() _Fit(boolean)')
_begin_Desc
_tindex(PORT?)
Returns true if _Fit(object) is a port.
_end_Desc 

_Comdef(`INPUT-PORT?',`Type predicate operation',
`(INPUT-PORT? _Fit(object)) _yl() _Fit(boolean)')
_begin_Desc
_tindex(INPUT-PORT?)
Returns true if _Fit(object) is an input port.
_end_Desc 


_Comdef(`OUTPUT-PORT?',`Type predicate operation',
`(OUTPUT-PORT? _Fit(object)) _yl() _Fit(boolean)')
_begin_Desc
_tindex(OUTPUT-PORT?)
Returns true if _Fit(object) is an output port.
_end_Desc 


_Comdef(`INTERACTIVE-PORT?',`Type predicate operation',
`(INTERACTIVE-PORT? _Fit(object)) _yl() _Fit(boolean)')
_begin_Desc
_tindex(INTERACTIVE-PORT?)
Returns true if _Fit(object) is an _iix(interactive) port.
An interactive port is any input port which is likely to have
a human being at the other end, for example, a terminal input port.
_end_Desc 


_Comdef(`EOF?',`Type predicate',
`(EOF? _Fit(object)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(object) is the end-of-file token.
(_qu(End-of-port) would be a more appropriate term.)
_end_Desc 

_Comdef(`EOF',` ',
`EOF _yl() _Fit(end-of-file)')
_begin_Desc
In _Tv(2) was called _tix(*EOF*).
This global variable holds the end-of-file token.
_end_Desc

_Comdef(`WITH-OPEN-PORTS',`Special form',
`(WITH-OPEN-PORTS _Fit(specs) . _Fit(body)) _yl() _Fit(object)')
_label(WITH-OPEN-PORTS)
_begin_Desc
_tc(WITH-OPEN-PORTS) has the same syntax as _tc(LET),
and similar semantics.
Each _Fit(spec) should be of the form _wt((_Fit(variable port))).
Each _Fit(port) expression
is evaluated, and should evaluate to a port;
for example, _Fit(port) would typically be an expression
involving _tc(OPEN) or _tc(MAYBE-OPEN).
The _Fit(body), an implicit block, is evaluated in a lexical context in which
each _Fit(variable) is bound to the value of the corresponding
_Fit(port) expression.
The ports are closed,
and the value of _Fit(body) is returned.

_tc(WITH-OPEN-PORTS) is the preferred way to use port creation
operations such as _tc(OPEN).  It ensures that the
ports will be closed, even if there is a non-local exit (a
_tc((RESET)) or any other kind of
throw) out of _Fit(body) or any of the _Fit(port) expressions.
(See _tc(UNWIND-PROTECT), page _Pageref(UNWIND-PROTECT).)

For an example, see _tc(OPEN), page _Pageref(OPEN).
_end_Desc 

_Comdef(`CLOSE',`Operation',
`(CLOSE _Fit(port)) _yl() _Fit(undefined)')
_label(CLOSE)
_begin_Desc
Closes _Fit(port); indicates that no more input or output is intended,
and that any resources associated with it may be freed.
_end_Desc 

_Comdef(`_a(STRING-,_cGT,INPUT-PORT)',` ',
`(_a(STRING-,_cGT,INPUT-PORT) _Fit(string)) _yl() _Fit(port)')
_begin_Desc
Returns an input port which yields successive characters of _Fit(string)
on successive _tc(READ-CHAR)'s.
_end_Desc 

_Comdef(`WITH-INPUT-FROM-STRING',`Special form',
`(WITH-INPUT-FROM-STRING (_Fit(variable string)) . _Fit(body)) _yl() 
_Fit(value-of-body)')
_begin_Desc
Opens an input port to _Fit(string), binds _Fit(variable) to that
port, and evaluates _Fit(body), returning whatever _Fit(body) returns.
_begin_Example
(WITH-INPUT-FROM-STRING (_Fit(variable string)) . _Fit(body)) _LNL
  _equiv() _LNL
(WITH-OPEN-PORTS ((_Fit(variable) (_a(STRING-,_cGT,INPUT-PORT) _Fit(string))))LNL
  . _Fit(body))
_end_Example
_end_Desc 

_Comdef(`WITH-OUTPUT-TO-STRING',`Special form',
`(WITH-OUTPUT-TO-STRING _Fit(var . body)) _yl() _Fit(string)')
_begin_Desc
Binds _Fit(var) to an output port.  The _Fit(body) (an implicit block) is
evaluated, and any characters written to the port are
collected in a string, which is returned as the value of the
_tc(WITH-OUTPUT-TO-STRING) form.
_begin_Example
(WITH-OUTPUT-TO-STRING FOO (WRITE FOO '(A B)))  _evalto()  (A B)
_end_Example
_end_Desc 

_Section(Port switches)

_Comdef(`TERMINAL-INPUT',`Settable',
`(TERMINAL-INPUT) _yl() _Fit(port)')
_label(TERMINAL-INPUT)
_begin_Desc
Accesses the default port for input from the terminal.

Note that an end-of-file condition on the terminal input port (see
page _Pageref(end-of-file)) will cause the end-of-file token to be
returned as the value of the next input operation on that port,
but will not cause the port to become closed.  This is an exception
to the normal rule that no input is available from a port following
an end-of-file condition on it.
_end_Desc 

_Comdef(`TERMINAL-OUTPUT',`Settable',
`(TERMINAL-OUTPUT) _yl() _Fit(port)')
_begin_Desc
Accesses the default port for output to the terminal.
_end_Desc 

_Comdef(`STANDARD-INPUT',`Settable',
`(STANDARD-INPUT) _yl() _Fit(port)')
_begin_Desc
Accesses the default standard input port.
Initially, this is the same as the value of _tc((TERMINAL-INPUT)).

The intent is that a program could do all its input from
the standard input port.
By default, input would come from the terminal.  But some procedure could
set the standard input port to be a file, for example, and then
call the program, which would automatically read from the file.
This same idea is used for all the following predefined ports.
_end_Desc 

_Comdef(`STANDARD-OUTPUT',`Settable',
`(STANDARD-OUTPUT) _yl() _Fit(port)')
_begin_Desc
_tc(STANDARD-OUTPUT) accesses the default standard output port.
Initially, this is the same as the value of _tc((TERMINAL-OUTPUT)).
_end_Desc 

_Comdef(`ERROR-OUTPUT)',`Settable',
`(ERROR-OUTPUT) _yl() _Fit(port)')
_begin_Desc
Initially, yields the same value as _tc((TERMINAL-OUTPUT)).
_end_Desc 

_Comdef(`DEBUG-OUTPUT)',`Settable',
`(DEBUG-OUTPUT) _yl() _Fit(port)')
_begin_Desc
Initially, yields the same value as _tc((TERMINAL-OUTPUT)).
_end_Desc 

_Section(Input)

_Comdef(`READ-CHAR',`Operation',
`(READ-CHAR _Fit(port)) _yl() _Fit(character) _rm(or) _Fit(end-of-file)')
_label(READ-CHAR)
_Comdef(`READC',`Operation',
`(READC _Fit(port)) _yl() _Fit(character) _rm(or) _Fit(end-of-file)')
_begin_Desc 
Reads a single character from _Fit(port), advances the port pointer,
and returns the character read.  If no character is available, then
the end-of-file token is returned.
_end_Desc

_Comdef(`MAYBE-READ-CHAR',` ',
`(MAYBE-READ-CHAR _Fsem(port)) _yl() _Fsem(character) _rm(or) _Fsem(false)')
_begin_Desc 
_wt(MAYBE-READ-CHAR) when invoked on a port will return
the next character if one is available; otherwise, it will return
immediately with a value of false.
_end_Desc

_Comdef(`CHAR-READY?',` ',
`(CHAR-READY? _Fsem(port)) _yl() _Fsem(boolean)')
_begin_Desc 
_wt(CHAR-READY?) returns true if a character is available
for input; otherwise, it returns false.
_end_Desc

_Comdef(`UNREAD-CHAR',`Operation',
`(UNREAD-CHAR _Fit(port)) _yl() _Fit(undefined)')
_label(UNREAD-CHAR)
_Comdef(`UNREADC',`Operation',
`(UNREADC _Fit(port)) _yl() _Fit(undefined)')
_begin_Desc 
Backs up _Fit(port)'s pointer into its corresponding sequence of
characters by one character.  This causes the
next _tc(READ-CHAR) from _Fit(port) to return _Fit(character) instead of
actually reading another character.  _Fit(Character) is returned.
_tc(UNREAD-CHAR) is convenient for implementing one-character-lookahead
scanners.  Only the previous character _tc(READ-CHAR)'ed from _Fit(port)
may be put back, and it may be put back only once.
_DComment( Explain why one needs to supply the character at all. )
_end_Desc

_Comdef(`PEEK-CHAR',`Operation',
`(PEEK-CHAR _Fit(port)) _yl() _Fit(character) _rm(or) _Fit(end-of-file)')
_Comdef(`PEEKC',`Operation',
`(PEEKC _Fit(port)) _yl() _Fit(character) _rm(or) _Fit(end-of-file)')
_begin_Desc 
Returns the next character available on _Fit(port) without
advancing the port's pointer.
If no character is there then the end-of-file token is returned.
_begin_ExampleTabbing
(PEEK-CHAR _settab()_Fit(port))  _equiv() _incrtab()_LNL
  (BLOCK0 (READ-CHAR _Fit(port)) (UNREAD-CHAR _Fit(port)))
_end_ExampleTabbing
_end_Desc

_Comdef(`READ-LINE',`Operation',
`(READ-LINE _Fit(port)) _yl() _Fit(string) _rm(or) _Fit(end-of-file)')
_begin_Desc
Reads a line of input from _Fit(port) and returns it as a string.
If no input is available then the end-of-file token is returned.
_end_Desc 

_Comdef(`READ',`Operation',
`(READ _Fit(port)) _yl() _Fit(object) _rm(or) _Fit(end-of-file)')
_label(READ)
_begin_Desc
Reads an object from _Fit(port).  The default method simply calls
_tc(READ-OBJECT), passing it the port and
the port's current associated read table.  See _tc(READ-OBJECT),
page _Pageref(READ-OBJECT), and _tc(PORT-READ-TABLE), page
_Pageref(PORT-READ-TABLE).
_end_Desc 

_Comdef(`READ-REFUSING-EOF',` ',
`(READ-REFUSING-EOF _Fit(port)) _yl() _Fit(object)')
_begin_Desc
This is like _tc(READ) but should be used in cases where an end-of-file
is not appropriate or is not handled, such as within
the definition of a read macro.
_end_Desc 

_Comdef(`READ-OBJECTS-FROM-STRING',` ',
`(READ-OBJECTS-FROM-STRING _Fit(string)) _yl() _Fit(list)')
_begin_Desc
Returns a list of all the objects that could be read from the string.
_begin_ExampleTabular
(READ-OBJECTS-FROM-STRING _cQ()A B C _cQ())           _colsep()_evalto()_colsep  (A B C) _LNL
(READ-OBJECTS-FROM-STRING _cQ() 015  ( Foo ) _cQ())  _colsep()_evalto()_colsep  (15 (FOO)) _LNL
(READ-OBJECTS-FROM-STRING _cQ()_cQ())                _colsep()_evalto()_colsep  ()
_end_ExampleTabular
_end_Desc 

_Comdef(`CLEAR-INPUT',`Operation',
`(CLEAR-INPUT _Fit(port)) _yl() _Fit(undefined)')
_begin_Desc
Discards any buffered input for _Fit(port).
The precise action of this operation is implementation-dependent.
_end_Desc 

_Section(Output)
  
_Comdef(`PRINT',` ',
`(PRINT _Fit(object port)) _yl() _Fit(undefined)')
_begin_Desc
Prints _Fit(object) on _Fit(port) according to the current read-table.
This is an operation, so objects may decide how they would like
to print.
_end_Desc 

_Comdef(`WRITE',`Operation',
`(WRITE _Fit(port object)) _yl() _Fit(undefined)')
_begin_Desc
Prints the _Fit(object) on _Fit(port).  This is like _tc(PRINT) with the
argument order reversed.
This is an operation, so particular ports may decide how they want
to write objects to themselves.
_end_Desc 

_Comdef(`WRITE-CHAR',`Operation',
`(WRITE-CHAR _Fit(port character)) _yl() _Fit(undefined)')
_Comdef(`WRITEC',`Operation',
`(WRITEC _Fit(port character)) _yl() _Fit(undefined)')
_begin_Desc 
Writes a single _Fit(character) to _Fit(port).
_end_Desc

_Comdef(`WRITE-STRING',`Operation',
`(WRITE-STRING _Fit(port string)) _yl() _Fit(undefined)')
_Comdef(`WRITES',`Operation',
`(WRITES _Fit(port string)) _yl() _Fit(undefined)')
_begin_Desc 
Writes _Fit(string) to _Fit(port).
_end_Desc

_Comdef(`WRITE-LINE',`Operation',
`(WRITE-LINE _Fit(port string)) _yl() _Fit(undefined)')
_begin_Desc
Writes _Fit(string) to _Fit(port) (like _tc(WRITE-STRING)),
then does a _tc(NEWLINE) operation.
_end_Desc 

_Comdef(`WRITE-SPACES',` ',
`(WRITE-SPACES _Fit(port count)) _yl() _Fit(undefined)')
_begin_Desc
Writes _Fit(count) space characters to _Fit(port).
_end_Desc 

_Comdef(`DISPLAY',` ',
`(DISPLAY _Fit(object port)) _yl() _Fit(undefined)')
_begin_Desc
Prints _Fit(object) on _Fit(port), but omits any slashes, delimiters, etc., when
printing strings, symbols, and characters.
_end_Desc 
  
_Comdef(`PRETTY-PRINT',` ',
`(PRETTY-PRINT _Fit(object port)) _yl() _Fit(undefined)')
_label(PRETTY-PRINT)
_begin_Desc
Pretty-prints _Fit(object) on _Fit(port).
_end_Desc 

_Comdef(`NEWLINE',`Operation',
`(NEWLINE _Fit(port)) _yl() _Fit(undefined)')
_begin_Desc
Begins a new line on the given output _Fit(port).
_end_Desc 

_Comdef(`FRESH-LINE',`Operation',
`(FRESH-LINE _Fit(port)) _yl() _Fit(undefined)')
_begin_Desc
If not at the beginning of a line,
begins a new line on the given output _Fit(port).
_end_Desc 

_Comdef(`SPACE',`Operation',
`(SPACE _Fit(port)) _yl() _Fit(undefined)')
_begin_Desc
Write whitespace to _Fit(port).  Ordinarily this will simply write
a space character, but if the current output line has overflowed
a _qu(reasonable) right margin, this will do a _tc(NEWLINE).
_end_Desc 

_Comdef(`FORCE-OUTPUT',`Operation',
`(FORCE-OUTPUT _Fit(port)) _yl() _Fit(undefined)')
_begin_Desc
Makes sure any buffered output to _Fit(port) is forced out.
This is useful especially with terminal output ports.
The precise behavior of this operation is implementation-dependent.
_end_Desc 

_Section(Formatted output)

_Comdef(`FORMAT',` ',
`(FORMAT _Fit(destination control-string) . _Fit(rest)) _yl() _Fit(string) _rm(or) _Fit(undefined)')
_label(FORMAT)
_begin_Desc
Performs formatted output.
Characters in the _Fit(control-string) other than tilde (_cTL())
are simply written to _Fit(destination).
When a tilde is encountered, special action is taken
according to the character following the tilde.

_Fit(Destination) should be one of the following:
_begin_Itemize
_Item()    A port.  In this case, output is simply written to the port.
    The value returned by the call to _tc(FORMAT) is undefined.

_Item()    The standard true value.  (This is the value of the system variable _tc(T).)
    This is equivalent to a port argument of _tc((STANDARD-OUTPUT)).
    The value returned by the call to _tc(FORMAT) is undefined.

_Item()    Null.  In this case the output is collected in a string, as with
    _tc(WITH-OUTPUT-TO-STRING).  This string is returned as the value of
    the call to _tc(FORMAT).
_end_Itemize

The _tc(FORMAT) control sequences are as follows.
(Case is irrelevant, so _cTL()_tc(A) and _cTL()_tc(a) behave identically.)
_begin_Itemize
_Item(_cTL()_tc(A))  _tc(DISPLAY) the next format argument. 
_Item(_cTL()_tc(B))  Print the next argument in binary. 
_Item(_cTL()_tc(D))  Print the next argument in decimal (radix ten). 
_Item(_cTL()_tc(O))  Print the next argument in _ix(octal) (radix eight). 
_Item(_cTL()_tc(P))  Write the character _exqu(_tc(s)) if the next argument, 
           which must be a number, is not equal to 1 (for plurals). 
_Item(_cTL()_tc(R))  _cTL()_Fit(n)_tc(R) prints the next argument in radix _Fit(n). 
_Item(_cTL()_tc(S))  _tc(PRINT) the next format argument. 
_Item(_cTL()_tc(T))  _cTL()_Fit(n)_tc(T) tabs to column _Fit(n) (_tc(HPOS)). 
_Item(_cTL()_tc(X))  Print the next argument in _ix(hexadecimal) (radix sixteen). 
_Item(_cTL()_tc(_cP))  Go to a new output line (_tc(NEWLINE)). 
_Item(_cTL()_tc(_cAND))  Go to a fresh output line (_tc(FRESH-LINE)). 
_Item(_cTL()_tc(_cUL))  Print a space, or go to a fresh output line (_tc(SPACE)). 
_Item(_cTL()_cTL())  Write a tilde.
_end_Itemize

A tilde followed by any whitespace character is ignored, along with all
following whitespace.

_begin_Example
(FORMAT NIL _exqu(The _Ftt(_cTL)s eats grass.) 'ELAND)  _evalto()  _exqu(The ELAND eats grass.) _LNL
(FORMAT NIL _exqu(The _Ftt(_cTL)A eats grass.) _exqu(kudu))  _evalto()  _exqu(The kudu eats grass.) _LNL
(FORMAT NIL _exqu(_Ftt(_cTL)S had _Ftt(_cTL)X goat _Ftt(_cTL)P.) '(SANDY SMITH) 31 31) _LNL
  _evalto()  _exqu((SANDY SMITH) had 1F goats.)
_end_Example

_DComment( Explain numeric prefix parameters. )

_DComment( Are there other features? )

_DComment( Say somewhere that newlines follow output, like in C, rather than
preceding output, as in Maclisp. )
_end_Desc 

_Section(Miscellaneous)

_Comdef(`PORT-READ-TABLE',`Settable operation',
`(PORT-READ-TABLE _Fit(port)) _yl() _Fit(read-table)')
_label(PORT-READ-TABLE)
_begin_Desc
_tindex(PORT-READ-TABLE)
Accesses the read table associated with _Fit(port).
See section _Ref(READTABLES).
_end_Desc 

_Comdef(`LINE-LENGTH',`Settable operation',
`(LINE-LENGTH _Fit(port)) _yl() _Fit(integer)')
_begin_Desc
Returns the maximum width that lines read from _Fit(port) are likely to take,
or that lines written to _Fit(port) ought to take.
    _begin_Inset(Bug:)
    In _T 2.7, the _tc(LINE-LENGTH) of system-supplied ports is
    not settable.
    _end_Inset
_end_Desc 

_Comdef(`HPOS',`Settable operation',
`(HPOS _Fit(port)) _yl() _Fit(integer)')
_begin_Desc
Accesses the current horizontal position (column number) of _Fit(port).
The leftmost position on a line is column 0.
When assigned, as many spaces as necessary are written to bring the
horizontal position to the assigned value.
_end_Desc 

_Comdef(`VPOS',`Settable operation',
`(VPOS _Fit(port)) _yl() _Fit(integer)')
_begin_Desc
Accesses the current vertical position (line number) of _Fit(port).
The uppermost vertical position is line 0.
_end_Desc 

_Comdef(`WITH-OUTPUT-WIDTH-PORT',`Settable',
`(MAKE-OUTPUT-WIDTH-PORT _Fit(variable) . _Fit(body)) _yl() _Fit(integer)')
_begin_Desc
_tindex(MAKE-OUTPUT-WIDTH-PORT)
Binds _Fit(variable) to an output port, and evaluates _Fit(body) in
the augmented lexical environment.
The characters sent to the output port are not accumulated, but
merely counted, and the total is returned as the value of
_tc(WITH-OUTPUT-WIDTH-PORT).
_end_Desc 

_Comdef(`PRINTWIDTH',` ',
`(PRINTWIDTH _Fit(object)) _yl() _Fit(integer)')
_begin_Desc
Returns the number of _tc(WRITEC)'s
which would be performed were _Fit(object) to be printed using _tc(PRINT).
_begin_Example
(PRINTWIDTH _Fit(object)) _LNL
  _equiv() _LNL
(WITH-OUTPUT-WIDTH-PORT PORT (PRINT _Fit(object) PORT))
_end_Example
_end_Desc 

_Comdef(`DISPLAYWIDTH',` ',
`(DISPLAYWIDTH _Fit(object)) _yl() _Fit(integer)')
_begin_Desc
Returns the number of _tc(WRITEC)'s
which would be performed were _Fit(object) to be printed using _tc(DISPLAY).
_begin_Example
(DISPLAYWIDTH _Fit(object)) _LNL
  _equiv() _LNL
(WITH-OUTPUT-WIDTH-PORT PORT (DISPLAY _Fit(object) PORT)
_end_Example
_end_Desc 

_Comdef(`MAKE-BROADCAST-PORT',` ',
`(MAKE-BROADCAST-PORT . _Fit(output-ports)) _yl() _Fit(port)')
_begin_Desc
Returns a port which will _qu(broadcast) all output operations to
all of the _Fit(output-ports).  For example, if the port _Fit(s) is the
value of a call
_begin_Example
(MAKE-BROADCAST-PORT _Fit(q) _Fit(r))
_end_Example
then any _tc(WRITEC) (_tc(WRITES), _tc(SPACE), etc.) operation
to _Fit(s) will result in _tc(WRITEC) operations on both
_Fit(q) and _Fit(r).
_end_Desc

_Section(Example)

Here is an example of a user-defined port.
_tc(MAKE-PREFIXED-PORT) returns a port
which prefixes each line written to a given port with a given string.
_begin_ExampleTabbing
(DEFINE _settab()(MAKE-PREFIXED-PORT PORT PREFIX) _incrtab()_LNL
  (JOIN _settab()(OBJECT _settab()NIL _incrtab()_incrtab()_LNL
                ((NEWLINE SELF) (NEWLINE PORT) (WRITES PORT PREFIX)) _LNL
                (_settab()(PRINT SELF OPORT) _incrtab()_LNL
                 (FORMAT _settab()OPORT _incrtab()_LNL
                         _a(_cH,_cBo,Prefixed-port,_cTL,_Ftt(_cUL),_a(_cTL,S,_cTL,_Ftt(_cUL),_a(_cTL,S,_cBc())))
			 _LNL
                         PORT _LNL
                         PREFIX))) _decrtab()_decrtab()_decrtab()_LNL
        PORT))
_end_ExampleTabbing
