_Chapter(Operations)
_label(chapter:operations)

_T provides a simple mechanism for programming in what
has come to be known as the _Fit(object-oriented style) of programming.
Object-oriented style may be contrasted to what will here be called
_Fit(procedural style).  In object-oriented programming, programs are
organized by giving the behavior of objects when various operations
are applied to them, whereas in procedural style, programs are organized
by giving the behavior of procedures when applied to various kinds
of objects.  These styles are equivalent in terms of computational
power, but each offers different advantages in terms of readability
and modularity.

_T supports the object-oriented style with a special kind of procedure
known as an _iix(operation), and with forms which permit one to create
objects which exhibit certain behavior when a given operation is applied
to them.

When an operation is called, the following sequence of events occurs:
_begin_Itemize
_Item()A _iix(handler) is obtained for the object which was the operation's
first argument.  (Operations must always be called with at least one argument.)

_Item()The operation asks the handler for a _iix(method) which will handle the
operation for the object.

_Item()The handler either provides a method, or it indicates that the
object is not prepared to handle the operation.

_Item()If the handler provided a method, the method is invoked.
If not, then the operation's _iix(default method), if any, is invoked.
If the operation has no default method, then the effect of the call to the
operation is undefined (and presumably an error condition is signalled).
_end_Itemize

In this way, an object's handler may determine how the operation
is to be performed for the object - that is, which particular method
is to be invoked as a result of invoking the operation.

Handlers map operations to methods.  Many objects may have the same
handler, or a handler may be idiosyncratic to a particular object.
However, _Fit(every) object has a handler, so all objects participate in the
generic operation dispatch protocol.

_Section(Fundamental forms)

The basis of the generic operation system consists of the two special
forms _tc(OBJECT) and _tc(OPERATION).  _tc(OBJECT)-expressions create
objects which respond appropriately to generic operations, and
_tc(OPERATION)-expressions evaluate to operations.
_index(objects)

_Comdef(`OBJECT',`Special form',
`(OBJECT _Fit(procedure) . _Fit(method-clauses)) _yl() _Fit(object)')
_label(OBJECT)
_begin_Desc

An _tc(OBJECT)-expression yields an object which is prepared to handle
generic operations according to the _Fit(method-clauses).
In the following description, _qu(the object) refers
to the value of a given _tc(OBJECT)-expression.

Each _Fit(method-clause) should be of the form
_begin_Example
((_Fit(operation) . _Fit(variables)) . _Fit(body))
_end_Example
_Fit(Operation) is an evaluated position, and is typically a variable
which evaluates to an operation, although it may be any
expression.  When an operation is called with the object as its first
argument, the _Fit(operation)-expressions are evaluated,
and if one yields the operation being applied to the object, the corresponding
_Fit(method-clause) is selected.  The operation is then performed
according to the selected _Fit(method-clause): the clause's _Fit(variables)
are bound to the arguments to the operation,
and its _Fit(body), an implicit block, is evaluated.
_begin_ExampleTabular
(DEFINE OP (OPERATION NIL)) _LNL
(OP (OBJECT NIL ((OP SELF) 34)))      _colsep()_evalto()_colsep  34 _LNL
(OP (OBJECT NIL ((OP SELF X) X)) 55)  _colsep()_evalto()_colsep  55
_end_ExampleTabular

_Fit(Procedure) may be any expression, and is evaluated at the time the
_tc(OBJECT)-expression is evaluated.  The object, when called, simply
calls the value of the _Fit(procedure) expression, passing on any
arguments.  Typically _Fit(procedure) might be either a
_tc(LAMBDA)-expression, if the object is to be callable, or it is
_tc(NIL), which by convention means that the object is not intended to
be called, the value of _tc(NIL) being an uncallable object.

In the degenerate case, where there are no method clauses, the value of
_begin_Example
(OBJECT (LAMBDA _Fit(args) . _Fit(body)))
_end_Example
is indistinguishable from that of
_begin_Example
(LAMBDA _Fit(args) . _Fit(body))_rm(.)
_end_Example

The semantics of the _tc(OBJECT) and _tc(OPERATION) special forms
can be described in terms of hypothetical primitive procedures
_tc(*OBJECT) and _tc(GET-HANDLER).
These primitives do not actually
exist in _T, but are introduced here as expository aids.
_tc(*OBJECT) takes two arguments, and returns an object which, when
called, calls the object which was _tc(*OBJECT)'s first argument, and
when given to _tc(GET-HANDLER) returns the object which was
_tc(*OBJECT)'s second argument.  That is,
_tc(*OBJECT) creates a two-component record (like a pair),
_tc(GET-HANDLER) extracts one component, and the other component is
called when the record is called.
_begin_ExampleTabular
(GET-HANDLER (*OBJECT _Fit(proc handler)))   _colsep()_equiv()_colsep  _Fit(handler) _LNL
((*OBJECT _Fit(proc) _Fit(handler)) _Fit(arg) _dots)   _colsep()_equiv()_colsep  (_Fit(proc) _Fit(arg) _dots)
_end_ExampleTabular
In addition, _tc(GET-HANDLER) is defined on _Fit(all) objects to return
some handler, even objects not created by _tc(*OBJECT) (if indeed
there are any such objects).

Given these primitives, the following rough equivalence holds:
_begin_ExampleTabbing
(OBJECT _settab()_Fit(proc) _incrtab()_LNL
        ((_Fit(_sub(op,1)) . _Fit(_sub(args,1))) . _Fit(_sub(body,1))) _LNL
        ((_Fit(_sub(op,2)) . _Fit(_sub(args,2))) . _Fit(_sub(body,2))) _LNL
        _dots() _LNL
        ((_Fit(_sub(op,n)) . _Fit(_sub(args,n))) . _Fit(_sub(body,n)))) _LNL
  _equiv() _decrtab()_LNL
(*OBJECT _settab()_Fit(proc) _incrtab()_LNL
         (LAMBDA _settab()(OP) _incrtab()LNL
           (SELECT _settab()OP _incrtab()_LNL
             ((_Fit(_sub(op,1))) (LAMBDA _Fit(_sub(args,1)) . _Fit(_sub(body,1)))) _LNL
             ((_Fit(_sub(op,2))) (LAMBDA _Fit(_sub(args,2)) . _Fit(_sub(body,2)))) _LNL
             _dots _LNL
             ((_Fit(_sub(op,n))) (LAMBDA _Fit(_sub(args,n)) . _Fit(_sub(body,n)))) _LNL
             (ELSE NIL))))
_end_ExampleTabbing
The outer _tc(LAMBDA)-expression yields the object's handler;
the inner _tc(LAMBDA)-expressions yield the methods, and
the mapping from operations to methods is accomplished by
the _tc(SELECT)-expression (see _tc(SELECT), page _Pageref(SELECT)).
Note that the syntactic positions
_Fit(_sub(op,1)),
_Fit(_sub(op,2)),
_dots
_Fit(_sub(op,n))
are evaluated positions, and the operation expressions
are evaluated when an operation is applied to the object,
not when the object is created.
_end_Desc

_Comdef(`OPERATION',`Special form',
`(OPERATION _Fit(default) . _Fit(method-clauses)) _yl() _Fit(operation)')
_begin_Desc

The syntax of _tc(OPERATION) is the same as that of _tc(OBJECT), but its
semantics and application are somewhat different.  An
_tc(OPERATION)-expression evaluates to an operation.  When called, the
operation obtains a handler for its first argument, calls the handler to
obtain a method, and then invokes the method.  The default method for
the operation is established as being _Fit(default).

As the subject of another generic operation, an operation is an object
like any other, and in this case the operation acts just as if it had
been created by an _tc(OBJECT)-expression with the same _Fit(method-clauses).
In this way one can establish the behavior of an operation
when subject to other operations, for example _tc(SETTER).

The following rough equivalence describes the semantics of _tc(OPERATION).
Some details have been omitted.
_begin_ExampleTabbing
(OPERATION _Fit(default) . _Fit(methods)) _LNL
  _equiv() _LNL
(LABELS ((OP (OBJECT (LAMBDA _settab()(OBJ . ARGS) _incrtab()_LNL
                       (LET _settab()((METHOD ((GET-HANDLER OBJ) OP))) _incrtab()_LNL
                         (COND _settab()(METHOD _incrtab()_LNL
                                (APPLY METHOD OBJ ARGS)) _LNL
                               (ELSE _LNL
                                (APPLY _Fit(default) OBJ ARGS))))) _decrtab()_LNL
                     . _Fit(methods)))) _LNL
  OP)
_end_ExampleTabbing
For example:
_begin_ExampleTabular
(DEFINE OP (OPERATION (LAMBDA (OBJ) 'ZEBU))) _LNL
(OP (OBJECT NIL ((OP SELF) 'QUAGGA)))  _colsep()_evalto()_colsep  QUAGGA _LNL
(OP 'ELAND)                            _colsep()_evalto()_colsep  ZEBU
_end_ExampleTabular
An operation is created, and the variable _tc(OP) is bound to it.
The operation's default method always returns the symbol _tc(ZEBU).
When the operation is applied to the value of the _tc(OBJECT)-expression,
the appropriate method is invoked, and the call to the operation yields
the symbol _tc(QUAGGA).  When the operation is applied to an object
which doesn't handle it - the symbol _tc(ELAND) - the operation's
default method is invoked, so the call yields the symbol _tc(ZEBU).
_end_Desc

_Comdef(`OPERATION?',`Type predicate',
`(OPERATION? _Fit(object)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(object) is an operation.
_end_Desc

_Section(Defining operations)

_Comdef(`DEFINE-OPERATION',`Special form',
`(DEFINE-OPERATION (_Fit(variable) . _Fit(argument-vars)) . _Fit(body)) _yl() _Fit(undefined)')
_begin_Desc

Defines _Fit(variable) to be an operation.
The syntax is intended to be analogous to that of _tc(DEFINE).
The operation's default method is defined by _Fit(argument-vars) and _Fit(body).
If there is no _Fit(body), then the operation's default method
is undefined.  In this case, the _Fit(argument-vars)
appear only for documentary purposes.
_begin_Example
(DEFINE-OPERATION (_Fit(var) . _Fit(args)) . _Fit(body)) _LNL
  _equiv()  (DEFINE _Fit(var) (OPERATION (LAMBDA _Fit(args) . _Fit(body)))) _LNL

(DEFINE-OPERATION (_Fit(var) . _Fit(args))) _LNL
  _equiv()  (DEFINE _Fit(var) (OPERATION UNDEFINED-EFFECT))
_end_Example
_end_Desc

_Comdef(`DEFINE-SETTABLE-OPERATION',`Special form',
`(DEFINE-SETTABLE-OPERATION (_Fit(variable) . _Fit(argument-vars)) . _Fit(body)) _yl() _Fit(undefined)')
_label(DEFINE-SETTABLE-OPERATION)
_begin_Desc

Defines _Fit(variable) to be an operation, as with _tc(DEFINE-OPERATION),
but arranges for the operation's _qu(setter) to be another operation,
so that the operation is _qu(settable) (see page _Pageref(Settable)).
_begin_ExampleTabbing
(DEFINE-SETTABLE-OPERATION _settab()(_Fit(var) . _Fit(args)) . _Fit(body)) _LNL
  _gotab()_equiv() _LNL
(DEFINE _settab()_Fit(var) _incrtab()_LNL
  (LET _settab()((THE-SETTER (OPERATION UNDEFINED-EFFECT))) _incrtab()_LNL
    (OPERATION _settab()(LAMBDA _Fit(args) . _Fit(body)) _incrtab()_LNL
      ((SETTER SELF) THE-SETTER))))
_end_ExampleTabbing
_end_Desc

_Comdef(`DEFINE-PREDICATE',`Special form',
`(DEFINE-PREDICATE _Fit(variable)) _yl() _Fit(undefined)')
_begin_Desc

Defines _Fit(variable) to be an operation which, by default,
returns false.
_begin_Example
(DEFINE-PREDICATE _Fit(var)) _LNL
  _equiv() _LNL
(DEFINE-OPERATION (_Fit(var) OBJ) NIL)
_end_Example

The intent is that particular _tc(OBJECT)-expressions contain clauses
of the form _wt(((_Fit(variable) SELF) T)).  This way the operation
defined by _tc(DEFINE-PREDICATE) may act as a type predicate that returns
true only for those objects returned by such _tc(OBJECT)-expressions.
_end_Desc

_DComment( Talk about how to use _tc(OBJECT) to define _qu(types.) )

_Section(Joined objects)

_Comdef(`JOIN',`',
`(JOIN . _Fit(objects)) _yl() _Fit(joined-object)')
_begin_Desc

_tc(JOIN) returns an object, called a _iix(joined object), whose
behavior is a combination of the behaviors of the _Fit(objects).  When an
operation is applied to the joined object, each _Fit(object) in turn is
given an opportunity to handle the operation; the first
to handle it does so.
_begin_ExampleTabbing
(JOIN _settab()(OBJECT _Fit(_sub(proc,1)) _Fit(_sub(method,11) _sub(method,12)) _dots) _LNL
      _gotab()(OBJECT _Fit(_sub(proc,2)) _Fit(_sub(method,21) _sub(method,22)) _dots)) _LNL
  _gotab()_equiv() _LNL
(OBJECT _Fit(_sub(proc,1)) _Fit(_sub(method,11) _sub(method,12)) _dots _Fit(_sub(method,21) _sub(method,22)) _dots)
_end_ExampleTabbing
Using the hypothetical primitives described earlier, _tc(JOIN)
could be defined by the following:
_begin_ExampleTabbing
(JOIN _Fit(first) _Fit(second)) _LNL
  _equiv() _LNL
(*OBJECT _settab()_Fit(first) _incrtab()_LNL
         (LAMBDA _settab()(OP) _incrtab()_LNL
           (OR _settab(0((GET-HANDLER _Fit(first)) OP) _incrtab()_LNL
               ((GET-HANDLER _Fit(second)) OP))))
_end_ExampleTabbing
	_begin_Inset(Bug:)
	 _Tv(3.0): _tc(JOIN) works on proceedures and objects created by
	 _tc(OBJECT), but not on structures or primitive objects.
	_end_Inset
_end_Desc

_DComment(

Talk about how to use _tc(JOIN) to implement type hierarchies and
heterarchies.

How to introduce _qu(punting)?  What syntax to use?  Bletch.

)

_Section(Example)

Hypothetical implementation of _tc(CONS):

_begin_ExampleTabbing
(DEFINE-PREDICATE PAIR?) _LNL
(DEFINE-SETTABLE-OPERATION (CAR PAIR)) _LNL
(DEFINE-SETTABLE-OPERATION (CDR PAIR)) _LNL

(DEFINE _settab()(CONS THE-CAR THE-CDR) _incrtab()_LNL
  (OBJECT _settab()NIL _incrtab()_LNL
          ((PAIR? SELF) T) _LNL
          ((CAR SELF) THE-CAR) _LNL
          ((CDR SELF) THE-CDR) _LNL
          (((SETTER CAR) SELF NEW-CAR) (SET THE-CAR NEW-CAR)) _LNL
          (((SETTER CDR) SELF NEW-CDR) (SET THE-CDR NEW-CDR))))
_end_ExampleTabbing

_DComment( Maybe insert the 6.001 queue example here. )
