_Chapter(Objects)

_T is an _Fit(object-oriented) language.  _T programs
are concerned for the most part with creating and manipulating
_iix(objects), which represent all data, and form the
currency of computation in _T.  Particular objects are defined not
by bit patterns or by addresses within a computer but rather by their
behavior when called or when passed to procedures which manipulate them.

Objects are obtained most primitively through the use of _tc(QUOTE)
(page _Pageref(QUOTE)), _tc(LAMBDA) (page _Pageref(LAMBDA)), and _tc(OBJECT)
(page _Pageref(OBJECT)) special forms, and less primitively by calling
procedures defined in the standard environment, e.g. _tc(CONS) and
_tc(COMPOSE), which create new objects or return existing ones.  (An
implementation of _T would presumably define many such procedures
using more primitive object constructors; for example, _tc(COMPOSE)
might be defined by a _T program which employs _tc(LAMBDA) to
construct the composed procedure.  Thus the question of what kinds of
objects are truly primitive and which are not is left unanswered by this
manual.)

_Section(Literals)

As described in section _Ref(section:coreLanguage), some expressions
evaluate _qu(to themselves) or to copies of themselves.  These include
numbers, strings, and characters, and are called
_Fit(self-evaluating literals.)  However, some expressions, lists and
symbols in particular, do not evaluate to themselves.  When an
expression yielding a particular constant value is required,
it is necessary to use _tc(QUOTE).  Self-evaluating literals
and quoted constants are called _iix(literals).

Although not all objects have external representations, some objects
which do have external representations have undefined evaluation
semantics.  These include vectors (section _Ref(section:vectors)) and the
empty list.  _tc(QUOTE) must also be used to obtain these values as
constants.

_Comdef(`QUOTE',`Special form',
`(QUOTE _Fit(object)) _yl() _Fit(object)')
_label(QUOTE)
_begin_Desc
Yields _Fit(object).  The _Fit(object) is not evaluated; thus _tc(QUOTE)
provides a literal notation for constants.
_begin_ExampleTabular
(QUOTE A)         _colsep  _evalto()  _colsep A _LNL
(QUOTE (A B))      _colsep _evalto()  _colsep (A B) _LNL
(QUOTE (+ X 8))    _colsep _evalto()  _colsep (+ X 8) _LNL
(QUOTE (QUOTE A))  _colsep _evalto()  _colsep (QUOTE A)
_end_ExampleTabular
Since _tc(QUOTE) is used so frequently, an abbreviated external syntax
is provided for _tc(QUOTE) forms: _cQc()_tc(_Fit(object)) is an alternative
external representation for the list _tc((QUOTE _Fit(object))).
_begin_ExampleTabular
_cQc()A          _colsep _evalto()  _colsep A _LNL
_cQc()(A B)      _colsep _evalto()  _colsep (A B) _LNL
_cQc()(QUOTE A)  _colsep _evalto()  _colsep (QUOTE A) _LNL
_cQc()_cQc()A         _colsep _evalto()  _colsep (QUOTE A)
_end_ExampleTabular
Objects returned by literal expressions are read-only; they should not
be altered using _tc(SET) or any other side-effecting form.
_end_Desc

_Section(Procedures)

A _Fit(procedure)_index(procedures) (or _Fit(routine)_index(routines))
is any object which may be called.  Ordinarily, a procedure is called
as a result of the evaluation of a _Fit(call) (page _Pageref(CallSemantics)).
The most primitive mechanism for creating procedures is the
_tc(LAMBDA) special form.
_index(functions)
_DComment( Talk about why procedures are important; first-class citizenship;
surprising roles; etc. ...? )

_Comdef(`LAMBDA',`Special form',
`(LAMBDA _Fit(variables) . _Fit(body)) _yl() _Fit(procedure)')
_label(LAMBDA)
_begin_Desc
A _tc(LAMBDA)-expression evaluates to a procedure.
When the procedure is called, the _Fit(variables)
are bound to the arguments to the call, and the _Fit(body), an implicit
block, is evaluated.  The call yields the value of the last form in the
_Fit(body).
_begin_Example
((LAMBDA (X Y) (LIST Y X)) 7 'FOO)  _evalto()  (FOO 7)
_end_Example

If _Fit(variables) is not a proper list, but ends in a symbol _Fit(x), then
the variable _Fit(x) will be bound to a list of the arguments beginning at
the position corresponding to _Fit(x).

_begin_ExampleTabular
((LAMBDA (X . Y) (LIST Y X)) 7 'FOO 'BAZ)  _colsep _evalto()  _colsep ((FOO BAZ) 7) _LNL
((LAMBDA Y Y) 7 'FOO 'BAZ)                 _colsep _evalto()  _colsep (7 FOO BAZ)
_end_ExampleTabular

If _Fit(body) in the _tc(LAMBDA)-expression is null, a syntax error
will be signalled.

If any _Fit(variable) is _tc(()) instead of a symbol, then the
corresponding argument in a call is ignored.
Also see, _tc(IGNORE), on page _Pageref(IGNORE).

_Fit(Scoping:)_index(scope)_index(lexical scoping)
The values of the bound variables are apparent only in code lexically
contained in the body of the _tc(LAMBDA)-expression, and not to routines
_Fit(called) from the body.  That is, like SCHEME and ALGOL and unlike
most Lisp dialects, _T is a lexically scoped language, not a dynamically
scoped language.

_Fit(Closure:)_index(closure)
_DComment( Rewrite this paragraph. )
The _Fit(procedure) is said to be a _iix(closure) of the
_tc(LAMBDA)-expression in the current lexical environment.  That is, when
_Fit(procedure) is called, the _Fit(body) is evaluated in an environment
which is the same as that in which the _tc(LAMBDA)-expression was
evaluated, augmented by the bindings of the _Fit(variables).  For example,
if _tc(Z) is mentioned in the _Fit(body), and it is not one of the
_Fit(variables), then it refers to whatever _tc(Z) was in scope when the
_tc(LAMBDA)-expression was evaluated, _Fit(not) (necessarily)
to the the variable _tc(Z) that is in scope when _Fit(procedure) is called.
_end_Desc

_tc(LAMBDA)-bindings do not shadow syntax table entries in the
standard compiler.  The _Xc(standard-compiler) and _orbit(), the new
optimizing compiler, now have the same evaluation semantics.
This is consistent with the _T manual.  In _Tv(2),
_Xc(TC), the old compiler, complied with the manual
but the standard compiler did not.  Thus,

_begin_Example
(LET ((SET LIST) (X 5)) (SET X 8)) _evalto 8 _em(not) (5 8)
_end_Example

However, this doesn't mean that the _tc(LAMBDA)-binding has no effect,
but rather that the binding is not recognized as such when the
name appears in the _Xc(CAR) of a form.  Thus,

_begin_Example
(LET ((SET LIST) (X 5)) ((BLOCK SET) X 8)) _evalto (5 8)
_end_Example

_em(This is not a final decision.) This was the easiest semantics
to implement, and it is consistent with the documentation.  In
the future lambda bindings may shadow syntax.

_Section(Object identity)

Every object has _Fit(identity,) in the sense that one may determine
whether two given values are the same object.
_index(equality predicates)
_index(identity)

In the following:
_begin_Example
(DEFINE A (LIST 'P 'Q)) _LNL
(DEFINE B (LIST 'P 'Q))
_end_Example
there is no way (other than _tc(EQ?)) to distinguish the two objects
which are the values of _tc(A) and _tc(B).  Nonetheless, since _tc(LIST)
is defined to return a new object each time it is called, the two
objects are distinct; and indeed, a side-effect to one object will not affect
the value of the other:
_begin_Example
(SET (CAR A) 'R) _LNL
A  _evalto()  (R Q) _LNL
B  _evalto()  (P Q)
_end_Example

Some system procedures and special forms create new objects, others
return objects which already exist.  In some cases, it is not defined
which of the two happens; it is only guaranteed that some object with
appropriate characteristics is returned.  For example, _tc(CONS) creates
new objects; _tc(QUOTE) expressions yield pre-existing constant objects;
and numerical routines such as _tc(+) may or may not create new numbers.

The _tc(EQ?) predicate primitively determines object identity.

_Comdef(`EQ?',`',
`(EQ? _Fit(object1 object2)) _yl() _Fit(boolean)')
_label(EQ?)
_begin_Desc
Returns true if _Fit(object1) and _Fit(object2) are identically the same
object.  _tc(EQ?) is the _Fit(finest) comparison predicate for
objects, in the sense that if _tc(EQ?) cannot distinguish two objects,
then neither can any other equality predicate.
_DComment( what the??? )
_end_Desc

_Comdef(`NEQ?',`',
`(NEQ? _Fit(object1 object2)) _yl() _Fit(boolean)')
_begin_Desc
_tc(NEQ?) is the logical complement of _tc(EQ?).
_begin_Example
(NEQ? _Fit(object1 object2)) _equiv() (NOT (EQ? _Fit(object1 object2)))
_end_Example
_end_Desc

Uniqueness of literals (other than symbols and characters) isn't defined
in general.  For example,
_begin_Example
(EQ? '(A B C) '(A B C))
_end_Example
may yield either true or false, depending on the implementation.
Two similar-looking literal expressions in different places
may or may not yield distinct objects.

However, a given literal expression will always yield the same object
each time it is evaluated. _DComment( forward reference )
_begin_Example
(LET ((F (LAMBDA () '(A B C)))) (EQ? (F) (F)))  _evalto()  _Fsem(true)
_end_Example

_Section(Symbols)
_label(section:symbols)
_Fit(Symbols)_index(symbols) are named objects which have wide applicability as
tokens and identifiers of various sorts.  Symbols are uniquely
determined by their names, and have a convenient external syntax
by which they may be obtained.

Uniqueness of symbols _Fit(is) defined:
_begin_Example
(EQ? 'FOO 'FOO)  _evalto()  _Fsem(true)
_end_Example

_DComment( Give details of external representation.  Should we avoid defining
the quasiquote syntax here? 
It really seems extraneous, and surely it shouldnt be encouraged. )

_Comdef(`SYMBOL?',`Type predicate',
`(SYMBOL? _Fit(object)) _yl() _Fit(boolean)')
_label(SYMBOL?)
_begin_Desc
Returns true if _Fit(object) is a symbol.
_end_Desc

See also _tc(SYMBOL->STRING) and _tc(STRING->SYMBOL),
page _Pageref(string-to-symbol)._R

_Section(Predicates and truth values)

Conditional expressions in _T (see section
_Ref(section:conditionals)) usually involve the evaluation of a
_iix(test) expression; the object yielded by the test is then used to
make a control decision, depending on whether the value is _iix(false)
or _iix(true).  There is one distinguished false value called _false().
Any other value is considered to be true.  A value
intended to be used in this way is called a _iix(boolean) or _iix(truth value).
_index(conditionals)

A _iix(predicate) is any procedure which yields truth values.
Predicates are typically given names which end in _tc(?),
e.g. _tc(NULL?) and _tc(EQ?).  Calls to predicates are
naturally used as test expressions.

An _iix(equality predicate) is a two-argument predicate which is
side-effectless and unaffected by side-effects, and acts like an
equivalence relation in the mathematical sense.

The canonical boolean objects have convenient read syntax associated
with them.

_Comdef2(`sharp-T',`_true()',`Read syntax',
`_true()  _Fsem(reads as)  _Fsem(true)')
_begin_Desc
Read syntax for canonical _Fsem(true) object.
_end_Desc

_Comdef2(`sharp-F',`_false()',`Read syntax',
`_false()  _Fsem(reads as)  _Fsem(false)')
_begin_Desc
Read syntax for canonical _Fsem(false) object.
_begin_ExampleTabular
(true? _cQc()_true) _colsep()_evalto()_colsep _Fsem(true) _LNL
(false? (car _cQc()(_false _true))) _colsep()_evalto()_colsep _Fsem(true) _LNL
_end_ExampleTabular
_end_Desc

_Comdef(`()',`Read syntax',
`()  _Fsem(reads as)  _Fsem(empty-list)')
_begin_Desc
Read syntax for _Fsem(empty-list) object.
_end_Desc

_Comdef(`NIL',`',
`NIL _yl() _false')
_begin_Desc
This system variable has as its value the canonical false object _false().
In _Tv(2) it was instead bound to _Fit(null).
_end_Desc

_Comdef(`T',`',
`T _yl() _true')
_begin_Desc
The system variable _tc(T) has as its value the canonical true value.
Later versions of _T may leave the system variable _tc(T) unbound,
so users should not depend on these semantics.
Any non-false value is considered to be true for the purposes of tests.
_end_Desc

(), _true, and _false are elements of read syntax, not evaluatable symbols.
_begin_ExampleTabular
(car '(_true foo)) _colsep _evalto _colsep _true _LNL
(list _true foo) _colsep _evalto _colsep _Undefined, _rm(and is probably a syntax error.) _LNL
_rm(In _Tv(2):)   () _colsep _evalto _colsep () _LNL
_rm(In _Tv(3.1):) () _colsep _evalto _colsep () _rm(with) _Fsem(warning). _LNL
_rm(In future:) () _colsep _evalto _colsep _Fsem(error) _LNL
_end_ExampleTabular

In _Tv(3), the canonical false value '_false is not necessarily the
same object as the empty list, ().
For compatibility with previous versions, in _Tv(3.1) _Fsem(false)
and the empty list will continue to be the same object, but this
will change in a future release.
_begin_Example
(eq? '_false '()) _yl _Undefined _LNL
_end_Example
In _Tv(3.1) _Xc((eq? _false '()) _evalto _Fsem(true)).

It is an error to use () in an evaluated position.  This error
currently generates a warning and treats () as '(), i.e. as
if the empty list were self evaluating.  An error will be
signalled in the future.  Use '() for empty
lists, and _tc(NULL?) to check for the empty list.
_key(NIL) or '_false can be used for false values, and _tc(NOT)
to check for false values.

_Section(Types)

A _iix(type) may be seen either as a collection of objects
with similar behavior, or as a characteristic function for such a
collection, or as the behavior characteristic of similar objects; these
views are equivalent.

A _iix(type predicate) is a predicate which is defined on all objects and
whose value is not affected by any side-effects (that is, calling the
type predicate on a particular object will return the same value
regardless of the point at which it is called with respect to arbitrary
other computations).  Type predicates are usually used to determine a
given object's membership in a type.
_DComment(is more discussion in order here?)

_Section(Continuations)
_label(section:continuations)
_Comdef(`CALL-WITH-CURRENT-CONTINUATION',`proc',`(CALL-WITH-CURRENT-CONTINUATION _Fsem(proc)) _yl() _Fsem(value-of-proc)')
_begin_Desc
The procedure _wt(CALL-WITH-CURRENT-CONTINUATION) packages
up the current continuation as an _qu(escape procedure) and passes
it as an argument to _Fsem(proc).  _Fsem(proc) must be a procedure of one
argument.  The escape procedure is an n-ary procedure, which
if later invoked with zero or more arguments, will ignore whatever
continuation is in effect at that later time and will instead pass
the arguments to whatever continuation was in effect
at the time the escape procedure was created.

The escape procedure created by
_wt(CALL-WITH-CURRENT-CONTINUATION) has unlimited extent
just like any other procedure.  It may be stored in variables
or data structures and may be called as many times as desired.
For a more thorough explanation consult the _r3rs.
_end_Desc
