_Chapter(Numbers)

_Fit(Numbers)_index(numbers) in _T are objects which represent real numbers.
Numbers come in three varieties: integers, ratios, and floating point
numbers.  Integers and ratios are exact models of the corresponding
mathematical objects.  Floating point numbers give discrete approximations
to real numbers within a certain implementation-dependent range.

_DComment( Talk about external syntax of numbers. )

As expressions, numbers are self-evaluating literals (see section
_Ref(EQ?)).
_begin_ExampleTabular
-377            _colsep()_evalto()_colsep  -377 _LNL
72723460248141  _colsep()_evalto()_colsep  72723460248141 _LNL
13/5            _colsep()_evalto()_colsep  13/5 _LNL
34.55           _colsep()_evalto()_colsep  34.55
_end_ExampleTabular
_DComment(
(define (fib)
  (do ((a 0 b)
       (b 1 (+ a b))
       (n 1 (+ n 1)))
      (nil)
    (format t BQ (fib ~ s) = ~ s ~)_cP() QU n b))

(define tau (/ (+ 1 (sqrt 5.0)) 2))

(define (fib n)
  (/ (+ (expt tau n) (expt tau (- 0 n))) (sqrt 5.0)))
)

There may be many different objects which all represent the same number.
The effect of this is that _tc(EQ?) may behave in nonintuitive ways when
applied to numbers.  It is guaranteed that if two numbers have different
types or different numerical values, then they are _Fit(not)
_tc(EQ?), but two numbers that appear to be the same may or may not be
_tc(EQ?), even though there is no other way to distinguish them.  Use
_tc(EQUAL?) or _tc(=) (page _Pageref(EQUAL?))  for comparing numbers.

_Section(Predicates)

_Comdef(`NUMBER?',`Type predicate',
`(NUMBER? _Fit(object)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(object) is a number.
_end_Desc

_Comdef(`INTEGER?',`Type predicate',
`(INTEGER? _Fit(object)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(object) is an integer.
_end_Desc

_Comdef(`FLOAT?',`Type predicate',
`(FLOAT? _Fit(object)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(object) is a floating point number.
_end_Desc

_Comdef(`RATIONAL?',` ',
`(RATIONAL? obj) _yl() _Fsem(boolean)')
_begin_Desc
_wt(RATIONAL?) returns true if _Fsem(obj) is an integer or
ratio; otherwise, it returns false.
_end_Desc

_Comdef(`RATIO?',`Type predicate',
`(RATIO? _Fit(object)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(object) is a ratio.
_end_Desc 

_Comdef(`ODD?',` ',
`(ODD? _Fit(integer)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(integer) is odd.
_end_Desc 

_Comdef(`EVEN?',` ',
`(EVEN? _Fit(integer)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(integer) is even.
_end_Desc 

_Section(Arithmetic)

_Comdef(`+',` ',
`(+ . _Fit(numbers)) _yl() _Fit(number)')
_Comdef(`ADD',` ',
`(ADD . _Fit(numbers)) _yl() _Fit(number)')
_begin_Desc
Returns the sum of the _Fit(numbers).
_begin_ExampleTabular
(+ 10 27)    _colsep()_evalto()_colsep  37 _LNL
(+ 10 27.8)  _colsep()_evalto()_colsep  37.8 _LNL
(+)          _colsep()_evalto()_colsep  0 _LNL
(+ -35)      _colsep()_evalto()_colsep  -35 _LNL
(+ 1 2 3)    _colsep()_evalto()_colsep  6
_end_ExampleTabular
_end_Desc

_Comdef2(`binary-minus',`_Ftt(-)',` ',
`(_Ftt(-) _Fit(n1 n2)) _yl() _Fit(number)')
_Comdef(`SUBTRACT',` ',
`(SUBTRACT _Fit(n1 n2)) _yl() _Fit(number)')
_begin_Desc
Returns the difference of _Fit(n1) and _Fit(n2).
_end_Desc

_Comdef2(`unary-minus',`_Ftt(-)',` ',
`(_Ftt(-) _Fit(n)) _yl() _Fit(number)')
_Comdef(`NEGATE',` ',
`(NEGATE _Fit(n)) _yl() _Fit(number)')
_begin_Desc
Returns the additive inverse of _Fit(n).
_end_Desc

_Comdef(`*',` ',
`(* . _Fit(numbers)) _yl() _Fit(number)')
_Comdef(`MULTIPLY',` ',
`(MULTIPLY . _Fit(numbers)) _yl() _Fit(number)')
_begin_Desc
Returns the product of the _Fit(numbers).
_end_Desc

_Comdef(`/',` ',
`(/ _Fit(n1 n2)) _yl() _Fit(number)')
_Comdef(`DIVIDE',` ',
`(DIVIDE _Fit(n1 n2)) _yl() _Fit(number)')
_begin_Desc
Returns the quotient of _Fit(n1) and _Fit(n2).
_begin_ExampleTabular
(/ 20 5)    _colsep()_evalto()_colsep  4 _LNL
(/ 5 20)    _colsep()_evalto()_colsep  1/4 _LNL
(/ 5.0 20)  _colsep()_evalto()_colsep  0.25
_end_ExampleTabular
_end_Desc

_Comdef(`QUOTIENT',` ',
`(QUOTIENT _Fit(n1 n2)) _yl() _Fit(integer)')
_begin_Desc
In _Tv(2) called _tix(DIV).
Integer division; truncates the quotient of _Fit(n1) and _Fit(n2)
towards zero.
_end_Desc

_Comdef(`REMAINDER',` ',
`(REMAINDER _Fit(n1 n2)) _yl() _Fit(number)')
_begin_Desc
Returns the remainder of the division of _Fit(n1) by _Fit(n2), with
the sign of _Fit(n1).
_end_Desc 

_Comdef2(`quotient-and-remainder',`_a(QUOTIENT,_cAND(),REMAINDER)',` ',
`(_a(QUOTIENT,_cAND(),REMAINDER) _Fit(n1 n2)) _yl() _Fit(integer1 integer2)')
_begin_Desc
In _Tv(2) called _tix(DIV2).
Returns the quotient and remainder (respectively) as muiltiple
values of dividing _Fit(n1) by _Fit(n2).
_end_Desc

_Comdef(`FLOOR',` ',
`(FLOOR _Fit(n1 n2)) _yl() _Fit(number)')
_begin_Desc
Returns the greatest multiple of _Fit(n2) which is less than or equal to _Fit(n1);
_qu(round down).
A particularly useful case is where _Fit(n2) is 1, in which case
_tc(FLOOR) returns _Fit(n1)'s integer part.
_begin_ExampleTabular
(FLOOR 21 8)    _colsep()_evalto()_colsep  16 _LNL
(FLOOR -21 8)   _colsep()_evalto()_colsep  -24 _LNL
(FLOOR 2.67 1)  _colsep()_evalto()_colsep  2
_end_ExampleTabular
_end_Desc 

_Comdef(`CEILING',` ',
`(CEILING _Fit(n1 n2)) _yl() _Fit(number)')
_begin_Desc
Returns the least multiple of _Fit(n2) which is greater than or equal to _Fit(n1);
_qu(round up).
_begin_ExampleTabular
(CEILING 21 8)    _colsep()_evalto()_colsep  24 _LNL
(CEILING -21 8)   _colsep()_evalto()_colsep  16 _LNL
(CEILING 2.67 1)  _colsep()_evalto()_colsep  3
_end_ExampleTabular
_end_Desc 

_Comdef(`TRUNCATE',` ',
`(TRUNCATE _Fit(n1 n2)) _yl() _Fit(number)')
_begin_Desc
Returns the greatest multiple of _Fit(n2) which is less than or equal to the
absolute value of _Fit(n1), with _Fit(n1)'s sign;
_qu(round towards zero).
_begin_ExampleTabular
(TRUNCATE 21 8)    _colsep()_evalto()_colsep  16 _LNL
(TRUNCATE -21 8)   _colsep()_evalto()_colsep  -24 _LNL
(TRUNCATE 2.67 1)  _colsep()_evalto()_colsep  1
_end_ExampleTabular
_end_Desc 

_Comdef(`ROUND',` ',
`(ROUND _Fit(n1 n2)) _yl() _Fit(number)')
_begin_Desc
Rounds _Fit(n1) toward the nearest multiple of _Fit(n2).
_end_Desc 

_Comdef(`MOD',` ',
`(MOD _Fit(n1 n2)) _yl() _Fit(number)')
_begin_Desc
Returns a number _Fit(k) in the range from zero, inclusive, to _Fit(n2),
exclusive, such that _Fit(k) differs from _Fit(n1) by an integral
multiple of _Fit(n2).  If _Fit(n1) is positive, this behaves like
_tc(REMAINDER).
_end_Desc 

_Comdef(`EXPT',` ',
`(EXPT _Fit(base exponent)) _yl() _Fit(number)')
_begin_Desc
Returns _Fit(base) raised to the _Fit(exponent) power.
_Fit(Base) and _Fit(exponent) may be any numbers.
_begin_Inset(Bug:)
In _T 3.1, _Fit(exponent) must be a finxnum.
_end_Inset
_end_Desc 

_Comdef(`ABS',` ',
`(ABS _Fit(n)) _yl() _Fit(number)')
_begin_Desc
Returns the absolute value of _Fit(n).
_end_Desc 

_Comdef(`GCD',` ',
`(GCD _Fit(integer1 integer2)) _yl() _Fit(integer)')
_begin_Desc
Returns the greatest common divisor of _Fit(integer1) and _Fit(integer2).
_begin_Example
(GCD 36 60)  _evalto()  12
_end_Example
_end_Desc 

_Comdef(`truncate',` ',
`(truncate _Fsem(number)) _yl _Fsem(integer)')
_begin_Desc
_wt(truncate) returns the integer of maximal absolute
value not larger than the absolute value of _Fsem(number) with
the same sign as _Fsem(number).  _wt(truncate) truncates
its argument toward zero.
_end_Desc

_Comdef(`ADD1',` ',
`(ADD1 _Fit(n)) _yl() _Fit(number)')
_Comdef(`1+',` ',
`(1+ _Fit(n)) _yl() _Fit(number)')
_begin_Desc
Returns _Fit(n) + 1.
(See also _tc(INCREMENT), page _Pageref(INCREMENT).)
_end_Desc

_Comdef(`-1+',` ',
`(SUBTRACT1 _Fit(n)) _yl() _Fit(number)',
`(-1+ _Fit(n)) _yl() _Fit(number)')
_begin_Desc
Returns _Fit(n) - 1.
(See also _tc(DECREMENT), page _Pageref(DECREMENT).)
_end_Desc

_Comdef(`MIN',` ',
`(MIN . _Fit(numbers)) _yl() _Fit(number)')
_begin_Desc
Returns the _Fit(number) with the least numerical magnitude.
(There must be at least one _Fit(number).)
_end_Desc 

_Comdef(`MAX',` ',
`(MAX . _Fit(numbers)) _yl() _Fit(number)')
_begin_Desc
Returns the _Fit(number) with the greatest numerical magnitude.
(There must be at least one _Fit(number).)
_end_Desc 

_Section(Comparison)

_Comdef(`=',` ',
`(= _Fit(n1 n2)) _yl() _Fit(boolean)')
_Comdef(`EQUAL?',` ',
`(EQUAL? _Fit(n1 n2)) _yl() _Fit(boolean)')
_label(EQUAL?)
_begin_Desc
Returns true if _Fit(n1) is numerically equal to _Fit(n2).
_end_Desc

_Comdef2(`less-than',`_cLT',` ',
`(_cLT _Fit(n1 n2)) _yl() _Fit(boolean)')
_Comdef(`LESS?',` ',
`(LESS? _Fit(n1 n2)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(n1) is numerically less than _Fit(n2).
_end_Desc

_Comdef2(`greater-than',`_cGT',` ',
`(_cGT() _Fit(n1 n2)) _yl() _Fit(boolean)')
_Comdef(`GREATER?',` ',
`(GREATER? _Fit(n1 n2)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(n1) is numerically greater than _Fit(n2).
_end_Desc

_Comdef(`N=',` ',
`(N= _Fit(n1 n2)) _yl() _Fit(boolean)')
_Comdef(`NOT-EQUAL?',` ',
`(NOT-EQUAL? _Fit(n1 n2)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(n1) is not numerically equal to _Fit(n2).
_end_Desc

_Comdef2(`greater-than-or-equal-to',`_a(_cGT(),=)',` ',
`(_a(_cGT,=) _Fit(n1 n2)) _yl() _Fit(boolean)')
_Comdef(`NOT-LESS?',` ',
`(NOT-LESS? _Fit(n1 n2)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(n1) is not numerically less than _Fit(n2).
_end_Desc

_Comdef2(`less-than-or-<equal-to',`_a(_cLT(),=)',` ',
`(_a(_cLT(),=) _Fit(n1 n2)) _yl() _Fit(boolean)',
`(NOT-GREATER? _Fit(n1 n2)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(n1) is not numerically greater than _Fit(n2).
_end_Desc

_Section(Sign predicates)

_Comdef(`=0?',` ',
`(=0? _Fit(n)) _yl() _Fit(boolean)')
_Comdef(`ZERO?',` ',
`(ZERO? _Fit(n)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(n) is numerically equal to zero.
_end_Desc

_Comdef2(`less-than-zero',`_a(_cLT,0?)',` ',
`(_a(_cLT,0?) _Fit(n)) _yl() _Fit(boolean)')
_Comdef(`NEGATIVE?',` ',
`(NEGATIVE? _Fit(n)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(n) is negative.
_end_Desc

_Comdef2(`greater-than-zero',`_a(_cGT,0?)',` ',
`(_a(_cGT,0?) _Fit(n)) _yl() _Fit(boolean)')
_Comdef(`POSITIVE?',` ',
`(POSITIVE? _Fit(n)) _yl() _Fit(boolean)')
_begin_Desc 
Returns true if _Fit(n) is positive.
_end_Desc

_Comdef(`N=0?',` ',
`(N=0? _Fit(n)) _yl() _Fit(boolean)')
_Comdef(`NOT-ZERO?',` ',
`(NOT-ZERO? _Fit(n)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(n) is not numerically equal to zero.
_end_Desc

_Comdef2(`greater-than-or-equal-to-zero',`_a(_cGT,=0?)',` ',
`(_a(_cGT,=0?) _Fit(n)) _yl() _Fit(boolean)')
_Comdef(`NOT-NEGATIVE?',` ',
`(NOT-NEGATIVE? _Fit(n)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(n) is non-negative.
_end_Desc

_Comdef2(`less-than-or-equal-to-zero',`_a(_cLT,=0?)',` ',
`(_a(_cLT,=0?) _Fit(n)) _yl() _Fit(boolean)')
_Comdef(`NOT-POSITIVE?',` ',
`(NOT-POSITIVE? _Fit(n)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(n) is non-positive.
_end_Desc

_Section(Transcendental functions)

_Comdef(`EXP',` ',
`(EXP _Fit(float)) _yl() _Fit(float)')
_begin_Desc
Exponential function (_sup(e,_Fit(x))).
_end_Desc 

_Comdef(`LOG',` ',
`(LOG _Fit(float)) _yl() _Fit(float)')
_begin_Desc
Natural logarithm (_sub(log,e)_Fit(x)).
_end_Desc 

_Comdef(`SQRT',` ',
`(SQRT _Fit(float)) _yl() _Fit(float)')
_begin_Desc
Returns the square root of its argument.
_end_Desc 

_Comdef(`COS',` ',
`(COS _Fit(float)) _yl() _Fit(float)')
_begin_Desc
Returns the cosine of its argument.
_end_Desc 

_Comdef(`SIN',` ',
`(SIN _Fit(float)) _yl() _Fit(float)')
_begin_Desc
Returns the sine of its argument.
_end_Desc 

_Comdef(`TAN',` ',
`(TAN _Fit(float)) _yl() _Fit(float)')
_begin_Desc
Returns the tangent of its argument.
_end_Desc 

_Comdef(`ACOS',` ',
`(ACOS _Fit(float1)) _yl() _Fit(float2)')
_begin_Desc
Arccosine.  Returns a number whose cosine is _Fit(float1).
_end_Desc 

_Comdef(`ASIN',` ',
`(ASIN _Fit(float1)) _yl() _Fit(float2)')
_begin_Desc
Arcsine.  Returns a number whose sine is _Fit(float1).
_end_Desc 

_Comdef(`ATAN2',` ',
`(ATAN2 _Fit(x y)) _yl() _Fit(float)')
_begin_Desc
Two-argument arctangent.  This computes the
angle between the positive x-axis and the point
(_Fit(x), _Fit(y)).  For example, if (_Fit(x), _Fit(y)) is in the first or third
quadrant, _tc((ATAN2 _Fit(x y))) returns the arctangent of _Fit(y)/_Fit(x).

_begin_Inset(Bug:)
_tc(ATAN2) isn't implemented in _T 3.1.  _T 3.1 does
implement _tc(ATAN) (arctangent), however.
_end_Inset

_end_Desc 

_Section(Bitwise logical operators)

_begin_Inset(Bug:)
In _T 3.1, the routines in this section are restricted to take
fixnums (see page _Pageref(FIXNUM?)), not arbitrary integers.
_end_Inset

_Comdef(`LOGAND',` ',
`(LOGAND _Fit(integer1 integer2)) _yl() _Fit(integer)')
_begin_Desc
Returns the bitwise logical _Fit(and) of its arguments.
_begin_Example
(LOGAND 10 12)  _evalto()  8
_end_Example
_end_Desc 

_Comdef(`LOGIOR',` ',
`(LOGIOR _Fit(integer1 integer2)) _yl() _Fit(integer)')
_begin_Desc
Returns the bitwise logical inclusive _Fit(or) of its arguments.
_end_Desc 

_Comdef(`LOGXOR',` ',
`(LOGXOR _Fit(integer1 integer2)) _yl() _Fit(integer)')
_begin_Desc
Returns the bitwise logical exclusive _Fit(or) of its arguments.
_end_Desc 

_Comdef(`LOGNOT',` ',
`(LOGNOT _Fit(integer)) _yl() _Fit(integer)')
_begin_Desc
Returns the bitwise logical _Fit(not) of its argument.
_end_Desc 

_Comdef(`ASH',` ',
`(ASH _Fit(integer amount)) _yl() _Fit(integer)')
_begin_Desc
Shifts _Fit(integer) to the left _Fit(amount) bit positions.
If _Fit(amount) is negative, shifts _Fit(integer) right by the absolute
value of _Fit(amount) bit positions.
_end_Desc 

_Comdef(`BIT-FIELD',` ',
`(BIT-FIELD _Fit(integer position size)) _yl() _Fit(integer)')
_begin_Desc
Extracts a bit field out of _Fit(integer).  The field extracted begins
at bit position _Fit(position) from the low-order bit of the integer
and consists of _Fit(size) bits.  The extracted field is returned
as a positive integer.
_begin_ExampleTabular
(BIT-FIELD 27 1 3)  _colsep()_evalto()_colsep  5 _LNL
(BIT-FIELD -1 4 5)  _colsep()_evalto()_colsep  31
_end_ExampleTabular
_end_Desc 

_Comdef(`SET-BIT-FIELD',` ',
`(SET-BIT-FIELD _Fit(integer position size value)) _yl() _Fit(integer)')
_begin_Desc
Inserts a value into a bit field of _Fit(integer).  The field begins
at bit position _Fit(position) from the low-order bit of the integer
and consists of _Fit(size) bits.  A new integer is returned which is
the same as the argument _Fit(integer) except that this field has been
altered to be _Fit(value).
_begin_Example
(SET-BIT-FIELD 32 1 3 5)  _evalto()  42
_end_Example
_end_Desc 

_Section(Coercion)

_Comdef2(`to-integer',`_a(-,_cGT,INTEGER)',` ',
`(_a(-,_cGT,INTEGER) _Fit(number)) _yl() _Fit(integer)')
_begin_Desc
Coerces _Fit(number) to an integer, truncating towards zero if necessary.
_begin_ExampleTabular
(_a(-,_cGT,INTEGER) 17)     _colsep()_evalto()_colsep  17 _LNL
(_a(-,_cGT,INTEGER) 7/4)    _colsep()_evalto()_colsep  1 _LNL
(_a(-,_cGT,INTEGER) 17.6)   _colsep()_evalto()_colsep  17 _LNL
(_a(-,_cGT,INTEGER) -17.6)  _colsep()_evalto()_colsep  -17
_end_ExampleTabular
_end_Desc 

_Comdef2(`to-float',`_a(-,_cGT,FLOAT)',` ',
`(_a(-,_cGT,FLOAT) _Fit(number)) _yl() _Fit(float)')
_begin_Desc
Coerces _Fit(number) to a floating point number.
_begin_ExampleTabular
(_a(-,_cGT,FLOAT) 17)    _colsep()_evalto()_colsep  17.0 _LNL
(_a(-,_cGT,FLOAT) 7/4)   _colsep()_evalto()_colsep  1.75 _LNL
(_a(-,_cGT,FLOAT) 17.6)  _colsep()_evalto()_colsep  17.6
_end_ExampleTabular
_end_Desc 

_Section(Assignment)

_tc(INCREMENT) and _tc(DECREMENT) are assignment forms, like _tc(SET)
and _tc(PUSH).  See section _Ref(section:assignment) for a general
discussion.

_Comdef(`INCREMENT',` ',
`(INCREMENT _Fit(location)) _yl() _Fit(number)')
_label(INCREMENT)
_begin_Desc
Adds one to the value in _Fit(location), stores the sum back
into _Fit(location), and yields the sum.
_begin_ExampleTabular
(LSET L 6) _LNL
(INCREMENT L)             _colsep()_evalto()_colsep  7 _LNL
L                         _colsep()_evalto()_colsep  7 _LNL
(LSET M (LIST 10 20 30))  _colsep()_evalto()_colsep  (10 20 30) _LNL
(INCREMENT (CAR M))       _colsep()_evalto()_colsep  11 _LNL
M                         _colsep()_evalto()_colsep  (11 20 30) _LNL

(INCREMENT _Fit(location))  _colsep()_equiv()_colsep  (MODIFY _Fit(location) ADD1)
_end_ExampleTabular
_end_Desc 

_Comdef(`DECREMENT',` ',
`(DECREMENT _Fit(location)) _yl() _Fit(number)')
_label(DECREMENT)
_begin_Desc
Subtracts one from the value in _Fit(location), stores the
difference back into _Fit(location), and yields the difference.
_begin_Example
(DECREMENT _Fit(location))  _equiv()  (MODIFY _Fit(location) SUBTRACT1)
_end_Example
_end_Desc 
