_Appendix(Libraries)
_label(appendix:libraries)

This appendix describes various software packages which are not
officially part of the _T language but which are of general utility.
Some are available within the implementations
directly, while others must be loaded from external files
using _tc(LOAD).

_DComment( Etc.
Talk about the various temporary hacks to get around various implementation
inadequacies.
)

_DComment( What things should be here described?  Refer somewhere to the Yale
looping constructs?  What about DEFINE-APOLLO etc.?
What about the apollo system utilities?
What about _tc(MSG) and the TLISP utilities?
)

_Section(Tables)
_label(tables)

_Tv(3.1) contains generalized hash tables.  A table associates
a _Fsem(key) with a _Fsem(value).  _wt(MAKE-HASH-TABLE)
is the most general way to make a hash table.  In addition, 
the most common types of tables have been predefined.
_begin_Inset(Caution:)
This feature is experimental and may go away or change in future
releases.
_end_Inset

Tables should be used in place of property lists.

_Comdef(`MAKE-HASH-TABLE',` ',
`(MAKE-HASH-TABLE _Fsem(type? hash comparator gc? id)) _yl() _Fsem(table)')
_begin_Desc
_wt(MAKE-HASH-TABLE) creates a table which associates keys to values.
Any object may be a key or a value.

_begin_Table

_Item(_Fsem(type?)) --- is a predicate.  All keys in the table must
answer true to the predicate _Fsem(type?).

_Item(_Fsem(hash)) --- is a procedure from keys to fixnums which
is used to hash the table entries.

_Item(_Fsem(comparator)) --- is an equality predicate on keys.

_Item(_Fsem(gc?)) --- is a boolean value which specifies whether the
hash procedure is dependent on the memory location(s) occupied
by the object, i.e.  whether or not the table must be rehashed
after a garbage collection.

_Item(_Fsem(id)) --- is an identifier used by the print method of the table.
_end_Table
_end_Desc

_Comdef(`HASH-TABLE?',` ',
`(HASH-TABLE? _Fsem(object)) _yl() _Fsem(boolean)')
_begin_Desc
_wt(HASH-TABLE?) returns true if the _Fsem(object) is a hash table.
_end_Desc

_Comdef(`TABLE-ENTRY',`Settable',
`(TABLE-ENTRY _Fsem(table key)) _yl() _Fsem(object)')
_begin_Desc
_wt(TABLE-ENTRY) returns the _Fsem(object) associated with the
_Fsem(key) in the _Fsem(table) if there is an entry for _Fsem(key),
otherwise returns _Fsem(false).
_end_Desc

_Comdef(`WALK-TABLE',` ',
`(WALK-TABLE _Fsem(proc table)) _yl() _Undefined')
_begin_Desc
_wt(WALK-TABLE) invokes _Fsem(proc), a procedure of two arguments,
on each _Fsem(key, value) association in the _Fsem(table).
Note that it is an error to perform any operations on the table 
while walking it.
_end_Desc

The following common table types have been predefined as follows:

_Comdef(`MAKE-TABLE',` ',
`(MAKE-TABLE _Fsem(. id)) _yl() _Fsem(table)')
_begin_Desc
_wt(MAKE-TABLE) creates a _Fsem(table) in which any object
can be a _Fsem(key) and _wt(EQV?) is used as the equality
predicate on _Fsem(keys).
_end_Desc

_Comdef(`TABLE?',` ',
`(TABLE? _Fsem( object)) _yl() _Fsem(boolean)')
_begin_Desc
_wt(TABLE?) returns true if the _Fsem(object) is an _wt(EQ?) table.
_end_Desc

_Comdef(`MAKE-STRING-TABLE',` ',
`(MAKE-STRING-TABLE _Fsem( .  id)) _yl() _Fsem(table)')
_begin_Desc
_wt(MAKE-STRING-TABLE) creates a _Fsem(table) in which
the _Fsem(keys) must be _Fsem(strings) and
_wt(STRING-EQUAL?) is used as the equality predicate on
_Fsem(keys).
_end_Desc

_Comdef(`STRING-TABLE?',` ',
`(STRING-TABLE? _Fsem( object)) _yl() _Fsem(boolean)')
_begin_Desc
_wt(STRING-TABLE?) returns true if the _Fsem(object) is a
_Fsem(string-table).
_end_Desc

_Comdef(`MAKE-SYMBOL-TABLE',` ',
`(MAKE-SYMBOL-TABLE _Fsem( . id)) _yl() _Fsem(symbol-table)')
_begin_Desc
_wt(MAKE-SYMBOL-TABLE) creates a table in which the keys
must be _Fsem(symbols) and _wt(EQ?) is used as the equality
predicate on keys.
_end_Desc

_Comdef(`SYMBOL-TABLE?',` ',
`(SYMBOL-TABLE? _Fsem( object)) _yl() _Fsem(boolean)')
_begin_Desc
_wt(SYMBOL-TABLE?) returns true if the _Fsem(object) is a
_Fsem(symbol-table).
_end_Desc

_Section(Random Integers)

_Comdef(`MAKE-RANDOM',` ',
`(MAKE-RANDOM _Fsem(seed)) _yl() _Fsem(thunk)')
_begin_Desc
_wt(MAKE-RANDOM) takes a _Fsem(seed) which is a fixnum
and returns a _Fsem(thunk).  The thunk returns a new
pseudo-random _Fsem(integer), _Fit(x), in the range 
_begin_Example
_wt(MOST-NEGATIVE-FIXNUM) _cLE _Fit(x) _cLE _wt(MOST-POSITIVE-FIXNUM)
_end_Example
each time it is invoked.
_end_Desc

_Section(List utilities)

_DComment( Move all that random stuff here from the list chapter. )

_Comdef(`MEM',` ',
`(MEM _Fit(predicate object list)) _yl() _Fit(list)')
_begin_Desc
Returns the first _Fit(tail) of _Fit(list) such that
_tc((_Fit(predicate object) (CAR _Fit(tail)))).
_begin_Example
(MEM EQ? 'A '(B A D E))  _evalto()  (A D E)
_end_Example
_end_Desc 

_Comdef(`MEMQ',` ',
`(MEMQ _Fit(object list)) _yl() _Fit(list)')
_begin_Desc
_begin_Example
(MEMQ _Fit(object list))  _equiv()  (MEM EQ? _Fit(object list))
_end_Example
_end_Desc 

_DComment( MEMV, MEMV?, ... )

_Comdef(`ANY',` ',
`(ANY _Fit(predicate . lists)) _yl() _Fit(object)')
_begin_Desc
Calls the _Fit(predicate) on successive elements of the _Fit(lists),
stopping as soon as the _Fit(predicate) returns a value other than false.
This value is returned as _tc(ANY)'s value.
_begin_ExampleTabular
(ANY NUMBER? '(A B 3 FOO))  _colsep()_evalto()_colsep  _Fsem(true) _LNL
(ANY NUMBER? '(A B C FOO))  _colsep()_evalto()_colsep  _Fsem(false) _LNL
(ANY _Ftt(_cLT) '(1 2 3) '(6 6 6))   _colsep()_evalto()_colsep  _Fsem(true) _LNL
(ANY MEMQ '(A B C) '((X B) (U B Z) (C D E F)))  _colsep()_evalto()_colsep  (B Z)
_end_ExampleTabular
_DComment(that last is a horrible example!...)
_end_Desc 

_Comdef(`ANYCDR',` ',
`(ANYCDR _Fit(predicate . lists)) _yl() _Fit(object)')
_begin_Desc
Like _tc(ANY), but the _Fit(predicate) is called on successive
tails of the _Fit(lists) instead of successive elements.
_end_Desc 

_Comdef(`EVERY',` ',
`(EVERY _Fit(predicate . lists)) _yl() _Fit(object)')
_begin_Desc
Calls the _Fit(predicate) on successive elements of the _Fit(lists),
stopping as soon as the _Fit(predicate) returns false.
If for every element _Fit(predicate) returns true, _tc(EVERY)
returns the value of the last call.
_begin_Example
(EVERY NUMBER? '(1 2 3 -15.7))  _evalto()  _Fsem(true) _LNL
(EVERY NUMBER? '(1 2 3 FOO))	_evalto()  _Fsem(false) _LNL
(EVERY ASSQ '(A B C) _LNL
     '(((A X) (X Y)) ((A J) (B K)) ((C D) (T U)))) _LNL
  _evalto()  (C D)
_end_Example
_end_Desc 

_Comdef(`EVERYCDR',` ',
`(EVERYCDR _Fit(predicate . lists)) _yl() _Fit(object)')
_begin_Desc
Like _tc(EVERY), but the _Fit(predicate) is called on successive
tails of the _Fit(lists) instead of successive elements.
_end_Desc 

_Comdef(`EVERYCDR?',` ',
`(EVERYCDR? _Fit(predicate . lists)) _yl() _Fit(boolean)')
_begin_Desc
_begin_Example
(EVERYCDR? _Fit(predicate . lists))  _equiv()  (TRUE? (EVERYCDR _Fit(predicate . lists)))
_end_Example
_end_Desc 

_Comdef(`ANYCDR?',` ',
`(ANYCDR? _Fit(predicate . lists)) _yl() _Fit(boolean)')
_begin_Desc
_begin_Example
(ANYCDR? _Fit(predicate . lists))  _equiv()  (TRUE? (ANYCDR _Fit(predicate . lists)))
_end_Example
_end_Desc 

_Comdef(`POS',` ',
`(POS _Fit(predicate object list)) _yl() _Fit(integer) _rm(or) _Fit(false)')
_begin_Desc
Returns the position of the first item in _Fit(list) such that
_tc((_Fit(predicate object item))), or false if there is no such
item.
_end_Desc 

_Comdef(`POSQ',` ',
`(POSQ _Fit(object list)) _yl() _Fit(integer) _rm(or) _Fit(false)')
_begin_Desc
_DComment( Randomness. )
_begin_Example
(POSQ _Fit(object list))  _equiv()  (POS EQ? _Fit(object list))
_end_Example
_end_Desc 

_Comdef(`APPEND-REVERSE',` ',
`(APPEND-REVERSE _Fit(list ending)) _yl() _Fit(list)')
_begin_Desc
_begin_ExampleTabbing
(APPEND-REVERSE _settab()_Fit(list ending))  _equiv() _LNL
  _gotab()(APPEND (REVERSE _Fit(list)) _Fit(ending)) _LNL

(APPEND-REVERSE '(A B C) '(D E))  _evalto()  (C B A D E)
_end_ExampleTabbing
_end_Desc 

_Comdef(`APPEND-REVERSE!',` ',
`(APPEND-REVERSE! _Fit(list ending)) _yl() _Fit(list)')
_begin_Desc
_begin_Example
(APPEND-REVERSE! _Fit(list ending))  _equiv() _LNL
(APPEND! (REVERSE! _Fit(list)) _Fit(ending))
_end_Example
_end_Desc 

_Section(Type-specific arithmetic)
_DComment(dorab: is this -2^29 to +2^29)

A _iix(fixnum) is an integer whose magnitude lies within an
implementation-dependent range.  This range is guaranteed to include all
integers which are acceptable as array, string, or vector indices.
_T guarantees that fixnums will have at least 24 bits.
In _Tv(3.1), this range is the half-open interval
_begin_Example
[_sup(2,-29),_sup(2,29)_cPc. _LNL
_end_Example

_Comdef(`FIXNUM?',`Type predicate',
`(FIXNUM? _Fit(object)) _yl() _Fit(boolean)')
_label(FIXNUM?)
_begin_Desc
Returns true if _Fit(object) is a fixnum.
_end_Desc 

_Comdef(`MOST-POSITIVE-FIXNUM',` ',
`MOST-POSITIVE-FIXNUM _yl() _Fit(integer)')
_begin_Desc
In _Tv(2) called _tix(*MAX-FIXNUM*).
Returns the largest integer value within the fixnum range.  No integer
answering true to _tc(FIXNUM?) is greater than _tc(MOST-POSITIVE-FIXNUM).
_end_Desc

_Comdef(`MOST-NEGATIVE-FIXNUM',` ',
`MOST-NEGATIVE-FIXNUM _yl() _Fit(integer)')
_begin_Desc
In _Tv(2) called _tix(*MIN-FIXNUM*).
Returns the smallest integer value within the fixnum range.  No integer
answering true to _tc(FIXNUM?) is less than _tc(MOST-NEGATIVE-FIXNUM).
_begin_ExampleTabbing
(FIXNUM? _settab()_Fit(x)) _LNL
_gotab()_equiv()_LNL
(AND _settab()(INTEGER? X) _incrtab()_LNL
     (_a(_cGT,=) _Fit(x) MOST-NEGATIVE-FIXNUM) _LNL
     (_a(_cLT,=) _Fit(x) MOST-POSITIVE-FIXNUM))
_end_ExampleTabbing
_end_Desc

The following procedures are defined for performing type-restricted
arithmetic.  These procedures should be considered specializations of
their corresponding generic arithmetic procedures.  They assume
restrictions on the types of their arguments and results.  The prefix
_tc(FX) means _qu(fixnum-specific,) and _tc(FL) means
_qu(flonum-specific.)  For example,
_begin_Example
(FX+ _Fit(x) _Fit(y))   _LNL
_equiv()  (ENFORCE FIXNUM? (+ (ENFORCE FIXNUM? _Fit(x)) (ENFORCE FIXNUM? _Fit(y))))
_end_Example
_T will implement calls to these type-specific procedures in a more
efficient manner than calls to the corresponding generic procedures.

The following list catalogs the available routines.  In most case the
effect of the procedure should be analogous to the example above.  The
one exception is _tc(FX/), which is a specialization of the truncated
(integer) division routine _tc(QUOTIENT), not of the division routine _tc(/).
_begin_ExampleTabular
(FX+ _Fit(fixnum1 fixnum2)) _colsep()_yl()_colsep _Fit(fixnum)_tindex(FX+) _LNL
(FL+ _Fit(fixnum1 fixnum2)) _colsep()_yl()_colsep _Fit(flonum)_tindex(FL+) _LNL
(FX- _Fit(fixnum1 fixnum2)) _colsep()_yl()_colsep _Fit(fixnum)_tindex(FX-) _LNL
(FL- _Fit(flonum1 flonum2)) _colsep()_yl()_colsep _Fit(flonum)_tindex(FL-) _LNL
(FX* _Fit(fixnum1 fixnum2)) _colsep()_yl()_colsep _Fit(fixnum)_tindex(FX*) _LNL
(FL* _Fit(fixnum1 fixnum2)) _colsep()_yl()_colsep _Fit(flonum)_tindex(FL*) _LNL
(FX/ _Fit(fixnum1 fixnum2)) _colsep()_yl()_colsep _Fit(fixnum)_tindex(FX/) _LNL
(FL/ _Fit(flonum1 flonum2)) _colsep()_yl()_colsep _Fit(flonum)_tindex(FL/) _LNL
(FX= _Fit(fixnum1 fixnum2)) _colsep()_yl()_colsep _Fit(boolean)_tindex(FX=) _LNL
(FL= _Fit(flonum1 flonum2)) _colsep()_yl()_colsep _Fit(boolean)_tindex(FL=) _LNL
(_a(FX,_cLT) _Fit(fixnum1 fixnum2)) _colsep()_yl()_colsep _Fit(boolean)_tindex(_a(FX,_cLT)) _LNL
(_a(FL,_cLT) _Fit(flonum1 flonum2)) _colsep()_yl()_colsep _Fit(boolean)_tindex(_a(FL,_cLT)) _LNL
(_a(FX,_cGT) _Fit(fixnum1 fixnum2)) _colsep()_yl()_colsep _Fit(boolean)_tindex(FX>) _LNL
(_a(FL,_cGT) _Fit(flonum1 flonum2)) _colsep()_yl()_colsep _Fit(boolean)_tindex(FL>) _LNL
(FXN= _Fit(fixnum1 fixnum2)) _colsep()_yl()_colsep _Fit(boolean)_tindex(FXN=) _LNL
(FLN= _Fit(flonum1 flonum2)) _colsep()_yl()_colsep _Fit(boolean)_tindex(FLN=) _LNL
(_a(FX,_cGT,=) _Fit(fixnum1 fixnum2)) _colsep()_yl()_colsep _Fit(boolean)_tindex(FX>=) _LNL
(_a(FL,_cGT,=) _Fit(flonum1 flonum2)) _colsep()_yl()_colsep _Fit(boolean)_tindex(FL>=) _LNL
(_a(FX,_cLT,=) _Fit(fixnum1 fixnum2)) _colsep()_yl()_colsep _Fit(boolean)_tindex(_a(FX,_cLT,=)) _LNL
(_a(FL,_cLT,=) _Fit(flonum1 flonum2)) _colsep()_yl()_colsep _Fit(boolean)_tindex(_a(FL,_cLT,=)) _LNL
(FIXNUM-REMAINDER _Fit(fixnum1 fixnum2)) _colsep()_yl()_colsep _Fit(fixnum)_tindex(FIXNUM-REMAINDER) _LNL
(FX-REM _Fit(fixnum1 fixnum2)) _colsep()_yl()_colsep _Fit(fixnum)_tindex(FX-REM) _Tv(3): _equiv() FIXNUM-REMAINDER _LNL
(FXREM _Fit(fixnum1 fixnum2)) _colsep()_yl()_colsep _Fit(fixnum)_tindex(FXREM) _Tv(2): _equiv() FIXNUM-REMAINDER _LNL
(FIXNUM-ODD? _Fit(fixnum)) _colsep()_yl()_colsep _Fit(boolean)_tindex(FIXNUM-ODD?) _LNL
(FIXNUM-EVEN? _Fit(fixnum)) _colsep()_yl()_colsep _Fit(boolean)_tindex(FIXNUM-EVEN?) _LNL
(FIXNUM-ABS _Fit(fixnum)) _colsep()_yl()_colsep _Fit(fixnum)_tindex(FIXNUM-ABS) _LNL
(FIXNUM-MIN _Fit(fixnum1 fixnum2)) _colsep()_yl()_colsep _Fit(fixnum)_tindex(FIXNUM-MIN) _LNL
(FIXNUM-MAX _Fit(fixnum1 fixnum2)) _colsep()_yl()_colsep _Fit(fixnum)_tindex(FIXNUM-MAX) _LNL
(FIXNUM-LOGAND _Fit(fixnum1 fixnum2)) _colsep()_yl()_colsep _Fit(fixnum)_tindex(FIXNUM-LOGAND) _LNL
(FIXNUM-LOGIOR _Fit(fixnum1 fixnum2)) _colsep()_yl()_colsep _Fit(fixnum)_tindex(FIXNUM-LOGIOR) _LNL
(FIXNUM-LOGNOT _Fit(fixnum)) _colsep()_yl()_colsep _Fit(fixnum)_tindex(FIXNUM-LOGNOT) _LNL
(FIXNUM-ASHR _Fit(fixnum)) _colsep()_yl()_colsep _Fit(fixnum)_tindex(FIXNUM-ASHR) _LNL
(FIXNUM-ASHL _Fit(fixnum)) _colsep()_yl()_colsep _Fit(fixnum)_tindex(FIXNUM-ASHL) _LNL
(_a(FIXNUM-,_cGT,FLONUM) _Fit(fixnum)) _colsep()_yl()_colsep _Fit(flonum)_tindex(FIXNUM->FLONUM) _LNL
(_a(FLONUM-,_cGT,FIXNUM) _Fit(flonum)) _colsep()_yl()_colsep _Fit(fixnum)_tindex(FLONUM->FIXNUM)
_end_ExampleTabular
