_Chapter(Introduction,Notation,,Top)

_T is a dialect of Lisp derived from Scheme
_cite(rrs).
It is comparable in power and expressivness to other recent Lisp
dialects such as Lisp Machine Lisp
_cite(Weinreb81), Common Lisp _cite(CLtL), and NIL _cite(White79),
but fundamentally more similar in spirit to Scheme than these other
Lisp dialects.

_T() is an attempt to create a powerful and expressive language which
is portable, efficient, and suitable for a broad variety of applications,
including symbolic, numerical, and systems programming.

_T() draws from many sources in its attempt to provide a complete
yet simple and unified system.
For the most part, the language's designers are collators, not
originators.
Common Lisp, NIL, and Scheme have been the strongest influences.

_Section(Notation,Notation - Margin Notes,Introduction,Introduction)
Throughout this document the following conventions are used:
_begin_Table
_Item(_cBo _dots _cBc)
Curly braces group together whatever they enclose._R

_Item([ _dots ])
Square brackets indicate that what they enclose is optional.
See also _Fit(Dot-notation) below._R

_Item(_star)
Braces or brackets followed by a star,
_Xw(e.g. _a(_cBo _dots _cBc,_star)),
indicate zero or more occurences of the enclosed item.
See also _Fit(Dot-notation) below._R

_Item(_plus)
Braces or brackets followed by a plus sign, e.g.
_a([ _dots ],_plus), indicate one or more occurences of the enclosed
item._R

_Item(_or)
A vertical bar is used to separate alternatives in a
braced or bracketed group, e.g. _cBo thing1 _or _dots _or thingN _cBc._R

_Item(_evalto)
is used to indicate _Fit(evaluation).
(Evaluation is described in section _Ref(section:coreLanguage).)
It is read as _qu(evaluates to).
For example, _Xc((+ 3 5) _evalto 8) means that evaluating the
expression _Xc((+ 3 5)) yields _Xc(8)._R

_Item(_equiv)
indicates _Fit(code equivalence).
It is read as _qu(is equivalent to).
For example, _example((CAR (CDR _Fit(x))) _equiv (CADR _Fit(x)))
means that for any _Fit(x),
the value and effects of _Xc((CAR (CDR _Fit(x)))) are always the
same as the value and effects of _Xc((CADR _Fit(x)))._R

_Item(_yl)
is used in definitions to indicate
the _Fit(type) of the result.  For example,
_example((NUMBER? _Fit(object)) _yl() _Fit(boolean))
means that the procedure named _Xc(NUMBER?) yields a boolean result._R
_begin_Example
(PRINT _Fit(object port)) _yl() _Undefined
_end_Example
means that _Xc(PRINT)
returns a value of no particular interest; that is, one should
not depend on it to return anything in particular._R

_Item(_Fit(Italicized))
names in the code examples are meta-variables
that stand
for pieces of code to be filled in.  Restrictions on the particular
types or values of a meta-variable are often suggested by its name or
are given in the text associated with the example.
The term _Fit(object) denotes data of unrestricted type._R

_Item(_Fit(Dot-notation)), as in _Xc((ADD . _Fit(numbers))),
is used where any
number of sub-forms are permitted.  In this example, there may be zero
or more _Fit(numbers);
the description subsumes cases such as _Xc((ADD)),
_Xc((ADD 3)), and _Xc((ADD 3 5 2)).
See also _star and ([ _dots ]) above._R

_Item(_Fit(Settable))
Some routines described in this manual, such as _Xc(VREF)
(page _Pageref(VREF)), serve as _Fit(access routines) in
the sense that they are appropriate for use in _Xc(SET) and related
forms to designate locations.  These routines have their descriptions
flagged with the notation _Fit(Settable)._R

_Item(_Fit(Type Predicate))
Functions that take an object of any type as an argument and return
a boolean are called type predicates. They return true if the
argument was of the required type and false otherwise.

_Item(_Fit(Operation))
Functions that dispatch on their first argument are labelled as
_Fit(operations). See Chapter _Ref(chapter:operations).
_end_Table

_Section(Naming Conventions,Language principles and conventions,Notation,Introduction)
Below are listed some of the naming conventions used for standard _T
procedures, variables, and reserved words._R
_begin_Table
_Item(_tc(_dots()?))
The suffix _tc(?) indicates a predicate.  For example,
_tc(ZERO?) is a predicate which returns true if its argument is
numerically equal to zero._R

_Item(_tc(_dots()!))
The suffix _tc(!) indicates a side-effecting variant of a
non-side-effecting procedure.  For example, _tc(REVERSE!) is the same as
_tc(REVERSE), but it alters its argument, recycling the storage to
form its result._R

_Item(_tc(_a(_dots(),_txar(),_dots())))
Infix _tc(_txar()) is used in names of _Fit(coercion procedures),
which are routines which perform conversions
between objects of different types.  For example, given a string,
_tc(_a(STRING,_txar(),LIST)) forms a list of the characters in the string._R

_Item(_tc(*_dots()*))
The names of mutable variables whose scope is not
visually apparent
to someone reading the program is usually bounded on either side with
_tc(*)'s.  In _Tv(2), also used for some immutable variables._R

_Item(_tc(DEFINE-_dots()))
Relates to the assignment of something in a permanent
way.  _tc(DEFINE) is typically used for defining procedures,
_tc(DEFINE-OPERATION) to define generic operations, and so forth._R

_Item(_tc(MAKE-_dots()))
Indicates a routine which creates an object of some type,
given size (and sometimes datatype) information.  For example,
_tc((MAKE-STRING 5)) makes a string of length 5._R

_Item(_tc(NOT-_dots()))
The prefix _qu(_tc(NOT-)) means that the truth value of some
predicate is complemented.  For example, _wt((NOT-LESS? _Fit(x) _Fit(y)))
is the same as _wt((NOT (LESS? _Fit(x) _Fit(y))))._R

_Item(_tc(_dots()CDR))
Relates to the subtail or successive subtails of a list.
For example, while the procedure named _tc(NTH) returns the nth
_Fit(element) of a list, there is another procedure named _tc(NTHCDR) that
returns the nth _Fit(subtail)._R

_Item(_tc(_dots()Q))
The presence of the trailing character _qu(_tc(Q)) on a name
typically means that the predicate _qu(_tc(EQ?)) is involved.  For
example,_R
_begin_Example
(MEMQ? _Fit(x) _Fit(l))  _equiv  (MEM? EQ? _Fit(x) _Fit(l))
_end_Example
_end_Table

_Section(Language principles and conventions,,Naming Conventions,Introduction)
The design of _T employs a number of conventions.
These conventions make the language more regular, predictable, and
easy to learn.

_Fit(Anonymity:) objects are not tightly coupled to their names.
_DComment( How to explain this essential principle.  Procedures, operations,
types, structure types, ... )

_Fit(Locality:) effects may be achieved locally.
_DComment( Another painfully basic idea, impossible to articulate. )

_Fit(Argument order:) procedures which extract components from aggregate
objects generally take the aggregate object as the first argument, and
selection information (if any) as subsequent arguments.
Similarly, assignment procedures take the aggregate object or location
specification early, and the value to be stored last.

_Fit(Indexing:) where numeric indices are involved, the indices begin with
zero and range up to a given limit.  Ranges are specified as
_Fit(half-open intervals), inclusive at the low end and exclusive at the
high end.

_Fit(Abbreviations:) are avoided
in names of _T entities.  Words are spelled out and separated by
hyphens, e.g. _tc(DEFINE-OPERATION), _tc(STRING-LENGTH).
Where abbreviations are used, they are used consistently:
e.g. _tc(CHAR) abbreviates _tc(CHARACTER), as in _tc(CHAR?),
and _tc(ELT) abbreviates _tc(ELEMENT), as in _tc(STRING-ELT).

_DComment(
Talk about the standard definition format.
Give examples.  Talk about _qu(body) and `undefined'.)

_DComment( Talk about long names, abbreviation phobia, etc.)
_DComment( Talk about hyphenation: hack-frob vs. frob-hack.  Input type vs.
output type.  inputtype-operation-outputtype.
Why _tc(COPY-LIST) vs. _tc(LIST-COPY)?  What about
_tc(FILE-NEWER?) and _tc(MAYBE-OPEN)? )

_DComment(
The most common rule for formation of names for standard _T
operations is that hyphenated names are often formed according to
the formula
  _begin_Example
_Fit(input type)-_Fit(verb)-_Fit(output type)
  _end_Example
where either _Fit(input type) or _Fit(output type) may be ommitted where
obvious or meaningless.  For example, _tc(STRING-LENGTH) names a
procedure whose input type (that is, the expected type of its argument)
is _Fit(string), whose verb is _Fit(length), and whose output type (type
of the object returned) is _Fit(integer).  The name in expanded form
would be _tc(STRING-LENGTH-INTEGER), but it is supposed to be obvious
that the length of a string is an integer, so that part of the name
is omitted.  Similarly, _tc(MAKE-VECTOR) abbreviates
_tc(INTEGER-MAKE-VECTOR).  In many cases, both input and output type
are omitted, e.g. _tc(APPEND) instead of _tc(LIST-APPEND-LIST). )
