_Chapter(Miscellaneous features)

_Section(Comments and declarations)

_Comdef(`COMMENT',`Special form',
`(COMMENT . _Fit(comment)) _yl() _Fit(undefined)')
_begin_Desc
Does nothing and returns no value of interest.
_tc(COMMENT)-expressions may be used to write comments in code.
(The preferred way to write comments, however, is with the semicolon
read macro character; see page _Pageref(SEMICOLON).)
_end_Desc 

_Comdef(`IGNORE',`Special form',
`(IGNORE . _Fit(variables)) _yl() _Fit(undefined)')
_label(IGNORE)
_begin_Desc
Ordinarily, programs
such as compilers
which manipulate source programs
consider it to be an exceptional condition
when a bound variable is not referenced, and may generate warning messages
when they detect this condition.
_tc(IGNORE)-expressions may be used to suppress such warnings
and also to request that a warning be issued if in fact there are
any references to _Fit(variables).
_begin_Example
(LAMBDA (X Y) (IGNORE X) (CAR Y))
_end_Example
_end_Desc 

_Comdef(`IGNORABLE',`Special form',
`(IGNORABLE . _Fit(variables)) _yl() _Fit(undefined)')
_begin_Desc

_tc(IGNORABLE) is like _tc(IGNORE) except that permission is _Fit(not)
given to give warnings if any of _Fit(variables) actually is referenced.
This is not useful for human-generated expressions, but may be useful
in the expansion of a macro invocation where the macro expander may
not know whether a bound variable in the expansion is referenced or
not, and wants to declare that it is all right if the variable is
not referenced.
_end_Desc 

_Section(Errors and dead ends)
_label(section:errors)  
_Comdef(`ERROR',` ',
`(ERROR _Fit(control-string) . _Fit(arguments)) _yl() _Fit(object)')
_begin_Desc
Signals an error.  _Fit(Control-string) and _Fit(arguments)
should be arguments suitable for a call to _tc(FORMAT)
(page _Pageref(FORMAT)).
The error is reported in an implementation-dependent
manner, and an opportunity is provided to possibly correct
or proceed from the error.  (See section _Ref(section:errorsInterface)
for details of _T's handling of errors.)
_begin_Example
(ERROR _exqu(cannot wash the dishes because _cTL()A) EXCUSE-DESCRIPTION-STRING)
_end_Example
_index(errors)
_end_Desc 

_Comdef(`SYNTAX-ERROR',` ',
`(SYNTAX-ERROR _Fit(control-string) . _Fit(arguments)) _yl() _Fit(object)')
_begin_Desc
Similar to _tc(ERROR), but signals a syntax error.
This should be called, for example, from within macro expanders
when an illegal syntax is encountered.
_end_Desc 

_Comdef(`READ-ERROR',` ',
`(READ-ERROR _Fit(port control-string) . _Fit(arguments)) _yl() _Fit(object)')
_begin_Desc
Similar to _tc(ERROR), but signals a read error.
This should be called, for example, from within read macros
when an illegal read syntax is encountered.
_end_Desc 

_Comdef(`CHECK-ARG',` ',
`(CHECK-ARG _Fit(predicate object procedure)) _yl() _Fit(object)')
_begin_Desc
_index(type)
Verifies that an object is of a particular type.
_Fit(Predicate) should be a type predicate, and _Fit(object) can be any object.
If _Fit(predicate), when applied to _Fit(object), returns false,
then an error is signalled.
If it returns true, then the _tc(CHECK-ARG) returns _Fit(object).
_Fit(Procedure) is a procedure whose name will be given in any
message printed by the error system.

The user interface (see section _Ref(section:errorsInterface))
may provide a way to supply a value to use in place of _Fit(object).
If the user attempts to correct the error in this way, then
_tc(CHECK-ARG) again verifies that the new value answers true to
_Fit(predicate), and returns it.

For example:
_begin_ExampleTabbing
(DEFINE _settab()(WASH-DISH DISH) _incrtab()_LNL
  (LET _settab()((DISH (CHECK-ARG DISH? DISH WASH-DISH))) _incrtab()_LNL
    _dots)) 
_end_ExampleTabbing
_end_Desc 

_DComment(
_Comdef(`PROCLAIM',` ',
`(PROCLAIM _Fit(predicate) _Fit(object)) _yl() _Fit(object)')
_begin_Desc
Returns _Fit(object), which must answer true to _Fit(predicate).
A call to _tc(PROCLAIM) serves as a type declaration;
this may assist an optimizing compiler in generating efficient code.
_begin_ExampleTabbing
(PROCLAIM _settab()_Fit(predicate) _Fit(object)) _LNL
  _gotab()_equiv() _LNL
(LET _settab()((VALUE _Fit(object))) _incrtab()_LNL
  (COND _settab()((_Fit(predicate) VALUE) VALUE) _incrtab()_LNL
        (ELSE (UNDEFINED-EFFECT))))
_end_ExampleTabbing
_end_Desc 
)

_Comdef(`ENFORCE',` ',
`(ENFORCE _Fit(predicate) _Fit(value)) _yl() _Fit(value)')
_begin_Desc
Returns _Fit(value) which must answer _Fsem(true) to
_Fit(predicate).
If _Fit(predicate) returns _Fsem(false) when applied to
_Fit(value), the effect
is undefined (normally, this means that an error is signalled).
If _tc(ENFORCE) signals an error and enters a breakpoint, then a
new value can be returned using _tc(RET).  For example,
_begin_Example
    _cGT() (LET ((A (ENFORCE FIXNUM? 'A))) (+ A 1)) _LNL
    _star()_star() Error: (ENFORCE FIXNUM? A) failed in (anonymous) _LNL
    _cGT()_cGT() (RET 1) _LNL
    2 _LNL
    _cGT()
_end_Example
_end_Desc

_Comdef(`UNDEFINED-VALUE',` ',
`(UNDEFINED-VALUE . _Fit(arguments)) _yl() _Fit(undefined)')
_begin_Desc
_label(section:undefined)        
_index(undefined)
Has no effect and yields some undefined value.  An implementation will
endeavor to return some object which, when printed or otherwise
displayed, will show the _Fit(arguments).  This feature may be useful in
debugging, for example in tracking down the origin of the undefined
value, if the value has propagated to an undesirable place.
_end_Desc 

_Comdef(`UNDEFINED-EFFECT',` ',
`(UNDEFINED-EFFECT . _Fit(arguments)) _yl() _Fit(undefined)')
_begin_Desc
The effect of calling _tc(UNDEFINED-EFFECT) is undefined.  An
implementation will endeavor to signal an error condition if such a call
ever occurs; however, an optimizing compiler may make use of the fact
that the control path leading to a call to _tc(UNDEFINED-EFFECT) will
never be taken in a correctly running program, and so in some cases may
eliminate the call.
_end_Desc 

_Section(Early binding)
_index(early bindings)

_DComment( Streamline the following!  Talk about early vs. late binding and
incremental redefinition. )

_Comdef(`DEFINE-CONSTANT',`Special form',
`(DEFINE-CONSTANT _Fit(variable value)) _yl() _Fit(undefined)')
_begin_Desc
This is semantically identical to _tc(DEFINE), but also declares that
the value of the variable will not change.  This might permit a compiler
to perform constant-folding.
Also, if the variable is defined to be a small integer, this may
interact well with _tc(SELECT) to obtain fast numeric dispatch on
_qu(enumerated types).
_end_Desc 

_Comdefb(`DEFINE-INTEGRABLE',`Special form',
`(DEFINE-INTEGRABLE _Fit(variable value)) _yl() _Fit(undefined)',
`(DEFINE-INTEGRABLE (_Fit(variable) . _Fit(arguments)) . _Fit(body)) _yl() _Fit(undefined)')
_label(section:defineIntegrable)
_begin_Desc 
This is semantically identical to _tc(DEFINE), but also declares
that the value of the variable is not expected to change.
For example, if a reference to the variable is encountered in
functional position in a call, its definition may be _Fit(integrated),
that is, substituted in-line.
_end_Desc

_Section(Symbol generators)
_index(symbol)

_Comdef(`GENERATE-SYMBOL',` ',
`(GENERATE-SYMBOL _Fit(prefix)) _yl() _Fit(symbol)')
_begin_Desc
Each call to _tc(GENERATE-SYMBOL) generates a unique identifier.  The
form which the new identifier's name takes is not defined, but the
identifier is guaranteed to be different from any identifier created
in any other way.  The identifier's external representation will begin
with _Fit(prefix).
_end_Desc 

_Comdef(`CONCATENATE-SYMBOL',` ',
`(CONCATENATE-SYMBOL . _Fit(things)) _yl() _Fit(symbol)')
_begin_Desc
Creates a symbol whose print name is obtained by appending the printed
representations of _Fit(things) according to the _tc(DISPLAY) operation.
_begin_Example
(CONCATENATE-SYMBOL 'FOO- `THING-' 34)  _evalto()  FOO-THING-34
_end_Example
_end_Desc 

_Section(Combinators)
_index(combinators)

_Comdef(`ALWAYS',` ',
`(ALWAYS _Fit(value)) _yl() _Fit(procedure)')
_begin_Desc
Returns a procedure which ignores its arguments and always returns _Fit(value).
_begin_Example
(ALWAYS _Fit(value)) _equiv() (LAMBDA X (IGNORE X) _Fit(value))
_end_Example
_end_Desc 

_Comdef(`IDENTITY',` ',
`(IDENTITY _Fit(object)) _yl() _Fit(object)')
_begin_Desc
Identity function.  Returns its argument.
_end_Desc 

_Comdef(`PROJN',` ',
`(PROJN _Fit(n)) _yl() _Fit(procedure)')
_begin_Desc
Returns a procedure which returns (projects) its _Fit(nth) argument, ignoring
any others.
_begin_Example
(PROJN 1)  _equiv()  (LAMBDA (A B . REST) (IGNORE A REST) B)
_end_Example
_end_Desc 

_Comdef(`PROJ0',` ',
`(PROJ0 _Fit(object . rest)) _yl() _Fit(object)')
_begin_Desc
Projection function: returns its zeroth argument, ignoring the rest.
_begin_Example
PROJ0  _equiv()  (PROJN 0)
_end_Example
_tc(PROJ0) is similar to _tc(BLOCK0) (page _Pageref(BLOCK0)), except
that it is a procedure, not a special form.
_end_Desc 

_Comdef(`PROJ1',` ',
`(PROJ1 _Fit(object0 object1 . rest)) _yl() _Fit(object1)')
_begin_Desc
Returns its second argument.
_end_Desc 

_Comdef(`PROJ2',` ',
`(PROJ2 _Fit(object0 object1 object2 . rest)) _yl() _Fit(object2)')
_begin_Desc
Returns its third argument.
_end_Desc 

_Comdef(`PROJ3',` ',
`(PROJ3 _Fit(object0 object1 object2 object3 . rest)) _yl() _Fit(object3)')
_begin_Desc
Returns its fourth argument.
_end_Desc 

_Comdef(`CONJOIN',` ',
`(CONJOIN . _Fit(predicates)) _yl() _Fit(predicate)')
_begin_Desc
Returns a predicate which is the logical conjunction of all of the
_Fit(predicates).
_begin_ExampleTabular
((CONJOIN _a(_cGT,0?) ODD?) 13)  _colsep()_evalto()_colsep  _Fsem(true) _LNL
((CONJOIN _a(_cGT,0?) ODD?) 8)  _colsep()_evalto()_colsep  _Fsem(false)
_end_ExampleTabular
_end_Desc 

_Comdef(`DISJOIN',` ',
`(DISJOIN . _Fit(predicates)) _yl() _Fit(predicate)')
_begin_Desc
Returns a predicate which is the logical disjunction of all of the
_Fit(predicates).
_begin_ExampleTabular
((DISJOIN _a(_cGT,0?) ODD?) 13)  _colsep()_evalto()_colsep  _Fsem(true) _LNL
((DISJOIN _a(_cGT,0?) ODD?) 8)  _colsep()_evalto()_colsep  _Fsem(true)
_end_ExampleTabular
_end_Desc 

_Comdef(`COMPLEMENT',` ',
`(COMPLEMENT _Fit(predicate)) _yl() _Fit(predicate)')
_begin_Desc
Returns a predicate which is the logical complement of the _Fit(predicate).
_begin_ExampleTabular
ATOM? _colsep()_equiv()_colsep (COMPLEMENT PAIR?) _LNL
((COMPLEMENT MEMQ?) 'A '(X Y Z))  _colsep()_evalto()_colsep  _Fsem(true)
_end_ExampleTabular
_end_Desc 

_Comdef(`COMPOSE',` ',
`(COMPOSE . _Fit(procedures)) _yl() _Fit(procedure)')
_begin_Desc
Returns a procedure which is the composition of the _Fit(procedures).
The last of the _Fit(procedures) may take any number of arguments, and the resulting
procedure will take that same number of arguments; all the other
_Fit(procedures) must take one argument.
_begin_ExampleTabbing
((COMPOSE CAR CDR) '(A B))   _evalto()  B _LNL
(COMPLEMENT _Fit(predicate))   _equiv()  (COMPOSE NOT _Fit(predicate)) _LNL
PROPER-LIST?   _equiv()  (DISJOIN NULL? (COMPOSE NULL? CDR LASTCDR)) _LNL
NTH   _equiv()  (COMPOSE CAR NTHCDR)
_end_ExampleTabbing
_end_Desc 

_DComment( Is this the right place to talk about these things...? )

_Comdef(`TRUE',`Type predicate',
`(TRUE . _Fit(arguments)) _yl() _Fit(true)')
_begin_Desc
Ignores its arguments, and always returns true.
This may be used as a predicate representing the _qu(universal type)
- the type which subsumes all objects.
_end_Desc 

_Comdef(`FALSE',`Type predicate',
`(FALSE . _Fit(arguments)) _yl() _Fit(false)')
_begin_Desc
Ignores its arguments, and always returns false.
This may be used as a predicate representing the _qu(null type) - the
type which subsumes no objects.
_end_Desc 

_Comdef(`TRUE?',`Type predicate',
`(TRUE? _Fit(value)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(value) is _Fit(some) true value, false otherwise.
This is convenient where one wants to coerce a truth value
to be a _Fit(standard) truth value; that is,
_tc(TRUE?) maps false to itself, and any true value to
the standard true value (_tc(T)).
_begin_ExampleTabular
(TRUE? _Fit(object))    _colsep()_equiv()_colsep  (NOT (FALSE? _Fit(object))) _LNL
(TRUE? NIL)  _colsep()_evalto()_colsep  _Fsem(false) _LNL
(TRUE? T)  _colsep()_evalto()_colsep  _Fsem(true) _LNL
(TRUE? 3)  _colsep()_evalto()_colsep  _Fsem(true)
_end_ExampleTabular
_end_Desc 

_Comdef(`BOOLEAN?',`Type predicate',
`(BOOLEAN? _Fit(object)) _yl() _Fit(boolean)')
_begin_Desc
This returns true if _Fit(object) is either the standard true value
or the standard false value.
_DComment( It is a nearly useless predicate, and probably oughtn't be documented
until such time as _tc(PROCLAIM) and types are better supported. )
_begin_ExampleTabular
(BOOLEAN? NIL)  _colsep()_evalto()_colsep  _Fsem(true) _LNL
(BOOLEAN? T)    _colsep()_evalto()_colsep  _Fsem(true) _LNL
(BOOLEAN? 3)    _colsep()_evalto()_colsep  _Fsem(false)
_end_ExampleTabular
_end_Desc 

_Section(Vectors)
_label(section:vectors)  
_index(vectors)

_Fit(Vectors)_index(vectors) can be thought of as
one-dimensional, zero-based arrays, or as fixed-length, random-access lists.
They read and print like lists with a _tc(_cH()) in front.
Like lists, but unlike numbers and strings, vectors are not
self-evaluating.  To write a constant vector, quote it:
_cQc()_cH()_wt((X Y (1 2))).

_Comdef(`VECTOR?',`Type predicate',
`(VECTOR? _Fit(object)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(object) is a vector.
_end_Desc 

_Comdef(`MAKE-VECTOR',` ',
`(MAKE-VECTOR _Fit(size)) _yl() _Fit(vector)')
_begin_Desc
Returns a vector whose length is _Fit(size).
The elements are not initialized to any particular value.

_tc(VECTOR-FILL) (see below) may be used
to fill the vector with some useful value (such as _tc(())).
_end_Desc 

_Comdef2(`list-to-vector',`_a(LIST-,_cGT,VECTOR)',` ',
`(_a(LIST-,_cGT,VECTOR) _Fit(list)) _yl() _Fit(vector)')
_begin_Desc
Converts a list to a vector.
_begin_Example
(_a(LIST-,_cGT,VECTOR) '(A B C))  _evalto()  _cH()(A B C)
_end_Example
_end_Desc 

_Comdef2(`vector-to-list',`_a(VECTOR-,_cGT,LIST)',` ',
`(_a(VECTOR-,_cGT,LIST) _Fit(vector)) _yl() _Fit(list)')
_begin_Desc
Converts a vector to a list.
_begin_Example
(_a(VECTOR-,_cGT,LIST) '_cH()(A B C))  _evalto()  (A B C)
_end_Example
_end_Desc 

_Comdef(`VECTOR-ELT',`Settable',
`(VECTOR-ELT _Fit(vector n)) _yl() _Fit(object)')
_Comdef(`VREF',`Settable',
`(VREF _Fit(vector n)) _yl() _Fit(object)')
_label(VREF)
_begin_Desc 
Accesses the _Fit(nth) element of _Fit(vector) (zero-based).
_begin_Example
(VECTOR-ELT '_cH()(A B C) 1) _evalto()  B
_end_Example
_end_Desc

_Comdef(`VSET',` ',
`(VSET _Fit(vector n object)) _yl() _Fit(object)')
_begin_Desc
Sets the _Fit(nth) element of _Fit(vector) to _Fit(object).
_begin_Example
(VSET _Fit(vector n object)) _equiv() (SET (VREF _Fit(vector n)) _Fit(object))
_end_Example
_end_Desc 

_Comdef(`COPY-VECTOR',` ',
`(COPY-VECTOR _Fit(vector)) _yl() _Fit(vector)')
_begin_Desc
Makes a copy of _Fit(vector).
_end_Desc 

_Comdef(`VECTOR-FILL',` ',
`(VECTOR-FILL _Fit(vector value)) _yl() _Fit(vector)')
_begin_Desc
Sets every element of _Fit(vector) to _Fit(value), and returns the
modified _Fit(vector).
_end_Desc 

_Comdef(`VECTOR-REPLACE',` ',
`(VECTOR-REPLACE _Fit(target source n)) _yl() _Fit(vector)')
_begin_Desc
Sets the first _Fit(n) elements of _Fit(target) to be the same as the
corresponding elements of _Fit(source), and returns the (modified)
_Fit(target).
_end_Desc 

_Comdef(`VECTOR-LENGTH',` ',
`(VECTOR-LENGTH _Fit(vector)) _yl() _Fit(integer)')
_begin_Desc
Returns _Fit(vector)'s length.
_end_Desc 

_Comdef(`VECTOR-POS',` ',
`(VECTOR-POS _Fit(predicate object vector)) _yl() _Fit(integer) _rm(or) _Fit(false)')
_begin_Desc
Returns index of the first element _Fit(x) of _Fit(vector)
such that _tc((_Fit(predicate object x))), or false if there is no such element.
_end_Desc 

_Comdef(`VECTOR-POSQ',` ',
`(VECTOR-POSQ _Fit(object vector)) _yl() _Fit(integer) _rm(or) _Fit(false)')
_begin_Desc
_begin_Example
(VECTOR-POSQ _Fit(object vector)) _equiv() (VECTOR-POS EQ? _Fit(object vector))
_end_Example
_end_Desc 

_Comdef(`WALK-VECTOR',` ',
`(WALK-VECTOR _Fit(procedure vector)) _yl() _Fit(undefined)')
_begin_Desc
Applies _Fit(procedure) to every element in _Fit(vector).
_end_Desc 

_Section(Pools)

_DComment( More documentation should be written.  Talk about GC interaction, etc. )

_Fit(Pools)_index(pools) give a convenient way to perform explicit storage management in T.
One may obtain an object from a pool (popping the pool's free list, or
creating a new object if the free list is empty), and later return an
object to a pool.  By managing storage allocation in this way, the
frequency of garbage collections _DComment(where explained?) can be reduced.
_index(free lists)

All pools are emptied when a garbage collection occurs.  Garbage
collections occur asynchronously in an implementation-dependent manner.
_index(garbage collection)

_Comdef(`MAKE-POOL',` ',
`(MAKE-POOL _Fit(identification) _Fit(generator)) _yl() _Fit(pool)')
_begin_Desc
Creates a pool.  _Fit(Generator) should be a procedure, and will be
called by _tc(OBTAIN-FROM-POOL) whenever the pool's free list is empty.
_Fit(Identification) is only for identification purposes, for example,
when the pool is printed.
_end_Desc 

_Comdef(`OBTAIN-FROM-POOL',` ',
`(OBTAIN-FROM-POOL _Fit(pool)) _yl() _Fit(object)')
_begin_Desc
Obtains an object from _Fit(pool).  If the pool is empty, the pool's generator
is called to obtain an object, which is then returned directly.
_end_Desc 

_Comdef(`RETURN-TO-POOL',` ',
`(RETURN-TO-POOL _Fit(pool) _Fit(object)) _yl() _Fit(undefined)')
_begin_Desc
Returns _Fit(object) to _Fit(pool).  A future call to
_tc(OBTAIN-FROM-POOL) may yield _Fit(object).
_end_Desc 

_Section(Weak pointers)

_Comdef(`OBJECT-HASH',` ',
`(OBJECT-HASH _Fit(object)) _yl() _Fit(integer)')
_label(OBJECT-HASH)
_begin_Desc
Returns a unique numeric identifier for _Fit(object).
That is,
_begin_Example
(EQ? _Fit(object1) _Fit(object2))
_end_Example
if and only if
_begin_Example
(= (OBJECT-HASH _Fit(object1)) (OBJECT-HASH _Fit(object2)))
_end_Example
Because _tc(OBJECT-HASH) is invertible (see below), it can be used
to create _ix(weak pointers) to objects, that is, _qu(pointers) or
_qu(references) which are not strong enough to prevent an object from
being reclaimed by the garbage collector.  This concept of weak pointer
is implemented by the integers returned by _tc(OBJECT-HASH), which
can be dereferenced by calling _tc(OBJECT-UNHASH).

_tc(OBJECT-HASH) is used by standard methods for the _tc(PRINT) operation
when printing objects which have no read syntax.
_end_Desc 

_Comdef(`OBJECT-UNHASH',` ',
`(OBJECT-UNHASH _Fit(integer)) _yl() _Fit(object) _rm(or) _Fit(false)')
_begin_Desc
Returns the object whose unique identifier is _Fit(integer),
or false if the object is no longer accessible (e.g. due to garbage
collection).
_begin_Example
(OBJECT-UNHASH (OBJECT-HASH _Fit(object)))  _evalto()  _Fit(object)
_end_Example
_end_Desc 

In _Tv(3), _qu(populations) have been renamed to _qu(weak-sets).
This change was made in the belief that _qu(weak-set) is a more
intuitive name than _qu(population).  The old names are still
supported, but they will be removed in a future release.

_Fit(Weak-Sets)_index(weak sets) provide a way to keep track of a collection of objects.
They are sometimes known as _iix(weak sets) because they behave much like
sets, but an object in a weak-set may go away if the only pointer to
the object is via the weak-set.  The garbage collector will remove
such objects from weak-sets.
_index(garbage collection)

_Comdef(`MAKE-WEAK-SET',` ',
`(MAKE-WEAK-SET _Fit(identification)) _yl() _Fit(weak-set)')
_begin_Desc
_tindex(MAKE-WEAK-SET)
Creates a new weak-set.
_end_Desc 

_Comdef(`ADD-TO-WEAK-SET!',` ',
`(ADD-TO-WEAK-SET _Fit(weak-set) _Fit(object)) _yl() _Fit(undefined)')
_begin_Desc
_tindex(ADD-TO-WEAK-SET)
Adds _Fit(object) to _Fit(weak-set).
_end_Desc

_Comdef(`REMOVE-FROM-WEAK-SET!',` ',
`(REMOVE-FROM-WEAK-SET _Fit(weak-set) _Fit(object)) _yl() _Fit(undefined)')
_begin_Desc
_tindex(REMOVE-FROM-WEAK-SET)
In _Tv(2) was _wt(REMOVE-FROM-POPULATION).
Removes _Fit(object) from _Fit(weak-set).
_end_Desc 

_Comdef2(`weak-set-to-list',`_a(WEAK-SET-,_cGT,LIST)',` ',
`(_a(WEAK-SET-,_cGT,LIST) _Fit(weak-set)) _yl() _Fit(list)')
_begin_Desc
Returns a list of all objects currently in _Fit(weak-set).  Note that as
long as this list is accessible, none of the objects will be implicitly
removed from the weak-set, because they will be accessible via this list.
_end_Desc 

_Comdef(`WALK-WEAK-SET',` ',
`(WALK-WEAK-SET _Fit(weak-set) _Fit(procedure)) _yl() _Fit(undefined)')
_begin_Desc
_tindex(WALK-WEAK-SET)
Calls _Fit(procedure) on each member of _Fit(weak-set).
_begin_Example
(WALK-WEAK-SET _Fit(weak-set) _Fit(procedure)) _LNL
  _equiv() _LNL
(WALK _Fit(procedure) (_a(WEAK-SET-,_cGT,LIST) _Fit(weak-set)))
_end_Example
_end_Desc 

_Comdef(`WEAK-SET-MEMBER?',` ',
`(WEAK-SET-MEMBER? _Fsem(object weak-set)) _yl() _Fsem(boolean)')
_begin_Desc
_wt(WEAK-SET-MEMBER?) returns true if _Fsem(object) is a member
of _Fsem(weak-set); otherwise, it returns false.
_end_Desc

_Comdef(`WEAK-SET-EMPTY?',` ',
`(WEAK-SET-EMPTY? _Fsem(weak-set)) _yl() _Fsem(boolean)')
_begin_Desc
_wt(WEAK-SET-EMPTY?) returns true if _Fsem(weak-set) is
empty; otherwise, it returns false.
_end_Desc
