_Chapter(Control)

_DComment( Talk about calls, tail-recursion, conditionals, etc. )

_Section(Conditionals)
_label(section:conditionals)
_index(conditionals)

_Comdef(`COND',`Special form',
`(COND . _Fit(clauses)) _yl() _Fit(value-of-clause)')
_begin_Desc
_tc(COND) is a general conditional construct.  Each _Fit(clause) should
have one of the following forms:
_begin_Itemize
_Item()(_Fit(test) . _Fit(body))

_Item()(_Fit(test))

_Item()(_Fit(test) _a(_Ftt(=),_cGT) _Fit(procedure))

_end_Itemize
The _Fit(test) expressions are evaluated in sequence until one yields true,
at which point:
_begin_Itemize
_Item()If it is part of a clause of the form _wt((_Fit(test) . _Fit(body))),
then _Fit(body), an implicit block, is evaluated, and its value is what
the _tc(COND)-expression yields.

_Item()If the clause has the form _wt((_Fit(test))),
then the _tc(COND)-expression yields
the value of _Fit(test) (which, of course, is non-null).

_Item()If the clause has the form
_wt((_Fit(test) _a(=,_cGT) _Fit(procedure))), then the _Fit(procedure)
expression is evaluated, and its value, which should be
a procedure, is called with the value of the _Fit(test) as its one and only
argument.  The _tc(COND) yields the value of that call.
_end_Itemize

Example:
_begin_ExampleTabbing
(COND _settab()((PAIR? X)   (GAUR (CAR X))) _LNL
      _gotab()((FIXNUM? X) (GAUR X))) _LNL
_end_ExampleTabbing

If all the _Fit(tests) yield false, then the _tc(COND) yields an
undefined value.
See section _Ref(section:undefinedSemantics) for a discussion of undefined
values.

The system variable _tix(ELSE) has a non-null value.  This provides a
convenient way to specify a branch to take when all other _Fit(tests)
fail.

_begin_ExampleTabbing
(COND _settab()((PAIR? X) (GAUR (CAR X))) _incrtab()_LNL
      ((ASSQ X *SAMPLE-ALIST*) _a(=,_cGT) CDR) _LNL
      ((GAUR X)) _LNL
      (ELSE NIL)) _LNL
_end_ExampleTabbing
_DComment( Important: devise examples which illustrate all the various
features of _tc(COND). )
_end_Desc

_Comdef(`XCOND',`Special form',
`(XCOND . _Fit(clauses)) _yl() _Fit(value-of-clause)')
_begin_Desc
Similar to _tc(COND), but its effect is undefined (and presumably an error
is signalled) if no _Fit(clause) is selected.  _tc(X) is mnemonic for
_qu(exhaustive).
_end_Desc

_Comdef(`ELSE',` ',
`ELSE _yl() _Fit(true)')
_begin_Desc
_tc(ELSE) has as its value some true value.
It exists mainly for use in _tc(COND).
_end_Desc

_Comdefb(`IF',`Special form',
`(IF _Fit(test consequent alternate)) _yl() _Fit(value-of-arm)',
`(IF _Fit(test consequent)) _yl() _Fit(undefined)')
_begin_Desc

_tc(IF) is a primitive two-way conditional.  The _Fit(test) expression
is evaluated.  If it yields true, then the _Fit(consequent) expression is
evaluated, and the _tc(IF) yields its value.  Otherwise, the
_Fit(alternate) expression, if any, is evaluated, and the _tc(IF) yields its
value.  If _Fit(test) yields false and there is no _Fit(alternate),
then the value of the _tc(IF) is undefined.
_begin_ExampleTabular
(IF T 1 2)                 _colsep()_evalto()_colsep  1 _LNL
(IF (PAIR? 'X) 'FOO 'BAR)  _colsep()_evalto()_colsep  BAR _LNL

(IF _Fit(test) _Fit(consequent))  _colsep()_equiv()_colsep  (IF _Fit(test) _Fit(consequent) (UNDEFINED-VALUE)) _LNL
_end_ExampleTabular
_end_Desc

_Comdef(`CASE',`Special form',
`(CASE _Fit(key) . _Fit(clauses)) _yl() _Fit(value-of-clause)')
_begin_Desc

_tc(CASE) performs a multi-way dispatch based on the value of the
_Fit(key) expression.  Each _Fit(clause) should be of the form
_wt((_Fit(keys) . _Fit(body))), where _Fit(keys) is a list of values (_Fit(not)
expressions!) against which the value of the _Fit(key) expression is
compared (using _tc(EQ?)), and _Fit(body) is an implicit block.  The
body of the clause which matches the _Fit(key) value is evaluated, and
the _tc(CASE)-expression yields the value of the body.  The last
_Fit(clause) may be of the form _wt((ELSE . _Fit(body))); this designates
a default action to be taken if no other clause is selected.  If the
_Fit(key) never matches and there is no default clause, then the
_tc(CASE)-expression yields an undefined value.
_begin_Example
(CASE 'B ((A) 'LOSE) ((B C) 'WIN) (ELSE NIL))  _evalto()  WIN
_end_Example
_end_Desc

_Comdef(`XCASE',`Special form',
`(XCASE _Fit(key) . _Fit(clauses)) _yl() _Fit(value-of-clause)')
_begin_Desc

Similar to _tc(CASE), but no _tc(ELSE)-clause is permitted, and
the effect is undefined (and presumably an error is signalled)
if no _Fit(clause) is selected.
_end_Desc

_Comdef(`SELECT',`Special form',
`(SELECT _Fit(key) . _Fit(clauses)) _yl() _Fit(value-of-clause)')
_label(SELECT)
_begin_Desc

_tc(SELECT) is like _tc(CASE), but the car of each _Fit(clause) is a list
of expressions that are evaluated, instead of a list of constants.
_begin_ExampleTabbing
(DEFINE *RED-COLOR*   _dots) _LNL
(DEFINE *GREEN-COLOR* _dots) _LNL
(DEFINE *BLUE-COLOR*  _dots) _LNL
(SELECT _settab()COLOR _incrtab()_LNL
        ((*RED-COLOR* *BLUE-COLOR*) _settab()'INORGANIC) _LNL
        ((*GREEN-COLOR*)            _gotab()'ORGANIC))
_end_ExampleTabbing
_end_Desc

_Comdef(`XSELECT',`Special form',
`(XSELECT _Fit(key) . _Fit(clauses)) _yl() _Fit(value-of-clause)')
_begin_Desc

Similar to _tc(SELECT), but no _tc(ELSE)-clause is permitted, and
the effect is undefined (and presumably an error is signalled)
if no _Fit(clause) is selected.
_end_Desc

_Comdef(`NOT',`Type predicate',
`(NOT _Fit(object)) _yl() _Fit(boolean)')
_Comdef(`FALSE?',`Type predicate',
`(FALSE? _Fit(object)) _yl() _Fit(boolean)')
_begin_Desc
_tc(NOT) returns true if _Fit(object) is false, and returns false otherwise.
_begin_ExampleTabular
(NOT NIL)  _colsep()_evalto()_colsep  _Fsem(true) _LNL
(NOT T)    _colsep()_evalto()_colsep  _Fsem(false) _LNL
(NOT 3)    _colsep()_evalto()_colsep  _Fsem(false)
_end_ExampleTabular
_end_Desc

_Comdef(`AND',`Special form',
`(AND . _Fit(tests)) _yl() _Fit(value-of-test) _rm(or) _Fit(false)')
_begin_Desc

The _Fit(test) expressions are evaluated from left to right, until one
evaluates to false, at which point the _tc(AND) yields false.
If no _Fit(test) evaluates to false then the value of the _tc(AND)
is the value of the last _Fit(test).
_begin_ExampleTabular
(AND 3 4)    _colsep()_evalto()_colsep  4 _LNL
(AND 3 NIL)  _colsep()_evalto()_colsep  _Fsem(false) _LNL
(AND)        _colsep()_evalto()_colsep  _Fsem(true)
_end_ExampleTabular
_end_Desc

_Comdef(`OR',`Special form',
`(OR . _Fit(tests)) _yl() _Fit(value-of-test) _Fit(or) _Fit(false)')
_begin_Desc

The _Fit(test) expressions are evaluated from left to right, until one
evaluates to true (i.e., not null); its value is yielded as the value
of the _tc(OR).  If no _Fit(test) evaluates to true, then the value
of the _tc(OR) is false.
_begin_ExampleTabular
(OR 3 4)    _colsep()_evalto()_colsep  3 _LNL
(OR 3 NIL)  _colsep()_evalto()_colsep  3 _LNL
(OR)        _colsep()_evalto()_colsep  _Fsem(false)
_end_ExampleTabular
_end_Desc

_Comdef(`*AND',` ',
`(*AND . _Fit(objects)) _yl() _Fit(object)')
_begin_Desc

If any of the _Fit(objects) is false, _tc(*AND) returns false; otherwise
it returns the last _Fit(object).  This is superficially similar to
_tc(AND), but it is a procedure, not a special form.  That is, the
value of _tc(*AND) is a procedure, whereas _tc(AND) is a reserved word
which introduces a special syntactic form.
This fact implies that (a) the variable _tc(*AND) has a value suitable
to be passed as an argument to some procedure, and
(b) a call to _tc(*AND) behaves differently from
an _tc(AND) special form in the case that the argument expressions have
side-effects.  In
_begin_Example
(AND NIL (FOO))
_end_Example
_tc(FOO) will not be called, whereas in
_begin_Example
(*AND NIL (FOO))
_end_Example
_tc(FOO) _Fit(will) be called.
_end_Desc

_Comdef(`*OR',` ',
`(*OR . _Fit(objects)) _yl() _Fit(object)')
_begin_Desc

If any of the _Fit(objects) is true, _tc(*OR) returns that object; otherwise
it returns false.  _tc(*OR)'s relation to _tc(OR) is
analogous to _tc(*AND)'s relation to _tc(AND).
_end_Desc

_Comdef(`*IF',` ',
`(*IF _Fit(test consequent alternate)) _yl() _Fit(object)')
_begin_Desc

If _Fit(test) is true, _tc(*IF) returns _Fit(consequent);
otherwise it returns _Fit(alternate).  _tc(*IF)'s relation to _tc(IF) is
analogous to _tc(*AND)'s relation to _tc(AND).
_end_Desc

_Section(Iteration)
_index(iteration)
_index(loops)

Separate iteration constructs are not strictly necessary in _T,
since iteration may be written using recursive procedures defined
by _tc(LABELS) (or even _tc(DEFINE)).  There is no penalty for this
in _T, either in efficiency or practicality (for example, stack
size), because tail-recursions are implemented without net growth
of stack, and it is expected that compilers will implement local
procedures efficiently.

However, the following two iteration constructs provide a somewhat
more convenient notation for loops than does _tc(LABELS).  (There
are also some higher-order procedures which perform iteration; see
for example _tc(MAP), page _Pageref(MAP), and _tc(WALK), page
_Pageref(WALK).)

_Comdef(`DO',`Special form',
`(DO _Fit(specs) (_Fit(end-test) . _Fit(exit-forms)) . _Fit(body))
 _yl() _Fit(value-of-exit)')
_begin_Desc

Iterates until _Fit(end-test) yields true.
Each _Fit(spec) should be of the form
_wt((_Fit(variable initial next))).
The _Fit(variables) are initialized (bound) in parallel to the values
of the _Fit(initial)-expressions, as with _tc(LET);
then, the _Fit(end-test) and _Fit(body) are executed iteratively.
If the _Fit(end-test) yields true on any iteration, then the loop
terminates, at which point the _Fit(exit-forms) are evaluated.
The value of the _tc(DO)-expression is the value of the
last _Fit(exit-form), or the value of the _Fit(end-test)
if there are no _Fit(exit-forms) (this is like a _tc(COND) clause).
At the end of each iteration, the _Fit(next)-expressions are all evaluated,
and the _Fit(variables) are re-bound
to the values of the _Fit(next)-expressions.

_tc(DO) is useful for loops which have a single termination condition,
such as numerical, ALGOL-style _tc(for)-loops, loops where desired
results are accumulated in variables, and loops that perform
side-effects on every element in a sequence
(see _tc(WALK), page _Pageref(WALK)).
_begin_ExampleTabbing
(_settab()REVERSE L)  _equiv() _incrtab()_LNL
  (DO _settab()(_settab()(L L (CDR L)) _incrtab()_incrtab()_LNL
       (RESULT '() (CONS (CAR L) RESULT))) _decrtab()_LNL
      ((NULL? L) RESULT))) _decrtab()_decrtab()_LNL

(_settab()VECTOR-FILL VECTOR CONSTANT)  _equiv() _incrtab()_LNL
  (DO _settab()((I (-1+ (VECTOR-LENGTH VECTOR)) (-1+ I))) _incrtab()_LNL
      ((_Ftt(_a(_cLT(),0?)) I) VECTOR) _LNL
    (VSET VECTOR I CONSTANT))
_end_ExampleTabbing

Any _tc(DO)-expression may be rewritten using the more primitive _tc(LABELS)
construct.  The following example has only one induction variable and
one _Fit(body)-expression, and assumes that there are no name conflicts
with the variable _tc(LOOP).
_begin_ExampleTabbing
(DO _settab()((_Fit(variable) _Fit(initial) _Fit(next))) _Fit(exit-clause) _Fit(body)) _LNL
  _gotab()_equiv() _LNL
(LABELS _settab()((_settab()(LOOP _Fit(variable)) _incrtab()_incrtab()_LNL
          (COND _settab()_Fit(exit-clause) _incrtab()_LNL
                (ELSE _settab()_Fit(body) _incrtab()_LNL
                      (LOOP _Fit(next)))))) _decrtab()_decrtab()_decrtab()_LNL
  (LOOP _Fit(initial)))
_end_ExampleTabbing
_end_Desc

_Comdef(`ITERATE',`Special form',
`(ITERATE _Fit(variable specs) . _Fit(body)) _yl() _Fit(value-of-body)')
_begin_Desc

Another iteration construct.
_Fit(Specs) has the form
_begin_Example
((_Fit(_sub(arg,1) _sub(val,1))) (_Fit(_sub(arg,2) _sub(val,2))) _dots (_Fit(_sub(arg,n) _sub(val,n))))
_end_Example
The _Fit(variable) is bound to a local procedure whose formal parameters
are _Fit(_sub(arg,1) _sub(arg,2) _dots _sub(arg,n)).  The procedure is initially invoked
with the _Fit(val)s bound to the corresponding _Fit(arg)s.

_tc(ITERATE) is more flexible than _tc(DO).  It is useful in loops where
the terminating condition occurs in the middle of the body of the loop,
or where there is more than one terminating condition, or where the
iteration may occur in several places.

For example, consider the following example (from _cite(rrs)),
a procedure to sort a list of trees into atoms and lists:
_begin_ExampleTabbing
(DEFINE _settab()(COLLATE X) _incrtab()_LNL
  (ITERATE _settab()COL ((Z X) (ATOMS '()) (LISTS '())) _incrtab()_LNL
    (COND _settab()(_settab()(NULL? Z) _incrtab()_LNL
           (LIST ATOMS LISTS)) _decrtab()_LNL
          ((ATOM? (CAR Z)) _incrtab()_LNL
           (COL (CDR Z) (CONS (CAR Z) ATOMS) LISTS)) _decrtab()_LNL
          (ELSE _settab()_incrtab()_LNL
           (COL (CDR Z) ATOMS (CONS (CAR Z) LISTS))))))
_end_ExampleTabbing
A rough analogy _tc(ITERATE : LABELS :: LET : LAMBDA) holds.
_tc(ITERATE) expands trivially into _tc(LABELS), but may be more convenient
than _tc(LABELS) for the same reason that a _tc(LET) form may be preferable
than a call to a _tc(LAMBDA)-expression.
_begin_ExampleTabbing
(ITERATE _settab()_Fit(variable) _incrtab()_LNL
((_Fit(_sub(arg,1) _sub(val,1))) (_Fit(_sub(arg,2) _sub(val,2))) _dots (_Fit(_sub(arg,n) _sub(val,n)))) _LNL
. _Fit(body)) _LNL
  _equiv() _decrtab()_LNL
(LABELS _settab()(((_Fit(variable _sub(arg,1) _sub(arg,2) _dots _sub(arg,n))) . _Fit(body))) _LNL
  _gotab()(_Fit(variable _sub(val,1) _sub(val,2) _dots _sub(val,n))))
_end_ExampleTabbing
_end_Desc

_Section(Procedure application)

The only operation which all procedures support is invocation.
All initial system routines, like _tc(CAR), _tc(LIST), and _tc(EQ?), are
procedures.  Procedures are usually created by evaluating _tc(LAMBDA)-
or _tc(DEFINE)-forms.
_index(procedures)

The standard way to apply a procedure to arguments is with a
_Fit(call) expression.  Calls are described on page _Pageref(CallSemantics).
_index(calls)

_DComment( Describe _tc(CALL), just for fun?  People might not understand
that it's redundant. )

_Comdef(`PROCEDURE?',`Type predicate',
`(PROCEDURE? _Fit(object)) _yl() _Fit(boolean)')
_begin_Desc
Returns true if _Fit(object) is a procedure, i.e., if it may be called.
_end_Desc

_Comdef(`APPLY',` ',
`(APPLY _Fit(procedure) . _Fit(objects)) _yl() _Fit(object)')
_begin_Desc

_tc(APPLY) applies a procedure to a list of arguments.

The sequence of _Fit(object) arguments should have the form
_begin_Example
_Fit(_sub(arg,1) _sub(arg,2)) _dots _Fit(_sub(arg,n) arglist)
_end_Example
where _Fit(n) may be 0.  The _Fit(procedure) is called with
_Fit(_sub(arg,1)), _Fit(_sub(arg,2)), etc., as the first _Fit(n) arguments,
and the members of _Fit(arglist) as final arguments.
_begin_ExampleTabular
(APPLY CONS '(1 2))          _colsep()_evalto()_colsep  (1 . 2) _LNL
(APPLY CONS 1 '(2))          _colsep()_evalto()_colsep  (1 . 2) _LNL
(APPLY CONS 1 2 '())         _colsep()_evalto()_colsep  (1 . 2) _LNL
(APPLY LIST 1 2 3 '(4 5 6))  _colsep()_evalto()_colsep  (1 2 3 4 5 6)
_end_ExampleTabular
_end_Desc

_Section(Sequencing)

_Comdef(`BLOCK',`Special form',
`(BLOCK . _Fit(body)) _yl() _Fit(value-of-body)')
_begin_Desc

_Fit(Body) is a non-empty sequence of expressions.
These expressions are evaluated in order from left to right.
The _tc(BLOCK)-expression
yields the value of the last expression.

Because their values are ignored, expressions other than the last are
useful only for side-effects they may cause.

Since the bodies of most special forms are implicitly blocks, _tc(BLOCK)
is useful only in places where syntactically a single expression is
needed, but some sequencing is required.
_end_Desc

_Comdef(`BLOCK0',`Special form',
`(BLOCK0 _Fit(first-form) . _Fit(body)) _yl()
_Fit(value-of-first-form)')
_label(BLOCK0)
_begin_Desc

The _Fit(first-form) is evaluated, then the expressions in the _Fit(body)
are evaluated.  The _tc(BLOCK0)-expression yields _Fit(first-form)'s value.
_end_Desc

_Section(Explicit return)

_Comdef(`RET',` ',
`(RET _a(_cBo(),_Fsem(value),_cBc(),_star))')
_begin_Desc
Returns zero or more values as the value of the current _wt(read-eval-print)
loop.  _Fsem(value) defaults to an undefined value if not supplied.
See section _Ref(section:errorsInterface) for examples.
_end_Desc

_SubSection(Non-local exits)

_Comdef(`CATCH',`Special form',
`(CATCH _Fsem(identifier) . _Fit(body)) _yl() _Fit(value-of-body)')
_label(CATCH)
_begin_Desc

_tc(CATCH) provides a structured, non-local exit facility
similar to _tc(PROG) and _tc(RETURN) (without _tc(GO)),
or _tc(CATCH) and _tc(THROW), in other Lisps.
The _Fsem(identifier) is bound to an _qu(escape procedure)
corresponding to the _Fit(continuation) of the
_wt(CATCH) form. The escape procedure is now an n-ary procedure.
This means that _wt(CATCH) forms can ruturn multiple values.
In _Tv(2) the continuation was a procedure of one argument.
The escape procedure can be invoked only during the dynamic extent
of the _wt(CATCH) form (see section _Ref(section:continuations)).
If the escape procedure is called
as a result of evaluating _Fit(body), then the argument to the
_Fit(escape procedure)
is returned as the value of the _tc(CATCH)-expression.
If the escape procedure is not called, then _tc(CATCH) returns whatever
_Fit(body) returns.
A call to an escape procedure is called a _Fit(throw)._index(throws)

In the following example, the call to _tc(LIST) never happens,
because one of its subforms performs a throw.
_begin_ExampleTabular
(CATCH X (LIST 1 (X 2) 3))   _colsep()_evalto()_colsep  2 _LNL
(CATCH X (LIST 1 (X 2 3) 4)) _colsep()_evalto()_colsep 2 3
_end_ExampleTabular

A throw may cause side-effects if the dynamic state in effect when the
escape procedure is called differs from that in effect when evaluation
of its corresponding _tc(CATCH)-expression began._index(dynamic state)
_T's _tc(CATCH) is a restriction of SCHEME's.
Continuations are only valid within the dynamic extent of the
_tc(CATCH)-expression;
however, because of _tc(CALL-WITH-CURRENT-CONTINUATION)
(see page _Pageref(section:continuations)) the _tc(CATCH) can
yield a value at most once.
In this case the
throw undoes the effects of _tc(BIND) forms, and must perform cleanup
action requested by _tc(UNWIND-PROTECT) forms, in the process of
_qu(unwinding) the evaluation context from that of the throw to that of
the _tc(CATCH).  See section _Ref(section:dynamicState) for
descriptions of _tc(BIND) and _tc(UNWIND-PROTECT).
_end_Desc

_SubSection(Returning multiple values)
_label(subsection:multipleReturnValues)

_T supports multiple return values.  This makes
procedure call and return uniform, in the sense that a procedure
can be invoked with zero or more values and can return zero
or more values.  

_Comdef(`RETURN',` ',
`(RETURN _a(_cBo(),_Fsem(value),_cBc(),_star))')
_label(RETURN)
_begin_Desc
_wt(RETURN) returns its arguments as the _Fsem(values) of the
current expression.  In order to access the _Fsem(values) of a
_wt(RETURN) expression the _Fsem(values) must be bound to
identifiers using either _wt(RECEIVE) or
_wt(RECEIVE-VALUES). 

For example,

_example((LAMBDA () (RETURN 1 2 3)) _evalto 1 2 3)

where _qu(_evalto 1 2 3) denotes _Fit(evaluates to) the
_Fit(three) values 1, 2, and 3.

Like procedures, continuations have certain expectations about the
number of arguments (values) that will be delivered to them.  It is an
error if more or fewer values are delivered than expected.  There are
only a small number of ways to create continuations, thus one need only
understand these cases:

_begin_Itemize
_Item()Implicit continuations, e.g. those receiving an argument
of a combination or the predicate of an _Fcode(IF), expect exactly
one value, thus
_begin_Example
(LIST (VALUES 1) 2)  _evalto  (1 2)
_end_Example
    but
_begin_ExampleTabular
(LIST (VALUES) 2)        _colsep()_colsep()_rm(is an error) _LNL
(LIST (VALUES 1 2) 2)    _colsep()_colsep()_rm(is an error)
_end_ExampleTabular

_Item()In a _wt(BLOCK), a continuation
which proceeds to execute subsequent commands (e.g. the
continuation to the call to _Fcode(FOO) in _Fcode((BLOCK (FOO) 2)))
accepts an arbitrary number of values, and discards all of them.

_Item()_wt(RECEIVE) expressions (and the subprimitive
_wt(RECEIVE-VALUES)) creates a continuation which accepts
whatever values are delivered to it, and passes them to
a procedure; and of course it is an error if this procedure
is passed the wrong number of values.
_end_Itemize

_wt(RETURN) when _Fit(invoked) with no arguments returns to the
calling procedure with no value.  Thus _Fcode((RETURN)) will
return to its caller with no value. It is an error to return no value to
a value-requiring position.  For example,

_begin_Example
(LIST _cQc()A (RETURN)) _evalto _Fsem(error)
_end_Example

The idiom _Fcode((RETURN)) is useful for procedures that return
an undefined value.
Many of the system procedures whose value
is undefined now return no value. The procedure
_wt(UNDEFINED-VALUE) may provide a more informative error message.
_end_Desc

_Comdef(`RECEIVE-VALUES',` ',
`(RECIEVE-VALUES _Fsem(receiver sender)) _evalto _Fsem(value(s) of receiver)')
_begin_Desc
_wt(RECEIVE-VALUES) returns the value of applying _Fsem(receiver),
a procedure of _Fit(n) arguments, to the values
returned by _Fsem(sender).  _Fsem(sender) is a _Fit(thunk),
a procedure of no arguments, which returns _Fit(n) values.
    
For example,
_begin_ExampleTabbing
(RECEIVE-VALUES _settab()(LAMBDA (X Y) (LIST X Y)) _LNL
                _gotab()(LAMBDA () (RETURN 1 2))) _evalto (1 2)
_end_ExampleTabbing
_end_Desc

_Comdef(`RECEIVE',`Syntax',
`(RECEIVE (_a(_cBo(),ident,_cBc(),_star)) _Fsem(expression) _a(_cBo(),body,_cBc(),_star)) _evalto _Fsem(value-of-body)')
_begin_Desc
In a _wt(RECEIVE) form the _Fsem(expression) is evaluated in
the current environment and the values returned by the
_Fsem(expression) are bound to the corresponding identifiers.  _Fsem(body),
which should be a LAMBDA body, i.e. a sequence of one or more
expressions, is evaluated in the extended environment and the
_Fsem(values) of the last expression in _Fsem(body) is returned.

The expression 
_begin_ExampleTabbing
(RECEIVE _settab()(A B C) (RETURN 1 2 3) _incrtab _LNL
         (LIST A B C)) _LNL
      _evalto  (1 2 3)
_end_ExampleTabbing

is equivalent to

_begin_ExampleTabbing
(RECEIVE-VALUES _settab()(LAMBDA (A B C) (LIST A B C)) _incrtab _LNL
                (LAMBDA () (RETURN 1 2 3))) _LNL
      _evalto  (1 2 3)
_end_ExampleTabbing
_end_Desc

_Section(Lazy evaluation)

_Fit(Delays) provide a general mechanism for delayed (lazy) evaluation,
also known as _qu(call-by-need).
_index(delays)
_index(lazy evaluation)
_index(call by need)

_DComment( Where does this belong, really? )
_DComment( Should we admit that this is just a trivial macro in terms of
_tc(LAMBDA)? )

_Comdef(`DELAY',`Special form',
`(DELAY _Fit(expression)) _yl() _Fit(delay)')
_begin_Desc

Returns a delay of the _Fit(expression).  The computation of the expression,
which happens at most once, is delayed until its value is
requested with _tc(FORCE).
_begin_ExampleTabbing
(DEFINE _settab()(INF-LIST-OF-INTEGERS N) _LNL
  _gotab()(CONS N (DELAY (INF-LIST-OF-INTEGERS (1+ N))))) _LNL
(HEAD (TAIL (TAIL (INF-LIST-OF-INTEGERS 1))))  _evalto  3 _LNL

(DEFINE HEAD CAR) _LNL
(DEFINE (TAIL OBJ) (FORCE (CDR OBJ)))
_end_ExampleTabbing
The behavior of _tc(DELAY) and _tc(FORCE) can be described by the
following hypothetical implementation:
_begin_ExampleTabbing
(DEFINE-SYNTAX _settab()(DELAY EXP) _LNL
  _gotab()_cQo()(MAKE-DELAYED-OBJECT (LAMBDA () ,EXP))) _LNL

(DEFINE _settab()(MAKE-DELAYED-OBJECT THUNK) _incrtab()_LNL
  (LET _settab()(_settab()(FORCED-YET? NIL) _incrtab()_incrtab()_LNL
        (FORCED-VALUE NIL)) _decrtab()_LNL
    (OBJECT _settab()NIL _incrtab()_LNL
            (_settab()(FORCE SELF) _incrtab()_LNL
             (COND (_settab()(NOT FORCED-YET?) _incrtab()_LNL
                    (SET FORCED-VALUE (THUNK)) _LNL
                    (SET FORCED-YET? T))) _decrtab()_LNL
             FORCED-VALUE)))) _decrtab()_decrtab()_decrtab()_decrtab()_LNL

(DEFINE-OPERATION (FORCE OBJ) OBJ)
_end_ExampleTabbing
_end_Desc

_Comdef(`FORCE',` ',
`(FORCE _Fit(delay)) _yl() _Fit(object)')
_begin_Desc

Forces the computation of the _Fit(delay)'s value,
If _Ftt(FORCE) has not previously been applied to the delay,
then the _Fit(expression) in the original _tc(DELAY)-expression
which created _Fit(delay) (see above)
is evaluated, and its value is returned.
If _Ftt(FORCE) has previously been applied to the delay,
then the value previously computed is returned.

If _tc(FORCE) is applied to a non-delay, then it simply returns
its argument.
_end_Desc
