_Appendix(Friendly advice)

_Section(Comparison with other Lisp dialects)

Some of the terminology may take some getting used to.  We always say
_Fit(procedure) instead of _Fit(function), for example.  _Fit(Special form)
and _Fit(reserved word) have special meaning.  _Fit(Syntax) usually refers
not to what the reader does but to what the compiler does.
_index(functions)

As in Common Lisp, but unlike most familiar Lisp dialects besides Scheme,
_T is lexically scoped.

As in Scheme, there is full support for lexical closures,
and tail-recursive calls are reliably performed as jumps.

Generic operations are like message-passing.
_tc(JOIN) can be used to implement object systems analogous to
the Lisp Machine's flavor system.

_DComment(dorab: commented this out)
_DComment(Synonyms generalize Lisp Machine Lisp's _tc(MAKE-SYN-STREAM).)

See also the equivalences appendix for some rough functional analogues.

_Section(Incompatibilities)

The empty list is distinguished from the symbol whose print name
is _tc(`NIL').  That is, _wt((NEQ? NIL 'NIL)).  The _Fit(value) of the
variable _tc(NIL) is the empty list.  The empty list is the same as the
logical false value currently, but these two will be differentiated
in the future.

All _qu(global) variables must be declared using _tc(LSET) before they
are assigned using _tc(SET) or _tc(BIND).  This is quite unlike most Lisp
dialects where the first _tc(SETQ) causes a variable to come into existence.

_T has no _tc(FEXPR) or _tc(NLAMBDA) mechanism.  Their effect may be
accomplished using procedures or macros.

There are no _tc(SPECIAL) declarations and no implicit dynamic
binding.  _tc(BIND) must be used explicitly when a variable is to be
dynamically bound.

_tc(COND) and _tc(CASE) don't yield nil in the fall-through case;
they yield undefined values.

_tc(RETURN) and _tc(GO)-tags are not supported in _tc(DO).
Lisp _tc(RETURN) may be simulated using _wt((CATCH RETURN _dots)).

_tc(NTH) is incompatible with Maclisp's function of the same name.
Maclisp's takes the index as the first argument and the list as
the second, instead of the other way around.

_tc(LAST) returns the last _Fit(element) of the list, not the
last _Fit(pair), as in Maclisp.
Maclisp's _tc(LAST) is like _T's _tc(LASTCDR).

_tc(APPEND) isn't defined to copy all but the last list.  I.e.
the language definition allows the implementation to
yield _tc(X), and not a copy of it, for _tc((APPEND X '())).

_tc(PUSH)'s syntax is incompatible with that of _tc(PUSH)
in Maclisp and Common Lisp.

Locatives aren't as cheap as they are in Lisp Machine Lisp; creating
a locative may involve consing.

_DComment(

_Section(Style suggestions)

Coding style cannot be dictated.  The _T designers and implementors
attempt to adhere to a strict programming discipline.  The less
_qu(randomness) there is in a program, the easier it is to understand.
The noise level must be kept to a minimum.

Understand _tc(NIL), _tc(()), _tc('()), and _tc(T).
As a matter of style, users are advised to write _tc(NIL) as an
expression which evaluates to a logically false value, and _tc('()) as
an expression which evaluates to the empty list.  Use _tc(()) in
quoted structures: _wt((CADR '(A () B)) _evalto() ()), but _wt((CADR '(A NIL
B)) _evalto() NIL).

That car and cdr of null evaluate to null is sometimes considered a
programming convenience, but code which depends on this fact may be
difficult to read and is considered stylistically poor.

In Maclisp-like Lisp dialects, many users program with macros as a way
to get certain trivial operations to _qu(open-code.)  _T provides
_Fit(integrable procedures) (see section _Ref(section:defineIntegrable))
for that purpose, and we encourage their use.

It is usually unnecessary to use _tc(SET) on local variables.
_tc(LET) and various side-effect-free iteration constructs usually
suffice to express most code which in other Lisp dialects would
require _tc(SET).

   Avoid irregular abbreviations.

   Indent and comment properly.

   Avoid side-effects.

   Avoid _tc(EVAL).

   Use locales sparingly.

)
