@part[User, root "TMAN.MSS"]	@Comment{-*-System:TMAN-*-}
@chap[User interface]
@label[User Chapter]


This chapter describes the user interface to the @Timp[] system, which
is the current implementation of the @Tau[] language.  Also part of
the user interface are the various debugging facilities, which are
described in chapter @ref[debugging chapter].

The features described in this chapter are highly volatile and
implementation-dependent.


@section[Invoking @timp[]]

To invoke a @Timp[] system, one typically gives a command to the system
command processor, as appropriate to the operating system and installation.
For example, under Aegis, the following interaction might take place:
@begin[ProgramExample]
$ t
This is MC68000/Aegis @Timp[] version 2.8 (329)
;Loading "~sys/tfix/tfix329.t" into *T-IMPLEMENTATION-ENV*
;Loading "~init.t" into *SCRATCH-ENV*
> (list 'planner 'conniver)
(PLANNER CONNIVER)
> 
@end[ProgramExample]
The interaction may look slightly different in the other implementations.
The above illustrates the startup sequence, which proceeds as follows:
@begin[itemize]
The user invokes @timp[] with an appropriate command.

The @timp[] system identifies itself by giving the processor and
operating system under which it believes itself to be running, the
major and minor system @ix[version numbers], and the system
edit number.  The version numbers identify which release of
@timp[] is running.  The edit number is
useful to the system implementors and
should be provided in any bug reports sent to them.

@Timp[] loads a @iix[patch file], if one exists.  The patch file
consists of forms which fix bugs in the current release of the system.

@Timp[] loads a user @ix[initialization file], if one exists.  The user
@ix[initialization file] consists of any forms which the users wants to
have evaluated when @timp[] starts up.  The location in the file system
where the initialization file is found is system-dependent, but is usually
the file @tc[init.t] in the user's home directory.

@Timp[] enters a @iix[read-eval-print loop].  Read-eval-print loops
are described in section @ref[REPL section].
@end[itemize]

@desc[(STOP) @yl[] @i[undefined]]
Exits @timp[] in such a way that it may be resumed later.
Control returns to the context from which @timp[]
was invoked.  Under Unix, this usually means the
shell.  Under VMS, this means the command interpreter (DCL).
@tc[STOP] is not defined in Aegis @Timp[] because
the Aegis environment makes it unnecessary.
@EndDesc[STOP]

@desc[(EXIT)]
Exits @timp[], returning control to the context in which @timp[]
was invoked in the first place (usually a shell or other command processor).
Any resources associated with the @Timp[] process will be freed;
@tc[EXIT] is not reversible.
A call to @tc[EXIT] cannot return.
@EndDesc[EXIT]

@desc[*COMMAND-LINE* @yl[] @i[list]]
This variable has as its value the command line which
was used to invoke @timp[], represented as a list of strings.
@EndDesc[*COMMAND-LINE*]


@section[Read-eval-print loops]
@label[REPL section]

The user usually interacts with the @timp[] system
via a @ix[read-eval-print loop].
As illustrated above, this is a command loop which repeatedly reads an
expression, evaluates it, and prints the value.

The read-eval-print loop is a simple command processor;
it prints a prompt, reads a command from the terminal,
executes the command, then prints another prompt, ad infinitum.
A @iixs[command] is any executable @tau[] form, and executing
the command consists of evaluating the form and printing the result.

@dc{There really ought to be a more complete history mechanism;
this will probably be done at some point.}

@desc[** @yl[] @i[object]]
The variable @tc[**] always has as its value the last object
which was @i[printed] by the read-eval-print loop, that is, the value
of the last expression typed by the user.
@EndDesc[**]

@info[NL]
@desc[++ @yl[] @i[object]]
The variable @tc[++] always has as its value the last expression
@i[read] by the read-eval-print loop.
It is not assigned this value, however, until @i[after] the expression
has been evaluated, so that a new expression may refer to
the previous one.
@EndDesc[++]

Expressions are read from the terminal by applying the @tc[READ]
operation (actually, the value of @tc[(REPL-READ)]; see page
@pageref[REPL-READ]) to the terminal input stream.  Initially, that
stream's read table is the standard read table, but this may be changed
using @tc[SET], for example:
  @begin[ProgramExample]
(SET (STREAM-READ-TABLE (TERMINAL-INPUT)) *MY-READ-TABLE*)
  @end[ProgramExample]

Evaluation is performed with respect to a particular variable
environment and its syntax table.  The read-eval-print loop may move
from place to place within the environment hierarchy; one may control
the evaluation environment and syntax table by setting @tc[(REPL-ENV)].

@info[Notes="Settable"]
@desc[(REPL-ENV) @yl[] @i[environment]]
Accesses the environment passed to @tc[(REPL-EVAL)] by the
read-eval-print loop.  Initially, this is the scratch environment
(see page @PageRef[*SCRATCH-ENV*]).
@EndDesc[REPL-ENV]


@section[Command levels]

Read-eval-print loops may be invoked recursively.  Each currently running
read-eval-print loop is said to be at a different @iix[command level].
The initial read-eval-print loop is at @i[top level], and recursive
read-eval-print loops are at successively deeper levels.

The level of the current command loop is reflected in the way the
loop prompts for input.  At top level, the prompt is a single
greater-than sign (@tc[>]).  At deeper command levels, the prompt
contains as many greater-than signs as there are active read-eval-print
loops; for example, @tc[>>>] if there are two recursive read-eval-print
loops beneath the top level one.

Deeper command levels are usually entered as the result of program
execution errors, but may also be entered because of a keyboard
interrupt or an explicit call to @tc[BREAKPOINT].

@i[Interrupts:] @index[Interrupts] @label[Interrupts]
Issuing a keyboard interrupt will asynchronously enter a read-eval-print
loop.  One may proceed from this breakpoint, at the point where
computation was interrupted, by doing @tc[(RET)].  Keyboard interrupts
are normally issued under Aegis by giving a Display Manager @tc[DQ]
command (normally assigned to control-Q), under VMS by typing control-C,
or under Unix by typing the interrupt character (normally control-C
or DEL).

@i[End-of-file:] @index[end-of-file] @label[end-of-file]
An end-of-file condition on the terminal input stream (see page
@pageref[TERMINAL-INPUT]) which occurs at a read-eval-print loop
will cause control to transfer up one command level to the next
read-eval-print loop.  End-of-file can usually be generated under
Aegis with the display manager @tc[EEF] command (normally assigned
to control-Z), under VMS by typing control-Z, or under Unix by typing
the end of file character (normally control-D).

@info[EQUIV="^G"]
@desc[(RESET)]
Transfers control directly to the top-level read-eval-print loop
by performing a throw (see page @PageRef[CATCH]).
@EndDesc[RESET]


@dc{ **************** should move the following somewhere else }

@descN[
  FN1="RET",
  F1="(RET)",
  F2="(RET @i[object])"
]
Returns @i[object] (which defaults to an undefined value if not supplied)
as the value of the current read-eval-print loop.
See section @ref[dealing section] for examples.
@EndDescN[]

@desc[(BREAKPOINT . @i[message]) @yl[] @i[object] @r[or] @i[undefined]]
Enters a read-eval-print loop.  If @i[message] is not null, then it
is printed by @tc[DISPLAY] on the @tc[(ERROR-OUTPUT)] stream.
If @wt[(RET @i[object])] is called, then the loop terminates and
@i[object] is returned as the value of the call to
@tc[BREAKPOINT].  If an end-of-file condition occurs, then
control is thrown to the read-eval-print loop at the next higher level,
which continues.
@EndDesc[BREAKPOINT]



@section[Transcripts]

A @iix[transcript] is a record of the user's interaction with the
@Tau[] system.  Transcripts are necessary in @Tau[] implementations
under operating systems which do not natively provide transcript
facilities.  Transcripts are not necessary, for example, when running
under the Aegis Display Manager.

@desc[(TRANSCRIPT-ON @i[filename]) @yl[] @i[undefined]]
Starts writing a transcript to the specified file.  All output to
@tc[(TERMINAL-OUTPUT)] and input from @tc[(TERMINAL-INPUT)] between
calls to @tc[TRANSCRIPT-ON] and @tc[TRANSCRIPT-OFF] is written to
the file.  A subsequent call to @tc[TRANSCRIPT-OFF] will terminate
the transcript, closing the file.
@EndDesc[TRANSCRIPT-ON]

@desc[(TRANSCRIPT-OFF) @yl[] @i[undefined]]
Closes the active transcript file.
@EndDesc[TRANSCRIPT-OFF]


@section[Customization]

The various phases of the read-eval-print loop may be customized by
assigning values to switches.

@info[Notes="Settable"]
@desc[(REPL-READ) @yl[] @i[procedure]]
Accesses the @tc[READ] part of the read-eval-print loop.  Initially, this is
@tc[READ].
@EndDesc[REPL-READ]

@info[Notes="Settable"]
@desc[(REPL-EVAL) @yl[] @i[procedure]]
Accesses the @tc[EVAL] part of the read-eval-print loop.  Initially, this is
@tc[EVAL].
@EndDesc[REPL-EVAL]

@info[Notes="Settable"]
@desc[(REPL-PRINT) @yl[] @i[procedure]]
Accesses the @tc[PRINT] part of the read-eval-print loop.  Initially, this
is @tc[PRINT].
@EndDesc[REPL-PRINT]

@info[Notes="Settable"]
@desc[(REPL-PROMPT) @yl[] @i[procedure]]
Accesses the prompting routine used in the read-eval-print loop.  This
should be a procedure of one argument, which is a nonnegative integer
giving the command level (zero at top level, one at the next deeper
level, and so on).  The procedure should return a string.  Initially,
@tc[(REPL-PROMPT)] is a procedure that returns @tc["> "] at the top
level, @tc[">> "] at the level below that, etc.
@EndDesc[REPL-PROMPT]

@info[Notes="Settable"]
@desc[(LOAD-NOISILY?) @yl[] @i[boolean]]
If @tc[(LOAD-NOISILY?)] is true (which it is initially), then @tc[LOAD]
and @tc[REQUIRE] will print the value of each top-level expression
in the file (standard compiler only).  The output goes to the terminal
output stream.
@EndDesc[LOAD-NOISILY?]

@info[NOTES="Operation"]
@desc[(REPL-WONT-PRINT? @i[object]) @yl[] @i[boolean]]
Read-eval-print loops will not print any object which answers true to
this operation.
Note that this is unrelated to the functioning of @tc[PRINT] itself.
@enddesc[REPL-WONT-PRINT?]

@desc[*REPL-WONT-PRINT* @yl[] @i[object]]
This has as value an object which answers true to the @tc[REPL-WONT-PRINT?]
predicate.
  @begin[ProgramExample]
*REPL-WONT-PRINT*  @ce[]  (OBJECT NIL ((REPL-WONT-PRINT? SELF) T))
  @end[ProgramExample]
@enddesc[*REPL-WONT-PRINT*]
