@part[INTRO, Root "TMAN.MSS"]	@comment{ -*-System:TMAN-*-}
@set[Page=+1]@string[ContentsPage=Page]@set[Page='0']
@chap[Introduction]
@label[First T Chapter]	@Comment{ref: Implementation Chapter}


@section[Language overview]

@tau[] is a dialect of Lisp derived from SCHEME. @cite[STEELE78REV]
It is comparable in power and expressiveness to
other recent Lisp dialects such as Lisp Machine Lisp, @cite[WEINREB81] Common
Lisp, @cite[STEELE83COM] and NIL, @cite[WHITE79] but fundamentally more
similar in spirit to SCHEME than these other Lisp dialects.

@Tau[] endeavors to be a powerful, expressive language which also
permits portable and efficient implementations.  @tau[] is a @qu"modern"
Lisp suitable for a broad variety of applications, including symbolic,
numerical, and systems programming, on a variety of machines.

@tau[] draws from many sources in its attempt to provide a complete yet
simple and unified system.  For the most part, the language's designers
are collators, not originators.  Common Lisp, NIL, and SCHEME have been
the strongest influences.

Except for a restriction on the use of escape procedures (see the
description of @tc[CATCH], page @PageRef[CATCH]),
the omission of @tc[TEST] and the multiprocessing primitives,
and a few changed names (e.g., @tc[SET] instead of @tc[ASET']),
@tau[] includes as a subset the SCHEME dialect described in
@i[The Revised Report on SCHEME]@cite[STEELE78REV].

@citemark[GABRIEL82]
@citemark[HOLLOWAY80]
@citemark[STEELE76IMP]
@citemark[STEELE76DEC]
@citemark[STEELE78RAB]
@citemark[STEELE79]
@citemark[STEELE80]
@citemark[SUSSMAN75]
@citemark[CHARNIAK80]

@dc{ don't appeal to other Lisps as much. }

@dc{ Talk about how technical terms are introduced. }

@section[Notational conventions]

@dc{
Talk about the standard definition format - what the arrows
and all that mean, etc.  Give examples.  Talk about @qu"body" and "undefined".

Flushed all the @b[boldface] commands, turned them into italics.
}

The symbol @qu"@ev[]" @index[@ev[]] is used to indicate @i[evaluation].
(Evaluation is described in section @ref[core language section].)
For example, @wt[(+ 3 5) @ev[] 8] means that evaluating the expression
@wt[(+ 3 5)] yields @tc[8].

The symbol @qu"@ce[]" @index[@ce[]] indicates @i[code equivalence].  For
example,
@teg[(CAR (CDR @i[x])) @ce[] (CADR @i[x])]
means that for any
@i[x], the value and effects of @wt[(CAR (CDR @i[x]))] are always the
same as the value and effects of @wt[(CADR @i[x])].

The symbol @qu"@yl[]" @index(@yl[]) is used in definitions to indicate
the @i[type of result].  For example,
  @teg[(NUMBER? @i[object]) @yl[] @i[boolean]]
means that the procedure named @tc[NUMBER?] yields a boolean result.
  @begin[ProgramExample]
(PRINT @i[object stream]) @yl[] @i[undefined]
  @end[ProgramExample]
@index[undefined] means that @tc[PRINT]
returns a value of no particular interest; that is, one should
not depend on it to return anything in particular.

@i[Italicized] names in the code examples are meta-variables that stand
for pieces of code to be filled in.  Restrictions on the particular
types or values of a meta-variable are often suggested by its name or
are given in the text associated with the example.  The term @i[object]
denotes data of unrestricted type.

@ix[Dot-notation], as in @wt[(ADD . @i[numbers])], is used where any
number of sub-forms are permitted.  In this example, there may be zero
or more @i[numbers]; the description subsumes cases such as @wt[(ADD)],
@wt[(ADD 3)], and @wt[(ADD 3 5 2)].

Some routines described in this manual, such as @tc[VREF]
(page @pageref[VREF]), serve as @iix[access routines] in
the sense that they are appropriate for use in @tc[SET] and related
forms to designate locations.  These routines have their descriptions
flagged with the notation @iix[Settable].

@dc{ Talk about other notations: @i[Type predicate, Operation,] etc. }


@section[Naming conventions]

@dc{ Talk about long names, abbreviation phobia, etc.

@i[Abbreviations.]  Abbreviations are avoided
in names of @Tau[] entities.  Words are spelled out and separated by
hyphens, e.g. @tc[DEFINE-OPERATION], @tc[STRING-LENGTH].
Where abbreviations are used, they are used consistently:
e.g. @tc[CHAR] abbreviates @tc[CHARACTER], as in @tc[CHAR?],
and @tc[ELT] abbreviates @tc[ELEMENT], as in @tc[STRING-ELT].

}

@dc{ Talk about hyphenation: hack-frob vs. frob-hack.  Input type vs.
output type.  inputtype-operation-outputtype.
Why @tc[COPY-LIST] vs. @tc[LIST-COPY]?  What about
@tc[FILE-NEWER?] and @tc[MAYBE-OPEN]? }

@dc{
The most common rule for formation of names for standard @Tau[]
operations is that hyphenated names are often formed according to
the formula
  @begin[ProgramExample]
@i[input type]-@i[verb]-@i[output type]
  @end[ProgramExample]
where either @i[input type] or @i[output type] may be ommitted where
obvious or meaningless.  For example, @tc[STRING-LENGTH] names a
procedure whose input type (that is, the expected type of its argument)
is @i[string], whose verb @dc< ?? > is @i[length], and whose output type (type
of the object returned) is @i[integer].  The name in expanded form
would be @tc[STRING-LENGTH-INTEGER], but it is supposed to be obvious
that the length of a string is an integer, so that part of the name
is omitted.  Similarly, @tc[MAKE-VECTOR] abbreviates
@tc[INTEGER-MAKE-VECTOR].  In many cases, both input and output type
are omitted, e.g. @tc[APPEND] instead of @tc[LIST-APPEND-LIST].
}

Below are listed some of the naming conventions used for standard @tau[]
procedures, variables, and reserved words.

@begin[Description]

@tc[...?]@\The suffix @tc[?] indicates a predicate.  For example,
@tc[ZERO?] is a predicate which returns true if its argument is
numerically equal to zero.

@tc[...!]@\The suffix @tc[!] indicates a side-effecting variant of a
non-side-effecting procedure.  For example, @tc[REVERSE!] is the same as
@tc[REVERSE], but it alters its argument, recycling the storage to
form its result.

@tc[...->...]@\Infix @tc[->] is used in names of @i[coercion procedures],
which are routines which perform conversions
between objects of different types.  For example, given a string,
@tc[STRING->LIST] forms a list of the characters in the string.

@tc[*...*]@\The names of variables whose scope is not visually apparent
to someone reading the program is usually bounded on either side with
@tc[*]'s.  This convention is used for variables which are
either not bound to procedures, or whose value is intended to change.

@tc[DEFINE-...]@\Relates to the assignment of something in a permanent
way.  @tc[DEFINE] is typically used for defining procedures,
@tc[DEFINE-OPERATION] to define generic operations, and so forth.

@tc[MAKE-...]@\Indicates a routine which creates an object of some type,
given size (and sometimes datatype) information.  For example,
@tc[(MAKE-STRING 5)] makes a string of length 5.

@tc[NOT-...]@\The prefix @qu"@tc[NOT-]" means that the truth value of some
predicate is complemented.  For example, @wt[(NOT-LESS? @i[x] @i[y])]
is the same as @wt[(NOT (LESS? @i[x] @i[y]))].

@tc[...CDR]@\Relates to the subtail or successive subtails of a list.
For example, while the procedure named @tc[NTH] returns the n@+(th)
@i[element] of a list, there is another procedure named @tc[NTHCDR] that
returns the n@+(th) @i[subtail].

@tc[...Q]@\The presence of the trailing character @qu"@tc[Q]" on a name
typically means that the predicate @qu"@tc[EQ?]" is involved.  For
example,
@begin[ProgramExample]
@tc[(MEMQ? @i[x] @i[l])  @ce[]  (MEM? EQ? @i[x] @i[l])]
@end[ProgramExample]

@end[description]

@section[Language principles and conventions]

@dc{ If this section can't be made to work, flush it. }

The design of @Tau[] employs a number of conventions.
These conventions make the language more regular, predictable, and
easy to learn.

@i[Anonymity:] objects are not tightly coupled to their names.
@dc{ How to explain this essential principle.  Procedures, operations,
types, structure types, ... }

@i[Locality:] effects may be achieved locally.
@dc{ Another painfully basic idea, impossible to articulate. }

@i[Argument order:] procedures which extract components from aggregate
objects generally take the aggregate object as the first argument, and
selection information (if any) as subsequent arguments.
Similarly, assignment procedures take the aggregate object or location
specification early, and the value to be stored last.

@i[Indexing:] where numeric indices are involved, the indices begin with
zero and range up to a given limit.  Ranges are specified as
@i[half-open intervals], inclusive at the low end and exclusive at the
high end.
