#include <stdio.h>
#include <signal.h>

#define IF ((
#define THEN )?(
#define ELSE ):(
#define FI ))

#define MIN_HEAP_SIZE 524288  /* .5 Mb */
#define MAX_HEAP_SIZE 8192000 /* 8 Mb  */
#define DEFAULT_HEAP_SIZE 4096000 /* 4 Mb  */
#define STDIO_SPACE   49152   /* be sure to save 48k of data space for stdio */
#define STATIC_SPACE  131072  /* .125Mb for fun, usr "-l" to add to this */
#define SAVED_SPACE   (STDIO_SPACE+STATIC_SPACE)


main( argc, argv )
char **argv;
int argc;
{
    long heap_wanted = -1;
    long leave_wanted = -1;
    long debug = 0;

    long
	max_heap_size,
	heap_size;
			  
    long
	total,
	aligned_total,
	aligned_heap_size;

    char **av;

    av = argv;
    av[argc] = 0; /* easy end test */

    while (*av)  {
	if ( ( !strcmp( *av, "-h" ) ) || ( !strcmp( *av, "-heap" ) ) )
	    heap_wanted = IF (!*++av) THEN -2 ELSE atoi( *av ) FI;
	else if ( ( !strcmp( *av, "-l" ) ) || ( !strcmp( *av, "-leave" ) ) )
	    leave_wanted = IF (!*++av) THEN -2 ELSE atoi( *av ) FI;
	else if (!strcmp( *av, "-d" ) )
	    debug = -1;
	av++;
    }

    /* Compute max allowed heap size.  MIN in case datasize is big. */
    /*  Quad align. */

    max_heap_size = MAX_HEAP_SIZE;
				   
    /* decide what to allocate - give user his request if it's within reason */

    if ((heap_wanted == -2) || (heap_wanted > MAX_HEAP_SIZE))
	heap_size = MAX_HEAP_SIZE;
    else                      
    if (heap_wanted == -1)
    heap_size = DEFAULT_HEAP_SIZE;
    else
    if (heap_wanted > MIN_HEAP_SIZE)
    heap_size = heap_wanted;
    else
	heap_size = MIN_HEAP_SIZE;

    total = sbrk( heap_size * 2 );
    if (total == -1)  {
	printf( "T could not allocate two heaps of %d bytes.\n", heap_size);
	printf( "Please retry with smaller heaps by using the -h switch.\n");
	exit(1);
    }
		
    /* make heaps smaller (if necessary) for quadword alignment */

    aligned_total = (total + 15) & 0xFFFFFFF0;
    aligned_heap_size = ( ((heap_size * 2) - (aligned_total - total))
			  & 0xFFFFFFC0 );

    heap_size = aligned_heap_size / 2;

    /* print message if any command line flag is given */

    if ( (heap_wanted != -1) || (leave_wanted != -1) )
	printf( "%d bytes per heap, %d bytes reserved\n",
		heap_size, leave_wanted + STATIC_SPACE );

    start_t( aligned_total, (aligned_total + heap_size), heap_size, 
             argc, argv, debug);

}

gc_interrupt()
{
  printf("Interrupted during GC; 'q' to exit, anything else to continue GC.\n");
  if (getchar() == 'q')
     exit(0);
}

csh()
{
	int status, pid, w;
	register int (*istat)(), (*qstat)();

	if ((pid = vfork()) == 0) {
		execl("/bin/csh", "csh", 0);
		_exit(127);
	}
	istat = signal(SIGINT, SIG_IGN);
	qstat = signal(SIGQUIT, SIG_IGN);
	while ((w = wait(&status)) != pid && w != -1)
		;
	if (w == -1)
		status = -1;
	signal(SIGINT, istat);
	signal(SIGQUIT, qstat);
	return(status);
}

extern int errno;
extern char *sys_errlist[];
extern int sys_nerr;

get_unix_error_msg(t, size) 
char *t;
int size; 
{
  char *s;    
  int i;

  i = 0;
  s = (char *) sys_errlist[ errno ];
  while (i<size && ((*t++ = *s++) != '\0')) i++; 
}


