
/*  *************************************************************************
    macqd.c -- The Macintosh QuickDraw functions (part 1 of 2) code for:

    MacSCM v1.0

    Author: Kevin Scott Kunzelman (kkunzelm@cam.cornell.edu)

    This code is in the public domain.	You can copy it, sell it, modify it,
    all without any restrictions.
    ************************************************************************/


#include <Events.h>
#include <Controls.h>
#include <Windows.h>
#include <QuickDraw.h>
#include <TextEdit.h>
#include <Menus.h>
#include <Pascal.h>

#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <console.h>

#include "scm.h"
#include "macscm.h"
#include "macqd.h"
#include "version.h"


/*  ************************************************************************/


static Str255 GStr255;
static char ARG6[] = "arg6";
static char ARG7[] = "arg7";
static char ARG8[] = "arg8";
static char ARG9[] = "arg9";


/*  ************************************************************************/


#define PTH(p) ((p).h)
#define PTV(p) ((p).v)
#define RECTLEFT(r) ((r).left)
#define RECTTOP(r) ((r).top)
#define RECTRIGHT(r) ((r).right)
#define RECTBOTTOM(r) ((r).bottom)


/*  ************************************************************************/


#define SUBRS(x)							    \
x("pt-get-h",		pt_get_h,   PT_INT_FUNC,	PTH)		    \
x("pt-get-v",		pt_get_v,   PT_INT_FUNC,	PTV)		    \
x("pt-equal?",		pt_equal,   PT2_BOOL_FUNC,	EqualPt)	    \
x("pt-in-rect?",	pt_in_rect, PTRECT_BOOL_FUNC,	PtInRect)	    \
x("global-to-local",	glob2local, PT_PT_FUNC,		GlobalToLocal)	    \
x("local-to-global",	local2glob, PT_PT_FUNC,		LocalToGlobal)	    \
x("rect-get-left",	r_g_left,   RECT_INT_FUNC,	RECTLEFT)	    \
x("rect-get-top",	r_g_top,    RECT_INT_FUNC,	RECTTOP)	    \
x("rect-get-right",	r_g_right,  RECT_INT_FUNC,	RECTRIGHT)	    \
x("rect-get-bottom",	r_g_bottom, RECT_INT_FUNC,	RECTBOTTOM)	    \
x("rect-inset",		r_inset,    RECTINT2_RECT_FUNC, InsetRect)	    \
x("rect-offset",	r_offset,   RECTINT2_RECT_FUNC, OffsetRect)	    \
x("rect-erase",		r_erase,    RECT_FUNC,		EraseRect)	    \
x("rect-frame",		r_frame,    RECT_FUNC,		FrameRect)	    \
x("rect-invert",	r_invert,   RECT_FUNC,		InvertRect)	    \
x("rect-paint",		r_paint,    RECT_FUNC,		PaintRect)	    \
x("oval-erase",		oval_erase, RECT_FUNC,		EraseOval)	    \
x("oval-frame",		oval_frame, RECT_FUNC,		FrameOval)	    \
x("oval-invert",	oval_inv,   RECT_FUNC,		InvertOval)	    \
x("oval-paint",		oval_paint, RECT_FUNC,		PaintOval)	    \
x("round-rect-erase",	r_r_erase,  RECTINT2_FUNC,	EraseRoundRect)	    \
x("round-rect-frame",	r_r_frame,  RECTINT2_FUNC,	FrameRoundRect)	    \
x("round-rect-invert",	r_r_invert, RECTINT2_FUNC,	InvertRoundRect)    \
x("round-rect-paint",	r_r_paint,  RECTINT2_FUNC,	PaintRoundRect)	    \
x("arc-erase",		arc_erase,  RECTINT2_FUNC,	EraseArc)	    \
x("arc-frame",		arc_frame,  RECTINT2_FUNC,	FrameArc)	    \
x("arc-invert",		arc_invert, RECTINT2_FUNC,	InvertArc)	    \
x("arc-paint",		arc_paint,  RECTINT2_FUNC,	PaintArc)	    \
x("text-font",		text_font,  INT_FUNC,		TextFont)	    \
x("text-face",		text_face,  INT_FUNC,		TextFace)	    \
x("text-size",		text_size,  INT_FUNC,		TextSize)	    \
x("text-mode",		text_mode,  INT_FUNC,		TextMode)	    \
x("line-to",		line_to,    INT2_FUNC,		LineTo)		    \
x("line",		line,	    INT2_FUNC,		Line)		    \
x("move-to",		move_to,    INT2_FUNC,		MoveTo)		    \
x("move",		move,	    INT2_FUNC,		Move)		    \
x("draw-char",		draw_char,  INT_FUNC,		DrawChar)	    \
x("draw-string",	draw_strg,  STRING_FUNC ,	DrawString)	    \
x("char-width",		char_width, INT_INT_FUNC,	CharWidth)	    \
x("string-width",	strg_width, STRING_INT_FUNC,	StringWidth)	    \


/*  ************************************************************************/


DECLARE_FUNCS(SUBRS, init_mac_qd)


/*  ************************************************************************/


/*  ************************************************************************/
