(create-scheme-primitive 'car '(1 *pr &se . car))
(create-scheme-primitive 'cdr '(1 *pr &se . cdr))
(create-scheme-primitive 'caaar '(1 *pr &se . caaar))
(create-scheme-primitive 'caadr '(1 *pr &se . caadr))
(create-scheme-primitive 'caar '(1 *pr &se . caar))
(create-scheme-primitive 'cadar '(1 *pr &se . cadar))
(create-scheme-primitive 'caddr '(1 *pr &se . caddr))
(create-scheme-primitive 'cadr '(1 *pr &se . cadr))
(create-scheme-primitive 'cdaar '(1 *pr &se . cdaar))
(create-scheme-primitive 'cdadr '(1 *pr &se . cdadr))
(create-scheme-primitive 'cdar '(1 *pr &se . cdar))
(create-scheme-primitive 'cddar '(1 *pr &se . cddar))
(create-scheme-primitive 'cdddr '(1 *pr &se . cdddr))
(create-scheme-primitive 'cddr '(1 *pr &se . cddr))

(create-scheme-primitive 'caaaar '(1 *pr &s4 . caaaar))
(create-scheme-primitive 'caaadr '(1 *pr &s4 . caaadr))
(create-scheme-primitive 'caadar '(1 *pr &s4 . caadar))
(create-scheme-primitive 'caaddr '(1 *pr &s4 . caaddr))
(create-scheme-primitive 'cadaar '(1 *pr &s4 . cadaar))
(create-scheme-primitive 'cadadr '(1 *pr &s4 . cadadr))
(create-scheme-primitive 'caddar '(1 *pr &s4 . caddar))
(create-scheme-primitive 'cadddr '(1 *pr &s4 . cadddr))
(create-scheme-primitive 'cdaaar '(1 *pr &s4 . cdaaar))
(create-scheme-primitive 'cdaadr '(1 *pr &s4 . cdaadr))
(create-scheme-primitive 'cdadar '(1 *pr &s4 . cdadar))
(create-scheme-primitive 'cdaddr '(1 *pr &s4 . cdaddr))
(create-scheme-primitive 'cddaar '(1 *pr &s4 . cddaar))
(create-scheme-primitive 'cddadr '(1 *pr &s4 . cddadr))
(create-scheme-primitive 'cdddar '(1 *pr &s4 . cdddar))
(create-scheme-primitive 'cddddr '(1 *pr &s4 . cddddr))

(create-scheme-primitive 'cons '(2 *pr &ls . cons))
(create-scheme-primitive 'set-car! '(2 *pr &ls . set-car!))
(create-scheme-primitive 'set-car!! '(2 *pr &ls . set-car!!))
(create-scheme-primitive 'set-cdr! '(2 *pr &ls . set-cdr!))
(create-scheme-primitive 'copy '(1 *pr &ls . copy-no-constant))
(create-scheme-primitive 'delete! '(2 *pr &ls . delete))
(create-scheme-primitive 'delq! '(2 *pr &ls . delq))
(create-scheme-primitive 'last-pair '(1 *pr &ls . last-pair))
(create-scheme-primitive 'length '(1 *pr &ls . length))
(create-scheme-primitive 'member '(2 *pr &ls . member))
(create-scheme-primitive 'nth '(2 *pr &ls . nth))
(create-scheme-primitive 'list-ref '(2 *pr &ls . list-ref))
(create-scheme-primitive 'list-tail '(2 *pr &ls . list-tail))
(create-scheme-primitive 'reverse '(1 *pr &ls . reverse))
(create-scheme-primitive 'reverse! '(1 *pr &ls . reverse!))
(create-scheme-primitive 'transpose '(1 *pr &ls . transpose))

(create-scheme-primitive 'null? '(1 *pr &pr . null?))
(create-scheme-primitive 'not 'null?)
(create-scheme-primitive 'eq? '(2 *pr &pr . eq?))
(create-scheme-primitive 'eqv? '(2 *pr &pr . eqv?))
(create-scheme-primitive 'memv '(2 *pr &pr . memv))
(create-scheme-primitive 'assv '(2 *pr &pr . assv))
(create-scheme-primitive 'assoc '(2 *pr &pr . assoc))
(create-scheme-primitive 'assq '(2 *pr &pr . assq))
(create-scheme-primitive 'port? '(1 *pr &pr . port?))
(create-scheme-primitive 'equal? '(2 *pr &pr . equal?))
(create-scheme-primitive 'string-equal? '(2 *pr &pr . equal?))
(create-scheme-primitive 'memq '(2 *pr &pr . memq))

(create-scheme-primitive 'atom? '(1 *pr &tp . atom?))
(create-scheme-primitive 'number? '(1 *pr &tp . number?))
(create-scheme-primitive 'string? '(1 *pr &tp . string?))
(create-scheme-primitive 'proc? '(1 *pr &tp . proc?)) ; 1-Mar-85
(create-scheme-primitive 'function? '(1 *pr &tp . proc?))
(create-scheme-primitive 'fix? '(1 *pr &tp . fix?)) ; 1-Mar-85
(create-scheme-primitive 'integer? '(1 *pr &tp . fix?))
(create-scheme-primitive 'float? '(1 *pr &tp . float?))
(create-scheme-primitive 'pair? '(1 *pr &tp . pair?))
(create-scheme-primitive 'ref? '(1 *pr &tp . ref?))
(create-scheme-primitive 'symbol? '(1 *pr &tp . symbol?))
(create-scheme-primitive 'syntactic-extension?
   '(1 *pr &tp . syntactic-extension?))
(create-scheme-primitive 'constant? '(1 *pr &tp . scheme-constant?))

(create-scheme-primitive 'add1 '(1 *pr &no . add1))
(create-scheme-primitive 'sub1 '(1 *pr &no . sub1))
(create-scheme-primitive '+ '(2 *pr &no . +))
(create-scheme-primitive '* '(2 *pr &no . *))
(create-scheme-primitive '- '(2 *pr &no . -))
(create-scheme-primitive 'minus '(1 *pr &no . minus))
(create-scheme-primitive '/ '(2 *pr &no . /))
(create-scheme-primitive 'quotient '(2 *pr &no . quotient))
(create-scheme-primitive 'abs '(1 *pr &no . abs))
(create-scheme-primitive 'factorial '(1 *pr &no . factorial))
(create-scheme-primitive 'floor '(1 *pr &no . fix))
(create-scheme-primitive 'ceiling '(1 *pr &no . ceiling))
(create-scheme-primitive 'truncate '(1 *pr &no . truncate))
(create-scheme-primitive 'round '(1 *pr &no . round))
(create-scheme-primitive 'fix '(1 *pr &no . fix)) ; 1-Mar-85
(create-scheme-primitive 'float '(1 *pr &no . float))
(create-scheme-primitive 'remainder '(2 *pr &no . remainder))
(create-scheme-primitive 'random '(1 *pr &no . random))
(create-scheme-primitive 'sqrt '(1 *pr &no . sqrt))

(create-scheme-primitive 'zero? '(1 *pr &np . =0))
(create-scheme-primitive '=0 '(1 *pr &np . =0)) ; 1-Mar-85
(create-scheme-primitive 'positive? '(1 *pr &np . >0))
(create-scheme-primitive '>0 '(1 *pr &np . >0)) ; 1-Mar-85
(create-scheme-primitive 'negative? '(1 *pr &np . <0))
(create-scheme-primitive '<0 '(1 *pr &np . <0)) ; 1-Mar-85
(create-scheme-primitive '= '(2 *pr &np . =))
(create-scheme-primitive '=? '(2 *pr &np . =))
(create-scheme-primitive '< '(2 *pr &np . <))
(create-scheme-primitive '<? '(2 *pr &np . <))
(create-scheme-primitive '> '(2 *pr &np . >))
(create-scheme-primitive '>? '(2 *pr &np . >))
(create-scheme-primitive '<= '(2 *pr &np . <=))
(create-scheme-primitive '<=? '(2 *pr &np . <=))
(create-scheme-primitive '>= '(2 *pr &np . >=))
(create-scheme-primitive '>=? '(2 *pr &np . >=))
(create-scheme-primitive 'string-less? '(2 *pr &np . alpha<))
(create-scheme-primitive 'alpha< '(2 *pr &np . alpha<)) ; 1-Mar-85

(create-scheme-primitive 'vector? '(1 *pr &ve . vector?))
(create-scheme-primitive 'list->vector '(1 *pr &ve . list->vector))
(create-scheme-primitive 'vector->list '(1 *pr &ve . vector->list))
(create-scheme-primitive 'vector-ref '(2 *pr &ve . vector-ref))
(create-scheme-primitive 'vector-set! '(3 *pr &ve . vector-set!))
(create-scheme-primitive 'vector-length '(1 *pr &ve . vector-length))
(create-scheme-primitive 'vector-fill! '(2 *pr &ve . vector-fill!))
(create-scheme-primitive 'primitive-make-vector
                          '(1 *pr &ve . primitive-make-vector))

(create-scheme-primitive 'close '(1 *pr &io . close))
(create-scheme-primitive 'current-column
                         '(0 *pr &io . current-column))
(create-scheme-primitive 'display '(1 *pr &io . display))
(create-scheme-primitive 'display& '(1 *pr &io . display&))
(create-scheme-primitive 'file-exists? '(1 *pr &io . file-exists?))
(create-scheme-primitive 'flush-input '(0 *pr &io . flush-input))
(create-scheme-primitive 'flush-output '(0 *pr &io . flush-output))
(create-scheme-primitive 'line-length '(0 *pr &io . line-length))
(create-scheme-primitive 'newline '(0 *pr &io . newline))
(create-scheme-primitive 'open '(2 *pr &io . open))
(create-scheme-primitive 'print '(1 *pr &io . print))
(create-scheme-primitive 'print-length '(1 *pr &io . print-length))
(create-scheme-primitive 'print& '(1 *pr &io . print&))
(create-scheme-primitive 'prompt-read '(1 *pr &io . prompt-read))
(create-scheme-primitive 'read '(0 *pr &io . read))
(create-scheme-primitive 'read-atom '(0 *pr &io . read-atom))
(create-scheme-primitive 'read-char '(0 *pr &io . read-char))
(create-scheme-primitive 'read/port '(1 *pr &io . read/port))
(create-scheme-primitive 'read-atom/port '(1 *pr &io . read-atom/port))
(create-scheme-primitive 'read-char/port '(1 *pr &io . read-char/port))
(create-scheme-primitive 'set-line-length!
                         '(1 *pr &io . set-line-length!))

(create-scheme-primitive 'pretty '(1 *pr &si . pretty))
(create-scheme-primitive 'pp-exp '(1 *pr &si . pp-exp))
(create-scheme-primitive 'compile '(1 *pr &si . compile))
(create-scheme-primitive 'mkmac-match? '(3 *pr &si . mkmac-match?))
(create-scheme-primitive 'add-mkmac-name '(1 *pr &si . add-mkmac-name))
(create-scheme-primitive 'remove-mkmac-name '(1 *pr &si . remove-mkmac-name))
(create-scheme-primitive 'add-to-syntax-table
		'(2 *pr &si . add-to-syntax-table))
(create-scheme-primitive 'expand '(1 *pr &si . beta-expand))
(create-scheme-primitive 'expand-once '(1 *pr &si . expand-once))
(create-scheme-primitive 'untag-special-form '(1 *pr &si . copying-intern*))
(create-scheme-primitive 'intern* '(1 *pr &si . copying-intern*))
(create-scheme-primitive 'beta-tag '(1 *pr &si . beta-tag))
(create-scheme-primitive 'declare-constant '(1 *pr &si . declare-constant))
(create-scheme-primitive 'undeclare-constant
                         '(1 *pr &si . undeclare-constant))
(create-scheme-primitive 'exit '(0 *pr &si . exit))
(create-scheme-primitive 'function-alias
                         '(2 *pr &si . function-alias))
(create-scheme-primitive 'gc '(0 *pr &si . gc))
(create-scheme-primitive 'top-level-assigned-identifiers
			 '(0 *pr &si . top-level-ids))
(create-scheme-primitive 'scheme-constants
                         '(0 *pr &si . scheme-constants))
(create-scheme-primitive 'syntactic-extensions
   			 '(0 *pr &si . beta-transforms))
(create-scheme-primitive 'scheme-globals 
                         '(0 *pr &si . base-identifiers)) ; 1-Mar-85
(create-scheme-primitive 'scheme-primitives
                         '(0 *pr &si . scheme-primitives)) ; 1-Mar-85
(create-scheme-primitive 'system-functions
                         '(0 *pr &si . system-functions)) ; 1-Mar-85
(create-scheme-primitive 'reify '(1 *pr &si . reify))
(create-scheme-primitive 'global-namespace-type
    '(1 *pr &si . global-namespace-type))  ; 1-Mar-85
(create-scheme-primitive 'import '(1 *pr &si . import))          ; 1-Mar-85
(create-scheme-primitive 'import-from-host '(1 *pr &si . import))
(create-scheme-primitive 'lisp-eval '(1 *pr &si . lisp-eval))
(create-scheme-primitive 'make-printable 
   '(1 *pr &si . make-printable))
(create-scheme-primitive 'make-unprintable
   '(2 *pr &si . make-unprintable))
(create-scheme-primitive 'ptime '(0 *pr &si . ptime))
(create-scheme-primitive 'remove-from-namespace
   '(1 *pr &si . remove-from-namespace))
(create-scheme-primitive 'reset '(0 *pr &si . reset))
(create-scheme-primitive 'scheme-reset '(0 *pr &si . scheme-reset))
(create-scheme-primitive 'transcript-off '(0 *pr &si . transcript-off))
(create-scheme-primitive 'transcript-on '(1 *pr &si . transcript-on))
(create-scheme-primitive 'identifier-semantics
   			 '(1 *pr &si . set-lexical-semantics))
(create-scheme-primitive 'application-semantics
   			 '(1 *pr &si . set-application-semantics))
(create-scheme-primitive 'literal-semantics
                         '(1 *pr &si . set-literal-semantics))
(create-scheme-primitive 'scoped? '(1 *pr &si . scoped?))

(create-scheme-primitive 'acos '(1 *pr &tr . arccos))
(create-scheme-primitive 'arccos '(1 *pr &tr . arccos)) ; 1-Mar-85
(create-scheme-primitive 'asin '(1 *pr &tr . arcsin))
(create-scheme-primitive 'arcsin '(1 *pr &tr . arcsin)) ; 1-Mar-85
(create-scheme-primitive 'atan '(2 *pr &tr . atan))
(create-scheme-primitive 'arctan '(1 *pr &tr . arctan)) ; 1-Mar-85
(create-scheme-primitive 'cos '(1 *pr &tr . cos))
(create-scheme-primitive 'exp '(1 *pr &tr . exp))
(create-scheme-primitive 'expt '(2 *pr &tr . expt))
(create-scheme-primitive 'log '(1 *pr &tr . log))
(create-scheme-primitive 'sin '(1 *pr &tr . sin))
(create-scheme-primitive 'tan '(1 *pr &tr . tan))
(create-scheme-primitive 'synthetic-binding
   '(2 *pr &ms . synthetic-identifier))
(create-scheme-primitive 'result '(0 *pr &ms . result))
(create-scheme-primitive 'try '(5 *pr &ms . try))
(create-scheme-primitive 'exit-try '(1 *pr &ms . exit-try))
(create-scheme-primitive 'call/ccc '(1 *pr &ms . C))
(create-scheme-primitive 'partial-cont '(2 *pr &ms . partial-cont))
(create-scheme-primitive 'append-cont '(2 *pr &ms . append-cont))
(create-scheme-primitive 'throw '(2 *pr &ms . T))
(create-scheme-primitive 'execute '(1 *pr &ms . execute))
(create-scheme-primitive 'apply '(2 *pr &ms . apply))
(create-scheme-primitive 'string->symbol '(1 *pr &ms . ascii->symbol))
(create-scheme-primitive 'ascii->symbol
                         '(1 *pr &ms . ascii->symbol)) ; 1-Mar-85
(create-scheme-primitive 'symbol->string '(1 *pr &ms . symbol->ascii))
(create-scheme-primitive 'symbol->ascii
                         '(1 *pr &ms . symbol->ascii)) ; 1-Mar-85
(create-scheme-primitive 'deref '(1 *pr &ms . deref))
(create-scheme-primitive 'explode '(1 *pr &ms . explode))
(create-scheme-primitive 'genbase '(0 *pr &ms . genbase))
(create-scheme-primitive 'gensym '(1 *pr &ms . gensym))
(create-scheme-primitive 'string->uninterned-symbol
   			'(1 *pr &ms . string->uninterned))
(create-scheme-primitive 'getprop '(2 *pr &ms . getprop))
(create-scheme-primitive 'global-binding '(1 *pr &ms . global-binding))
(create-scheme-primitive 'implode '(1 *pr &ms . implode))
(create-scheme-primitive 'proplist '(1 *pr &ms . proplist))
(create-scheme-primitive 'putprop '(3 *pr &ms . putprop))
(create-scheme-primitive 'ref '(1 *pr &ms . ref))
(create-scheme-primitive 'remprop '(2 *pr &ms . remprop))
(create-scheme-primitive 'set-ref! '(2 *pr &ms . set-ref!))
(create-scheme-primitive 'subst '(3 *pr &ms . subst))
(create-scheme-primitive 'substring '(3 *pr &ms . substring))
(create-scheme-primitive 'swap-ref! '(2 *pr &ms . swap-ref!))

(mapc (function declare-constant) (scheme-primitives))

(create-system-function 'concat 'concat)
(create-system-function 'max 'max)
(create-system-function 'min 'min)
(create-system-function 'append 'append)
(create-system-function 'append! 'nconc)

(mapc (function declare-constant) (system-functions))
