(eval-when (load compile) (setsyntax 35 'vcharacter))

(declare (special core-ids fal **fnv** temp temp1 host-macs tagged-id))

(setq core-ids '(#!if #!lambda #!set!))

(def identity
   (lambda (x) x))

(def ormap
   (lambda (f l)
      (cond
	 [(dtpr l) (or (funcall f (car l)) (ormap f (cdr l)))]
	 [t nil])))

(def mapcar/atom
   (lambda (f l)
      (cond
	 [(dtpr l) (cons (funcall f (car l)) (mapcar/atom f (cdr l)))]
	 [t l])))

(def transform?
   (macro (l) `(eq (car ,(cadr l)) '&transform)))

(def st-lookup
   (lambda (id)
      (cond ((dtpr id) (and (transform? id) id))
	    (t (get id 'beta-transform)))))

(def host-mac?
   (macro (l) `(memq ,(cadr l) host-macs)))

(def syntax?
   (macro (l) `(st-lookup ,(cadr l))))
  
(def case
   (macro (*pattern*)
	  (list 'let
	     (list (list '*tag* (cadr *pattern*)))
	     (cons 'cond
		(mapcar (function
			   (lambda (^00005)
			      (cons
				 (cond ((not (atom (car ^00005)))
					(list 'memq '*tag*
					   (list 'quote (car ^00005))))
				       ((eq 'else (car ^00005)) t)
				       (t (list 'eq
					     (list 'quote (car ^00005))
					     '*tag*)))
				 (cdr ^00005))))
		   (cddr *pattern*))))))

(def runner
   (lambda (expander e body)
      (newnames
	 (funcall expander
	    (copy-no-constant-no-quote
	       (let ([**fnv** **fnv**])
		  (vsm '((*pr &ms . apply) (*re))
			'((((*pr &ms . result))) nil)
			nil
			(list (list (tag-frees e nil)))
			body))))
	 nil)))

(def expand-type
   (lambda (f type e)
      (cond
	 [(host-mac? type) (funcall f (host-mac-dispatch e))]
	 [(eq type '#!lambda)
	  `(#!lambda ,(copy (cadr e)) .
	      ,(mapcar f (cddr e)))]
	 [(eq type '#!if)
	  `(#!if .,(mapcar f (cdr e)))]
	 [(eq type '#!set!)
	  `(#!set! ,(cadr e) . ,(mapcar f (cddr e)))]
	 [(eq type 'quote) e]
	 [t (cons type (mapcar/atom f (cdr e)))])))

(def walk/s-exp!
   (lambda (f l extra)
      (cond
	 [(dtpr l) (walk/box! f l extra)])))

(def walk/box!
   (lambda (f l extra)
      (rplaca l (funcall f (car l) extra))
      (let ([temp (cdr l)]) 
	 (cond 
	    [(null temp) nil]
	    [(dtpr temp) (walk/box! f temp extra)]
	    [t (rplacd l (funcall f temp extra))]))))

(def tag
   (lambda (id)
      (let ([p (uconcat id '-beta)])
	 (putprop p id 'istagged)
	 (setq fal (cons (cons id p) fal))
	 p)))

(def tag-frees
   (lambda (e keys)
      (case (type-of e)	 
	 [identifier
	    (cond 
	       [(memq e keys) e]
	       [(memq e core-ids) e]
	       [(eq e 'quote) e]
	       [(host-mac? e) e]
	       [t (let ([p (assq e fal)])
		     (cond [p (cdr p)]
			   [t (tag e)]))])]
	 [combination
	    (cond [(atom (car e))
		   (let ([tform (syntax? (car e))])
		      (cond
			 [tform (walk/s-exp! 
				   'tag-frees
				   (cdr e)
				   (append (cadr tform) keys))]
			 [t (walk/s-exp! 'tag-frees e keys)]))]
		  [(transform? (car e))
		   (walk/s-exp! 
		      'tag-frees
		      (cdr e)
		      (append (cadar e) keys))]
		  [t (walk/s-exp! 'tag-frees e keys)])
	    e]
	 [constant e]
	 [else (walk/s-exp! 'tag-frees (cdr e) keys)
	       e])))
	  
(def type-of
   (lambda (e)
      (cond
	 [(atom e)
	  (cond [(numberp e) 'constant]
		[(memq e '(t nil)) 'constant]
		[(stringp e) 'constant]
		[t 'identifier])]
	 [(memq (car e) core-ids) (car e)]
	 [(eq (car e) 'quote) 'quoted-exp]
	 [(proc? e) 'constant]
	 [t 'combination])))

(def lexpand
   (lambda (e)
      (cond [(atom e) e]
	    [(proc? e) e]
	    [t (let ([temp (car e)])
		  (cond
		     [(atom temp)
		      (let ([temp1 (syntax? temp)])
			 (cond
			    [temp1 (runner
				      'lexpand2
				      (copy-no-constant e)
				      (caddr temp1))]
			    [t (expand-type 'lexpand temp e)]))]
		     [(transform? (car e)) (runner
					      'lexpand2
					      (copy-no-constant e)
					      (caddar e))]
		     [t (mapcar/atom 'lexpand e)]))])))

(def lexpand-no-copy
   (lambda (e)
      (cond [(atom e) e]
	    [(proc? e) e]
	    [t (let ([temp (car e)])
		  (cond
		     [(atom temp)
		      (let ([temp1 (syntax? temp)])
			 (cond 
			    [temp1 (runner 'lexpand2 e (caddr temp1))]
			    [t (expand-type 'lexpand-no-copy temp e)]))]
		     [(transform? (car e)) (runner 'lexpand2 e (caddar e))]
		     [t (mapcar/atom 'lexpand-no-copy e)]))])))
	  
(def lexpand2
   (lambda (e)
      (cond [(atom e) e]
	    [(proc? e) e]
	    [t (let ([temp (car e)])
		  (cond
		     [(atom temp)
		      (cond [(st-lookup temp) (beta-expand2 e)]
			    [t (expand-type 'lexpand2 temp e)])]
		     [(transform? (car e)) (beta-expand2 e)]
		     [t (mapcar/atom 'lexpand2 e)]))])))

(def newnames
   (lambda (e r)
      (case (type-of e)
	 [identifier (let ([pair (assq e r)])
			(cond [pair (cdr pair)]
			      [t (let ([i (get e 'istagged)])
				    (cond (i i)
					  (t e)))]))]
	 [constant e]	 
	 [quoted-exp
	    (cond [(atom (cdr e)) (rplacd e (intern* (cdr e)))]
		  [t (rplaca (cdr e) (intern* (cadr e)))])
	    e]
	 [#!lambda
	    (let ((c1 (cdr e)))		
	       (let ([args (let ([a (car c1)])
			      (cond ((null a) a)
				    ((atom a) (cons a nil))
				    (t (legal-args a nil))))])
		  (prog (temp args*)
			(setq args* args)
			loop (cond
				[(null args*) (return nil)])
			     (setq temp (assq (car args*) r))
			     (cond
				[temp (setq r (delq temp r))])
			     (setq args* (cdr args*))
			     (go loop))
		  (let ([newrib (getused args (cdr c1))])
		     (rplaca c1 (newnames (car c1) newrib))
		     (walk/s-exp! 
			'newnames
			(cdr c1)
			(append newrib r))
		     e)))]
	 [else 
	    (walk/s-exp! 'newnames e r)
	    e])))
	  
(def legal-args
   (lambda (l ans)
      (let ([temp (cdr l)]
	    [ans (cons (car l) ans)])
	 (cond [(null temp) ans]
	       [(dtpr temp) (legal-args temp ans)]
	       [t (cons temp ans)]))))

(def getused
   (lambda (bvl body)
      (cond [(null bvl) nil]
	    [(let ([pair (assq (car bvl) fal)])
		(and pair (conflicting0 (car bvl) body)))
	     ; is (car bvl) something that got tagged
	     ;    and does the tagged form appear in the body?
	     (cons (cons (car bvl) (gensym '^))
		   (getused (cdr bvl) body))]
	    [t (getused (cdr bvl) body)])))

(def conflicting0
   (lambda (tagged-id body)
      (ormap 'conflicting1 body)))

(def conflicting1
   (lambda (e)
      (case (type-of e)
	 [constant nil]
	 [identifier (let ([temp (tagged? e)])
			(cond
			   [temp (eq tagged-id temp)]
			   [t nil]))]
	 [quoted-exp nil]
	 [#!lambda (let ([args (let ([a (cadr e)])
				  (cond
				     [(null a) a]
				     [(dtpr a) (legal-args a nil)]
				     [t (cons a nil)]))])
		      (or (ormap 'conflicting1 args)
			  (ormap 'conflicting1 (cddr e))))]
	 [#!if (ormap 'conflicting1 (cdr e))]
	 [#!set! (ormap 'conflicting1 (cdr e))]
	 [else (ormap 'conflicting1 e)])))

;(def quote-conflicting
;   (lambda (s)
;      (cond
;	 [(eq (type-of s) 'constant) nil]
;	 [(dtpr s) 
;	  (cond
;	     [(memq s boxes) nil]
;	     [t (setq boxes (cons s boxes))
;		(or (quote-conflicting (car s))
;		    (quote-conflicting (cdr s)))])]
;	 [t (let ([temp (tagged? s)])
;	       (cond [temp (eq temp tagged-id)]
;		     [t nil]))])))	  
;
;(def conflicting1
;   (lambda (tagged-id body) ; tagged-id is untagged form of a tagged ident
;      (cond ((null body) nil)
;	    ((dtpr body)
;	     (case
;	     (cond ((eq (car body) 'quote)
;		    (prog2 (setq boxes nil)
;			   (quote-conflicting (cadr body))
;			   (setq boxes nil)))
;		   (t (or (conflicting1 tagged-id (car body))
;			  (conflicting1 tagged-id (cdr body))))))
;	    ((setq temp (tagged? body)) (eq temp tagged-id)))))

(def tagged?
   (lambda (id) (get id 'istagged)))

(def expand-once
   (lambda (e)
      (cond [(setq temp (st-lookup (car e)))
	     (setq fal nil)
	     (let ([ans (runner
			   'identity
			   (copy-no-constant e)
			   (caddr temp))])
		(setq fal nil)
		ans)]
	    [(host-mac? (car e)) (host-mac-dispatch e)]
	    [t (raise (list 'SE%expand 0 t 'expand-once:
			 '|car of expression is not a syntactic extension: |
			 (car e)))])))

(def beta-expand
   (lambda (e)
      (setq fal nil)
      (let ([ans (lexpand e)])
	 (setq fal nil)
	 ans)))

(def beta-expand2
   (lambda (e)
      (let ([current-fal fal])
	 (setq fal nil)
	 (let ([ans (lexpand-no-copy e)])
	    (setq fal current-fal)
	    ans))))

(def add-to-syntax-table
   (lambda (keywords transform)
      (let ([type (global-namespacetype (car keywords))])
	 (cond [(or (null type)
		    (eq type 'syntactic-extension)
		    (eq type 'special-form))
		(putprop
		   (car keywords)
		   (cons '&transform
		      (cons keywords (cons transform nil)))
		   'beta-transform)
		(car keywords)]
	       [t (raise
		     (list 'SE%add-to-syntax-table 0 t 'add-to-syntax-table:
			(concat (car keywords) '| already defined as a|)
			type))]))))

(def mkmac-match?
   (lambda (a k p)
      (cond ((eq (car a) (car p)) (mm? a k p))
	    ((and (transform? (car a)) (eq (caadr (car a)) (car p)))
	     (mm? (cdr a) k (cdr p)))
	    (t nil))))

(def mm?
   (lambda (a k p)
      (cond
	 [(and (null p) (null a)) t]
	 [(null p) nil]
	 [(atom p) (cond ((atom a) (cond ((memq p k) (eq a p))
					 (t t)))
			 (t (not (memq p k))))]
	 [(null a) (cond [(null (cdr p)) nil]
			 [(eq (cadr p) '...) t]
			 [t nil])]
	 [(atom a) nil]
	 [(null (cdr p)) (and (null (cdr a))
			      (mm? (car a) k (car p)))]
	 [(null (cddr p)) (cond ((eq '... (cadr p)) t)
				(t (and (mm? (car a) k (car p))
					(mm? (cdr a) k (cdr p)))))]
	 [(eq '... (cadr p)) (let ([v (memq (caddr p) a)])
				(cond (v (mm? v k (cddr p)))
				      (t nil)))]
	 [t (and (mm? (car a) k (car p))
		 (mm? (cdr a) k (cdr p)))])))

(def intern*
   (lambda (x)
      (cond
	 [(eq (type-of x) 'constant) x]
	 [(dtpr x) 
	  (rplaca x (intern* (car x)))
	  (rplacd x (intern* (cdr x)))
	  x]
	 [(setq temp (get x 'istagged)) temp] ; (intern* temp) ?
	 [t x])))

(def copying-intern*
   (lambda (x)
      (cond
	 [(eq (type-of x) 'constant) x]
	 [(dtpr x) (cons (copying-intern* (car x))
			 (copying-intern* (cdr x)))]
	 [(setq temp (get x 'istagged)) temp] ; (intern* temp) ?
	 [t x])))

(def copy-no-constant
   (lambda (l)
      (gc)
      (copy-no-constant* l)))

(def copy-no-constant*
   (lambda (l)
      (cond
	 [(atom l) l]
	 [(eq (type-of l) 'constant) l]
	 [t (cons (copy-no-constant* (car l))
		  (copy-no-constant* (cdr l)))])))

(def copy-no-constant-no-quote
   (lambda (l)
      (gc)
      (copy-no-constant-no-quote* l)))

(def copy-no-constant-no-quote*
   (lambda (l)
      (cond
	 [(atom l) l]
	 [t (let ((type (type-of l)))
	       (cond ((memq type '(constant quoted-exp)) l)
		     (t (cons (copy-no-constant-no-quote* (car l))
			      (copy-no-constant-no-quote* (cdr l))))))])))
