; VARARGS.S
;************************************************************************
;*									*
;*		PC Scheme/Geneva 4.00 Scheme code			*
;*									*
;* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
;* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;*	"Funarg" ie Variable Lengths Function Backups for Primitives	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;* Created by: David Bartley		Date: Oct 1985			*
;* Revision history:							*
;* - 13 Apr 87: Funarg handler for make/string (tc)			*
;* - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
;*									*
;*					``In nomine omnipotentii dei''	*
;************************************************************************

;				   NOTE:				   ;
;									   ;
;	Most of these routines are defined in terms of primitive	   ;
;	operations with the same name.	Thus, they must be compiled	   ;
;	with PCS-INTEGRATE-PRIMITIVES set true.  Also, be sure not to	   ;
;	use DEFREC!, LETREC, REC, etc., incorrectly.			   ;

(define *						; *
  (lambda args	; for funarg use, don't use DEFREC!
    (cond ((null? args)
	   1)
	  (else (do ((a (car args) (* a (car x)))
		  (x (cdr args) (cdr x)))
		 ((null? x) a))))))

(define +						; +
  (lambda args	; for funarg use, don't use DEFREC!
    (cond ((null? args)
	   0)
	  (else (do ((a (car args) (+ a (car x)))
		  (x (cdr args) (cdr x)))
		 ((null? x) a))))))

(define -						; -
  (lambda args	; for funarg use, don't use DEFREC!
    (cond ((null? args)
	   0)
	  ((null? (cdr args))
	   (- (car args)))
	  (else (do ((a (car args) (- a (car x)))
		  (x (cdr args) (cdr x)))
		 ((null? x) a))))))

(define /						; /
  (lambda args	; for funarg use, don't use DEFREC!
    (cond ((null? args)
	   1)
	  ((null? (cdr args))
	   (/ 1 (car args)))
	  (else (do ((a (car args) (/ a (car x)))
		  (x (cdr args) (cdr x)))
		 ((null? x) a))))))

(define <=						; <=
  (lambda args
    (cond ((null? (cdr args)) #T)
	  (else (do ((args args (cdr args))
		     (res #T (and res (<= (car args) (cadr args)))))
		    ((or (not res) (null? (cdr args))) res))))))

(define >=						; >=
  (lambda args
    (cond ((null? (cdr args)) #T)
	  (else (do ((args args (cdr args))
		     (res #T (and res (>= (car args) (cadr args)))))
		    ((or (not res) (null? (cdr args))) res))))))

(define <						; <
  (lambda args
    (cond ((null? (cdr args)) #T)
	  (else (do ((args args (cdr args))
		     (res #T (and res (< (car args) (cadr args)))))
		    ((or (not res) (null? (cdr args))) res))))))

(define >						; >
  (lambda args
    (cond ((null? (cdr args)) #T)
	  (else (do ((args args (cdr args))
		     (res #T (and res (> (car args) (cadr args)))))
		    ((or (not res) (null? (cdr args))) res))))))

(define =						; =
  (lambda args
    (cond ((null? (cdr args)) #T)
	  (else (do ((args args (cdr args))
		     (res #T (and res (= (car args) (cadr args)))))
		    ((or (not res) (null? (cdr args))) res))))))

(define <>						; <>
  (lambda args
    (cond ((null? (cdr args)) #T)
	  (else (do ((args args (cdr args))
		     (res #T (and res (<> (car args) (cadr args)))))
		    ((or (not res) (null? (cdr args))) res))))))

(define append						; APPEND
  (letrec		; for funarg use
    ((append*
      (lambda (args)
	(cond ((null? args)
	       '())
	      ((null? (cdr args))
	       (car args))
	      ((null? (cddr args))
	       (%append (car args)(cadr args)))
	      (else
	       (%append (car args) (append* (cdr args))))))))
    (lambda args
      (append* args))))

(define append! 					; APPEND!
  (letrec		; for funarg use
    ((append!*		; don't use DEFREC!
      (lambda (args)
	(cond ((null? args)
	       '())
	      ((null? (cdr args))
	       (car args))
	      ((null? (cddr args))
	       (append! (car args) (cadr args)))
	      (else
	       (append! (car args) (append!* (cdr args))))))))
    (lambda args
       (append!* args))))

(define bitwise-and					; BITWISE-AND, OR, XOR
  (lambda (first . args)	; force one argument
    (do ((a first (bitwise-and a (car x)))
	 (x args (cdr x)))
	((null? x) a))))

(define bitwise-or
  (lambda args
    (if (null? args)
	0
	(do ((a (car args) (bitwise-or a (car x)))
	     (x (cdr args) (cdr x)))
	    ((null? x) a)))))

(define bitwise-xor
  (lambda args
    (if (null? args)
	0
	(do ((a (car args) (bitwise-xor a (car x)))
	     (x (cdr args) (cdr x)))
	    ((null? x) a)))))

(define char-ready?					; CHAR-READY?
  (lambda args			; for funarg uses
    (char-ready? (car args))))	; don't define with defrec!

(define display 					; DISPLAY
  (lambda (exp . rest)		; for funarg uses
    (display exp		; don't define with defrec!
	     (car rest))))

(define list						; LIST
  (lambda x x))   ; (for funarg use)

(define list*						; LIST*
  (lambda x	  ; (for funarg use)
    (let loop ((x x))
	 (cond ((atom? x)	x)
	       ((atom? (cdr x)) (car x))
	       (else (cons (car x) (loop (cdr x))))))))

(define make-vector					; MAKE-VECTOR
  (lambda (size . rest)  ; for funarg use, don't use DEFREC!
    (let ((v (make-vector size)))
      (when rest
	    (vector-fill! v (car rest)))
      v)))

(define make-string					; MAKE-STRING
  (lambda (size . rest)  ; for funarg use, don't use DEFREC!
    (make-string size		; don't define with defrec!
		 (car rest))))

(define max						; MAX
  (lambda args	; for funarg use, don't use DEFREC!
    (if (null? args)
	0
	(do ((a (car args) (max a (car x)))
	     (x (cdr args) (cdr x)))
	    ((null? x) a)))))

(define min						; MIN
  (lambda args	; for funarg use, don't use DEFREC!
    (if (null? args)
	0
	(do ((a (car args) (min a (car x)))
	     (x (cdr args) (cdr x)))
	    ((null? x) a)))))

(define newline 					; NEWLINE
  (lambda args			; for funarg uses
    (newline (car args))))	; don't define with defrec!

(define prin1						; PRIN1
  (lambda (exp . rest)		; for funarg uses
    (prin1 exp (car rest))))	; don't define with defrec!

(define princ						; PRINC
  (lambda (exp . rest)		; for funarg uses
    (princ exp (car rest))))	; don't define with defrec!

(define print						; PRINT
  (lambda (exp . rest)		; for funarg uses
    (print exp (car rest))))	; don't define with defrec!

(define read-line					; READ-LINE
  (lambda args			; for funarg uses
    (read-line (car args))))	; don't define with defrec!

(define read-atom					; READ-ATOM
  (lambda args			; for funarg uses
    (read-atom (car args))))	; don't define with defrec!

(define read-char					; READ-CHAR
  (lambda args			; for funarg uses
    (if (or (not args) (window? (car args)))
	(let* ((win (if args (car args) (current-input-port)))
	       (pos (window-get-position win))
	       (cur (window-get-cursor win)))
	  (%esc 42 1 
		(+ (car cur) (car pos))
		(+ (cdr cur) (cdr pos)))
	  ((named-lambda (wait)	; don't define with defrec!
	     (if (char-ready? (car args))
		 (begin (%esc 42 0)
			(%read-char (car args)))
		 (wait)))))
	(%read-char (car args)))))

(define unread-char					; UNREAD-CHAR
  (lambda args			; for funarg uses
    (unread-char (car args))))	; don't define with defrec!

							; STRING-APPEND
;; STRING-APPEND should be moved here from PCHREQ.S
;; (for funarg definition) for consistency

(define vector						; VECTOR
  (lambda L
    (list->vector L)))

(define write						; WRITE
  (lambda (exp . rest)		; for funarg uses
    (write exp (car rest))))	; don't define with defrec!

(define write-char					; WRITE-CHAR
  (lambda (exp . rest)		    ; for funarg uses
    (write-char exp (car rest))))   ; don't define with defrec

(define %graphics					; %graphics (BGI)
  (lambda (func . rest)					; at least one arg (required for return value)
    (%execute (compile `(%graphics ,func ,@rest)))
    *the-non-printing-object*))

(define %mouse						; %mouse
  (lambda (func . rest)					; at least one arg (required for return value)
    (%execute (compile `(%mouse ,func ,@rest)))))

(define %esc						; %esc (C functions)
  (lambda (func . rest)
    (%execute (compile `(%esc ,func ,@rest)))))

