/* READ.C
 ************************************************************************
 *									*
 *		PC Scheme/Geneva 4.00 Borland C code			*
 *									*
 * (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
 * (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
 *									*
 *----------------------------------------------------------------------*
 *									*
 *		Scheme Expression Reading				*
 *									*
 *----------------------------------------------------------------------*
 *									*
 * Created by: Mark E. Meyer		Date: Jun 1984			*
 * Revision history:							*
 * - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
 *									*
 *					``In nomine omnipotentii dei''	*
 ************************************************************************/

#include	"scheme.h"

extern char	decpoint;	/* Current decimal point character */

#define ATOM 0			/* Codes returned by FINDTASK function */
#define NIL 1
#define LPAREN 2
#define RPAREN 3
#define QUOTE 4
#define DOT 5

#define DS 0			/* Register array subscripts */
#define PG 1

/****************************************************************/
/* SCANFLO(s,flo,base)						*/
/* The string S, which ends in a control char, holds a		*/
/* representation of a floating-point number.	The value of	*/
/* this number is stored in *FLO.				*/
/****************************************************************/
void	scanflo(char *s, double *flo, int base)
{
	int		i = 0;
	int		neg = 0;
	int		x = 0;
	double		place;

	switch (*s) {
	case '-':
		neg = -1;
	case '+':
		i++;
		break;
	default:
		break;
	}
	while (s[i] == '#')
		i += 2;
	*flo = 0.0;
	while (isdig(s[i], base)) {
		*flo = (*flo * base) + digval(s[i++]);
	}
	if (!(s[i] == decpoint))
		goto EXPON;
POINT:
	i++;
	place = 1.0;
	while (isdig(s[i], base)) {
		place /= base;
		*flo += place * digval(s[i++]);
	}
	if (s[i] < ' ')
		goto GOTFLO;
EXPON:
	i++;
	if (s[i] == '-') {
		i++;
		place = 1.0 / base;
	} else
		place = base;
	while (isdigit(s[i]))
		x = (x * 10) + digval(s[i++]);
	while (x) {
		if (x != (x >> 1) << 1)
			*flo *= place;
		if (place < 1.0e153)
			place *= place;
		x >>= 1;
	}
GOTFLO:
	if (neg)
		*flo = -*flo;
}


/****************************************************************/
/* ALLOC_INT(reg,buf)						*/
/* This allocates an integer, either a fixnum or a		*/
/* bignum, depending on the size of the integer, i.e., if	*/
/* the absolute value < 16384, then a fixnum is allocated.	*/
/* The value is read from BUF.					*/
/****************************************************************/
void	alloc_int( REGPTR reg, BIGDATA *buf )
{
	while( buf->len > 1 && buf->data[buf->len-1] == 0 )
		buf->len--;
	if( buf->len == 1 && buf->data[0] <= 0x7fff + (buf->sign & 1) )
		alloc_fixnum( reg, (buf->sign & 1) ? -buf->data[0] : buf->data[0] );
	else {
		alloc_block( reg, BIGTYPE, 2 * buf->len + 1 );
		toblock( reg, 3, &(buf->sign), 2 * buf->len + 1 );
	}
}
