;* TIMER.ASM
;************************************************************************
;*									*
;*		PC Scheme/Geneva 4.00 Borland TASM code			*
;*									*
;* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
;* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;*	    		Timer & Engine support				*
;*									*
;*----------------------------------------------------------------------*
;*									*
;* Created by: John Jensen		Date: 1985			*
;* Revision history:							*
;* - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
;*									*
;*					``In nomine omnipotentii dei''	*
;************************************************************************
IDEAL
%PAGESIZE	60, 132
MODEL	medium
LOCALS	@@

	INCLUDE	"scheme.ash"

GET_VEC	EQU	35h 			;DOS call to retrieve interrupt vector
SET_VEC	EQU	25h 			;DOS call to set vector
TIMER_INT EQU	1ch 			;18.2 Hz timer interrupt number

CODESEG

tickstat DB	-1 			;0=timeout, 1=engine running,
					;-1=no engine running (normal)
clk_ptr	DD	0			;Former timer vector
time	DD	0 			;Timer ticks

;************************************************************************
;*     Start timer running						*
;*	Calling sequence: set_timer(hi,lo)				*
;*	      Where ---- hi,lo: upper,lower words of initial timer value*
;*     Returns nonzero iff the set was during normal VM running mode	*
;************************************************************************
PROC C	settimer USES si di, @@hi:word, @@lo:word
	xor	ax, ax 			;Clear ax
	cmp	[cs:tickstat], -1 	;Check for normal run mode
	jne	@@running
	push	es
	mov	ah, GET_VEC 		;Put present timer interrupt vector
	mov	al, TIMER_INT 		;  into es:bx
	int	MSDOS
	mov	[WORD LOW cs:clk_ptr], bx
	mov	[WORD HIGH cs:clk_ptr], es
	pop	es
	mov	ax, [@@hi]		;Set timer
	mov	[WORD HIGH cs:time], ax
	mov	ax, [@@lo]
	mov	[WORD LOW cs:time], ax
	push	ds
	mov	ah, SET_VEC 		;Set new interrupt vector
	mov	al, TIMER_INT
	push	cs 			;Put vector segment number in ds
	pop	ds
	lea	dx, [tickhandler]
	int	MSDOS
	pop	ds
	mov	al, 1 			;Denote engine running
	mov	[cs:tickstat], al
@@running:
	ret
ENDP	settimer

;************************************************************************
;*     Stop the timer							*
;*	Calling sequence: rst_timer();					*
;*     Returns the number in the counter at the time of reset		*
;************************************************************************
PROC C	rsttimer USES si di
	cmp	[cs:tickstat], 1	;Only if timeout or engine running
	ja	@@noreset
	mov	ah, SET_VEC 		;Prepare to reset timer interrupt
	mov	al, TIMER_INT
	push	ds
	lds	dx, [cs:clk_ptr]	;Put original vector into ds:dx
	int	MSDOS
	pop	ds
	mov	[cs:tickstat], -1 	;Denote normal mode
@@noreset:
	mov	dx, [WORD HIGH cs:time]	;Return 32-bit clock value
	mov	ax, [WORD LOW cs:time]
	ret
ENDP	rsttimer

;************************************************************************
;*			The new timer code				*
;************************************************************************
PROC	tickhandler	far
	sti
	cmp	[cs:tickstat], 0	;If timeout, do nothing special
	je	@@return
	sub	[WORD LOW cs:time], 1	;Otherwise decrement counter
	sbb	[WORD HIGH cs:time], 0
	jnz	@@return
	cmp	[WORD LOW cs:time], 0	;Is the counter down ?
	jnz	@@return
	mov	[cs:tickstat], 0	;Record timeout event
	call	force_timeout C
@@return:
	jmp	[cs:clk_ptr]		;Jump to original timer code
ENDP	tickhandler

	END

