/* -*-C-*-

Copyright (c) 1987-1992 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. */

/* $Header: /scheme/src/microcode/RCS/comlin.h,v 1.5 1992/04/18 00:27:35 jinx Exp $
 *
 * This file contains definitions for the scheme command parser.
 *
 */

#ifndef COMLIN_H_INCLUDED
#define COMLIN_H_INCLUDED

#include "ansidecl.h"

#ifndef boolean
#  define boolean	int
#endif
#ifndef true
#  define true		1
#endif
#ifndef false
#  define false		0
#endif

typedef char *string;

/* Argument List Keyword Descriptor Structure */

#define LAST_KYWRD	0
#define BOOLEAN_KYWRD	1
#define INT_KYWRD	2
#define DOUBLE_KYWRD	3
#define STRING_KYWRD	4

#define BOOLEAN_LVALUE(struc)	((boolean *) ((struc).data))
#define INT_LVALUE(struc)	((int *) ((struc).data))
#define DOUBLE_LVALUE(struc)	((double *) ((struc).data))
#define STRING_LVALUE(struc)	((string *) ((struc).data))

struct keyword_struct
{
  int		type_tag;
  string	keyword;
  long		*data;
  string	format;
  boolean	*supplied_p;
};

#define KEYWORD(str, var, type, format, sup)				\
{									\
  type,									\
  ((string) str),							\
  ((long *) var),							\
  format,								\
  sup									\
}

#define END_KEYWORD()	KEYWORD("", NULL, LAST_KYWRD, NULL, NULL)

/* Fake boolean and string formats */

#define BFRMT	((string) NULL)
#define SFRMT	((string) NULL)

/* Exports */

extern char *program_name;

extern void EXFUN (parse_keywords,
		   (int, char **, struct keyword_struct *, boolean));

#endif /* COMLIN_H_INCLUDED */
