/* Copyright  1991 Gustavus Adolphus College.  All rights reserved.
 *
 * Schematik was developed by Gustavus Adolphus College (GAC) with
 * support from NeXT Computer, Inc.  Permission to copy this software,
 * to redistribute it, and to use it for any purpose is granted,
 * subject to the following restrictions and understandings.
 *
 * 1. Any copy made of this software must include this copyright
 * notice in full.
 *
 * 2. Users of this software agree to make their best efforts (a) to
 * return to the GAC Mathematics and Computer Science Department any
 * improvements or extensions that they make, so that these may be
 * included in future releases; and (b) to inform GAC of noteworthy
 * uses of this software.
 *
 * 3. All materials developed as a consequence of the use of this
 * software shall duly acknowledge such use, in accordance with the
 * usual standards of acknowledging credit in academic research.
 *
 * 4. GAC makes no express or implied warranty or representation of
 * any kind with respect to this software, including any warranty
 * that the operation of this software will be error-free.  ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
 * PURPOSE IS HEREBY DISCLAIMED.  GAC is under no obligation to
 * provide any services, by way of maintenance, update, or otherwise.
 *
 * 5. In conjunction with products arising from the use of this
 * material, there shall be no use of the name of Gustavus Adolphus
 * College nor of any adaptation thereof in any advertising,
 * promotional, or sales literature without prior written consent
 * from GAC in each case.
 */

#import "InteractionWin.h"
#import "../defines.h"
#import DocText_h
#import PrefAgent_h
#import Main_h
#import <appkit/Menu.h>
#import <appkit/ScrollView.h>
#import <appkit/TextFieldCell.h>
#import <mach.h>

extern void *malloc(size_t);
extern void free(void *);
extern size_t strlen(const char *);

#define NIBFILE		"Interaction.nib"
#define INTERZONENAME	"InterWin"
#define MINIWINDOWICON	"Interaction"
#define MINWINDOWHEIGHT	103
#define MINWINDOWWIDTH	450

@implementation InteractionWin

+ new
{
    NXRect r;
    NXZone *zone = NXCreateZone(vm_page_size, vm_page_size, YES);

DEBUG_FUNC1(DEBUGLEVEL);
    DEBUG_ASSERT(zone!=NULL)
    self = LoadNIB(NIBFILE, self, zone); 
    DEBUG_ASSERT(self!=nil)
    docZone = zone;
    NXNameZone(docZone, INTERZONENAME);
    [self _newAuxiliary];
    [[PrefAgent new] getInterFrame:&r];
    [self placeWindow:&r];
    [self setTitle:INTERWINDOWTITLE];
    DEBUG_ASSERT(([self title]!=NULL)&&(*[self title]))
    [self setMiniwindowIcon:MINIWINDOWICON];
    DEBUG_ASSERT(([self miniwindowIcon]!=NULL)&&(*[self miniwindowIcon]))
    [levelText setStringValue:LEVELTITLE];
    DEBUG_ASSERT(([levelText stringValue]!=NULL)&&(*[levelText stringValue]))
    return self;
}

- setTitleAsFilename:(const char *)aString
{
    char *temp;
    
    [super setTitleAsFilename:aString];
    temp = malloc(strlen([super title])+strlen(INTERWINDOWTITLE)+4);
    sprintf(temp, "%s (%s)", INTERWINDOWTITLE, [super title]);
    [super setTitle:temp];
    free(temp);
    return self;
}

- setLevel:(int)anInt
{
DEBUG_FUNC1(DEBUGLEVEL);
    return [levelField setIntValue:anInt];
}

- setPrompt:(const char *)aString
{
DEBUG_FUNC1(DEBUGLEVEL);
    return [promptField setStringValue:aString];
}

@end

@implementation InteractionWin (Delegate)

- textDidGetKeys:sender isEmpty:(BOOL)flag
{
DEBUG_FUNC1(DEBUGLEVEL);
    return [super setDocEdited:YES];
}

- textWillConvert:sender fromFont:from toFont:to
{
DEBUG_FUNC1(DEBUGLEVEL);
    [[PrefAgent new] setInterFont:to];
    return to;
}

- windowDidMove:sender
{
    NXRect r;

DEBUG_FUNC1(DEBUGLEVEL);
    [super getFrame:&r];
    return [[PrefAgent new] setInterFrame:&r];
}

- windowDidResize:sender
{
    NXRect r;

DEBUG_FUNC1(DEBUGLEVEL);
    [super getFrame:&r];
    return [[PrefAgent new] setInterFrame:&r];
}

- windowDidBecomeMain:sender
{
DEBUG_FUNC1(DEBUGLEVEL);
    DisableMenuItem(FindMenuCell2(MENU_DOCUMENT, MENU_DOCUMENT_Close));
    DisableMenuItem(FindMenuCell2(MENU_WINDOWS, MENU_WINDOWS_Close));
    if (![[PrefAgent new] evaluateAll])
      DisableMenuItem(FindMenuCell2(MENU_ACTIONS, MENU_ACTIONS_EvalAll));
    return self;
}

- windowDidResignMain:sender
{
DEBUG_FUNC1(DEBUGLEVEL);
    EnableMenuItem(FindMenuCell2(MENU_DOCUMENT, MENU_DOCUMENT_Close));
    EnableMenuItem(FindMenuCell2(MENU_WINDOWS, MENU_WINDOWS_Close));
    EnableMenuItem(FindMenuCell2(MENU_ACTIONS, MENU_ACTIONS_EvalAll));
    return self;
}

- windowWillResize:sender toSize:(NXSize *)frameSize
{
DEBUG_FUNC1(DEBUGLEVEL);
    if (frameSize->width<MINWINDOWWIDTH)
      frameSize->width = MINWINDOWWIDTH;
    if (frameSize->height<MINWINDOWHEIGHT)
      frameSize->height = MINWINDOWHEIGHT;
    return self;
}

@end
