/*
     libscheme	
     Copyright (C) 1994 Brent Benson

     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 1, or (at your option)
     any later version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "scheme.h"

/* locals */
static Scheme_Object *scheme_eval_combination (Scheme_Object *comb, Scheme_Env *env);
static Scheme_Object *eval (int argc, Scheme_Object *argv[]);

void
scheme_init_eval (Scheme_Env *env)
{
  scheme_add_global ("eval", scheme_make_prim (eval), env);
}

Scheme_Object *
scheme_eval (Scheme_Object *obj, Scheme_Env *env)
{
  Scheme_Object *type;

  type = SCHEME_TYPE (obj);
  if (type == scheme_symbol_type)
    {
      Scheme_Object *val;

      val = scheme_lookup_value (obj, env);
      if (! val)
	{
	  scheme_signal_error ("reference to unbound symbol: %s", SCHEME_STR_VAL(obj));
	}
      return (val);
    }
  else if (type == scheme_pair_type)
    {
      return (scheme_eval_combination (obj, env));
    }
  else
    {
      return (obj);
    }
}

/* local functions */

static Scheme_Object *
scheme_eval_combination (Scheme_Object *comb, Scheme_Env *env)
{
  Scheme_Object *rator, *type, *rands;
  Scheme_Object *evaled_rands[SCHEME_MAX_ARGS];
  Scheme_Object *rand, *fun, *form;
  int num_rands, i;

  rator = scheme_eval (SCHEME_CAR (comb), env);
  type = SCHEME_TYPE (rator);
  if (type == scheme_syntax_type)
    {
      return (SCHEME_SYNTAX(rator)(comb, env));
    }
  else if (type == scheme_macro_type)
    {
      fun = (Scheme_Object *) SCHEME_PTR_VAL (rator);
      rands = SCHEME_CDR (comb);
      form = scheme_apply_to_list (fun, rands);
      return (scheme_eval (form, env));
    }
  else
    {
      rands = SCHEME_CDR (comb);
      num_rands = scheme_list_length (rands);
      i = 0;
      while (rands != scheme_null)
	{
	  evaled_rands[i] = scheme_eval (SCHEME_CAR (rands), env);
	  i++;
	  rands = SCHEME_CDR (rands);
	}
      return (scheme_apply (rator, num_rands, evaled_rands));
    }
}

static Scheme_Object *
eval (int argc, Scheme_Object *argv[])
{
  SCHEME_ASSERT ((argc == 1), "eval: wrong number of args");
  return (scheme_eval (argv[0], scheme_env));
}
