/* @(#)sforms.h	1.1 2/12/90 */

/* declarations for special form compilers and run-time evaluators
 *
 * argv is the argument vector; argc is its length, callframe is the
 * frame representing the current environment; and vec is an array
 * of operands in the codevector.
 *
 * gen is the code generator; tail is TRUE if the expression is tail
 * expression; and opt stores compiling info. */

#define SF_EVAL(sform) \
static Obj sform(argv, argc, callframe) \
     Obj *argv; \
     int argc; \
     Obj callframe;

#define SF_EVAL1(sform) \
static Obj sform(argv, argc, callframe, vec) \
     Obj *argv; \
     int argc; \
     Obj callframe; \
     bcode *vec;

#define SF_COMP(sform) \
static void sform(argv, argc, gen, tail, opt) \
     Obj *argv; \
     int argc; \
     CodeGen gen; \
     Boolean tail; \
     optInfo_t *opt;
