/* vectors */

/*
 * Copyright 1989 Jonathan Lee.  All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */

#include "fools.h"
#include "utils.h"

#ifndef lint
static char SccsId[] = "@(#)Vector.c	1.6 4/23/90";
#endif

Obj objVectorRef(vec, n)
     Obj vec;
     int n;
{
    Obj ret;

    ASSERT(CLASS(vec) == Vector && n >= 0 && n < DATA(vec, size, vectorInst));
    return (ret = DATA(vec, vector, vectorInst)[ n ]) ? ret : FalseSymb;
}

void objVectorSet(vec, n, val)
     Obj vec, val;
     int n;
{
    Obj prev;

    ASSERT(CLASS(vec) == Vector);
    ASSERT(n >= 0 && n < DATA(vec, size, vectorInst));

    if (val) objLink(val);
    if (prev = DATA(vec, vector, vectorInst)[ n ])
	objUnlink(prev);
    DATA(vec, vector, vectorInst)[ n ] = val;
}

int objVectorSize(vec)
     Obj vec;
{
    ASSERT(CLASS(vec) == Vector);
    return DATA(vec, size, vectorInst);
}

static void vectorPrint(vec, file)
     Obj vec;
     FILE *file;
{
    int max;
    Obj *array;
    Callback_t cb;

    cb.arg = (Ptr)vec;
    cb.func = clearMarks;
    errorPushCB(&cb);

    putc('#', file); putc('(', file);
    if (checkCond(vec, MARK))
	fputs("...", file);
    else {
	setCond(vec, MARK);

	max = DATA(vec, size, vectorInst);
	array = DATA(vec, vector, vectorInst);
	while (--max >= 0) {
	    if (*array) objPrint(*array++, file);
	    else objPrint(NilSymb, file);

	    if (max != 0) putc(' ', file);
	}
    }
    putc(')', file);
    clearCond(vec, MARK);
    errorPopCB();
}

static void vectorDestroy(vec)
     Obj vec;
{
    int i, max;
    Obj *arr;
  
    for (i = 0, max = DATA(vec, size, vectorInst),
	 arr = DATA(vec, vector, vectorInst); i < max; i++) {
	if (arr[i]) objUnlink(arr[i]);
    }
    if (max > 0) free((char *)arr);
}

Obj newVector(alloc, size)
     F_OBJ alloc;
     int size;
{
    Obj new;
    static Obj emptyvec = (Obj)NULL;

    if (size < 0) errorPrint(BadVal, "(vector dimension %d)", size);
    else if (size == 0) {
	if (emptyvec == (Obj)NULL) {
	    emptyvec = gcNew(Vector);
	    objLink(emptyvec);
	}
	new = emptyvec;
    }
    else {
	new = (*alloc)(Vector);
	DATA(new, vector, vectorInst) = NEWVEC(Obj, size);
    }
    DATA(new, size, vectorInst) = size;

    return new;
}

struct basicClass_s protoVector =
    DEFBASIC(Basic, vectorInst_t, vectorPrint, vectorDestroy, "vector");
