/* @(#)Frame.h	1.6 1/16/90 */

/*
 * Copyright 1989 Jonathan Lee.  All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */

#ifndef _FRAME_H
#define _FRAME_H

/* frame instance */
typedef struct frameInst_s {
    basicInst_t inherit;
    Tree local;
    Obj parent;
    Obj *fixed;
    Obj formals;
    short numfixed;
} frameInst_t, *frameInst;

extern basicClass_t protoFrame;
#define Frame ((Class)&protoFrame)

#ifdef __STDC__

/* Bind key to value in frame and return the binding.  If a binding for
 * key already exists, a new binding is not created--the original is
 * modified. */
extern Obj objPut(Obj key, Obj val, Obj frame);

/* Get the binding of key in frame (returns NULL if key is not defined). */
extern Obj objGetBinding(Obj key, Obj frame);

/* Get the val bound to key in frame (returns NULL if key is not defined). */
extern Obj objGet(Obj key, Obj frame);

/* Get the first val bound to key in the frame->parent chain (returns
 * NULL if not key is not defined). */
extern Obj objLookup(Obj key, Obj frame);

/* Return a new frame whose parent is par (a NULL parent may be specified). */
extern Obj newFrame(F_OBJ alloc, Obj par);

/* Move the fixed vector of frame from stack to heap
 *
 * If link is TRUE then each obj in the fixed vector is linked. */
extern void saveFrame(Obj frame, Boolean link);

#else

extern Obj objPut();
extern Obj objGetBinding();
extern Obj objGet();
extern Obj objLookup();
extern Obj newFrame();
extern void saveFrame();

#endif /* __STDC__ */

#endif /* _FRAME_H */
