;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/ml/camloo/runtime0.2/Llib/constr.scm ...                 */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Dec  7 08:24:20 1993                          */
;*    Last change :  Sat May 28 10:02:25 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    La gestion (bigloo) des constructeurs                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __caml_constr
   (foreign (include "caml-bigloo.h")
	    ;; le createur de tag
            (define obj caml-make-tag (int int)
	       "CAML_MAKE_TAG")
	    ;; les allocateurs
	    (define obj caml-allocate-regular-constr (obj)
	       "CAML_ALLOCATE_REGULAR_CONSTR")
	    (obj caml-make-regular    (obj obj . obj)
		 "caml_make_regular")
	    (obj caml-make-regular-1  (obj obj)
		 "caml_make_regular_1")
	    (obj caml-make-regular-2  (obj obj obj)
		 "caml_make_regular_2")
	    (obj caml-make-regular-3  (obj obj obj obj)
		 "caml_make_regular_3")
	    (obj caml-make-regular-4  (obj obj obj obj obj)
		 "caml_make_regular_4")
	    (obj caml-make-extensible (obj obj . obj)
		 "caml_make_extensible")
	    (obj caml-make-extensible-1  (obj obj)
		 "caml_make_extensible_1")
	    (obj caml-make-extensible-2  (obj obj obj)
		 "caml_make_extensible_2")
	    (obj caml-make-extensible-3  (obj obj obj obj)
		 "caml_make_extensible_3")
	    (obj caml-make-extensible-4  (obj obj obj obj obj)
		 "caml_make_extensible_4")
	    ;; les predicats
	    (define bool caml-constant-constr? (obj)
	       "CAML_CONSTANT_CONSTRP")
	    (define bool caml-regular-constr? (obj)
	       "CAML_REGULAR_CONSTRP")
	    (define bool may-be-an-extensible-constr? (obj)
	       "MAY_BE_AN_CAML_EXTENSIBLE_CONSTRP")
	    (define bool caml-extensible-constr? (obj)
	       "CAML_EXTENSIBLE_CONSTRP")
	    ;; les longeurs
	    (define obj caml-regular-constr-length   (obj)
	       "CAML_REGULAR_CONSTR_LENGTH")
	    ;; les tags
	    (define obj caml-constr-tag  (obj)
	       "CAML_CONSTR_TAG")
	    (define obj caml-constant-constr-tag (obj)
	       "_CAML_CNST_CONSTR_TAG")
	    (define obj caml-regular-constr-tag (obj)
	       "CAML_REGULAR_CONSTR_TAG")
	    (define obj caml-extensible-constr-tag (obj)
	       "CAML_EXTENSIBLE_CONSTR_TAG")
	    ;; les trippotages des tags
	    (define obj vector-replace-tag! (obj obj)
	       "VECTOR_REPLACE_TAG")
	    (define obj caml-regular-constr-set-tag! (obj obj)
	       "CAML_REGULAR_CONSTR_SET_TAG")
	    ;; les acces aux champs
	    (define obj caml-constr-get-field  (obj bint)
	       "CAML_CONSTR_GET_FIELD")
	    (define obj caml-constr-set-field! (obj bint obj)
	       "CAML_CONSTR_SET_FIELD"))
   (export  (caml-constr-update! c1 c2))
   (pragma  (caml-constr-get-field _no_side_effect_ _no_mutation_ _imbricable_)
	    (caml-constant-constr? _no_side_effect_ _imutable_
				   _no_mutation_ _imbricable_)
	    (caml-regular-constr? _no_side_effect_ _imutable_
				  _no_mutation_ _imbricable_)
	    (caml-extensible-constr? _no_side_effect_ _imutable_
				     _no_mutation_ _imbricable_)
	    (caml-constant-constr-tag _no_side_effect_ _imutable_
				      _no_mutation_ _imbricable_)
	    (caml-regular-constr-tag _no_side_effect_ _imutable_
				      _no_mutation_ _imbricable_)
	    (caml-extensible-constr-tag _no_side_effect_ _imutable_
					_no_mutation_ _imbricable_)))
	     
;*---------------------------------------------------------------------*/
;*    caml-constr-update! ...                                          */
;*---------------------------------------------------------------------*/
(define (caml-constr-update! c1 c2)
   (cond
      ((and (vector? c1) (vector? c2))
       (if (=fx (vector-length c1) (vector-length c2))
	   (begin
	      (vector-replace-tag! c1 c2)
	      (let loop ((i (-fx (vector-length c1) 1)))
		 (if (=fx i -1)
		     'done
		     (begin
			(vector-set! c1 i (vector-ref c2 i))
			(loop (-fx i 1))))))
	   (error "Illegal vector update" c1 c2)))
      ((and (procedure? c1) (procedure? c2))
       (error "Illegal procedure update" c1 c2))
      ((and (pair? c1) (pair? c2))
       (set-car! c1 (car c2))
       (set-cdr! c1 (cdr c2)))
      ((caml-constant-constr? c2)
       (caml-regular-constr-set-tag! c1 (caml-constant-constr-tag c2))
       c1)
      (else
       (error "Illegal update" c1 c2))))
 

