;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/ml/camloo/runtime0.0/Llib/string.scm ...                 */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Dec 13 10:02:24 1993                          */
;*    Last change :  Mon Dec 13 10:30:45 1993 (serrano)                */
;*    -------------------------------------------------------------    */
;*    La manipulation des strings                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __caml_bstring
   (foreign (bbool c-is_printable (bchar) "is_printable")
	    (obj   c-blit_string (obj obj obj obj obj) "blit_string")
	    (obj   c-fill_string (obj obj obj obj)     "fill_string"))
   (export  (inline c-string_length s)
	    (inline c-create_string len)
	    (inline c-compare_strings s1 s2)))

;*---------------------------------------------------------------------*/
;*    c-string_length ...                                              */
;*---------------------------------------------------------------------*/
(define-inline (c-string_length s)
   (string-length s))

;*---------------------------------------------------------------------*/
;*    c-create_string ...                                              */
;*---------------------------------------------------------------------*/
(define-inline (c-create_string len)
   (make-string len))

;*---------------------------------------------------------------------*/
;*    c-compare_strings ...                                            */
;*---------------------------------------------------------------------*/
(define-inline (c-compare_strings s1 s2)
   (string=? s1 s2))

